#ifndef   _KaiShader_h_
#define   _KaiShader_h_


/**
 * @addtogroup Kai
 *  @{
 */


/**
 * KaiShader
 * @file
 * @brief Kai Shader.
 * @note 
 * @author aoi_lif
 */




////////////////////////////////////////////////////////////////////////////////
// include
////////////////////////////////////////////////////////////////////////////////
#include "../../../include/Core/KaiFirstInclude.h"								// Kai first include
#include "../../../../Kai/external/DXUT/Core/DXUT.h"							// DXUT




////////////////////////////////////////////////////////////////////////////////
// define
////////////////////////////////////////////////////////////////////////////////



KAI_NAMESPACE_START



/**
 * KaiShader
 */
class KAI_API KaiShader
{
public:		// public enum


public:		// public type


public:		// public function
	/**
	 * RXgN^
	 */
	KaiShader();

	/**
	 * fXgN^
	 */
	virtual
	~KaiShader();

	/**
	 * I
	 */
	void
	Terminate(void);

	/**
	 * I[v
	 */
	bool
	Open(const HTChar* a_shaderFilePath);

	/**
	 * Techniquẽ|C^̎擾
	 */
	inline ID3D10EffectTechnique*
	GetTechniqueP(void)
	{
		return m_pTechnique;
	}

	/**
	 * WorldMatrix̃|C^̎擾
	 */
	inline ID3D10EffectMatrixVariable*
	GetWorldMatrixP(void)
	{
		return m_pWorldVariable;
	}

	/**
	 * ViewMatrix̃|C^̎擾
	 */
	inline ID3D10EffectMatrixVariable*
	GetViewMatrixP(void)
	{
		return m_pViewVariable;
	}

	/**
	 * ProjectionMatrix̃|C^̎擾
	 */
	inline ID3D10EffectMatrixVariable*
	GetProjectionMatrixP(void)
	{
		return m_pProjectionVariable;
	}

	/**
	 * Color̃|C^̎擾
	 */
	inline ID3D10EffectVectorVariable*
	GetColorP(void)
	{
		return m_pMeshColorVariable;
	}

	/**
	 * DiffuseResourcẽ|C^̎擾
	 */
	inline ID3D10EffectShaderResourceVariable*
	GetDiffuseResourceP(void)
	{
		return m_pDiffuseVariable;
	}


protected:		// protected function


protected:		// protected type


protected:		// protected value
	ID3D10Effect*						m_pEffect;
	ID3D10EffectTechnique*				m_pTechnique;
	ID3D10EffectMatrixVariable*			m_pWorldVariable;
	ID3D10EffectMatrixVariable*			m_pViewVariable;
	ID3D10EffectMatrixVariable*			m_pProjectionVariable;
	ID3D10EffectVectorVariable*			m_pMeshColorVariable;
	ID3D10EffectShaderResourceVariable*	m_pDiffuseVariable;
};


KAI_NAMESPACE_END


/** @} */       // end of HLib group


#endif  // _KaiShader_h_
