#ifndef   _KaiPrimCube00_h_
#define   _KaiPrimCube00_h_


/**
 * @addtogroup Kai
 *  @{
 */


/**
 * KaiPrimCube00
 * @file
 * @brief Kai Primitive Cube 00.
 * @note 
 * @author aoi_lif
 */




////////////////////////////////////////////////////////////////////////////////
// include
////////////////////////////////////////////////////////////////////////////////
#include "../../../include/Core/KaiFirstInclude.h"								// Kai first include
#include "../../../include/Graphic/Shader/KaiShader.h"							// Kai Shader
#include "../../../../Kai/external/DXUT/Core/DXUT.h"							// DXUT




////////////////////////////////////////////////////////////////////////////////
// define
////////////////////////////////////////////////////////////////////////////////



KAI_NAMESPACE_START



/**
 * KaiPrimCube00
 */
class KAI_API KaiPrimCube00
{
public:		// public enum


public:		// public type


public:		// public function
	/**
	 * RXgN^
	 */
	KaiPrimCube00(ID3D10Device* a_pD3DDevice, KaiShader* a_pShader);

	/**
	 * fXgN^
	 */
	virtual
	~KaiPrimCube00();

	/**
	 * `
	 */
	void
	Render();

	/**
	 * Ont[Move
	 */
	void
	OnMove(double a_time, float a_elapsedTime);

	/**
	 * OnRender
	 */
	void
	OnRender(ID3D10Device* a_pD3DDevice);

	/**
	 * WorldMatrixւ̃|C^̎擾
	 */
	D3DXMATRIX*
	GetWorldMatrixP(void)
	{
		return m_pWorldMatrix;
	}


protected:		// protected function


protected:		// protected type


protected:		// protected value
	ID3D10InputLayout*					m_pVertexLayout;
	ID3D10Buffer*						m_pVertexBuffer;
	ID3D10Buffer*						m_pIndexBuffer;
	KaiShader*							m_pShader;
	D3DXMATRIX*							m_pWorldMatrix;
	D3DXVECTOR4*						m_pMeshColor;
};


KAI_NAMESPACE_END


/** @} */       // end of HLib group


#endif  // _KaiPrimCube00_h_
