#ifndef   _KaiGL_h_
#define   _KaiGL_h_


/**
 * @addtogroup Kai
 *  @{
 */


/**
 * KaiTexture
 * @file
 * @brief Kai Texture.
 * @note 
 * @author aoi_lif
 */




////////////////////////////////////////////////////////////////////////////////
// include
////////////////////////////////////////////////////////////////////////////////
#include "../../include/Core/KaiFirstInclude.h"									// Kai first include
#include "../../../Kai/external/DXUT/Core/DXUT.h"								// DXUT




////////////////////////////////////////////////////////////////////////////////
// define
////////////////////////////////////////////////////////////////////////////////



KAI_NAMESPACE_START



/**
 * KaiGL
 */
class KAI_API KaiGL
{
public:		// public enum


public:		// public type
	class DeviceSetter
	{
	public:		// public function
		DeviceSetter(ID3D10Device* a_pD3DDevice)
		{
			SetDevice(a_pD3DDevice);
		}

		~DeviceSetter()
		{
			SetDevice(NULL);
		}
	};


public:		// public function
	/**
	 * RXgN^
	 */
	KaiGL();

	/**
	 * fXgN^
	 */
	virtual
	~KaiGL()
	{
	}

	/**
	 * 
	 */
	static bool
	Initialize(void);

	/**
	 * I
	 */
	static void
	Terminate(void);

	/**
	 * ݂DeviceԂ
	 */
	static void
	SetDevice(ID3D10Device* a_pD3DDevice)
	{
		m_pStaticData->m_pNowD3DDevice = a_pD3DDevice;
	}

	/**
	 * ݂DeviceԂ
	 */
	static ID3D10Device*
	GetNowDevice(void)
	{
		return m_pStaticData->m_pNowD3DDevice;
	}

	/**
	 * ݂DeviceԂ
	 */
	static D3DXMATRIX&
	GetWorldMatrix(void)
	{
		return m_pStaticData->m_worldMatrix;
	}

//	/**
//	 * CreateDeviceJn
//	 */
//	static void
//	CreateDeviceBegin(ID3D10Device* a_pD3DDevice)
//	{
//		m_pStaticData->m_pNowD3DDevice = a_pD3DDevice;
//	}

//	/**
//	 * CreateDeviceI
//	 */
//	static void
//	CreateDeviceEnd(void)
//	{
//		m_pStaticData->m_pNowD3DDevice = NULL;
//	}


protected:		// protected function


protected:		// protected type
	struct StaticData {
		ID3D10Device*				m_pNowD3DDevice;
		D3DXMATRIX					m_worldMatrix;
	};


protected:		// protected value
	static StaticData*			m_pStaticData;
//	ID3D10Device*				m_pNowD3DDevice;
};


KAI_NAMESPACE_END


/** @} */       // end of HLib group


#endif  // _KaiGL_h_
