// TestHLib.cpp : R\[ AvP[ṼGg |Cg`܂B
//

#include "stdafx.h"
#include "../../../../Hlib/include/HLib.h"


/**
 * HPlatform̃eXg
 */
u32 TestHPlatform(void)
{
	// Test HPlatform
	printf("\nTest HPlatform.\n");
#ifdef    H_PLATFORM_IS_LINUX
	printf("Platform is Linux\n");
#endif // H_PLATFORM_IS_LINUX
#ifdef    H_PLATFORM_IS_WINDOWS
	printf(" Platform is Windows\n");
#endif // H_PLATFORM_IS_WINDOWS

	// Test compiler
	#if       H_COMPILER_IS_VC
		// RpCVC
		printf(" Compiler is Visual C++.\n");
	#elif     H_COMPILER_IS_GCC
		// RpCGCC
		printf(" Compiler is GCC.\n");
	#else  // H_COMPILER_IS
		// RpC̓T|[gO
		printf(" Unsupported compiler.\n");
	#endif // H_COMPILER_IS
	return 0;
}


/**
 * HTypẽeXg
 */
u32 TestHType(void)
{
	u32		errNum = 0;		// number of errors.
	printf("\nTest HType.\n");
	printf(" sizeof( u8):%uByte\n", sizeof( u8));
	printf(" sizeof( s8):%uByte\n", sizeof( s8));
	printf(" sizeof(u16):%uByte\n", sizeof(u16));
	printf(" sizeof(s16):%uByte\n", sizeof(s16));
	printf(" sizeof(u32):%uByte\n", sizeof(u32));
	printf(" sizeof(s32):%uByte\n", sizeof(s32));
	printf(" sizeof(u64):%uByte\n", sizeof(u64));
	printf(" sizeof(s64):%uByte\n", sizeof(s64));
	printf(" sizeof(f32):%uByte\n", sizeof(f32));
	printf(" sizeof(f64):%uByte\n", sizeof(f64));
	printf(" sizeof( ui):%uByte\n", sizeof( ui));
	printf(" sizeof( si):%uByte\n", sizeof( si));

	printf("  u8_MIN:%u, 0x%x\n",  u8_MIN,  u8_MIN);
	printf("  u8_MAX:%u, 0x%x\n",  u8_MAX,  u8_MAX);
	printf("  s8_MIN:%d, 0x%x\n",  s8_MIN,  s8_MIN);
	printf("  s8_MAX:%d, 0x%x\n",  s8_MAX,  s8_MAX);
	printf(" u16_MIN:%u, 0x%x\n", u16_MIN, u16_MIN);
	printf(" u16_MAX:%u, 0x%x\n", u16_MAX, u16_MAX);
	printf(" s16_MIN:%d, 0x%x\n", s16_MIN, s16_MIN);
	printf(" s16_MAX:%d, 0x%x\n", s16_MAX, s16_MAX);
	printf(" u32_MIN:%u, 0x%x\n", u32_MIN, u32_MIN);
	printf(" u32_MAX:%u, 0x%x\n", u32_MAX, u32_MAX);
	printf(" s32_MIN:%d, 0x%x\n", s32_MIN, s32_MIN);
	printf(" s32_MAX:%d, 0x%x\n", s32_MAX, s32_MAX);
	printf(" u64_MIN:%u, 0x%x\n", u64_MIN, u64_MIN);
	printf(" u64_MAX:%u, 0x%x\n", u64_MAX, u64_MAX);
	printf(" s64_MIN:%d, 0x%x\n", s64_MIN, s64_MIN);
	printf(" s64_MAX:%d, 0x%x\n", s64_MAX, s64_MAX);
	printf(" f32_MIN:%f, 0x%x\n", f32_MIN, f32_MIN);
	printf(" f32_MAX:%f, 0x%x\n", f32_MAX, f32_MAX);
	printf(" f64_MIN:%f, 0x%x\n", f64_MIN, f64_MIN);
	printf(" f64_MAX:%f, 0x%x\n", f64_MAX, f64_MAX);
	if (u8_MIN != 0) {
		++errNum;
	}

	return errNum;
}


enum ABC {
	A,
	B,
	C
};


const char* EnumToStr(ABC abc)
{
	const char* pStr;
	switch (abc) {
	H_SET_STR_CASE(pStr, A);
	H_SET_STR_CASE(pStr, B);
	H_SET_STR_CASE(pStr, C);
	H_SET_STR_DEFAULT(pStr, abc);
	}
	return pStr;
}


void OldFunc0(void)
{
	HDPrintToBeAbolished("on monday", "NewFunc()");
}

void OldFunc1(void)
{
	HDPrintToBeAbolished(NULL, "NewFunc()");
}

void OldFunc2(void)
{
	HDPrintToBeAbolished("on monday", NULL);
}

void OldFunc3(void)
{
	HDPrintToBeAbolished(NULL, NULL);
}

/**
 * HUtilitỹeXg
 */
u32 TestHUtility(void)
{
	u32		errNum = 0;		// number of errors.
	printf("\nTest HUtility.\n");
	printf("\n");
#define CHECK3(...) { printf(__VA_ARGS__); }
CHECK3("moji%d\n", 88);
	printf("\n");

	int	len = 0;
	len = HDPrint("HDPrint().\n");
	printf("HDPrint() return:%d\n", len);

	len = HDPrintf("HDPrintf() %d %s.\n",999, "Hello");
	printf("HDPrintf() return:%d\n", len);

	len = HDPFlush("HDPFlush(),\n");
	printf("HDPFlush() return:%d\n", len);

	len = HDPError("p is %p\n", NULL);
	printf("HDPError() return:%d\n", len);

	len = HDPWarning("p is %p\n", NULL);
	printf("HDPWarning() return:%d\n", len);

	len = HDPLinef("mojiretu\n");
	printf("HDPLinef() return:%d\n", len);

	len = HDPLine();
	printf("HDPLine() return:%d\n", len);

	// Test HDPrintToBeAbolished()
	OldFunc0();
	OldFunc0();
	OldFunc1();
	OldFunc2();
	OldFunc3();


	printf("\n");
	printf(" _0b1(1,1):%u, 0x%x\n", _0b1(1111,1111), _0b1(1111,1111));
	printf(" _0b2(1,1,1,1):%u, 0x%x\n", _0b2(1111,1111,1111,1111), _0b2(1111,1111,1111,1111));
	printf(" _0b3(1,1,1,1,1,1):%u, 0x%x\n", _0b3(1111,1111,1111,1111,1111,1111), _0b3(1111,1111,1111,1111,1111,1111));
	printf(" _0b4(1,1,1,1,1,1,1,1):%u, 0x%x\n", _0b4(1111,1111,1111,1111,1111,1111,1111,1111), _0b4(1111,1111,1111,1111,1111,1111,1111,1111));
	printf(" H_FUNC_NAME:%s\n", H_FUNC_NAME);
	printf(" H_FUNC_NAME_EXT:%s\n", H_FUNC_NAME_EXT);
	printf(" H_LINE:%u\n", H_LINE);
	printf(" H_FILE_NAME:%s\n", H_FILE_NAME);
	printf(" H_TO_STR(H_LINE):%s\n", H_TO_STR(H_LINE));
	printf(" H_MACRO_CAT(H_FUNC,_NAME):%s\n", H_MACRO_CAT(H_FUNC,_NAME));

	printf(" EnumToStr(A):%s\n", EnumToStr(A));
	printf(" EnumToStr(B):%s\n", EnumToStr(B));
	printf(" EnumToStr(C):%s\n", EnumToStr(C));
	printf(" EnumToStr((ABC)9):%s\n", EnumToStr((ABC)9));

//	bool    bValue = false;
//	HDAssert(bValue, "bValue:%d\n", bValue);
	return errNum;
}


/**
 * main
 */
int _tmain(int argc, _TCHAR* argv[])
{
	u32		errNum = 0;		// number of errors.

	// Test HPlatform
	errNum += TestHPlatform();
	// Test HType
	errNum += TestHType();
	// Test HUtility
	errNum += TestHUtility();

	printf("errNum:%u\n", errNum);
	return 0;
}

