﻿#ifndef   _HType_h_
#define   _HType_h_


/**
 * @addtogroup HLib
 *  @{
 */


/**
 * HType
 * @file
 * @brief HLib type.
 * @brief 型の定義。
 * @note 移植性維持のために使用する。
 * @author aoi_lif
 */




//////////////////////////////////////////////////////////////
// include
//////////////////////////////////////////////////////////////
#include "./HDefine.h"										// HLib define
#include "./HPlatform.h"									// HLib platform
#if        H_COMPILER_IS_VC
#else	// H_COMPILER_IS
	#include <inttypes.h>									// [uint8_t等]
#endif	// H_COMPILER_IS
#include <float.h>											// [FLT_MIN等]
#include <limits.h>											// [CHAR_BIT]
#include <stdio.h>											// [NULL]
#include <vector>



// start HLib namespace
H_NAMESPACE_START




//////////////////////////////////////////////////////////////
// type
//////////////////////////////////////////////////////////////
#if       H_COMPILER_IS_VC
	typedef  unsigned __int8			u8;					///< unsigned  8Byte
	typedef    signed __int8			s8;					///<   signed  8Byte
	typedef unsigned __int16		   u16;					///< unsigned 16Byte
	typedef   signed __int16		   s16;					///<   signed 16Byte
	typedef unsigned __int32		   u32;					///< unsigned 32Byte
	typedef   signed __int32		   s32;					///<   signed 32Byte
	typedef unsigned __int64		   u64;					///< unsigned 64Byte
	typedef   signed __int64		   s64;					///<   signed 64Byte
//	typedef            float		   f32;					///< floating point 32Byte(制度は処理系依存)		※いろいろと問題がありそうな気がするので封印する
//	typedef           double		   f64;					///< floating point 64Byte(制度は処理系依存)		※いろいろと問題がありそうな気がするので封印する
//	typedef             bool		 bool8;					///< bool      8Byte
//	typedef         uint32_t		bool32;					///< bool     32Byte
//	typedef           size_t		h_size;					///< サイズ(サイズは環境依存する)
	typedef     unsigned int			ui;					///< 最低32Byteある最も高速なunsigned int(unsigned intの代わりに使用する)
	typedef       signed int			si;					///< 最低32Byteある最も高速な  signed int(  signed intの代わりに使用する)
//	typedef          __int64		  tick;					///< CPU tick
#else  // H_COMPILER_IS
	typedef          uint8_t			u8;					///< unsigned  8Byte
	typedef           int8_t			s8;					///<   signed  8Byte
	typedef         uint16_t		   u16;					///< unsigned 16Byte
	typedef          int16_t		   s16;					///<   signed 16Byte
	typedef         uint32_t		   u32;					///< unsigned 32Byte
	typedef          int32_t		   s32;					///<   signed 32Byte
	typedef         uint64_t		   u64;					///< unsigned 64Byte
	typedef          int64_t		   s64;					///<   signed 64Byte
//	typedef            float		   f32;					///< floating point 32Byte(制度は処理系依存)		※いろいろと問題がありそうな気がするので封印する
//	typedef           double		   f64;					///< floating point 64Byte(制度は処理系依存)		※いろいろと問題がありそうな気がするので封印する
//	typedef             bool		 bool8;					///< bool      8Byte
//	typedef         uint32_t		bool32;					///< bool     32Byte
//	typedef           size_t		h_size;					///< サイズ(サイズは環境依存する)
	typedef    uint_fast32_t			ui;					///< 最低32Byteある最も高速なunsigned int(unsigned intの代わりに使用する)
	typedef     int_fast32_t			si;					///< 最低32Byteある最も高速な  signed int(  signed intの代わりに使用する)
//	typedef         uint64_t		  tick;					///< CPU tick
#endif // H_COMPILER_IS


// min max
#define  u8_MIN						(0)						///<    0
#define  u8_MAX						(0xff)					///<  255
#define  s8_MIN						(-127-1)				///< -128
#define  s8_MAX						( 127)					///<  127
#define u16_MIN						(0)						///<      0
#define u16_MAX						(0xffff)				///<  65535
#define s16_MIN						(-32767-1)				///< -32768
#define s16_MAX						( 32767)				///<  32767
#define u32_MIN						(0)						///<           0
#define u32_MAX						(0xffffffff)			///< 4294967295U
#define s32_MIN						(-2147483647-1)			///< -2147483648
#define s32_MAX						( 2147483647)			///<  2147483647
#define u64_MIN						(0)						///<                    0
#define u64_MAX						(0xffffffffffffffff)	///< 18446744073709551615
#define s64_MIN						(0x7fffffffffffffff)	///< -9223372036854775808
#define s64_MAX						(0x7fffffffffffffff)	///<  9223372036854775807
#define f32_MIN						FLT_MIN					///< 
#define f32_MAX						FLT_MAX					///< 
#define f64_MIN						DBL_MIN					///< 
#define f64_MAX						DBL_MAX					///< 


typedef std::vector<u8>				HVectorU8;
typedef std::vector<s8>				HVectorS8;


/*              未使用かつ、環境依存が強いのでコメントアウト
// bit
#define bitsof(type)        (sizeof(type) * CHAR_BIT)

#define  u8_BITS            bitsof(u8)
#define  s8_BITS            bitsof(u8)
#define u16_BITS            bitsof(u16)
#define s16_BITS            bitsof(u16)
#define u32_BITS            bitsof(u32)
#define s32_BITS            bitsof(u32)
#define u64_BITS            bitsof(u64)
#define s64_BITS            bitsof(u64)
#define f32_BITS            bitsof(f32)
#define f64_BITS            bitsof(f64)
*/


/*
// 数字値タイプ
enum H_VALUE_TYPE {
	H_VALUE_TYPE_u8,											// u8
	H_VALUE_TYPE_s8,											// s8
	H_VALUE_TYPE_u16,											// u16
	H_VALUE_TYPE_s16,											// s16
	H_VALUE_TYPE_u32,											// u32
	H_VALUE_TYPE_s32,											// s32
//	H_VALUE_TYPE_u64,											// u64
//	H_VALUE_TYPE_s64,											// s64
	H_VALUE_TYPE_f32,											// f32
	H_VALUE_TYPE_bool,											// bool
};


// 数字値
typedef struct {
	union {
		u8						value_u8;						// u8
		s8						value_s8;						// s8
		u16						value_u16;						// u16
		s16						value_s16;						// s16
		u32						value_u32;						// u32
		s32						value_s32;						// s32
//		u64						value_u64;						// u64
//		s64						value_s64;						// s64
		f32						value_f32;						// f32
		bool					value_bool;						// bool
	};
	u8							type;							// タイプ
} h_value;
*/




// end HLib namespace
H_NAMESPACE_END




/** @} */       // end of HLib group


#endif  // _HType_h_
