#ifndef   _HTick_h_
#define   _HTick_h_


/**
 * @addtogroup HLib
 *  @{
 */


/**
 * HTick
 * @file
 * @brief HLib CPU tickB
 * @note CPUtickA͎悤Ȃ̂B
 * @warning }`RACPUłCPUɒlႤ̂ŒӁB
 * @author aoi_lif
 */




//////////////////////////////////////////////////////////////
// include
//////////////////////////////////////////////////////////////
#include "./HDefine.h"										// HLib define
#include "./HPlatform.h"									// HLib platform
#include "./HUtility.h"										// HLib utility
#ifdef    H_PLATFORM_IS_WINDOWS
	// Windows
	#include <windows.h>										// DWORD
#endif // H_PLATFORM_IS_WINDOWS




// start HLib namespace
H_NAMESPACE_START




//////////////////////////////////////////////////////////////
// define
//////////////////////////////////////////////////////////////
#define HTick_FAST											(0)				// 0==ᑬ&덷, 1==&덷




//////////////////////////////////////////////////////////////
// type
//////////////////////////////////////////////////////////////
typedef u64					HTick;					///< CPU tick




//////////////////////////////////////////////////////////////
// function
//////////////////////////////////////////////////////////////
/**
 * ݂CPU tick擾
 * @return ݂CPU tick
 */
inline HTick
HTickGet(void)
{
	#if       H_COMPILER_IS_VC
		// RpCVC
		// IntelnȂ炤܂AȊO͂߂ȂB
		//   ̕@莟ύXB
		#if       1
			// &덷
			__asm {
				rdtsc		// Read Time Stamp Counter(^CX^vJE^EAXWX^(32bit)AEDXWX^(32bit)Ɋi[)
							// 64bit̖߂ĺAEAXWX^/EDXWX^Ɋi[ČĂяoɓn͂Ȃ̂returnȂ
			}
		#else  // 1
			// ᑬ&덷
			LARGE_INTEGER	tick;	// CPU tick

			__asm {
				cpuid		// I[_O(ɏd)
				rdtsc		// Read Time Stamp Counter(^CX^vJE^EAXWX^(32bit)AEDXWX^(32bit)Ɋi[)

				mov tick.LowPart,  eax
				mov tick.HighPart, edx
			}
			return static_cast<HTick>(cycles.QuadPart);
		#endif // 1
	#elif     H_COMPILER_IS_GCC
		// RpCGCC
		u64					tick;
		__asm__ volatile ("rdtsc" : "=A" (tick));
		return tick;
	#else  // H_COMPILER_IS
		// RpC̓T|[gO
		#error "unsupported compiler"
	#endif // H_COMPILER_IS
}


/**
 * ݂CPU frequency(NbNg)擾
 * @return ݂CPU frequency
 */
inline HTick
HTickGetFreq(void)
{
	#if       H_COMPILER_IS_VC
		// RpCVC
		static	HTick s_freq = 0;
		// freqŏ̈񂾂擾
		//  freq擾@킩Ȃ̂ŌvZŋ߂B
		//   GcȒlŁAŒl傫ς̂ő̕@莟ύXB
		if (s_freq == 0) {
			LARGE_INTEGER	endCounter;
			LARGE_INTEGER	nowCounter;
			LARGE_INTEGER	freq;				// QueryPerformanceCounter̎g(1bӂ̃JEg)
			QueryPerformanceFrequency(&freq);

			HTick start = HTickGet();
			// 1/128b(Œ̐x҂ł鎞)wait
			//  CPU͎gp邪ASleep()͂͂邩ɐm
			QueryPerformanceCounter(&endCounter);
			endCounter.QuadPart += freq.QuadPart >> 7;		// 1/128b̎Ԃɂ
			do {
				QueryPerformanceCounter(&nowCounter);
			} while (endCounter.QuadPart > nowCounter.QuadPart);
			// 1/128bCPU tick1bCPU tick(NbNg)vZ
			s_freq = (HTickGet() - start) << 7;
		}
		return s_freq;
	#elif     H_COMPILER_IS_GCC
		#error "unsupported compiler"
	#else  // H_COMPILER_IS
		// RpC̓T|[gO
		#error "unsupported compiler"
	#endif // H_COMPILER_IS
}


/**
 * tickb֕ϊ
 * @param[in] _tick CPU tick
 * @return b
 */
inline float
HTickTick2Sec(HTick _tick)
{
	#if       HTick_FAST
		// &덷
		// HTickfloatփLXĝ͖肪悤ɎvBrbgVtgČčŌɏق悢ȂB
	    return static_cast<float>(_tick) / static_cast<float>(HTickGetCpuFreq());
	#else  // HTick_FAST
		// ᑬ&덷
	    return static_cast<float>(static_cast<double>(_tick) / static_cast<double>(HTickGetFreq()));
	#endif // HTick_FAST
}


/**
 * tick~b֕ϊ
 * @param[in] _tick CPU tick
 * @return ~b
 */
inline float
HTickTick2MSec(HTick _tick)
{
	#if       HTick_FAST
		// &덷
		// HTickfloatփLXĝ͖肪悤ɎvBrbgVtgČčŌɏق悢ȂB
	return static_cast<float>(_tick) * 1000.0f / static_cast<float>(HTickGetCpuFreq());
	#else  // HTick_FAST
		// ᑬ&덷
	    return static_cast<float>(static_cast<double>(_tick) * 1000.0f / static_cast<double>(HTickGetFreq()));
	#endif // HTick_FAST
	return 0;
}




// end HLib namespace
H_NAMESPACE_END


/** @} */       // end of HLib group

#endif // _HTick_h_

