﻿#ifndef   _HSingleton_h_
#define   _HSingleton_h_


/**
 * @addtogroup HLib
 *  @{
 */


/**
 * HSingleton
 * @file
 * @brief HLib singleton.
 * @note シングルトンベース。
 * @author aoi_lif
 */




//////////////////////////////////////////////////////////////
// include
//////////////////////////////////////////////////////////////
#include "./HDefine.h"										// HLib define
#include "./HPlatform.h"									// HLib platform
#include <vector>




// start HLib namespace
H_NAMESPACE_START




//////////////////////////////////////////////////////////////
// type
//////////////////////////////////////////////////////////////
/**
 * シングルトンベース
 */
template<class T>
class HSingleton
{
public:
	/**
	 * インスタンスの取得
	 */
	static T&
	GetInstance(void)
	{
		static T t;
		return t;
	}
protected:
	/**
	 * コンストラクタ
	 */
	HSingleton()
	{
//		HDPrintf(ESC_GRE"In HSingleton::HSingleton() this:%p"ESC_DEF"\n", this);
	}

	/**
	 * デストラクタ
	 */
	virtual
	~HSingleton()
	{
//		HDPrintf(ESC_GRE"In HSingleton::~HSingleton() this:%p"ESC_DEF"\n", this);
	}
};




// end HLib namespace
H_NAMESPACE_END


/** @} */       // end of HLib group

#endif // _HSingleton_h_

