﻿#ifndef   _HRelation_h_
#define   _HRelation_h_


/**
 * @addtogroup HLib
 *  @{
 */


/**
 * HRelation
 * @file
 * @brief HLib relation。
 * @note オブジェクトの親戚関係を扱う。
 * @note 実験的に作ったものなので今後大きな変更や削除もありえる。
 * @author aoi_lif
 */




//////////////////////////////////////////////////////////////
// include
//////////////////////////////////////////////////////////////
#include "./HDefine.h"										// HLib define
#include "./HPlatform.h"									// HLib platform
#include "./HDPrint.h"										// HLib debug print
#include "./HUtility.h"										// HLib utility
#include <vector>




// start HLib namespace
H_NAMESPACE_START




//////////////////////////////////////////////////////////////
// type
//////////////////////////////////////////////////////////////
#if		1
/**
 * 親戚関係 子
 * @note 親を持ち、子を持たないオブジェクトを扱う。
 */
template<class T>
class HRelationChild
{
public:		// public function
	HRelationChild(T* _pParent=NULL, const char* _name=NULL) :
		m_pParent(_pParent),								// 親へのポインタ
		m_name(_name)										// 名前
	{
	}

	virtual
	~HRelationChild()
	{
	}

	T*
	GetPParent(void) const
	{
		return m_pParent;
	}

	const T*
	GetCPParent(void) const
	{
		return m_pParent;
	}

	/**
	 * 名前の設定
	 * @param[in] _name 名前
	 * @warning _nameは内部でコピーしないので注意
	 */
	void
	SetName(const char* _name)
	{
		m_name = _name;
	}

	/**
	 * 親戚関係のデバグプリント
	 */
	virtual void
	DPrintRelation(u32 _depth)
	{
		for (u32 i=_depth; i>0; --i) {
			HDPrint(" ");
		}
		HDPrintf("%s\n", Iif(m_name,m_name,"unknown"));
	}


protected:		// protected value
	T*							m_pParent;					///< 親へのポインタ
	const char*					m_name;						///< 名前
};


/**
 * 親戚関係 親
 * @note 親と子を持つオブジェクトを扱う。
 */
template<class T>
class HRelation : public HRelationChild<T>
{
public:		// public function
	HRelation(T* _pParent=NULL, const char* _name=NULL) :
		HRelationChild<T>(_pParent, _name),					// 親戚 子
		m_childrenList()									// 子リスト
	{
	}

	virtual
	~HRelation()
	{
	}

	virtual void
	AddChild(T* _pChild)
	{
		m_childrenList.push_back(_pChild);
	}

	virtual std::vector<T*>&
	GetChildrenList(void)
	{
		return m_childrenList;
	}

	const std::vector<T*>&
	GetCChildrenList(void) const
	{
		return m_childrenList;
	}

	/**
	 * 関係のデバグプリント
	 */
	virtual void
	DPrintRelation(u32 _depth)
	{
		HRelationChild<T>::DPrintRelation(_depth);
		++_depth;
		std::vector<T*>		pChild = GetChildrenList();
		for (std::vector<T*>::iterator itr=pChild.begin(); itr!=pChild.end(); ++itr) {
			(*itr)->DPrintRelation(_depth);
		}
	}


protected:		// protected value
	std::vector<T*>				m_childrenList;				///< 子リスト
};
#endif


// end HLib namespace
H_NAMESPACE_END


/** @} */       // end of HLib group

#endif // _HRelation_h_

