﻿#ifndef   _HPlatform_h_
#define   _HPlatform_h_


/**
 * @addtogroup HLib
 *  @{
 */


/**
 * HPlatform
 * @file
 * @brief HLib platform.
 * @brief プラットフォーム識別。
 * @note プラットフォームの差異を吸収するのを助ける。
 * @author aoi_lif
 */




//////////////////////////////////////////////////////////////
// include
//////////////////////////////////////////////////////////////
#include "./HDefine.h"										// HLib define




//////////////////////////////////////////////////////////////
// define
//////////////////////////////////////////////////////////////
// OS識別
#if       defined(linux) || defined(__linux) || defined(__linux__)
	#define	H_PLATFORM_IS_LINUX						(1)				// Linuxフラグ
#endif // defined(linux) || defined(__linux) || defined(__linux__)

#if       defined(WIN32) || defined(_WIN32)
	#define	H_PLATFORM_IS_WINDOWS					(1)				// Windowsフラグ
#endif // defined(WIN32) || defined(_WIN32)


// コンパイラ識別
/*
	exsample of use.
	#if       H_COMPILER_IS_VC
		// コンパイラはVC
	#elif     H_COMPILER_IS_GCC
		// コンパイラはGCC
	#else  // H_COMPILER_IS
		// コンパイラはサポート外
		#error "unsupported compiler"
	#endif // H_COMPILER_IS
*/
#if   defined(_MSC_VER)
	#define H_COMPILER_IS_VC		(1)						// コンパイラはVisualC++
	#define H_COMPILER_IS_NOT_VC	(0)						// コンパイラはVisualC++ではない
//	#define H_COMPILER_IS_BCC		(0)						// コンパイラはBolandC
//	#define H_COMPILER_IS_NOT_BCC	(1)						// コンパイラはBolandCではない
	#define H_COMPILER_IS_GCC		(0)						// コンパイラはGCC
	#define H_COMPILER_IS_NOT_GCC	(1)						// コンパイラはGCCではない
//#elif defined(__BORLANDC__)
//	#define H_COMPILER_IS_VC		(0)						// コンパイラはVisualC++
//	#define H_COMPILER_IS_NOT_VC	(1)						// コンパイラはVisualC++ではない
//	#define H_COMPILER_IS_BCC		(1)						// コンパイラはBolandC
//	#define H_COMPILER_IS_NOT_BCC	(0)						// コンパイラはBolandCではない
//	#define H_COMPILER_IS_GCC		(0)						// コンパイラはGCC
//	#define H_COMPILER_IS_NOT_GCC	(1)						// コンパイラはGCCではない
#elif defined(__GNUC__)
	#define H_COMPILER_IS_VC		(0)						// コンパイラはVisualC++
	#define H_COMPILER_IS_NOT_VC	(1)						// コンパイラはVisualC++ではない
//	#define H_COMPILER_IS_BCC		(0)						// コンパイラはBolandC
//	#define H_COMPILER_IS_NOT_BCC	(1)						// コンパイラはBolandCではない
	#define H_COMPILER_IS_GCC		(1)						// コンパイラはGCC
	#define H_COMPILER_IS_NOT_GCC	(0)						// コンパイラはGCCではない
#else
	#error "unsupported compiler"
#endif




/** @} */       // end of HLib group


#endif // _HPlatform_h_
