﻿#ifndef   _HOverloadSecure_h_
#define   _HOverloadSecure_h_


/**
 * @addtogroup HLib
 *  @{
 */


/**
 * HOverloadSecure
 * @file
 * @brief HLib overload secure function.
 * @brief セキュア関数のオーバーロード。
 * @author aoi_lif
 */




//////////////////////////////////////////////////////////////
// include
//////////////////////////////////////////////////////////////
#include "./HDefine.h"										// HLib define
#include "./HPlatform.h"									// HLib platform
#include <stdio.h>



// start HLib namespace
H_NAMESPACE_START










/*
#ifdef    __STDC_WANT_SECURE_LIB__
	#define HSPrintf(_dstBuf, _dstSize, _maxCount, ...)							snprintf_s(_dstBuf, _dstSize, _maxCount, __VA_ARGS__)
#else  // __STDC_WANT_SECURE_LIB__
	#define HSPrintf(_dstBuf, _dstSize, _maxCount, ...)							snprintf(_dstBuf, _dstSize, __VA_ARGS__)
#endif // __STDC_WANT_SECURE_LIB__
*/


#ifdef    __STDC_WANT_SECURE_LIB__
	#define HSPrintf(_dstBuf, _dstSize, _format, ...)							sprintf_s(_dstBuf, _dstSize, _format, __VA_ARGS__)
	#define HSTPrintf(_dstBuf, _dstSize, _format, ...)							_stprintf_s(_dstBuf, _dstSize, _format, __VA_ARGS__)
#else  // __STDC_WANT_SECURE_LIB__
	#define HSPrintf(_dstBuf, _dstSize, _format, ...)							sprintf(_dstBuf, _format, __VA_ARGS__)
	#define HSTPrintf(_dstBuf, _dstSize, _format, ...)							_stprintf(_dstBuf, _format, __VA_ARGS__)
#endif // __STDC_WANT_SECURE_LIB__


#ifdef    __STDC_WANT_SECURE_LIB__
	#define HStrcpy(_dstBuf, _dstSize, _srcBuf)									strcpy_s(_dstBuf, _dstSize, _srcBuf)
#else  // __STDC_WANT_SECURE_LIB__
	#define HStrcpy(_dstBuf, _dstSize, _srcBuf)									strcpy(_dstBuf, _srcBuf)
#endif // __STDC_WANT_SECURE_LIB__


#ifdef    __STDC_WANT_SECURE_LIB__
	#define HVSNPrintf(_dstBuf, _dstSize, _maxCount, _format, _argList)			vsnprintf_s(_dstBuf, _dstSize, _maxCount, _format, _argList)
	#define HVSNTPrintf(_dstBuf, _dstSize, _maxCount, _format, _argList)		_vsntprintf_s(_dstBuf, _dstSize, _maxCount, _format, _argList)
#else  // __STDC_WANT_SECURE_LIB__
	#define HVSNPrintf(_dstBuf, _dstSize, _maxCount, _format, _argList)			vsnprintf(_dstBuf, _dstSize, _format, _argList)
	#define HVSNTPrintf(_dstBuf, _dstSize, _maxCount, _format, _argList)		_vsntprintf(_dstBuf, _dstSize, _format, _argList)
#endif // __STDC_WANT_SECURE_LIB__


#ifdef    __STDC_WANT_SECURE_LIB__
	#define HFOpen(_pFP, _fileName, _mode)										fopen_s(_pFP, _fileName, _mode)
#else  // __STDC_WANT_SECURE_LIB__
	inline errno_t
	HFOpen(FILE* _pFP, const char* _fileName, const char* _mode)
	{
		FILE* pFP = fopen(_fileName, _mode);
		if (pFP == NULL) {
			_pFP = pFP;
			return 0;
		} else {
			return EINVAL;
		}
	}
#endif // __STDC_WANT_SECURE_LIB__




// end HLib namespace
H_NAMESPACE_END


/** @} */       // end of HLib group


#endif // _HOverloadSecure_h_
