#ifndef   _HMemory_h_
#define   _HMemory_h_


/**
 * @addtogroup HLib
 *  @{
 */


/**
 * HMemory
 * @file
 * @brief HLib memoryB
 * @note B
 * @author aoi_lif
 */




//////////////////////////////////////////////////////////////
// include
//////////////////////////////////////////////////////////////
#include "./HDefine.h"										// HLib define
#include "./HPlatform.h"									// HLib platform
#include "./HUtility.h"										// HLib utility
#if       H_DEBUG
	// foO
	#include "./HDPrint.h"									// HLib debug print
#endif // H_DEBUG
#include <string.h>											// [memset]
#include <stdlib.h>											// [malloc]




// start HLib namespace
H_NAMESPACE_START




//////////////////////////////////////////////////////////////
// function
//////////////////////////////////////////////////////////////
/**
 * ̊m
 * @param _size mۂTCY
 */
#if       H_DEBUG
	// foO
	inline void*
	HMemAlloc(size_t _size)
	{
		void*		pMem = malloc(_size);
		if (pMem == NULL) {
			HDPError("malloc() return %p\n", pMem);
		}
		return pMem;
	}
#else  // H_DEBUG
	// foOȊO
	#define HMemAlloc(_size)			malloc(_size)
#endif // H_DEBUG

/**
 * 폜
 * @brief Sȃ폜
 * @param[in] _pMem 폜ւ̃|C^
 * @note delete̋KiNULLdeleteĂȂ̂NULL`FbNĂȂB
 * @warning _pMem𕡐QƂׁA_pMem̓}N̕pNȂ̂łȂ΂ȂB
 */
#define HMemDelete(_pMem)																	\
			do {																			\
				delete (_pMem);																\
				(_pMem) = NULL;																\
			} while(0)

/**
 * z폜
 * @brief Sȃz폜
 * @param[in] _pMem 폜zւ̃|C^
 * @note delete̋KiNULLdeleteĂȂ̂NULL`FbNĂȂB
 * @warning _pMem𕡐QƂׁA_pMem̓}N̕pNȂ̂łȂ΂ȂB
 */
#define HMemDeleteArray(_pMem)																\
			do {																			\
				delete [] (_pMem);															\
				(_pMem) = NULL;																\
			} while(0)

/**
 * 폜
 * @brief Sȃ폜
 * @param[in] _pMem 폜ւ̃|C^
 * @note free̋KiNULLfreeĂȂ̂NULL`FbNĂȂB
 * @warning _pMem𕡐QƂׁA_pMem̓}N̕pNȂ̂łȂ΂ȂB
 */
#define HMemFree(_pMem)																		\
			do {																			\
				free(_pMem);																\
				(_pMem) = NULL;																\
			} while(0)


//#define HObjRelease(p)      { if (p) { (p)->Release(); (p)=NULL; } }


/**
 * ̃[NA
 * @param[in] _destination [NAւ̃|C^
 * @param[in] _size 0Ŗ߂TCY
 * @brief 0Ŗ߂B
 */
#ifdef  _DEBUG
	inline void
	HMemSetZero(void* _destination, size_t _size)
	{
		if (_destination == NULL) {
			HDPError("argument error. _destination:%p\n", _destination);
		}
		memset(_destination, 0, _size);
	}
#else   // _DEBUG
	#define HMemSetZero(_destination, _size)      memset((_destination), 0, (_size))
#endif  // _DEBUG


/**
 * ̃Rs[
 * @param[in] _destinationBuff Rs[
 * @param[in] _destinationBuffSize Rs[̃obt@TCY
 * @param[in] _sourceBuff Rs[
 * @param[in] _size Rs[TCY
 */
#if       H_DEBUG
	// foO
	inline void
	HMemCopy(void* _destinationBuff, size_t _destinationBuffSize, const void* _sourceBuff, size_t _size)
	{
		if (_destinationBuff == NULL ||
			_sourceBuff == NULL) {
			HDPError("argument error. _destinationBuff:%p, _sourceBuff:%p\n", _destinationBuff, _sourceBuff);
		}
		if (_destinationBuffSize < _size) {
			HDPError("_destinationBuffSize:%u < _size:%u\n", _destinationBuffSize, _size);
		}
		memcpy(_destinationBuff, _sourceBuff, _size);
	}
#else  // H_DEBUG
	// foOȊO
	#define HMemCopy(_destinationBuff, _destinationBuffSize, _sourceBuff, _size)			\
				do {																		\
					(void)(_destinationBuffSize);											\
					memcpy((_destinationBuff), (_sourceBuff), (_size));						\
				} while(0)
#endif // H_DEBUG


/**
 * ̈ړ
 * @param[in] _destinationBuff ړ
 * @param[in] _destinationBuffSize ړ̃obt@TCY
 * @param[in] _sourceBuff ړ
 * @param[in] _size ړTCY
 */
#if       H_DEBUG
	// foO
	inline void
	HMemMove(void* _destinationBuff, size_t _destinationBuffSize, const void* _sourceBuff, size_t _size)
	{
		if (_destinationBuff == NULL ||
			_sourceBuff == NULL) {
			HDPError("argument error. _destinationBuff:%p, _sourceBuff:%p\n", _destinationBuff, _sourceBuff);
		}
		if (_destinationBuffSize < _size) {
			HDPError("_destinationBuffSize:%u < _size:%u\n", _destinationBuffSize, _size);
		}
		memmove(_destinationBuff, _sourceBuff, _size);
	}
#else  // H_DEBUG
	// foOȊO
	#define HMemMove(_destinationBuff, _destinationBuffSize, _sourceBuff, _size)			\
				do {																		\
					(void)(_destinationBuffSize);											\
					memmove((_destinationBuff), (_sourceBuff), (_size));					\
				} while(0)
#endif // H_DEBUG


// end HLib namespace
H_NAMESPACE_END




/** @} */       // end of HLib group

#endif // _HMemory_h_


