﻿#ifndef   _HLib_h_
#define   _HLib_h_


/**
 * @defgroup HLib HLib ヘッダ完結ライブラリ
 *  ヘッダファイルだけで完結するライブラリ。
 *  インクルードするだけで使用可能。
 *  コンパイルやリンクの必要がないため、任意のライブラリの内外で気軽に使用可能。
 *  使い込まれていない機能もあるため、使用時は十分なデバッグが必要。
 *  gcc拡張を使用しているところもあるので移植時は注意。
 */
/**
 * @addtogroup HLib
 *  @{
 */


/**
 * HLib
 * @file
 * @brief HLib.
 * @brief HLibのヘッダを羅列する。
 * @note  基本的にはfolder名でソートした後file名でソートする。
 * @note  　(includeの抜けを確認し易くするため)
 * @note  このヘッダをインクルードすれば、HLibのすべての機能を使用することができる。
 * @ntoe  使用するヘッダだけを個々にインクルードしても問題ない。
 * @author aoi_lif
 */




//////////////////////////////////////////////////////////////
// include
//////////////////////////////////////////////////////////////
#include "./HDefine.h"										// HLib define
#include "./HDFWrite.h"										// HLib debug fwrite
#include "./HDPrint.h"										// HLib debug print
//#include "./HDResourceChecker.h"							// HLib debug resource checker
#include "./HMemory.h"										// HLib memory
#include "./HOverloadSecure.h"								// HLib overload secure
#include "./HPlatform.h"									// HLib platform
#include "./HRelation.h"									// HLib relation
#include "./HRingBuffer.h"									// HLib ring buffer
#include "./HSingleton.h"									// HLib singleton
#include "./HString.h"										// HLib string
#include "./HTick.h"										// HLib CPU tick
#include "./HType.h"										// HLib type
#include "./HUtility.h"										// HLib utility
// file
#include "./file/HIBinFile.h"								// HLib input binary file
#include "./file/HIBuffBinFile.h"							// HLib input buffered binary file
#include "./file/HITextFile.h"								// HLib input text file
#include "./file/HOBinFile.h"								// HLib output binary file
#include "./file/HOTextFile.h"								// HLib output text file



/** @} */       // end of HLib group


#endif // _HLib_h_
