﻿#ifndef   _HDefine_h_
#define   _HDefine_h_


/**
 * @addtogroup HLib
 *  @{
 */


/**
 * HDefine
 * @file
 * @brief HLib define.
 * @brief HLibの動作を切り替えるdefine。
 * @note makeの-Dオプションだけだと細かい制御が難しいのでここで制御する。
 * @note リリースモードで一部だけデバグしたい等の要求に対応するためここで制御する。
 * @note 主要なフラグをここで定義する事により、似たようなフラグがあちこちで定義されるのを防ぐ。
 * @note DEBUGや_DEBUG等は環境依存な部分もあるのでここで吸収。
 * @author aoi_lif
 */




//////////////////////////////////////////////////////////////
// define
//////////////////////////////////////////////////////////////
#ifdef	_DEBUG
	#define H_DEBUG											(1)					//< debugを使用するか
	#define H_USE_HDPrint									(1)					//< debug printを使用するか
	#define H_USE_HDPrintToBeAbolished						(1)					//< HDPrintToBeAbolishedを使用するか
#else	// _DEBUG
	#define H_DEBUG											(0)					//< debugを使用するか
	#define H_USE_HDPrint									(1)					//< debug printを使用するか
	#define H_USE_HDPrintToBeAbolished						(1)					//< HDPrintToBeAbolishedを使用するか
#endif	// _DEBUG

#define     H_USE_NAMESPACE									(0)					//< namespaceを使用するか


// namespace
#if       H_USE_NAMESPACE
	// namespaceを使用する
	#define H_NAMESPACE_START					namespace HLib {
	#define H_NAMESPACE_END						}
#else  // H_USE_NAMESPACE
	// namespaceを使用するしない
	#define H_NAMESPACE_START					
	#define H_NAMESPACE_END						
#endif // H_USE_NAMESPACE




/** @} */       // end of HLib group


#endif  // _HDefine_h_
