﻿#ifndef   _HDFWrite_h_
#define   _HDFWrite_h_


/**
 * @addtogroup HLib
 *  @{
 */


/**
 * HDFWrite
 * @file
 * @brief HLib debug fwrite.
 * @brief デバグ用のファイルへの文字出力。
 * @note デバグ用です。
 * @note バイナリが大きくなるのを無視し、ヘッダファイルのインクルードのみで使用できるようにしています。
 * @author aoi_lif
 */




//////////////////////////////////////////////////////////////
// include
//////////////////////////////////////////////////////////////
#include "./HDefine.h"                              // HLib define
#include "./HPlatform.h"                            // HLib platform




// start HLib namespace
H_NAMESPACE_START




#if       H_DEBUG
    // デバグ
  #define   H_USE_HDFWrite                          (1)             ///< HDFWrite を使用するか
#else  // H_DEBUG
    // デバグ以外
  #define   H_USE_HDFWrite                          (0)             ///< HDFWrite を使用するか
#endif // H_DEBUG


#if       H_USE_HDFWrite                    // HDFWrite を使用するか
	// HDFWrite を使用する
	/**
	 * デバグ用のfwrite
	 * @param[in] _fileName ファイル名
	 * @param[in] _data     データ
	 * @param[in] _dataSize データサイズ
	 * @warning _dataを複数回参照する為、_dataはマクロの副作用が起きないものでなければいけない。
	 * @warning _dataSizeを複数回参照する為、_dataSizeはマクロの副作用が起きないものでなければいけない。
	 */
	#define HDFWrite(_fileName, _data, _dataSize)																			\
				do {																										\
					if ((_fileName) != NULL) {																				\
						FILE	*pFP;																						\
						errno_t err = HFOpen(&pFP, (_fileName), "ab");														\
						if (pFP != NULL) {																					\
							fwrite((_data), sizeof(char), (_dataSize), pFP);												\
							fclose(pFP);																					\
						}																									\
					}																										\
				} while(0)
	#else   // H_USE_HDFWrite
		// HDFWrite を使用しない
	#define HDFWrite(_fileName, _data, _dataSize)
#endif // H_USE_HDFWrite




// end HLib namespace
H_NAMESPACE_END




/** @} */       // end of HLib group


#endif  // _HDFWrite_h_
