#!/bin/sh

trap "rm -f prototypes.h.tmp" 0 1 2 3 15

CPROTO_FLAGS='-m -d'
CPPFLAGS='-DSTDC_HEADERS=1
	-DHAVE_STRDUP=0
	-DHAVE_MEMSET=0
	-DHAVE_MEMMOVE=0
	-DMULTIBYTE_FILENAME=1
	-DRETSIGTYPE=void
	-DNEED_INCREMENTAL_INDICATOR=1
	-D__extension__=
'

SOURCES='append.c bitio.c crcio.c dhuf.c extract.c header.c
	huf.c larc.c lhadd.c lharc.c lhext.c
	lhlist.c maketbl.c maketree.c patmatch.c
	shuf.c slide.c util.c
'

exec 5>&1 > prototypes.h.tmp

cat <<END
/* This file was generated by cproto. */
#if PROTOTYPES /* defined in config.h */
#define P_(s) s
#else
#define P_(s) ()
#endif

END

cproto $CPROTO_FLAGS $CPPFLAGS $SOURCES | grep -v '^int main '

cat <<END

/* lharc.c */
RETSIGTYPE interrupt(int signo);
/* util.c */
#if !HAVE_MEMMOVE
void *memmove P_((void *dst, const void *src, size_t cnt));
#endif
#if !HAVE_STRDUP
char *strdup P_((char *buf));
#endif
#if !HAVE_MEMSET
char *memset P_((char *s, int c, int n));
#endif

/* vsnprintf.c */
#if !HAVE_VSNPRINTF
int vsnprintf P_((char *str, size_t n, const char *fmt, va_list ap));
int snprintf P_((char *str, size_t n, char const *fmt, ...));
#endif

#undef P_
END

exec 1>&5
if ! cmp prototypes.h.tmp prototypes.h; then
  mv -f prototypes.h prototypes.h.bak
  mv -f prototypes.h.tmp prototypes.h
fi
