package jp.sourceforge.lepidolite.dao;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;

/**
 * RlNV甭錋ʃZbg, Xe[gg
 * RlNṼN[YɕăN[YB
 * 
 * @see <a href="http://codezine.jp/a/article/aid/151.aspx">Oracle JDBChCoɃIuWFNg̎N[YǉFCodeZine</a>
 * @since 0.1.1
 */
public class ConnectionProxy {
	
	/**
	 * IWĩRlNVB
	 */
	private Connection conn;
	
	/**
	 * I[ṽXe[ggB
	 */
	private Set<Statement> openedStatements;
	
	/**
	 * I[v̌ʃZbgB
	 */
	private Set<ResultSet> openedResultSets;
	
	/**
	 * RlNV̑㗝IuWFNgB
	 */
	private Object proxy;
	
	/**
	 * BꂽRXgN^B
	 * 
	 * @param conn IWĩRlNVB
	 */
	private ConnectionProxy(Connection conn) {
		this.conn = conn;
		openedStatements = new HashSet<Statement>();
		openedResultSets = new HashSet<ResultSet>();
		proxy = Proxy.newProxyInstance(Connection.class.getClassLoader(),
				new Class[] { Connection.class }, new ConnectionHandler());
	}

	/**
	 * w肳ꂽRlNṼvNV𐶐B
	 * 
	 * @param conn IWĩRlNVB
	 * @return PreparedStatementResultSetclose؏ ܂񂾃RlNV
	 */
	public static Connection createProxy(Connection conn) {
        ConnectionProxy pc = new ConnectionProxy(conn);
        return (Connection)pc.proxy;
    }

	/**
	 * RlNV, ʃZbg, Xe[ggɑ΂鑀sB
	 * 
	 * @param target RlNV, ʃZbg, ܂̓Xe[ggB
	 * @param m Ăяoꂽ\bhB
	 * @param args \bhɑ΂B
	 * @return \bh̎sʁB
	 * @throws Throwable \bhŔOB
	 */
	private Object send(Object target, Method m, Object[] args) throws Throwable {
		try {
			return m.invoke(target, args);
		} catch (InvocationTargetException e) {
			throw e.getCause();
		}
	}

	/**
	 * ʃZbg, Xe[ggɑ΂ăN[Y삪Ƃ
	 * ĂяoAI[ṽ\[Xꗗ폜B
	 * 
	 * @param o N[Y삪ʃZbg, Xe[gg̃IuWFNgB
	 */
	private void remove(Object o) {
		if (o instanceof ResultSet) {
			openedResultSets.remove(o);
		} else if (o instanceof Statement) {
			openedStatements.remove(o);
		} else {
			throw new IllegalArgumentException("bad class:" + o);
		}
	}

	/**
	 * RlNVɑ΂ăN[Y삪ƂɌĂяoA
	 * I[v̌ʃZbg, Xe[ggSăN[YB
	 */
	private void closeAll() {
		for (ResultSet rs : openedResultSets) {
			try {
				rs.close();
			} catch (SQLException sqle) {
				throw new DaoException("ResultSet̃N[YɎs܂B", sqle);
			}
		}
		for (Statement ps : openedStatements) {
			try {
				ps.close();
			} catch (SQLException sqle) {
				throw new DaoException("Statement̃N[YɎs܂B", sqle);
			}
		}
	}

	/**
	 * ڑIuWFNgɑ΂đ삪ƂɏsB
	 *
	 */
	private class ConnectionHandler implements InvocationHandler {
		public Object invoke(Object proxy, Method method, Object[] args)
				throws Throwable {
			if (method.getName().equals("close")) {
				closeAll();
			} else if (method.getName().equals("equals") && args.length == 1) {
				return proxy == args[0];
			}
			Object o = send(conn, method, args);
			if (o instanceof DatabaseMetaData) {
				o = new Delegate(proxy, o, DatabaseMetaData.class).proxy;
			} else if (o instanceof CallableStatement) {
				openedStatements.add((Statement) o);
				o = new Delegate(proxy, o, CallableStatement.class).proxy;
			} else if (o instanceof PreparedStatement) {
				openedStatements.add((Statement) o);
				o = new Delegate(proxy, o, PreparedStatement.class).proxy;
			} else if (o instanceof Statement) {
				openedStatements.add((Statement) o);
				o = new Delegate(proxy, o, Statement.class).proxy;
			}
			return o;
		}
	}

	/**
	 * ڑIuWFNg琶ꂽʃZbg, Xe[gg
	 * ΂đ삪ƂɏsB
	 *
	 */
	private class Delegate implements InvocationHandler {
		private Object parent;
		private Object proxy;
		private Object original;

		private Delegate(Object parent, Object original, Class<?> c) {
			this.parent = parent;
			this.original = original;
			proxy = Proxy.newProxyInstance(c.getClassLoader(),
					new Class[] { c }, this);
		}

		public Object invoke(Object proxy, Method method, Object[] args)
				throws Throwable {
			if (method.getName().equals("close")) {
				remove(original);
			}
			Object o = send(original, method, args);
			
			if (o instanceof ResultSet) {
				openedResultSets.add((ResultSet) o);
				o = new Delegate(proxy, o, ResultSet.class).proxy;
			}
			if (original instanceof ResultSet && method.getName().equals("getStatement")) {
				// ResultSetgetStatement()ꍇ̑Ώ
				o = parent;
			}
			if (o instanceof Connection) {
				// StatemengetConnection()ꍇ̑Ώ
				o = parent;
			}
			return o;
		}
	}
}
