package jp.sourceforge.lepidolite.dao;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import junit.framework.TestCase;

public class DaoTransactionFactoryTest extends TestCase {
	
	
	public void testConnect() {
		DaoTransaction trans = null;
		try {
			trans = DaoTransactionFactory.getTransaction("test");
			Connection conn = trans.getConnection();
			Statement stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery("select 1");
			if (rs.next()) {
				assertEquals("lmF", rs.getInt(1), 1);
			} else {
				fail("a");
			}
		} catch (DaoException de) {
			de.printStackTrace();
			fail();
		} catch (SQLException sqle) {
			sqle.printStackTrace();
			fail();
		} finally {
			trans.close();
		}
	}
}
