package jp.sourceforge.lepidolite.dao;

import java.sql.Connection;
import java.sql.SQLException;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * f[^\[XgpgUNVEIuWFNgB
 *
 */
public class DataSourceDaoTransaction implements DaoTransaction {
	
	/**
	 * MOEIuWFNgB
	 */
	private Log log = LogFactory.getLog(this.getClass());
	
	/**
	 * ڑIuWFNgB
	 */
	private Connection conn;
	
	/**
	 * LҁB
	 */
	private String owner;
	
	
	/**
	 * gUNVIuWFNg𐶐܂B
	 * 
	 * @throws DaoException ReLXg̏ɎsƂA
	 * 					f[^\[X̎擾ɎsƂA
	 * 					f[^\[XڑIuWFNg擾łȂƂA
	 * 					ڑIuWFNg̎R~bg~߂ȂƂB
	 */
	DataSourceDaoTransaction() {
		try {
			InitialContext ic = new InitialContext();
			Context env = (Context) ic.lookup("java:comp/env");
			DataSource ds = (DataSource) env.lookup(DaoSettings.DATASOURCE_NAME);
			conn = ds.getConnection();
			conn.setAutoCommit(false);
		} catch (NamingException ne) {
			throw new DaoException("f[^\[X̎擾Ɏs܂B", ne);
		} catch (SQLException sqle) {
			throw new DaoException("ڑIuWFNg擾ł܂B", sqle);
		}
	}
	
	/**
	 * ڑIuWFNg擾B
	 * 
	 * @return ڑIuWFNgB
	 */
	public Connection getConnection() {
		return conn;
	}
	
	/**
	 * gUNVR~bgB
	 * 
	 * @throws DaoException R~bgsƂB
	 */
	public void commit() {
		try {
			conn.commit();
		} catch (SQLException sqle) {
			throw new DaoException("R~bg͎s܂B", sqle);
		}
	}
	
	/**
	 * gUNV[obNB
	 *
	 * @throws DaoException [obNsƂB
	 */
	public void rollback() {
		try {
			conn.rollback();
		} catch (SQLException sqle) {
			throw new DaoException("[obN͎s܂B", sqle);
		}
	}
	
	/**
	 * gUNVN[YB
	 * 
	 */
	public void close() {
		try {
			conn.close();
		} catch (SQLException sqle) {
			log.warn("gUNṼN[Y͎s܂B", sqle);
		} finally {
			conn = null;
		}
	}
	
	/**
	 * L҂ݒ肷B
	 * 
	 * @param owner L҂̃[UIDB
	 */
	public void setOwner(String owner) {
		this.owner = owner;
	}
	
	/**
	 * L҂擾B
	 * 
	 * @return L҂̃[UIDB
	 */
	public String getOwner() {
		return owner;
	}
}
