package jp.sourceforge.lepidolite.actions;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.sourceforge.lepidolite.dao.DaoTransaction;
import jp.sourceforge.lepidolite.dao.DaoTransactionFactory;
import jp.sourceforge.lepidolite.dao.UserDao;

import org.apache.struts.Globals;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.actions.EventDispatchAction;
import org.apache.struts.validator.LazyValidatorForm;

/**
 * pX[hύXʂ̃ANVB
 *
 */
public class PasswdAction extends EventDispatchAction {
	
	/**
	 * pX[hύXʂ\B
	 * 
	 */
	public ActionForward edit(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response) {
		// g[Nۑ
		saveToken(request);
		return mapping.findForward("edit");
	}
	
	
	/**
	 * pX[hύX{B
	 * 
	 * @param mapping ActionMappingB
	 * @param form NGXgɊ܂܂ActionForm BeanB
	 * @param request NGXgB
	 * @param response X|XB
	 * @return JڐB
	 */
	public ActionForward update(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response) {
		// g[NmF
		if (!isTokenValid(request, true)) {
			// G[bZ[Wݒ
			ActionErrors errors = new ActionErrors();
			errors.add(Globals.ERROR_KEY, new ActionMessage("errors.token"));
			saveErrors(request, errors);
			// g[Nۑ
			saveToken(request);
			return mapping.getInputForward();
		}
		
		// Ó`FbN
		ActionErrors errors = form.validate(mapping, request);
		if (!errors.isEmpty()) {
			// G[bZ[Wۑ
			saveErrors(request, errors);
			// g[Nۑ
			saveToken(request);
			return mapping.getInputForward();
		}
		
		DaoTransaction trans = DaoTransactionFactory.getTransaction(request.getRemoteUser());
		try {
			// Ώۃ[UOC[Uɐݒ
			LazyValidatorForm f = (LazyValidatorForm) form;
			f.set("user_id", request.getRemoteUser());
			
			// pX[hύX
			UserDao dao = new UserDao(trans);
			dao.updatePassword(f);
			trans.commit();
			
			// bZ[Wݒ
			ActionMessages messages = new ActionMessages();
			messages.add(Globals.MESSAGE_KEY, new ActionMessage("MPWU003"));
			saveMessages(request, messages);
			
			// ͒l
			form.reset(mapping, request);
		} catch (IllegalArgumentException iae) {
			// G[bZ[Wۑ
			errors = new ActionErrors();
			errors.add(Globals.ERROR_KEY, new ActionMessage("EPWU001"));
			saveErrors(request, errors);
		} finally {
			trans.close();
		}
		
		// g[Nۑ
		saveToken(request);
		return mapping.findForward("update");
	}
}
