/*!
	@breif	ev[gpXNvgVXe
	@auther	
	@note	2007/11/12 Created
	@note	STLmapgpĂ܂BxIɖ肪ꍇ͉C(ƎRei^O̐ݒ)KvłB
*/
#include <windows.h>
#include <iostream>
using namespace std;

#include "gmScripter.h"

/*
	SAFE_DELETE
*/
#ifndef SAFE_DELETE
#define SAFE_DELETE(p)       { if(p) { delete (p);     (p)=NULL; } }
#endif    

/*
	󔒂
*/
TCHAR* SPACECUTTER(TCHAR* tmp)
{
	int _j=0; while(tmp[_j] == ' ') _j++;
	tmp=&tmp[_j];
	_j=0; while(tmp[_j] == '@') _j++;
	tmp=&tmp[_j];
	return tmp;
}

TCHAR* SPACECLEAR(TCHAR* tmp)
{
	int _i=0,_j=0;
	TCHAR buff[1024]="";
	while(tmp[_j] != '\0')
	{
		if( tmp[_j] != ' ' && tmp[_j] != '@' ) buff[_i++] = tmp[_j];
		_j++;
	}
	buff[_i]='\0';
	strcpy( tmp , buff );
	return tmp;
}

TCHAR* ISNUMERIC(TCHAR* tmp)
{
	int _i=0,_j=0;
	TCHAR buff[1024]="";
	while(tmp[_j] != '\0')
	{
		if( tmp[_j] != ' ' && tmp[_j] != '@' ) buff[_i++] = tmp[_j];
		_j++;
	}
	buff[_i]='\0';
	strcpy( tmp , buff );
	return tmp;
}

CScriptCtrl::CScriptCtrl()
{
	this->m_vstScriptCtrl.clear();
	this->m_bAnalyzeFlg = 0;
}

CScriptCtrl::~CScriptCtrl()
{
	scr_ctrl::iterator i=m_vstScriptCtrl.begin();
	while( i != m_vstScriptCtrl.end() )
	{
		if( !i->second.empty() )
		{
			for( script::iterator it = i->second.begin(); it < i->second.end(); it++ )
			{
				SAFE_DELETE( it->Base );
			}
		}
		++i;
	}
	this->m_vstScriptCtrl.clear();
	this->m_SctiprFactry->ReleaseModule();
}

/*
	̋󔒂Ԃ
*/
TCHAR* SNIPSPRIT(TCHAR* tmp)
{
	TCHAR* ret=NULL,*t;
	if( (t = strstr( tmp+1, " " ))!=NULL )
	{
		ret = t;
	}
	else if( (t = strstr( tmp+1, "@" ))!=NULL )
	{
		ret = t;
	}
	else if( (t = strstr( tmp+1, "\n" ))!=NULL )
	{
		ret = t;
	}
	else if( (t = strstr( tmp+1, "\0" ))!=NULL )
	{
		ret = t;
	}
	return ret;
}

void	CScriptCtrl::LoadScript(TCHAR* fname)
{
	TCHAR	buff[1024];
	TCHAR	*tmp,*t;
	FILE* fp;
	fp = fopen(fname,"r+");
	if( fp == NULL ) return;

	/////@XNvgpbP[W
	string		sLabel;
	STT_SCTEMP	scr_tmp;
	script		script_tmp;
	sLabel="DEFAULT";
	script_tmp.clear();
	m_bAnalyzeFlg=0;
	/////////////////////////

	m_SctiprFactry = new ScriptController;
	m_SctiprFactry->SetModule();

	while( fgets( buff, 1024, fp ) )
	{
		tmp = buff;
		if( tmp[0] == '/' ) continue;	//Rg
		if( tmp[0] == '#' ){ tmp = Analyze(script_tmp,tmp,fp); continue; }
		if( tmp[0] == '$' ){ tmp = Variable(script_tmp,tmp); continue; }

		//////@͂ł̎Ⴕ͔ėp̂XNvg	///////////////////////////////////////////////////

		//GOTO
		if( !strncmp( tmp, "GOTO:", 5 ) )
		{
            tmp=&buff[5];
			tmp=SPACECUTTER(tmp);
			size_t len = strlen(tmp);
			tmp[len-1] = '\0';

			GOTO_Script* gt = new GOTO_Script;
			gt->SetLabel(tmp);
			scr_tmp.bExtFlag=SCR_END;
			scr_tmp.eExec=SCEXE_SYSTEM;
			scr_tmp.Base=gt;
			script_tmp.push_back(scr_tmp);
			continue;
		}

		//RETURN
		if( !strncmp( tmp, "RETURN", 6 ) )
		{
            tmp=&buff[5];
			tmp=SPACECUTTER(tmp);
			size_t len = strlen(tmp);
			tmp[len-1] = '\0';

			GOTO_Script* gt = new GOTO_Script;
			gt->SetLabel("");
			scr_tmp.bExtFlag=SCR_END;
			scr_tmp.eExec=SCEXE_SYSTEM;
			scr_tmp.Base=gt;
			script_tmp.push_back(scr_tmp);
			continue;
		}

		if( !strncmp( tmp, "LABEL:", 6 ) )
		{
			m_vstScriptCtrl.insert( std::map< std::string, script >::value_type( sLabel, script_tmp ) );
			
            tmp=&buff[6];
			tmp=SPACECUTTER(tmp);
			size_t len = strlen(tmp);
			tmp[len-1] = '\0';
			m_sLabelList.push_back(sLabel);
			sLabel=tmp;
			script_tmp.clear();
			continue;
		}

		////////////////////////////////////////////////////////////////////////////////////////////////////////////

		//ȊÔ̓eLXgAEg
		tmp = SPACECUTTER(tmp);
		size_t len = strlen(tmp);
		tmp[len-1] = '\0';
		scr_tmp.bExtFlag=0;
		scr_tmp.eExec=SCEXE_TEXTOUT;
		scr_tmp.Base=NULL;
		scr_tmp.sText = tmp;
		script_tmp.push_back(scr_tmp);
	}
	//Ō̃xB
	m_sLabelList.push_back(sLabel);
	m_vstScriptCtrl.insert( std::map< std::string, script >::value_type( sLabel, script_tmp ) );

	fclose(fp);

	m_sL = 0;
	m_sNowLabelName = m_sLabelList[m_sL];
	m_it = m_vstScriptCtrl[m_sNowLabelName].begin();
}

int	CScriptCtrl::Get(string& pStr)
{
	pStr.clear();
	if( m_it >= m_vstScriptCtrl[m_sNowLabelName].end() ) return 0;

	switch( m_it->eExec )
	{
//	SCEXE_SYSTEM,	//{\(DIMFLAGGOTOLABEL)
//	SCEXE_EXTRA,	//g\
	case SCEXE_CALC:
		if(m_it->Base)
		{
			Calc_Script* scr = (Calc_Script*)m_it->Base;
			VARIABLE*	 v = scr->GetData();
			TCHAR buff[64];

			if(v->type < 3)	m_vVariableList[v->key] = *v;
			switch(v->type)
			{
			case Calc_Script::NEW_TEXT:
				pStr = v->data_str;
				break;
			case Calc_Script::NEW_INT:
			case Calc_Script::NEW_DOUBLE:
				itoa( v->data_int, buff, 10 );
				pStr = buff;
				break;

			case Calc_Script::ADD_TEXT:
				strcat( m_vVariableList[v->key].data_str , v->data_str);
				pStr = m_vVariableList[v->key].data_str;
				break;
			case Calc_Script::ADD_INT:
				m_vVariableList[v->key].data_int += v->data_int;
				sprintf( buff, "%d", m_vVariableList[v->key].data_int );
				pStr = buff;
				break;
			case Calc_Script::ADD_DOUBLE:
				m_vVariableList[v->key].data_double += v->data_double;
				sprintf( buff, "%f", m_vVariableList[v->key].data_double );
				pStr = buff;
				break;

			case Calc_Script::EQ_VAR:
				if( m_vVariableList[v->data_str].type%3 == 0 ) {
					strcpy( buff ,m_vVariableList[v->data_str].data_str);
					strcpy( m_vVariableList[v->key].data_str ,buff);
					pStr = m_vVariableList[v->key].data_str;
				}else if( m_vVariableList[v->data_str].type%3 == 1 ) {
					m_vVariableList[v->key].data_int = m_vVariableList[v->data_str].data_int;
					sprintf( buff, "%d", m_vVariableList[v->key].data_int );
					pStr = buff;
				}else if( m_vVariableList[v->data_str].type%3 == 2 ) {
					m_vVariableList[v->key].data_double = m_vVariableList[v->data_str].data_double;
					sprintf( buff, "%f", m_vVariableList[v->key].data_double );
					pStr = buff;
				}
				break;

			case Calc_Script::ADD_VAR:
				if( m_vVariableList[v->data_str].type%3 == 0 ) {
					strcpy( buff ,m_vVariableList[v->data_str].data_str);
					strcat( m_vVariableList[v->key].data_str ,buff);
					pStr = m_vVariableList[v->key].data_str;
				}else if( m_vVariableList[v->data_str].type%3 == 1 ) {
					m_vVariableList[v->key].data_int += m_vVariableList[v->data_str].data_int*v->data_int;
					sprintf( buff, "%d", m_vVariableList[v->key].data_int );
					pStr = buff;
				}else if( m_vVariableList[v->data_str].type%3 == 2 ) {
					m_vVariableList[v->key].data_double += m_vVariableList[v->data_str].data_double*v->data_int;
					sprintf( buff, "%f", m_vVariableList[v->key].data_double );
					pStr = buff;
				}
				break;
			}

		}
		break;
	case SCEXE_TEXTOUT:
		if(m_it->Base)
		{
			m_it->Base->exec();
			pStr = m_it->Base->Get()->c_str();
		}else{
			pStr = m_it->sText.c_str();
		}
		break;
	}
	m_it++;
	return 1;
}

void	CScriptCtrl::Jump(string* str)
{
	for( int i=0; i < m_sLabelList.size(); i++ )
	{
		if( m_sLabelList[i] == *str )
		{
			m_sNowLabelName = m_sLabelList[i];
			m_sL = i;
			m_it = m_vstScriptCtrl[m_sNowLabelName].begin();
			break;
		}
	}
}

void	CScriptCtrl::Next(){
	if( m_it < m_vstScriptCtrl[m_sNowLabelName].end() ) return;
	m_sL++;
	if( m_sL >= m_sLabelList.size() ) return;
	m_sNowLabelName = m_sLabelList[m_sL];
	m_it = m_vstScriptCtrl[m_sNowLabelName].begin();
}


////////@͑u@////////////
TCHAR*	CScriptCtrl::Analyze(script& v_t,TCHAR* tmp,FILE* fp)
{
	STT_SCTEMP	scr_tmp;

	ScriptBase* scr_data = NULL;
	m_SctiprFactry->LoadModule(scr_data,tmp);
	scr_tmp.Base = scr_data;
	v_t.push_back(scr_tmp);

	return tmp;
}

bool IsZenkaku( unsigned char c )
{
	if ( c < 0x81 ) return false;//R[hApp
	if ( c < 0xA0 ) return true;
	if ( c < 0xE0 ) return false;//pJi
	if ( c < 0xFF ) return true;

	return false;
}

//ėpϐ
TCHAR*	CScriptCtrl::Variable(script& v_t,TCHAR* tmp)
{
	STT_SCTEMP	scr_tmp;
	TCHAR		__buff[1024];
	TCHAR		*__t,*__tmp;
	VARIABLE	v;

	tmp = &tmp[1];
	int l = strlen(tmp);
	tmp[l-1] = '\0';
	scr_tmp.Base = NULL;

	/*
		lȊO؂o(܂͑)
	*/
	TCHAR* t=NULL;
	TCHAR tBuf[64]="";
	tmp = SPACECLEAR(tmp);
	t=strstr(tmp,"=");
	if(t==NULL)t=strstr(tmp,"+");
	if(t==NULL)t=strstr(tmp,"-");
	if(t==NULL)t=strstr(tmp,"*");
	if(t==NULL)t=strstr(tmp,"/");
	if(t==NULL)t=strstr(tmp,"%");
	size_t len = (t-tmp);
	memcpy( tBuf, tmp, len );
	tBuf[len] = '\0';
	tmp=t+1;

	v.type=Calc_Script::NEW_TEXT;

	if( !IsZenkaku(tmp[0]) && isdigit(tmp[0]) )
	{
		int i=0;
		while(isdigit(tmp[i])||tmp[i]=='.')i++;
		tmp[i] = '\0';
		if( strstr(tmp,".") ) 
		{
			v.data_double = atof(tmp);
			v.type = Calc_Script::NEW_DOUBLE;
		}else{
			if(tmp[-1] == '+')
			{
				v.type = Calc_Script::ADD_INT;
				v.data_int = atoi(tmp);
			}
			else if(tmp[-1] == '-')
			{
				v.type = Calc_Script::ADD_INT;
				v.data_int = -atoi(tmp);
			}else{
				v.type = Calc_Script::NEW_INT;
				v.data_int = atoi(tmp);
			}
		}
	}else{/*
		if(tmp[0] == '+' && tmp[-1] == '+')
		{
			v.type = 4;
			v.data_int=1;
		}*/
		if(tmp[-1] == '+')
		{
			v.type = Calc_Script::ADD_TEXT;
			if(tmp[0] == '$')
			{
				v.type = Calc_Script::ADD_VAR;
				v.data_int = 1;
				tmp = &tmp[1];
			}
		}
		else if(tmp[-1] == '-')
		{
			if(tmp[0] == '$')
			{
				v.type = Calc_Script::ADD_VAR;
				v.data_int = -1;
				tmp = &tmp[1];
			}
		}
		if(tmp[0] == '$')
		{
			v.type = Calc_Script::EQ_VAR;
			tmp = &tmp[1];
		}
	}
	strcpy( v.data_str, tmp);
	strcpy( v.key , tBuf);
	Calc_Script* scr = new Calc_Script;
	scr->SetData(v);
	scr_tmp.Base = scr;
	scr_tmp.sText = tmp;
	scr_tmp.eExec = SCEXE_CALC;
	v_t.push_back(scr_tmp);
	//////////////////////////////////////////////////////////////////////////////////

	return tmp;
}