#include <iostream>
#include <windows.h>
#include <stdlib.h>
#include <string.h>
#include "gmScriptBase.h"
#include "scriptfactry.h"
#include "dlfnc.h"

#define BUF_SIZE 128
#define LOAD_MODULE_SYNTAX "LoadModule "
#define QUERY "This is a test for C++ dynamic class loading."
#define CONF_FILE "./test.conf"

int	ScriptController::SetModule(void)
{
    FILE *fp;
    const static char *conf_file = CONF_FILE;
    char buf[BUF_SIZE];

    // ݒt@CJ
    fp = fopen(conf_file, "r");
    if (fp == NULL) {
        std::cerr << "no configuration file found." << std::endl;
        return -1;
    }

    void *dlib;
    while (fgets(buf, BUF_SIZE, fp)) {
        if (buf[0] == '#') continue;
        buf[strlen(buf)-1] = ' ';
        // W[擾
        char *pbuf = strstr(buf, LOAD_MODULE_SYNTAX);
        pbuf += strlen(LOAD_MODULE_SYNTAX);

        char rel_mod_name[BUF_SIZE];
        sprintf(rel_mod_name, "./%s", pbuf);
        // W[[h(̎factoryɃCX^X֐ǉ)
        dlib = dlopen(rel_mod_name, RTLD_NOW);
        if (dlib == NULL) {
            std::cerr << dlerror() << std::endl;
			return -1;
        }

		ScriptFactry p;
		p.creater= (proc_creater*)GetProcAddress((HINSTANCE)dlib, "create");
		p.destroyer= (proc_destroyer*)GetProcAddress((HINSTANCE)dlib, "destroy");
		m_Factory.push_back(p);
        
		// ŃN[Y邽߂ɁAXgɒǉĂ
        m_dlList.push_back(dlib);
    }

    return 0;
}

void	ScriptController::LoadModule(ScriptBase* scr, TCHAR* tmp)
{
    std::list<ScriptFactry>::iterator qitr;
    // [hW[ꂼɑ΂
	for (qitr = m_Factory.begin(); qitr != m_Factory.end(); qitr++)
	{
		ScriptBase* p = qitr->creater(tmp);
		if(p)
		{
			p->init();
			break;
//			qitr->destroyer(p);
		}
	}
}

void	ScriptController::ReleaseModule()
{
    std::list<void *>::iterator itr;
    // W[̃A[h
    for (itr = m_dlList.begin(); itr != m_dlList.end(); itr++) {
        dlclose(*itr);
    }
}
