/*
	gD[VF[_ǗNX
*/

#include "dxSysAfx.h"
#include "dxSysCamera.h"
#include "ToonShader.h"
#include "d3dtypes.h"

ToonShader::~ToonShader()
{
	SAFE_RELEASE(m_pMesh);
	SAFE_RELEASE(m_pEffect);
}

void	ToonShader::Create(const TCHAR* fname)
{
	HRESULT hr;
/*
	// sNZVF[_o[W`FbN
    if( pCaps->PixelShaderVersion < D3DPS_VERSION(1,1) )
		return E_FAIL;

    // _VF[_o[Wʂ\tgEFA_
    if( pCaps->VertexShaderVersion < D3DVS_VERSION(1,1)
    &&  0==(dwBehavior & D3DCREATE_SOFTWARE_VERTEXPROCESSING) )
			return E_FAIL;
*/
	// cD[p̃eNX`
	int texNo = MCR_TEXMAN->CreateTexture((TCHAR*)fname);
	this->m_pTex = MCR_TEXMAN->GetTex(texNo);
//	D3DXCreateTextureFromFile(m_pd3dDevice, fname/*"toon.bmp"*/, &m_pTex);

	//b菈uB@ƂŐKB
	this->m_TextureID = MCR_TEXMAN->CreateTexture("t-pot.bmp");
	LoadEffect("hlsl.fx");

	m_rcWindowClient.top = 0;
	m_rcWindowClient.left = 0;
	m_rcWindowClient.right = 1024;
	m_rcWindowClient.bottom = 768;
/*	
	if(m_UserInput.bShift){
		// Cg̉]
		if( m_UserInput.bRotateLeft && !m_UserInput.bRotateRight )
			m_fLightRotY += m_fElapsedTime;
		else if( m_UserInput.bRotateRight && !m_UserInput.bRotateLeft )
			m_fLightRotY -= m_fElapsedTime;

		if( m_UserInput.bRotateUp && !m_UserInput.bRotateDown )
			m_fLightRotX += m_fElapsedTime;
		else if( m_UserInput.bRotateDown && !m_UserInput.bRotateUp )
			m_fLightRotX -= m_fElapsedTime;
	}else{
		// IuWFNg̉]
		if( m_UserInput.bRotateLeft && !m_UserInput.bRotateRight )
			m_fWorldRotY += m_fElapsedTime;
		else if( m_UserInput.bRotateRight && !m_UserInput.bRotateLeft )
			m_fWorldRotY -= m_fElapsedTime;

		if( m_UserInput.bRotateUp && !m_UserInput.bRotateDown )
			m_fWorldRotX += m_fElapsedTime;
		else if( m_UserInput.bRotateDown && !m_UserInput.bRotateUp )
			m_fWorldRotX -= m_fElapsedTime;
	}
*/
	//---------------------------------------------------------
	// ͂ɉčWnXV
	//---------------------------------------------------------
    D3DXMATRIX matRotY;
    D3DXMATRIX matRotX;

    m_vec3Rot.x                = -0.437504f;
    m_vec3Rot.y                = 1.0f;

    m_vecLightRot.x                = 0.344792f;
    m_vecLightRot.y                =-0.722427f;

	Refresh();

	// s̍쐬
    D3DXMatrixRotationX( &matRotX, m_vecLightRot.x );
    D3DXMatrixRotationY( &matRotY, m_vecLightRot.y );
    D3DXMatrixMultiply( &m_mLight, &matRotY, &matRotX );
/*
    D3DXMatrixRotationX( &matRotX, m_vec3Rot.x );
    D3DXMatrixRotationY( &matRotY, m_vec3Rot.y );
    D3DXMatrixMultiply( &m_matWorld, &matRotY, &matRotX );
*/
	MCR_DEVICE->SetTransform( D3DTS_WORLD, &m_matWorld );
}

void	ToonShader::Rendering()
{
	D3DXMATRIX m, mX, mY;
	D3DXVECTOR4 v;
	DWORD i;

    D3DXMATRIX matRotY;
    D3DXMATRIX matRotX;

	if(GetAsyncKeyState(VK_LEFT) & 0x8000){
		m_vecLightRot.x-=0.01f;
	}
	if(GetAsyncKeyState(VK_RIGHT) & 0x8000){
		m_vecLightRot.x+=0.01f;
	}

	if( GetAsyncKeyState(VK_UP) & 0x8000 ){
		m_vecLightRot.y-=0.01f;
	}
	if( GetAsyncKeyState(VK_DOWN) & 0x8000 ){
		m_vecLightRot.y+=0.01f;
	}

	D3DXMatrixRotationX( &matRotX, m_vecLightRot.x );
	D3DXMatrixRotationY( &matRotY, m_vecLightRot.y );
	D3DXMatrixMultiply( &m_mLight, &matRotY, &matRotX );
	D3DXVECTOR4 LightPos = D3DXVECTOR4(0.0f, 0.0f, -3.0f, 0.0f);
	D3DXVec4Transform( &LightPos, &LightPos, &m_mLight );

	D3DXMATRIX matV = *g_dxCameraCtrl->GetCurrentCamera()->GetViewmat();
	D3DXMATRIX matP = *g_dxCameraCtrl->GetProjectionMat();

	HRESULT hr;


	double time;
	LARGE_INTEGER spd_before,spd_after,freq;
	memset(&spd_before, 0x00,sizeof spd_before);
	memset(&spd_after,  0x00,sizeof spd_after);
	memset(&freq,		0x00,sizeof freq);
	QueryPerformanceCounter(&spd_before);

	MCR_DEVICE->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);	//_[Xe[g;At@uh֌W
	if(m_pEffect){
		hr= m_pEffect->SetTechnique( "TShader" );
		Begin();
		BeginPass( 0 );

		// ϊs̐ݒ
		D3DXMATRIX mWVP = m_matWorld* matV * matP;
		hr= m_pEffect->SetMatrix("mWVP", &mWVP);

		// Cǧ
		m = m_matWorld;
		D3DXMatrixInverse( &m, NULL, &m );
		D3DXVec4Transform( &v, &LightPos, &m );
		hr= m_pEffect->SetVector("LightPos", &v);

		// _
		v = D3DXVECTOR4(0,0,-5,0);
		m = m_matWorld;
		D3DXMatrixInverse( &m, NULL, &m );
		D3DXVec4Transform( &v, &v, &m );
		hr= m_pEffect->SetVector("EyePos", &v);

		hr= m_pEffect->SetTexture("ToonTex", m_pTex);
	/*
MCR_DEVICE->SetSamplerState( 0, D3DSAMP_MINFILTER, D3DTEXF_LINEAR );
MCR_DEVICE->SetSamplerState( 0, D3DSAMP_MAGFILTER, D3DTEXF_LINEAR );
MCR_DEVICE->SetSamplerState( 0, D3DSAMP_MIPFILTER, D3DTEXF_LINEAR );
		// ő~bv}bvڍ׃xݒ肷B
		// eNX`̃~bv}bvtB^ݒ肷B
		hr = MCR_DEVICE->SetSamplerState( 0, D3DSAMP_MIPFILTER, D3DTEXF_LINEAR );
		if( FAILED( hr ) )
		{
		// eNX`̃~bv}bvtB^ݒ肷邱ƂłȂB
		}
		hr = MCR_DEVICE->SetSamplerState( 0, D3DSAMP_MIPMAPLODBIAS, 0.0f );
		hr = MCR_DEVICE->SetSamplerState( 0, D3DSAMP_MAXMIPLEVEL, 0 );
		if( FAILED( hr ) )
		{
			// ő~bv}bvڍ׃xݒ肷邱ƂłȂB
			int a=0;
		}*/

		// Render the teapot mesh
		for(int i=0; i<m_numMatt;i++)
		{
			v.x = m_pMatt[i].Diffuse.r;
			v.y = m_pMatt[i].Diffuse.g;
			v.z = m_pMatt[i].Diffuse.b;
			m_pEffect->SetVector( "vColor", &v );
			m_pEffect->SetTexture( "DecaleTex", MCR_GETTEX(this->m_TextureID) );	
			hr= m_pMesh->DrawSubset( i );  // `
		}

		EndPass();
		End();
	}
	hr = MCR_DEVICE->SetSamplerState( 0, D3DSAMP_MIPMAPLODBIAS, 0.0f );
	hr = MCR_DEVICE->SetSamplerState( 0, D3DSAMP_MAXMIPLEVEL, 0 );
	MCR_DEVICE->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);	//_[Xe[g;At@uh֌W

	QueryPerformanceFrequency( &freq );
	QueryPerformanceCounter(&spd_after);
	time = (double)(spd_after.QuadPart - spd_before.QuadPart) * 1000 / (double)freq.QuadPart;
	TCHAR tmp[1024];
	sprintf( tmp, "Render MIPS: %1.8f/ms : 60Frame Score: %1.8f \n",time, time*60 );
	OutputDebugString( tmp );


	// Cg̈ʒu̕\
	m = matV * matP;
	v = LightPos;
	v.w = 1;
	D3DXVec4Transform( &v, &v, &m );
	float x = (this->m_rcWindowClient.right-this->m_rcWindowClient.left)*( 0.5f*v.x/v.w+0.5f);
	float y = (this->m_rcWindowClient.bottom-this->m_rcWindowClient.top)*(-0.5f*v.y/v.w+0.5f);

	MCR_DEVICE->SetTextureStageState(0,D3DTSS_COLOROP,	D3DTOP_SELECTARG1);
	MCR_DEVICE->SetTextureStageState(0,D3DTSS_COLORARG1,	D3DTA_DIFFUSE);
	MCR_DEVICE->SetTextureStageState(1,D3DTSS_COLOROP,    D3DTOP_DISABLE);
	MCR_DEVICE->SetRenderState( D3DRS_LIGHTING, FALSE );


	MCR_DEVICE->SetFVF( D3DFVF_XYZRHW | D3DFVF_DIFFUSE );
	MCR_DEVICE->SetVertexShader(NULL);
	MCR_DEVICE->SetPixelShader(NULL);

	typedef struct {FLOAT p[4]; DWORD color;} LVERTEX;
	for(DWORD i=0; i<2; i++){
		LVERTEX Vertex[4] = {
			// x  y   z rhw tu tv
			{x-3,y-3, v.z/v.w, 1, 0xffffc0,},
			{x+3,y-3, v.z/v.w, 1, 0xffffc0,},
			{x+3,y+3, v.z/v.w, 1, 0xffffc0,},
			{x-3,y+3, v.z/v.w, 1, 0xffffc0,},
		};
		MCR_DEVICE->DrawPrimitiveUP( D3DPT_TRIANGLEFAN, 2, Vertex, sizeof( LVERTEX ) );
	}
	MCR_DEVICE->SetTextureStageState(0,D3DTSS_COLOROP,D3DTOP_MODULATE);		//eNX`
	MCR_DEVICE->SetTextureStageState(0,D3DTSS_COLORARG1,D3DTA_TEXTURE);		//@@@@

	#if 1 // fobOpɃeNX`\
	{
		MCR_DEVICE->SetTextureStageState(0,D3DTSS_COLOROP,	D3DTOP_SELECTARG1);
		MCR_DEVICE->SetTextureStageState(0,D3DTSS_COLORARG1,	D3DTA_TEXTURE);
		MCR_DEVICE->SetTextureStageState(1,D3DTSS_COLOROP,    D3DTOP_DISABLE);
		MCR_DEVICE->SetVertexShader(NULL);
		MCR_DEVICE->SetFVF( D3DFVF_XYZRHW | D3DFVF_TEX1 );
		MCR_DEVICE->SetPixelShader(0);
		float scale = 128.0f;
		typedef struct {FLOAT p[4]; FLOAT tu, tv;} TVERTEX;
		for(DWORD i=0; i<1; i++){
			TVERTEX Vertex[4] = {
				// x  y  z rhw tu tv
				{    0,(i+0)*scale,0, 1, 0, 0,},
				{scale,(i+0)*scale,0, 1, 1, 0,},
				{scale,(i+1)*scale,0, 1, 1, 1,},
				{    0,(i+1)*scale,0, 1, 0, 1,},
			};
			if(0==i) MCR_DEVICE->SetTexture( 0, m_pTex );
			MCR_DEVICE->DrawPrimitiveUP( D3DPT_TRIANGLEFAN, 2, Vertex, sizeof( TVERTEX ) );
		}
	}
	#endif
}