#include <assert.h>
#include <ctype.h>
#include <errno.h>
#include <malloc.h>
#include <limits.h>
#include <stdarg.h>
#include <stddef.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#if defined(WIN32)

#include <windows.h>
#include <sys/timeb.h>

#elif defined(__GNUC__)

#include <sys/time.h>

#endif

#include "config.h"
#include "cp932.h"
#include "crypt64.h"
#include "desconst.h"
#include "tr64.h"
#include "translate.h"

#include "l2.h"

/*  */
unsigned char key[8 + 8];
unsigned char okey[8 + 8];

/* NX */
static
struct
{
  unsigned cls;
  unsigned map[256];
} kcls[8 + 8];


/* gNX */
#define KCLS_DT0 64
#define KCLS_DT1 128
#define KCLS_K2 256

/* w肳ꂽNXƓĂL[Aclassify s */
void
key_make_map( n )
int	n;
{
  int	i, j;
  unsigned int	c = kcls[n].map[key[n]];

  /* Ō̕ class map 𐶐KviV */
  if ( n >= 6 ) {
   return;
  }

  for ( i = 0; i < 256; i++ ) {
   unsigned bm = 0;
   if ( c & KCLS_K1 ) {
    if ( cp932[256 * key[n] + i] & KCLS_K1 ) {
     bm |= KCLS_K2 | (cp932[256 * key[n] + i] & KCLS_DT1);
    }
    if ( cp932[256 * (key[n] ^ 0x80) + i] & KCLS_K1 ) {
     bm |= KCLS_K2 | (cp932[256 * (key[n] ^ 0x80) + i] & KCLS_DT1);
    }
   }
   if ( c & (KCLS_AN | KCLS_KA | KCLS_K2) ) {
    for ( j = 0; j < 256; j++ ) {
     bm |= cp932[256 * i + j] & (KCLS_AN | KCLS_KA | KCLS_K1 | KCLS_DT0);
    }
   }
   kcls[n + 1].map[i] = bm;
   if ( i >= 128 && !(n == 0 || n == 1) ) {
    kcls[n + 1].map[i - 128] |= kcls[n + 1].map[i];
   }
  }

  if ( n < 6 ) {
   kcls[n + 1].map[0x00] = kcls[n + 1].map[0x80] = 0;
  }
  if ( n == 6 ) {
   kcls[7].map[0x00] |= KCLS_AN;
  }
}

/* }bv當EăZbg */
unsigned int
key_set( n, ch )
int	n;
unsigned int	ch;
{
  int	cnt = 0, i;

  for ( i = 0; i < 256; i++ ) {
   if ( kcls[n].map[i] ) {
    if ( ch-- == 0 ) {
     return( i );
    }
    cnt++;
   }
   if ( n != 1 && n != 2 && i >= 127 ) {
    break;
   }
  }
  /* Ȃ̂ł؂ */
  assert( cnt > 0 );
  ch %= cnt;
  for ( i = 0; i < 256; i++ ) {
   if ( kcls[n].map[i] ) {
    if ( ch-- == 0 ) {
     return( i );
    }
   }
  }
  assert( !"not matched" );
  return( 0 );
}

#if 0
key_set64( &key64, i, okey[i] = key[i], 0, 0x7F );
key_set64( &key64, i, key[i], key[i] ^ okey[i], 0 );
#endif

/* bitwise key Zbg */
static
void
key_set64(struct KEY *key64,
		  int n,
		  unsigned k,
		  unsigned vk,
		  unsigned sk)
{
  int	i, j;
  int	o;

  if ( !((vk | sk) & 0x7F) ) {
   return;
  }

  for ( i = 0; i < 7; i++ ) {
   if ( n == 7 && i < N_STRIDE ) {
    continue;
   }
   o = tr_pc1[n][6 - i] - 1;
   if ( sk & (1 << i) ) {
    if ( o < 28 ) {
     for ( j = 0; j < N_ALU; j++ ) {
      key64->k[0][0][o].a[j] = key64->k[0][1][o].a[j] = -!!(k & (1 << i));
     }
    } else {
     for ( j = 0; j < N_ALU; j++ ) {
      key64->k[1][0][o - 28].a[j] = key64->k[1][1][o - 28].a[j] = -!!(k & (1 << i));
     }
    }
   } else if ( vk & (1 << i) ) {
    if ( o < 28 ) {
     for ( j = 0; j < N_ALU; j++ ) {
      key64->k[0][0][o].a[j] = key64->k[0][1][o].a[j] = ~key64->k[0][0][o].a[j];
     }
    } else {
     for ( j = 0; j < N_ALU; j++ ) {
      key64->k[1][0][o - 28].a[j] = key64->k[1][1][o - 28].a[j] = ~key64->k[1][0][o - 28].a[j];
     }
    }
   }
  }
}

/* w肳ꂽNX̊JnlɃZbg
   Õ̕NXɔ */
int
key_reset( n )
int	n;
{
  if ( n >= 8 ) {
   return( 1 );
  }
  if ( n == 7 ) {
   key[7] = 0;
   return( 1 );
  }

  /* 0-2 ڂ̓_Ɍ߂ 3 ڈȍ~͏l */
  if ( n >= 3 ) {
   key[n] = key_set( n, 0 );
  } else {
   key[n] = key_set( n, rand() );
  }

  /* ZbgꂽɁAL̕NX߂ */
  key_make_map( n );

  return( key_reset(n + 1) );
}

/* w肳ꂽԂ̒ŁAL[ЂƂi߂
   SɃCNgłꍇ true Ԃ */
static
int
key_inc( n )
int	n;
{
  if ( n >= 8 ) {
   return( 0 );
  } else if ( n == 7 ) {
   key[7] = (key[7] + (1 << N_STRIDE)) & 0x7F;
   if ( key[7] ) {
    return( 1 );
   } else {
    return( 0 );
   }
  } else if ( key_inc( n + 1 ) ) {
   return( 1 );
  }

  if ( n == 1 || n == 2 ) {
   return( 1 );
  }

  /* ۂɑ₵Ă݂ */
  for ( ;; ) {
   if ( n <= 3 && !(key[n] & 0x80) &&
        kcls[n].map[key[n] ^ 0x80] & (KCLS_DT0) ) {
    /* pJ^Ji1oCg */
    key[n] ^= 0x80;
   } else {
    key[n] = (key[n] & 0x7F) + 1;
    if ( key[n] >= 0x80 ) {
     return( 0 );
    }
   }

   if ( kcls[n].map[key[n]] ) {
    key_make_map( n );
    key_reset( n + 1 );
    return( 1 );
   }
  }
}

/* SɃZbg
   SaltZbg */
static
void
key_init()
{
  int	i, j;
  unsigned int	bm;

  key[8] = 0;

  /* }bvg */
  for ( i = 0; i < 256; i++ ) {
   bm = 0;
   for ( j = 0; j < 256; j++ ) {
    bm |= cp932[256 * i + j];
   }
   kcls[0].map[i] = bm & (KCLS_AN | KCLS_KA | KCLS_K1 | KCLS_DT0);
   if ( i >= 128 ) {
    kcls[0].map[i - 128] |= kcls[0].map[i];
   }
  }

  key_reset( 0 );
}

#if N_STRIDE == 6
#define C(c,i,j,o) (*(int8_t  *)((c) + (loo - crypt64_sta) + los[6 * (i) + (j) + (o)]))
#elif N_STRIDE == 7
#define C(c,i,j,o) (*(int32_t *)((c) + (loo - crypt64_sta) + los[6 * (i) + (j) + (o)]))
#endif

void
set_salt(signed char *code,
		 unsigned char const *k)
{
  int	i, j;

  for ( i = 0; i < 2; i++ ) {
   unsigned s = k[1 + i] & 255;
   if ( s > 'z' ) {
    s = 0;
   } else if ( s >= 'a' ) {
    s = s - 'a' + 2 + 10 + 26;
   } else if ( s >= 'A' ) {
    s = s - 'A' + 2 + 10;
   } else if ( s >= '.' ) {
    s = s - '.';
   } else {
    s = 0;
   }

   for ( j = 0; j < 6; j++ ) {
    if ( s & (1 << j) ) {
     C(code, i, j,  0) = sizeof(WS_T) * (((4 * i + j + 15) & 31) - 16);
     C(code, i, j, 24) = sizeof(WS_T) * (((4 * i + j -  1) & 31) - 16);
    } else {
     C(code, i, j,  0) = sizeof(WS_T) * (((4 * i + j -  1) & 31) - 16);
     C(code, i, j, 24) = sizeof(WS_T) * (((4 * i + j + 15) & 31) - 16);
    }
    C(code, i, j, 12) = sizeof(WS_T) * (((4 * i + j +  7) & 31) - 16);
    C(code, i, j, 36) = sizeof(WS_T) * (((4 * i + j + 23) & 31) - 16);
   }
  }
}

static
uint32_t
usec()
{
  static uint32_t	epoch = 0;
  uint32_t	sec, msec;

#if !defined(WIN32)
  struct timeval	tv;
  gettimeofday( &tv, NULL );
  sec = tv.tv_sec;
  msec = tv.tv_usec / 10000;
#else
  struct timeb	tm;
  ftime( &tm );
  sec = tm.time;
  msec = tm.millitm / 10;
#endif

  if ( epoch == 0 ) {
   epoch = sec;
  }

  return ( (sec - epoch) * 100 + msec );
}

/* 萔 */
#if N_STRIDE == 7
static SLICE const sk6[N_STRIDE] =
{
  {0xAAAAAAAAUL, 0xAAAAAAAAUL, 0xAAAAAAAAUL, 0xAAAAAAAAUL},
  {0xCCCCCCCCUL, 0xCCCCCCCCUL, 0xCCCCCCCCUL, 0xCCCCCCCCUL},
  {0xF0F0F0F0UL, 0xF0F0F0F0UL, 0xF0F0F0F0UL, 0xF0F0F0F0UL},
  {0xFF00FF00UL, 0xFF00FF00UL, 0xFF00FF00UL, 0xFF00FF00UL},
  {0xFFFF0000UL, 0xFFFF0000UL, 0xFFFF0000UL, 0xFFFF0000UL},
  {0x00000000UL, 0xFFFFFFFFUL, 0x00000000UL, 0xFFFFFFFFUL},
  {0x00000000UL, 0x00000000UL, 0xFFFFFFFFUL, 0xFFFFFFFFUL},
};
#elif N_STRIDE == 6
static SLICE const sk6[N_STRIDE] =
{
  {0xAAAAAAAAUL, 0xAAAAAAAAUL},
  {0xCCCCCCCCUL, 0xCCCCCCCCUL},
  {0xF0F0F0F0UL, 0xF0F0F0F0UL},
  {0xFF00FF00UL, 0xFF00FF00UL},
  {0xFFFF0000UL, 0xFFFF0000UL},
  {0x00000000UL, 0xFFFFFFFFUL},
};
#endif

ALIGN_PREFIX(16) struct KEY key64 ALIGN_SUFFIX(16);
ALIGN_PREFIX(16) struct PARAM param64 ALIGN_SUFFIX(16);

int
main( ac, av )
int	ac;
char	*av[];
{
  int	i;
  signed char	*code;
  int	cr;
  int	codeSize;
  unsigned char	buf[32];

#define LOOP_FACTOR 128000	/* Ȃł */
#define UPDATE_INTERVAL 8	/* x\̊Ԋu b */
#define AVG_SPD 480000		/* ϑx̏l trips/s */
  struct status {
    uint32_t startTime;	/* Jn ~b */
    uint32_t lastTime;	/* Ōɕ\ ~b */
    uint32_t loop;	/*  % LOOP_FACTOR */
    uint32_t mloop;	/*  / LOOP_FACTOR */
    uint32_t lastloop;	/* Ōɕ\ loop */
  } status;
  uint32_t upd_int = AVG_SPD * UPDATE_INTERVAL;
/*
 ϑx (trips/s) * UPDATE_INTERVAL  UINT32_MAX 𒴂ƔB
 UINT32_MAX = 4294967295, ϑx = 100Mtrips/s ȂA
 4294967295 / (100 * 1000 * 1000) = 42.949 b܂ŁBia
 LOOP_FACTOR ϑx\΁AقڎwԊuɂȂB
 LOOP_FACTOR * UINT32_MAX + LOOP_FACOTR ƃI[o[t[B
 */

#ifdef WIN32
  HANDLE	h;
#endif

#ifndef __GNUC__
  CRYPT64_PP	d_crypt64;
#endif

  /* t[16] ́AZŎgpAall 1 Ă */
  for ( i = 0; i < N_ALU; i++ ) {
   param64.t[T_INV].a[i] = -1;
  }

  /* ŒL[̃Rs[ */
  for (i = 0; i < N_STRIDE; i++) {
   int o = tr_pc1[7][6 - i] - 1;
   if (o < 28) {
    key64.k[0][0][o] = key64.k[0][1][o] = sk6[i];
   } else {
    o -= 28;
    key64.k[1][0][o] = key64.k[1][1][o] = sk6[i];
   }
  }

  for ( i = 0; i < 28; i++ ) {
   key64.ks[i].a[0] = sizeof(WS_T) * ks_ls[i];
  }

  initComm();
  readList();

  codeSize = crypt64_end - crypt64_sta;
  code = NULL;

#ifdef WIN32
  code = (signed char*)VirtualAlloc( NULL, codeSize, MEM_COMMIT,
                                     PAGE_EXECUTE_READWRITE );
  if ( code == NULL ) {
   DWORD	errCode;
   errCode = GetLastError();
   fprintf( stderr, "VirtualAlloc ɎsB%lx\n", errCode );
   fprintf( stderr, "ACɂsB\n" );
  }
#if 0
  h = CreateFileMapping( INVALID_HANDLE_VALUE, NULL, PAGE_EXECUTE_READWRITE,
                         0, codeSize, NULL );
#ifndef FILE_MAP_EXECUTE
#define FILE_MAP_EXECUTE SECTION_MAP_EXECUTE    /* XXX cygwin */
#endif /* FILE_MAP_EXECUTE */
  if ( SUCCEEDED( h ) ) {
   code = (signed char *)MapViewOfFile( h, FILE_MAP_EXECUTE | FILE_MAP_WRITE,
                                        0, 0, 0 );
   if ( code == NULL ) {
    DWORD	errCode;
    errCode = GetLastError();
    CloseHandle( h );
    fprintf( stderr, "MapViewOfFile ɎsB%lx\n", errCode );
    fprintf( stderr, "ACɂsB\n" );
   }
  } else {
   fprintf( stderr, "CreateFileMapping ɎsB\n" );
   fprintf( stderr, "ACɂsB\n" );
  }
#endif /* 0 */
#else
  code = (signed char *)mmap( NULL, codeSize,
                              PROT_EXEC | PROT_READ | PROT_WRITE,
                              MAP_PRIVATE | MAP_ANON,
                              -1, 0 );
  if ( (void *)code == MAP_FAILED ) {
   code = NULL;
   fprintf( stderr, "mmap ɎsB\n" );
   fprintf( stderr, "ACɂsB\n" );
  }
#endif

  if ( code == NULL ) {
   fprintf( stderr, "傤Ȃ̂ malloc ł܂Ă݂eXgB\n" );
   code = (signed char *)malloc( codeSize );
   if ( code == NULL ) {
    fprintf( stderr, "Amalloc ɂsB\n" );
    exit( 1 );
   }
  }

  memcpy( code, crypt64_sta, codeSize );

#ifndef __GNUC__
  d_crypt64 = (CRYPT64_PP)code;
#endif

  /* L[̏ */
  srand( time( NULL ) );
  key_init();
  set_salt( code, key );
  for ( i = 0; i < 8; i++ ) {
   key_set64( &key64, i, okey[i] = key[i], 0, 0x7F );
  }

  cr = 0;
  memset( &status, 0, sizeof( struct status ) );
  status.startTime = status.lastTime = usec();
  for ( ;; ) {
   int	k, kk;

   /* ̃Zbg */
   for ( i = 0; i < 8; i++ ) {
    key_set64( &key64, i, key[i], key[i] ^ okey[i], 0 );
    okey[i] = key[i];
   }
   memcpy( buf, key, 32 );
   buf[8] = buf[9] = '\0';

   CALL_CRYPT64( code, key64.k, param64.lr );

   for ( kk = 0; kk < N_ALU; kk++ ) {
    static uint64_t	xhash[64];
    CALL_TR64( &param64.lr[0][0].q[kk / (N_ALU / N_Q)], xhash );
    for ( k = 0; k < ALU_BITS; k++ ) {
     buf[7] = (buf[7] & -(1 << N_STRIDE) & 0x7F) + ALU_BITS * kk + k;
     checkIt( xhash[(ALU_BITS * kk + k)&63], buf );
#ifdef OLDDEBUG
     printf( "%03d : key %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x\n",
             ALU_BITS * kk + k,
             key[0], key[1], key[2], key[3], key[4],
             key[5], key[6], key[7], key[8], key[9] );
#endif /* DEBUG */
#ifdef OLDDEBUG
     printf( "%03d : buf %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x\n",
             ALU_BITS * kk + k,
             buf[0], buf[1], buf[2], buf[3], buf[4],
             buf[5], buf[6], buf[7], buf[8], buf[9] );
#endif /* DEBUG */
    }
   }

   status.loop += N_ALU * ALU_BITS;
   if ( status.loop >= upd_int ) {
    /* 
     ōXVԊũ`FbN΁A}VŌ덷̑傫x\
     ôhB
     ƕʂ̃}VŃ_ usec() Ăяo邱ƂɂȂB
     ȂBĎ蔲ł͂ȂB
     */
    uint32_t	curTime, diffTime;
    int	a, b, c;

#ifdef SPDEBUG
    putchar( '\n' );
    printf( "mloop = %d, loop = %d\n", status.mloop, status.loop );
#endif
    curTime = usec();
    diffTime = curTime - status.lastTime;
    b = (status.loop - status.lastloop) * 100 / diffTime;
    status.mloop += ( status.loop / LOOP_FACTOR );
    status.loop %= LOOP_FACTOR;
    diffTime = curTime - status.startTime;
    if ( diffTime >= 1000000000 ) {
     c = 1000000;
    } else if ( diffTime >= 100000000 ) {
     c = 100000;
    } else if ( diffTime >= 10000000 ) {
     c = 10000;
    } else if ( diffTime >= 1000000 ) {
     c = 1000;
    } else if ( diffTime >= 100000 ) {
     c = 100;
    } else if ( diffTime >= 10000 ) {
     c = 10;
    } else {
     c = 1;
    }
    a = status.mloop * (LOOP_FACTOR / (10 * c)) / (diffTime / c);
    upd_int = b * UPDATE_INTERVAL;
    upd_int = upd_int / LOOP_FACTOR * LOOP_FACTOR;
#ifdef SPDEBUG
#ifndef USE_MMX
    printf( "%f\n",
            ((double)status.mloop * LOOP_FACTOR / 1000.0) /
            ((double)diffTime / 100.0) );
#endif
    printf( "mloop = %d, loop = %d\n", status.mloop, status.loop );
    printf( "elapsed = %d, span = %d\n",
            curTime - status.startTime, curTime - status.lastTime );
    printf( "c = %d\n", c );
    printf( "upd_int = %d\n", upd_int );
#endif
    status.lastTime = curTime;
    status.lastloop = status.loop;
    fprintf( stderr, "%6dktrips/s [%6d.%03dktrips/s]\r",
             a, b / 1000, b % 1000 );
    cr++;
   }
   if ( !key_inc( 3 ) ) {
    key_reset( 0 );
    set_salt( code, key );
    for ( i = 0; i < 8; i++ ) {
     key_set64( &key64, i, okey[i] = key[i], 0, 0x7F );
    }
   }
  }

  return( 0 );
}
