/* This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 * http://www.gnu.org/copyleft/gpl.html
 */
package net.sf.l2j.gameserver.instancemanager;

import net.sf.l2j.gameserver.GameTimeController;
import net.sf.l2j.gameserver.model.L2Object;

/**
 * L2J_JP r1057 CustomZoneManager ̎c[B
 */
public class CustomZoneManager
{
	private static CustomZoneManager _instance = new CustomZoneManager();
	public static final CustomZoneManager getInstance()
	{
		return _instance;
	}

	/**
	 * UP - RK쓌̓̓镔 scripts/ai/individual/Zaken.java ŎgpB
	 */
	public boolean isZakenWeakZone(L2Object npc)
	{
		if ((GameTimeController.getInstance().getGameTime() / 60) % 24 < 5) return false;
		return CustomZoneManager.getInstance().isInsideSunlightRoomZone(npc);
	}

	public boolean isInsideSunlightRoomZone(L2Object obj)
	{
		int x = obj.getX();
		int y = obj.getY();
		int z = obj.getZ();
		return 55779 <= x && x <=  56789
		   && 219619 <= y && y <= 220636
		   &&  -2970 <= z && z <=  -2690;

		//f[^ (L2J_JP r1057)
		//zone.xml
		//	<zone id='12012' type='BossZone' shape='Cuboid' minZ='-2900' maxZ='-2690'>
		//		<stat name='name' val='SunlightRoom'/>
		//		<stat name='Flying' val='false'/>
		//		<stat name='InvadeTime' val='0'/>
		//		<stat name='InvadeTimeAfterRestart' val='0'/>
		//	</zone>
		//zone_vertices.sql
		//   (id,order,x,y) VALUES
		//   (12012, 0, 55794, 219633),
		//   (12012, 1, 56789, 220629)
	}

	/**
	 * AҁEOAEgEX^֎~
	 * "You can not escape from here."
	 * "You can not log out in here."
	 * "You can not restart in here."
	 */
	public boolean isInsideNoEscapeZone(L2Object obj)
	{
		int x = obj.getX();
		int y = obj.getY();
		return -114800 <= x && x <= -114289
		    && -250740 <= y && y <= -251511;

		//f[^ (L2J_JP r1057)
		//zone.xml
		//	<zone id='12001' type='CustomZone' shape='Cuboid' minZ='0' maxZ='0'>
		//		<stat name='name' val='NoEscape'/>
		//		<stat name='flying' val='false'/>
		//	</zone>
		//zone_vertices.sql
		// (id,order,x,y) VALUES
		// (12001, 0, -114800, -250740),
		// (12001, 1, -114289, -251511),
	}

	/**
	 * S_
	 */
	public boolean isInsideFourSepulcherZone(L2Object obj)
	{
		return GrandBossManager.getInstance().checkIfInZone("Four Sepulcher", obj);
	}
}