/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package net.sf.l2j.gameserver.communitybbs.Manager;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

import javolution.text.TextBuilder;
import javolution.util.FastList;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.GameServer;
import net.sf.l2j.gameserver.GameTimeController;
import net.sf.l2j.gameserver.model.BlockList;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.model.actor.instance.L2PcInstance;
import net.sf.l2j.gameserver.model.base.Experience;
import net.sf.l2j.gameserver.network.SystemMessageId;
import net.sf.l2j.gameserver.network.clientpackets.Say2;
import net.sf.l2j.gameserver.network.serverpackets.CreatureSay;
import net.sf.l2j.gameserver.network.serverpackets.ShowBoard;
import net.sf.l2j.gameserver.network.serverpackets.SystemMessage;

public class RegionBBSManager extends BaseBBSManager
{
	private static Logger _logChat = Logger.getLogger("chat");
	
	/**
	 * 
	 * @see net.sf.l2j.gameserver.communitybbs.Manager.BaseBBSManager#parsecmd(java.lang.String, net.sf.l2j.gameserver.model.actor.instance.L2PcInstance)
	 */
	@Override
	public void parsecmd(String command, L2PcInstance activeChar)
	{
		if (command.equals("_bbsloc"))
		{
			showOldCommunity(activeChar, 1);
		}
		else if (command.startsWith("_bbsloc;page;"))
		{
			StringTokenizer st = new StringTokenizer(command, ";");
			st.nextToken();
			st.nextToken();
			int page = 0;
			try
			{
				page = Integer.parseInt(st.nextToken());
			}
			catch (NumberFormatException nfe)
			{
			}
			
			showOldCommunity(activeChar, page);
		}
		else if (command.startsWith("_bbsloc;playerinfo;"))
		{
			StringTokenizer st = new StringTokenizer(command, ";");
			st.nextToken();
			st.nextToken();
			String name = st.nextToken();
			
			showOldCommunityPI(activeChar, name);
		}
		else
		{
			if (Config.COMMUNITY_TYPE == 1)
			{
				showOldCommunity(activeChar, 1);
			}
			else
			{
				ShowBoard sb = new ShowBoard("<html><body><br><br><center>the command: " + command + " is not implemented yet</center><br><br></body></html>", "101");
				activeChar.sendPacket(sb);
				activeChar.sendPacket(new ShowBoard(null, "102"));
				activeChar.sendPacket(new ShowBoard(null, "103"));
			}
		}
	}
	
	/**
	 * @param activeChar
	 * @param name
	 */
	private void showOldCommunityPI(L2PcInstance activeChar, String name)
	{
		TextBuilder htmlCode = new TextBuilder("<html><body><br>");
		htmlCode.append("<table border=0><tr><td FIXWIDTH=15></td><td align=center>L2J Community Board<img src=\"sek.cbui355\" width=610 height=1></td></tr><tr><td FIXWIDTH=15></td><td>");
		L2PcInstance player = L2World.getInstance().getPlayer(name);
		
		if (player != null)
		{
			String sex = "Male";
			if (player.getAppearance().getSex())
			{
				sex = "Female";
			}
			String levelApprox = "low";
			if (player.getLevel() >= 60)
				levelApprox = "very high";
			else if (player.getLevel() >= 40)
				levelApprox = "high";
			else if (player.getLevel() >= 20)
				levelApprox = "medium";
			htmlCode.append("<table border=0><tr><td>" + player.getName() + " (" + sex + " " + player.getTemplate().className + "):</td></tr>");
			htmlCode.append("<tr><td>Level: " + levelApprox + "</td></tr>");
			htmlCode.append("<tr><td><br></td></tr>");
			
			if (activeChar != null && (activeChar.isGM() || player.getObjectId() == activeChar.getObjectId() || Config.SHOW_LEVEL_COMMUNITYBOARD))
			{
				long nextLevelExp = 0;
				long nextLevelExpNeeded = 0;
				if (player.getLevel() < (Experience.MAX_LEVEL - 1))
				{
					nextLevelExp = Experience.LEVEL[player.getLevel() + 1];
					nextLevelExpNeeded = nextLevelExp - player.getExp();
				}
				
				htmlCode.append("<tr><td>Level: " + player.getLevel() + "</td></tr>");
				htmlCode.append("<tr><td>Experience: " + player.getExp() + "/" + nextLevelExp + "</td></tr>");
				htmlCode.append("<tr><td>Experience needed for level up: " + nextLevelExpNeeded + "</td></tr>");
				htmlCode.append("<tr><td><br></td></tr>");
			}
			
			int uptime = (int) player.getUptime() / 1000;
			int h = uptime / 3600;
			int m = (uptime - (h * 3600)) / 60;
			int s = ((uptime - (h * 3600)) - (m * 60));
			
			htmlCode.append("<tr><td>Uptime: " + h + "h " + m + "m " + s + "s</td></tr>");
			htmlCode.append("<tr><td><br></td></tr>");
			
			if (player.getClan() != null)
			{
				htmlCode.append("<tr><td>Clan: " + player.getClan().getName() + "</td></tr>");
				htmlCode.append("<tr><td><br></td></tr>");
			}
			
			htmlCode.append("<tr><td><multiedit var=\"pm\" width=240 height=40><button value=\"Send PM\" action=\"Write Region PM "
					+ player.getName()
					+ " pm pm pm\" width=110 height=15 back=\"L2UI_ct1.button_df\" fore=\"L2UI_ct1.button_df\"></td></tr>");
			if (activeChar.isGM())
			{
				htmlCode.append("<tr><td><br><button value=\"ďo\" action=\"bypass -h admin_recall " + player.getName()
						+ "\" width=80 height=15 back=\"L2UI_ct1.button_df\" fore=\"L2UI_ct1.button_df\"></td></tr>");
				if (player.getParty() != null)
					htmlCode.append("<tr><td><br><button value=\"osďo\" action=\"bypass -h admin_recall_pt " + player.getName() + "\" width=80 height=15 back=\"L2UI_ct1.button_df\" fore=\"L2UI_ct1.button_df\"></td></tr>");
				htmlCode.append("<tr><td><br><button value=\"ȓ]\" action=\"bypass -h admin_teleportto " + player.getName()
						+ "\" width=80 height=15 back=\"L2UI_ct1.button_df\" fore=\"L2UI_ct1.button_df\"></td></tr>");
			}
			htmlCode.append("<tr><td><br><button value=\"Back\" action=\"bypass _bbsloc\" width=40 height=15 back=\"L2UI_ct1.button_df\" fore=\"L2UI_ct1.button_df\"></td></tr></table>");
			htmlCode.append("</td></tr></table>");
			htmlCode.append("</body></html>");
			separateAndSend(htmlCode.toString(), activeChar);
		}
		else
		{
			ShowBoard sb = new ShowBoard("<html><body><br><br><center>No player with name " + name + "</center><br><br></body></html>", "101");
			activeChar.sendPacket(sb);
			activeChar.sendPacket(new ShowBoard(null, "102"));
			activeChar.sendPacket(new ShowBoard(null, "103"));
		}
	}
	
	/**
	 * @param activeChar
	 */
	private void showOldCommunity(L2PcInstance activeChar, int page)
	{
		separateAndSend(getCommunityPage(page, activeChar.isGM() ? RegionBBSManager.FOR_GM/*"gm"*/ : RegionBBSManager.FOR_PLAYER/*"pl"*/), activeChar);
	}
	
	/* (non-Javadoc)
	 * @see net.sf.l2j.gameserver.communitybbs.Manager.BaseBBSManager#parsewrite(java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, net.sf.l2j.gameserver.model.actor.instance.L2PcInstance)
	 */
	@Override
	public void parsewrite(String ar1, String ar2, String ar3, String ar4, String ar5, L2PcInstance activeChar)
	{
		if (activeChar == null)
			return;
		
		if (ar1.equals("PM"))
		{
			TextBuilder htmlCode = new TextBuilder("<html><body><br>");
			htmlCode.append("<table border=0><tr><td FIXWIDTH=15></td><td align=center>L2J Community Board<img src=\"sek.cbui355\" width=610 height=1></td></tr><tr><td FIXWIDTH=15></td><td>");
			
			try
			{
				
				L2PcInstance receiver = L2World.getInstance().getPlayer(ar2);
				if (receiver == null)
				{
					htmlCode.append("Player not found!<br><button value=\"Back\" action=\"bypass _bbsloc;playerinfo;" + ar2 + "\" width=40 height=15 back=\"L2UI_ct1.button_df\" fore=\"L2UI_ct1.button_df\">");
					htmlCode.append("</td></tr></table></body></html>");
					separateAndSend(htmlCode.toString(), activeChar);
					return;
				}
				if (Config.JAIL_DISABLE_CHAT && receiver.isInJail())
				{
					activeChar.sendMessage("Player is in jail.");
					return;
				}
				if (receiver.isChatBanned())
				{
					activeChar.sendMessage("Player is chat banned.");
					return;
				}
				if (activeChar.isInJail() && Config.JAIL_DISABLE_CHAT)
				{
					activeChar.sendMessage("You can not chat while in jail.");
					return;
				}
				
				if (Config.LOG_CHAT)
				{
					LogRecord record = new LogRecord(Level.INFO, ar3);
					record.setLoggerName("chat");
					record.setParameters(new Object[]
					{
						"TELL", "[" + activeChar.getName() + " to " + receiver.getName() + "]"
					});
					_logChat.log(record);
				}
				CreatureSay cs = new CreatureSay(activeChar.getObjectId(), Say2.TELL, activeChar.getName(), ar3);
				if (receiver != null && !BlockList.isBlocked(receiver, activeChar))
				{
					if (!receiver.getMessageRefusal())
					{
						receiver.sendPacket(cs);
						activeChar.sendPacket(new CreatureSay(activeChar.getObjectId(), Say2.TELL, "->" + receiver.getName(), ar3));
						htmlCode.append("Message Sent<br><button value=\"Back\" action=\"bypass _bbsloc;playerinfo;" + receiver.getName() + "\" width=40 height=15 back=\"L2UI_ct1.button_df\" fore=\"L2UI_ct1.button_df\">");
						htmlCode.append("</td></tr></table></body></html>");
						separateAndSend(htmlCode.toString(), activeChar);
					}
					else
					{
						SystemMessage sm = new SystemMessage(SystemMessageId.THE_PERSON_IS_IN_MESSAGE_REFUSAL_MODE);
						activeChar.sendPacket(sm);
						parsecmd("_bbsloc;playerinfo;" + receiver.getName(), activeChar);
					}
				}
				else
				{
					SystemMessage sm = new SystemMessage(SystemMessageId.S1_IS_NOT_ONLINE);
					sm.addString(receiver.getName());
					activeChar.sendPacket(sm);
					sm = null;
				}
			}
			catch (StringIndexOutOfBoundsException e)
			{
				// ignore
			}
		}
		else
		{
			ShowBoard sb = new ShowBoard("<html><body><br><br><center>the command: " + ar1 + " is not implemented yet</center><br><br></body></html>", "101");
			activeChar.sendPacket(sb);
			activeChar.sendPacket(new ShowBoard(null, "102"));
			activeChar.sendPacket(new ShowBoard(null, "103"));
		}
		
	}
	private static RegionBBSManager _instance = null;
	private static final int _onlineCounts[] = new int[2];
	private static final int FOR_PLAYER = 0, FOR_GM = 1;
	@SuppressWarnings("unchecked")
	private static final FastList<String> _communityPages[] = new FastList[2];
		static {
			_communityPages[FOR_PLAYER] = new FastList<String>();
			_communityPages[FOR_GM] = new FastList<String>();
		}

	private static final SimpleDateFormat dateformat = new SimpleDateFormat("yyyy/MM/dd HH:mm");
	private static final SimpleDateFormat shortformat = new SimpleDateFormat("H mm");

	/**
	 * @return
	 */
	public static RegionBBSManager getInstance()
	{
		if (_instance == null)
		{
			_instance = new RegionBBSManager();
		}
		return _instance;
	}
	
	public synchronized void changeCommunityBoard()
	{
		FastList<L2PcInstance> sortedPlayers = new FastList<L2PcInstance>();
		//synchronized (L2World.getInstance().getAllPlayers())
		{
			sortedPlayers.addAll(L2World.getInstance().getAllPlayers().values());
		}
		
		Collections.sort(sortedPlayers, new Comparator<L2PcInstance>() {
			public int compare(L2PcInstance p1, L2PcInstance p2)
			{
				return p1.getName().compareToIgnoreCase(p2.getName());
			}
		});
		
		_onlineCounts[FOR_PLAYER] = 0;
		_onlineCounts[FOR_GM] = 0;
		
		for (L2PcInstance player : sortedPlayers)
		{
			addOnlinePlayer(player);
		}
		
		_communityPages[FOR_PLAYER].clear();
		_communityPages[FOR_GM].clear();

		writeCommunityPages(sortedPlayers);
	}
	
	private void addOnlinePlayer(L2PcInstance player)
	{
		++_onlineCounts[FOR_GM];
		if (! player.getAppearance().getInvisible())
			++_onlineCounts[FOR_PLAYER];
	}
	
	private void writeCommunityPages(FastList<L2PcInstance> sortedPlayers)
	{
		final String trOpen = "<tr>";
		final String trClose = "</tr>";
		final String tdOpen = "<td align=left valign=top>";
		final String colSpacer = "<td FIXWIDTH=15></td>";
		final String tdClose = "</td>";

		StringBuilder htmlCode;

		for (int type = 0; type <= 1; ++type)
		{
			//-------------
			// BBS HEADER
			//-------------
			htmlCode = new StringBuilder(2000);
			htmlCode.append("<html><body><br>");
			htmlCode.append("<center><table width=80><tr><td width=80><img src=l2ui.bbs_lineage2 height=16 width=80></td></tr><tr><td height=12></td></tr></table><center>");
			htmlCode.append("<img src=\"sek.cbui355\" width=\"610\" height=\"1\"><br>");
			
			htmlCode.append("<table width=630>");
			
			htmlCode.append(trOpen);
			htmlCode.append(tdOpen + "Q[: %gametime%" + tdClose);
			htmlCode.append(tdOpen + "T[o[: %realtime%" + tdClose);
			htmlCode.append(tdOpen + "T[o[N: " + dateformat.format(GameServer.dateTimeServerStarted.getTime()) + tdClose);
			htmlCode.append(trClose);
			
			htmlCode.append("</table>");
			
			htmlCode.append("<table width=630>");
			
			htmlCode.append(trOpen);
			htmlCode.append(tdOpen + "XP Rate: x" + Config.RATE_XP + tdClose);
			htmlCode.append(colSpacer);
			htmlCode.append(tdOpen + "Party XP Rate: x" + Config.RATE_XP * Config.RATE_PARTY_XP + tdClose);
			htmlCode.append(colSpacer);
			htmlCode.append(tdOpen + "XP Exponent: " + Config.ALT_GAME_EXPONENT_XP + tdClose);
			htmlCode.append(trClose);
			
			htmlCode.append(trOpen);
			htmlCode.append(tdOpen + "SP Rate: x" + Config.RATE_SP + tdClose);
			htmlCode.append(colSpacer);
			htmlCode.append(tdOpen + "Party SP Rate: x" + Config.RATE_SP * Config.RATE_PARTY_SP + tdClose);
			htmlCode.append(colSpacer);
			htmlCode.append(tdOpen + "SP Exponent: " + Config.ALT_GAME_EXPONENT_SP + tdClose);
			htmlCode.append(trClose);
			
			htmlCode.append(trOpen);
			htmlCode.append(tdOpen + "Drop Rate: " + Config.RATE_DROP_ITEMS + tdClose);
			htmlCode.append(colSpacer);
			htmlCode.append(tdOpen + "Spoil Rate: " + Config.RATE_DROP_SPOIL + tdClose);
			htmlCode.append(colSpacer);
			htmlCode.append(tdOpen + "Adena Rate: " + Config.RATE_DROP_ADENA + tdClose);
			htmlCode.append(trClose);
			
			htmlCode.append("</table>");
			
			htmlCode.append("<br><img src=\"sek.cbui355\" width=610 height=1><br>");
			
			if (type == FOR_GM)
				htmlCode.append(L2World.getInstance().getAllVisibleObjectsCount() + " Object count<br1>");
			htmlCode.append( _onlineCounts[type] + " Player(s) Online<br1>");
			if (Config.BBS_SHOW_PLAYERLIST)
				htmlCode.append("(Yellow names are GM)<br1>");
			
			StringBuilder htmlHeader = new StringBuilder(htmlCode);
			htmlCode = null;
			
			//-----------------
			// BBS PLAYER LIST
			//-----------------
			FastList<StringBuilder> pages = new FastList<StringBuilder>();
			
			if (Config.BBS_SHOW_PLAYERLIST)
			{
				int cells[] = new int[sortedPlayers.size() / Config.NAME_PAGE_SIZE_COMMUNITYBOARD + 3];
				int page = 0, cell = 0;
			
				final String tableOpen_1 = "<table border=0>";
				final String trOpen_2 = "<tr>";
				final String colSpacer_2 = colSpacer;
				final String trClose_2 = "</tr>";
				final String tableClose_1 = "</table><hr>";

				for (L2PcInstance player : sortedPlayers)
				{
					if (type == FOR_PLAYER && player.getAppearance().getInvisible())
						continue;	 // Go to next
					
					++cell;
					if (cell == 1)
					{
						++page;
						htmlCode = new StringBuilder(htmlHeader.length() + 2000);
						htmlCode.append(htmlHeader);
						htmlCode.append(tableOpen_1);
					}
					if (cell % Config.NAME_PER_ROW_COMMUNITYBOARD == 1) htmlCode.append(trOpen_2);
					
					htmlCode.append("<td align=left valign=top FIXWIDTH=110><a action=\"bypass _bbsloc;playerinfo;" + player.getName() + "\">");
					
					if (player.isGM())
						htmlCode.append("<font color=\"LEVEL\">" + player.getName() + "</font>");
					else
						htmlCode.append(player.getName());
					
					htmlCode.append("</a></td>");
					
					if (cell % Config.NAME_PER_ROW_COMMUNITYBOARD == 0)
						htmlCode.append(trClose_2);
					else
						htmlCode.append(colSpacer_2);
					
					if (cell == Config.NAME_PAGE_SIZE_COMMUNITYBOARD)
					{
						htmlCode.append(tableClose_1);
						pages.add(htmlCode);
						htmlCode = null;
						cells[page] = cell;
						cell = 0;
					}
				}
				
				if (cell % Config.NAME_PER_ROW_COMMUNITYBOARD != 0)
					htmlCode.append(trClose_2);
				
				if (cell > 0)
				{
					htmlCode.append(tableClose_1);
					pages.add(htmlCode);
					htmlCode = null;
					cells[page] = cell;
					cell = 0;
				}
				
				if (pages.size() >= 2)
				{
					page = 0;
					for (StringBuilder html : pages)
					{
						htmlCode = html; ++page;
						htmlCode.append("<br1><table border=0 width=600>");
						htmlCode.append("<tr>");
						if (page == 1)
							htmlCode.append("<td align=right width=190></td>");
						else
							htmlCode.append("<td align=right width=190><button value=\"Prev\" action=\"bypass _bbsloc;page;" + (page - 1)
									+ "\" width=50 height=15 back=\"L2UI_ct1.button_df\" fore=\"L2UI_ct1.button_df\"></td>");
						htmlCode.append("<td FIXWIDTH=10></td>");
						int n1 = ((page - 1) * Config.NAME_PAGE_SIZE_COMMUNITYBOARD) + 1;
						int n2 = ((page - 1) * Config.NAME_PAGE_SIZE_COMMUNITYBOARD) + cells[page];
						htmlCode.append("<td align=center valign=top width=200>" + n1 + " - " + n2 + " ̃vC[\</td>");
						htmlCode.append("<td FIXWIDTH=10></td>");
						if (page == pages.size())
							htmlCode.append("<td width=190></td>");
						else
							htmlCode.append("<td width=190><button value=\"Next\" action=\"bypass _bbsloc;page;" + (page + 1)
									+ "\" width=50 height=15 back=\"L2UI_ct1.button_df\" fore=\"L2UI_ct1.button_df\"></td>");
						htmlCode.append("</tr>");
						htmlCode.append("</table>");
					}
				}
			}

			if (pages.size() == 0)
			{
				pages.add(htmlHeader);
			}

			//--------------------------
			// BBS HEADER + PLAYER LIST
			//--------------------------
			for (StringBuilder html : pages)
			{
				htmlCode = html;
				htmlCode.append("</body></html>");
				_communityPages[type].add(new String(htmlCode));
			}
			
		} /*for type*/
	}
	
	private int getOnlineCount(int type)
	{
		return  _onlineCounts[type];
	}
	
	private FastList<L2PcInstance> getOnlinePlayers(int page)
	{
		return null;
	}
	
	private String getCommunityPage(int page, int type)
	{
		FastList<String> pages = _communityPages[type];
		if (page < 1)
			page = 1;
		if (page > pages.size())
			page = pages.size();

		Calendar realtime = Calendar.getInstance();
		Calendar gametime = Calendar.getInstance();
		int t = GameTimeController.getInstance().getGameTime();
		gametime.set(Calendar.HOUR_OF_DAY, t / 60);
		gametime.set(Calendar.MINUTE, t % 60);

		return pages.get(page-1)
					.replaceFirst("%gametime%", shortformat.format(gametime.getTime()))
					.replaceFirst("%realtime%", dateformat.format(realtime.getTime()))
					;
	}
}
