/*
 * Decompiled with CFR 0.152.
 */
package javolution.context;

import javolution.context.Context;
import javolution.util.FastMap;

public class LocalContext
extends Context {
    private static Class CLASS = new LocalContext().getClass();
    final FastMap _references = new FastMap();

    public static LocalContext enter() {
        return (LocalContext)Context.enter(CLASS);
    }

    public static LocalContext exit() {
        return (LocalContext)Context.exit();
    }

    @Override
    protected void enterAction() {
    }

    @Override
    protected void exitAction() {
        this._references.clear();
    }

    public static class Reference<T>
    implements javolution.lang.Reference<T> {
        private T _defaultValue;
        private boolean _hasBeenLocallyOverriden;

        public Reference() {
            this(null);
        }

        public Reference(T t) {
            this._defaultValue = t;
        }

        @Override
        public final T get() {
            return this._hasBeenLocallyOverriden ? this.retrieveValue() : this._defaultValue;
        }

        private T retrieveValue() {
            for (Context context = Context.getCurrent(); context != null; context = context.getOuter()) {
                if (!(context instanceof LocalContext)) continue;
                LocalContext localContext = (LocalContext)context;
                Object v = localContext._references.get(this);
                if (v == null) continue;
                return (T)v;
            }
            return this._defaultValue;
        }

        @Override
        public void set(T t) {
            LocalContext localContext = Reference.getLocalContext();
            if (localContext != null) {
                FastMap fastMap = localContext._references;
                fastMap.put(this, t);
                this._hasBeenLocallyOverriden = true;
                return;
            }
            this._defaultValue = t;
        }

        public T getDefault() {
            return this._defaultValue;
        }

        public T getLocal() {
            LocalContext localContext = Reference.getLocalContext();
            return (T)(localContext != null ? localContext._references.get(this) : this._defaultValue);
        }

        public void setDefault(T t) {
            this._defaultValue = t;
        }

        public String toString() {
            return String.valueOf(this.get());
        }

        private static LocalContext getLocalContext() {
            for (Context context = Context.getCurrent(); context != null; context = context.getOuter()) {
                if (!(context instanceof LocalContext)) continue;
                return (LocalContext)context;
            }
            return null;
        }
    }
}

