/* This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 * http://www.gnu.org/copyleft/gpl.html
 */
package net.sf.l2j.gameserver.model.actor.instance;

import java.util.concurrent.Future;
import java.util.logging.Logger;

import net.sf.l2j.gameserver.ThreadPoolManager;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.templates.L2NpcTemplate;
import net.sf.l2j.gameserver.instancemanager.FourSepulchersManager;
import net.sf.l2j.gameserver.model.L2Skill;
import net.sf.l2j.gameserver.datatables.SkillTable;

/**
 *
 * @author  sandman
 */
public class L2SepulcherMonsterInstance extends L2MonsterInstance
{
    protected static Logger _log = Logger.getLogger(L2SepulcherMonsterInstance.class.getName());
	
	// o̔ID
	public int MysteriousBoxId = 0;
	
	// P[vS[gp
	// ̔o^XN
	protected Future _VictimSpawnKeyBoxTask = null;

	// ̐Αp
	// Ή^XN
	protected Future _ChangeImmortalTask = null;
	// G̃^XN
	protected Future _ChangeMortalTask = null;
	
	// S̃Cxgp
	protected Future _OnDeadEventTask = null;
	
	// RXgN^[
	public L2SepulcherMonsterInstance(int objectId, L2NpcTemplate template)
	{
		super(objectId, template);
	}

	public void onSpawn()
    {
		super.onSpawn();
		switch(getNpcId())
		{
			// P[vS[g̏ꍇ
			case 18150: // P[vS[g
			case 18151: // P[vS[g
			case 18152: // P[vS[g
			case 18153: // P[vS[g
			case 18154: // P[vS[g
			case 18155: // P[vS[g
			case 18156: // P[vS[g
			case 18157: // P[vS[g
				// ̃X^[̃wCg҂

				// TɌ̔o^XNd
				if (_VictimSpawnKeyBoxTask != null)
					_VictimSpawnKeyBoxTask.cancel(true);
				_VictimSpawnKeyBoxTask = ThreadPoolManager.getInstance().scheduleEffect(new VictimSpawnKeyBox(this), 300000);
				break;

			// ̂̏ꍇ
			case 18196:	// ̂
			case 18197:	// ̂
			case 18198:	// ̂
			case 18199:	// ̂
			case 18200:	// ̂
			case 18201:	// ̂
			case 18202:	// ̂
			case 18203:	// ̂
			case 18204:	// ̂
			case 18205:	// ̂
			case 18206:	// ̂
			case 18207:	// ̂
			case 18208:	// ̂
			case 18209:	// ̂
			case 18210:	// ̂
			case 18211:	// ̂
				// fotXL𔭓
				break;
				
			// ̐Α̏ꍇ
			case 18231:	//̐Α
			case 18232:	//̐Α
			case 18233:	//̐Α
			case 18234:	//̐Α
			case 18235:	//̐Α
			case 18236:	//̐Α
			case 18237:	//̐Α
			case 18238:	//̐Α
			case 18239:	//̐Α
			case 18240:	//̐Α
			case 18241:	//̐Α
			case 18242:	//̐Α
			case 18243:	//̐Α
				// GAჂ̌ʁiΉjo
				// G͏oƓɍs
				setIsInvul(true);

				// Ή̌ʂ͂xԂuȂƂȂĂ܂B
				if (_ChangeImmortalTask != null)
					_ChangeImmortalTask.cancel(true);
				_ChangeImmortalTask = ThreadPoolManager.getInstance().scheduleEffect(new ChangeImmortal(this), 1600);

				break;
		}
    }

    public boolean doDie(L2Character killer) 
    {
        if (!super.doDie(killer))
            return false;
		// 񂾏ꍇ̃Cxg郂X^[͂ŏ
		switch(getNpcId())
		{
			// ̔o郂X^[
			case 18120:	//nV̕
			case 18121:	//nV̕
			case 18122:	//nV̕
			case 18123:	//nV̕
			case 18124:	//nV̕
			case 18125:	//nV̕
			case 18126:	//nV̕
			case 18127:	//nV̕
			case 18128:	//nV̕
			case 18129:	//nV̕
			case 18130:	//nV̕
			case 18131:	//nV̕
			case 18149:	//n̍b
			case 18158:	//nV̎s
			case 18159:	//nV̎s
			case 18160:	//nV̎s
			case 18161:	//nV̎s
			case 18162:	//nV̎s
			case 18163:	//nV̎s
			case 18164:	//nV̎s
			case 18165:	//nV̎s
			case 18183:	//nV̊ē
			case 18184:	//nV̊ē
			case 18212:	//nV Ah~jXg[^[
			case 18213:	//nV Ah~jXg[^[
			case 18214:	//nV Ah~jXg[^[
			case 18215:	//nV Ah~jXg[^[
			case 18216:	//nV Ah~jXg[^[
			case 18217:	//nV Ah~jXg[^[
			case 18218:	//nV Ah~jXg[^[
			case 18219:	//nV Ah~jXg[^[
				if(_OnDeadEventTask != null) _OnDeadEventTask.cancel(true);
				_OnDeadEventTask = ThreadPoolManager.getInstance().scheduleEffect(new OnDeadEvent(this), 3500);
				break;

			// P[vS[g͎EƃnV̎s҂o
			case 18150:	//P[vS[g
			case 18151:	//P[vS[g
			case 18152:	//P[vS[g
			case 18153:	//P[vS[g
			case 18154:	//P[vS[g
			case 18155:	//P[vS[g
			case 18156:	//P[vS[g
			case 18157:	//P[vS[g
		        if (_VictimSpawnKeyBoxTask != null)
		        {
		        	_VictimSpawnKeyBoxTask.cancel(true);
		        	_VictimSpawnKeyBoxTask = null;
		        }
				if(_OnDeadEventTask != null) _OnDeadEventTask.cancel(true);
				_OnDeadEventTask = ThreadPoolManager.getInstance().scheduleEffect(new OnDeadEvent(this), 3500);
				break;

			// ̟rŏԂĎāASŏԂȂCxg𔭐郂X^[
			// q݂̉
			case 18141:	//n̍b
			case 18142:	//n̍b
			case 18143:	//n̍b
			case 18144:	//n̍b
			case 18145:	//n̍b
			case 18146:	//n̍b
			case 18147:	//n̍b
			case 18148:	//n̍b
				if(FourSepulchersManager.getInstance().IsViscountMobsAnnihilated(MysteriousBoxId))
				{
					if(_OnDeadEventTask != null) _OnDeadEventTask.cancel(true);
					_OnDeadEventTask = ThreadPoolManager.getInstance().scheduleEffect(new OnDeadEvent(this), 3500);
				}
				break;

			// ̟rŏԂĎāASŏԂȂCxg𔭐郂X^[
			// ݂̉
			case 18220:	//ł̛ޏ
			case 18221:	//ł̛ޏ
			case 18222:	//ł̈ÎE
			case 18223:	//ł̈ÎE
			case 18224:	//ł̈ÎE
			case 18225:	//ł̈ÎE
			case 18226:	//ł̎j`
			case 18227:	//ł̎j`
			case 18228:	//ł̎j`
			case 18229:	//ł̎j`
			case 18230:	//c̈
			case 18231:	//̐Α
			case 18232:	//̐Α
			case 18233:	//̐Α
			case 18234:	//̐Α
			case 18235:	//̐Α
			case 18236:	//̐Α
			case 18237:	//̐Α
			case 18238:	//̐Α
			case 18239:	//̐Α
			case 18240:	//̐Α
				if(FourSepulchersManager.getInstance().IsDukeMobsAnnihilated(MysteriousBoxId))
				{
					if(_OnDeadEventTask != null) _OnDeadEventTask.cancel(true);
					_OnDeadEventTask = ThreadPoolManager.getInstance().scheduleEffect(new OnDeadEvent(this), 3500);
				}
				break;

			// nVVh[͓ɔtn
			// nVVh[̓EBSbg̗Ho
			case 25339:
			case 25342:
			case 25346:
			case 25349:
				GiveCup((L2PcInstance)killer);
				if(_OnDeadEventTask != null) _OnDeadEventTask.cancel(true);
				_OnDeadEventTask = ThreadPoolManager.getInstance().scheduleEffect(new OnDeadEvent(this), 8500);
				break;
		}
		return true;
    }

    public void deleteMe()
    {
        if (_VictimSpawnKeyBoxTask != null)
        {
        	_VictimSpawnKeyBoxTask.cancel(true);
        	_VictimSpawnKeyBoxTask = null;
        }
		if(_OnDeadEventTask != null)
		{
			_OnDeadEventTask.cancel(true);
			_OnDeadEventTask = null;
		}

		super.deleteMe();
    }

	public boolean isRaid()
	{
		switch(getNpcId())
		{
			// nVVh[̓Ch{X
			case 25339:
			case 25342:
			case 25346:
			case 25349:
				return true;
			default:
				return false;
		}
	}
	
	// nVVh[͓ɔtn
	protected void GiveCup(L2PcInstance player)
	{
	    // NGXguS̔tv
	    String QuestId = "620_FourGoblets";
	    int CupId = 0;
	    int OldBrooch = 7262;	// Âu[`

	    
    	// ǂ̔t肷
		switch(getNpcId())
		{
			case 25339:
				CupId = 7256;	// ANeBA̔t
				break;
			case 25342:
				CupId = 7257;	// eBVX̔t
				break;
			case 25346:
				CupId = 7258;	// J̔t
				break;
			case 25349:
				CupId = 7259;	// O̔t
				break;
		}
		
		// p[eB[̏ꍇ
		if(player.getParty() != null)
		{
            for (L2PcInstance mem : player.getParty().getPartyMembers())
            {
                // p[eBo[SNGXguS̔tv󂯂Ă邱
                if(mem.getQuestState(QuestId).get("<state>") == null) return;
                else
                {
					// Âu[`ĂȂΔtCxgɓ
                    if (mem.getInventory().getItemByItemId(OldBrooch) == null)
                    {
    					mem.addItem("Quest", CupId, 1, mem, true);
                    }
                }
            }
		}
	    // \̏ꍇ
		else
		{
            if(player.getQuestState(QuestId).get("<state>") == null) return;
            else
            {
				// Âu[`ĂȂΔtCxgɓ
                if (player.getInventory().getItemByItemId(OldBrooch) == null)
                {
                	player.addItem("Quest", CupId, 1, player, true);
                }
            }
		}
	}

	// P[vS[g̔o^XN
	protected class VictimSpawnKeyBox implements Runnable
	{
		L2SepulcherMonsterInstance _activeChar;
		
		public VictimSpawnKeyBox(L2SepulcherMonsterInstance activeChar)
		{
			_activeChar = activeChar;
		}
		
        public void run()
        {
        	// łꍇ͉Ȃ
        	if(_activeChar.isDead()) return;
        	
        	// pĂꍇȂ
        	if(!_activeChar.isVisible()) return;

        	// ̔o
			FourSepulchersManager.getInstance().SpawnKeyBox(_activeChar);
        }
	}

	// S̃Cxg𔭐^XN
	protected class OnDeadEvent implements Runnable
	{
		L2SepulcherMonsterInstance _activeChar;
		
		public OnDeadEvent(L2SepulcherMonsterInstance activeChar)
		{
			_activeChar = activeChar;
		}
		
        public void run()
        {
    		switch(_activeChar.getNpcId())
    		{
    			// ̔o郂X^[
    			case 18120:	//nV̕
    			case 18121:	//nV̕
    			case 18122:	//nV̕
    			case 18123:	//nV̕
    			case 18124:	//nV̕
    			case 18125:	//nV̕
    			case 18126:	//nV̕
    			case 18127:	//nV̕
    			case 18128:	//nV̕
    			case 18129:	//nV̕
    			case 18130:	//nV̕
    			case 18131:	//nV̕
    			case 18149:	//n̍b
    			case 18158:	//nV̎s
    			case 18159:	//nV̎s
    			case 18160:	//nV̎s
    			case 18161:	//nV̎s
    			case 18162:	//nV̎s
    			case 18163:	//nV̎s
    			case 18164:	//nV̎s
    			case 18165:	//nV̎s
    			case 18183:	//nV̊ē
    			case 18184:	//nV̊ē
    			case 18212:	//nV Ah~jXg[^[
    			case 18213:	//nV Ah~jXg[^[
    			case 18214:	//nV Ah~jXg[^[
    			case 18215:	//nV Ah~jXg[^[
    			case 18216:	//nV Ah~jXg[^[
    			case 18217:	//nV Ah~jXg[^[
    			case 18218:	//nV Ah~jXg[^[
    			case 18219:	//nV Ah~jXg[^[
    				FourSepulchersManager.getInstance().SpawnKeyBox(_activeChar);
    				break;

    			// P[vS[g͎EƃnV̎s҂o
    			case 18150:	//P[vS[g
    			case 18151:	//P[vS[g
    			case 18152:	//P[vS[g
    			case 18153:	//P[vS[g
    			case 18154:	//P[vS[g
    			case 18155:	//P[vS[g
    			case 18156:	//P[vS[g
    			case 18157:	//P[vS[g
    				FourSepulchersManager.getInstance().SpawnExecutionerOfHalisha(_activeChar);
    				break;

    			// ̟rŏԂĎāASŏԂȂCxg𔭐郂X^[
    			// q݂̉
    			case 18141:	//n̍b
    			case 18142:	//n̍b
    			case 18143:	//n̍b
    			case 18144:	//n̍b
    			case 18145:	//n̍b
    			case 18146:	//n̍b
    			case 18147:	//n̍b
    			case 18148:	//n̍b
    				FourSepulchersManager.getInstance().SpawnMonster(_activeChar.MysteriousBoxId);
    				break;

    			// ̟rŏԂĎāASŏԂȂCxg𔭐郂X^[
    			// ݂̉
    			case 18220:	//ł̛ޏ
    			case 18221:	//ł̛ޏ
    			case 18222:	//ł̈ÎE
    			case 18223:	//ł̈ÎE
    			case 18224:	//ł̈ÎE
    			case 18225:	//ł̈ÎE
    			case 18226:	//ł̎j`
    			case 18227:	//ł̎j`
    			case 18228:	//ł̎j`
    			case 18229:	//ł̎j`
    			case 18230:	//c̈
    			case 18231:	//̐Α
    			case 18232:	//̐Α
    			case 18233:	//̐Α
    			case 18234:	//̐Α
    			case 18235:	//̐Α
    			case 18236:	//̐Α
    			case 18237:	//̐Α
    			case 18238:	//̐Α
    			case 18239:	//̐Α
    			case 18240:	//̐Α
   					FourSepulchersManager.getInstance().SpawnArchonOfHalisha(_activeChar.MysteriousBoxId);
    				break;

    			// nVVh[̓EBSbg̗Ho
    			case 25339:
    			case 25342:
    			case 25346:
    			case 25349:
   					FourSepulchersManager.getInstance().SpawnEmperorsGraveNpc(_activeChar.MysteriousBoxId);
    				break;
    		}
        }
	}
	
	// ̐ΑΉ^XN
	protected class ChangeImmortal implements Runnable
	{
		L2SepulcherMonsterInstance activeChar;
		public ChangeImmortal(L2SepulcherMonsterInstance mob)
		{
			activeChar = mob;
		}
		
		public void run()
		{
			L2Skill fp = SkillTable.getInstance().getInfo(4616, 1);
			fp.getEffects(activeChar, activeChar);

			// G^XN̎d
			if (_ChangeMortalTask != null)
				_ChangeMortalTask.cancel(true);
			_ChangeMortalTask = ThreadPoolManager.getInstance().scheduleEffect(new ChangeMortal(), fp.getBuffDuration());
		}
	}

	// ̐ΑG^XN
	protected class ChangeMortal implements Runnable
	{
		public ChangeMortal()
		{
		}
		
		public void run()
		{
			setIsInvul(false);
		}
	}
}
