/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package net.sf.l2j.gameserver.instancemanager.lastimperialtomb;

/**
 * @author Darki699
 */

import java.util.logging.Logger;
import java.util.concurrent.Future;

import net.sf.l2j.gameserver.ThreadPoolManager;
import net.sf.l2j.gameserver.model.actor.instance.L2NpcInstance;
import net.sf.l2j.gameserver.serverpackets.MagicSkillUse;
import net.sf.l2j.util.Rnd;

/**
 * control for sequence of Frintezza and Scarlet Van Halisha and their minions.
 * this part is control for Frintezza to playing organ.
 *
 * @version 1.00.002
 * @author Darki699
 * @author SANDMAN L2J_JP(modified)
 * NOTE:
 * The class is divided from an original source file for making to L2J_LP.
 * Work has not been completed yet. now
 * Therefore, a lot of incomplete operation exists.
 */
public class OrganManager
{

	protected static Logger _log = Logger.getLogger(OrganManager.class.getName());

	private static OrganManager _instance = new OrganManager();

	private final int _music[][] = {
			{5006,1,34000},
			{5007,1,32000},
			{5007,2,32000},
			{5007,3,32000},
			{5007,4,31000},
			{5007,5,35000},
			{5008,1,35000},
			{5008,2,35000},
			{5008,3,35000},
			{5008,4,35000},
			{5008,5,35000}
	};

	private int _nowPlaying = 0;
	private L2NpcInstance _player = null;
	private boolean _isStopMusic = true;
	protected Future<?> _playOrganTask = null;

	private OrganManager()
	{
	}

	protected static OrganManager getInstance()
	{
		return _instance;
	}

	protected void setPlayer(L2NpcInstance npc)
	{
		_player = npc;
	}

	protected void startMusic()
	{
		_isStopMusic = false;
	}

	protected void stopMusic()
	{
		_isStopMusic = true;
	}

	protected void doPlayOrgan(int music)
	{
		if(_isStopMusic || _player == null || _player.isAlikeDead()) return;

		_nowPlaying = music;

		_player.broadcastPacket(new MagicSkillUse(_player,_player, _music[music][0], _music[music][1], _music[music][2], 0));

		_playOrganTask = ThreadPoolManager.getInstance().scheduleGeneral(new PlayOrgan(), _music[music][2]);
	}

	protected class PlayOrgan implements Runnable
	{
		public PlayOrgan()
		{
		}

		public void run()
		{
			if(Rnd.get(100) <= 70)
			{
				doPlayOrgan(0);
			}
			else
			{
				doPlayOrgan(Rnd.get(1,10));
			}
		}
	}

	protected int[] getMusicPlayNow()
	{
		return _music[_nowPlaying];
	}

}