/*
 * Decompiled with CFR 0.152.
 */
package org.mmocore.network;

import javolution.text.TextBuilder;
import org.mmocore.network.AbstractPacket;
import org.mmocore.network.MMOClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReceivablePacket<T extends MMOClient>
extends AbstractPacket<T>
implements Runnable {
    protected ReceivablePacket() {
    }

    protected int getAvaliableBytes() {
        return this.getByteBuffer().remaining();
    }

    protected abstract boolean read();

    @Override
    public abstract void run();

    protected void readB(byte[] dst) {
        this.getByteBuffer().get(dst);
    }

    protected void readB(byte[] dst, int offset, int len) {
        this.getByteBuffer().get(dst, offset, len);
    }

    protected int readC() {
        return this.getByteBuffer().get() & 0xFF;
    }

    protected int readH() {
        return this.getByteBuffer().getShort() & 0xFFFF;
    }

    protected int readD() {
        return this.getByteBuffer().getInt();
    }

    protected long readQ() {
        return this.getByteBuffer().getLong();
    }

    protected double readF() {
        return this.getByteBuffer().getDouble();
    }

    protected String readS() {
        char ch;
        TextBuilder tb = TextBuilder.newInstance();
        while ((ch = this.getByteBuffer().getChar()) != '\u0000') {
            tb.append(ch);
        }
        String str = tb.toString();
        TextBuilder.recycle(tb);
        return str;
    }
}

