/*
 * Decompiled with CFR 0.152.
 */
package javolution.xml;

import javolution.Javolution;
import javolution.lang.Reusable;
import javolution.text.CharArray;
import javolution.text.TextBuilder;
import javolution.util.FastComparator;
import javolution.util.FastMap;
import javolution.util.FastTable;
import javolution.util.Index;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;

public class XMLReferenceResolver
implements Reusable {
    private FastMap _objectToId = new FastMap().setKeyComparator(FastComparator.IDENTITY);
    private FastTable _idToObject = new FastTable();
    private int _counter;
    private String _idName = "id";
    private String _idURI = null;
    private String _refName = "ref";
    private String _refURI = null;
    private TextBuilder _tmp = new TextBuilder();

    public void setIdentifierAttribute(String string) {
        this.setIdentifierAttribute(string, null);
    }

    public void setIdentifierAttribute(String string, String string2) {
        this._idName = string;
        this._idURI = string2;
    }

    public void setReferenceAttribute(String string) {
        this.setReferenceAttribute(string, null);
    }

    public void setReferenceAttribute(String string, String string2) {
        this._refName = string;
        this._refURI = string2;
    }

    public boolean writeReference(Object object, XMLFormat.OutputElement outputElement) throws XMLStreamException {
        Index index = (Index)this._objectToId.get(object);
        if (index == null) {
            index = Index.valueOf(this._counter++);
            this._objectToId.put(object, index);
            this._tmp.clear().append(index.intValue());
            if (this._idURI == null) {
                outputElement.getStreamWriter().writeAttribute(this._idName, this._tmp);
            } else {
                outputElement.getStreamWriter().writeAttribute(this._idURI, this._idName, this._tmp);
            }
            return false;
        }
        this._tmp.clear().append(index.intValue());
        if (this._refURI == null) {
            outputElement._writer.writeAttribute(this._refName, this._tmp);
        } else {
            outputElement._writer.writeAttribute(this._refURI, this._refName, this._tmp);
        }
        return true;
    }

    public Object readReference(XMLFormat.InputElement inputElement) throws XMLStreamException {
        CharArray charArray = inputElement._reader.getAttributeValue(this._refURI, this._refName);
        if (charArray == null) {
            return null;
        }
        int n = charArray.toInt();
        if (n >= this._idToObject.size()) {
            throw new XMLStreamException("Reference: " + charArray + " not found");
        }
        return this._idToObject.get(n);
    }

    public void createReference(Object object, XMLFormat.InputElement inputElement) throws XMLStreamException {
        CharArray charArray = inputElement._reader.getAttributeValue(this._idURI, this._idName);
        if (charArray == null) {
            return;
        }
        int n = charArray.toInt();
        if (this._idToObject.size() != n) {
            throw new XMLStreamException("Identifier discontinuity detected (expected " + this._idToObject.size() + " found " + n + ")");
        }
        this._idToObject.add(object);
    }

    public void reset() {
        this._idName = "id";
        this._idURI = null;
        this._refName = "ref";
        this._refURI = null;
        this._idToObject.clear();
        this._objectToId.clear();
        this._counter = 0;
    }

    private static CharSequence toCsq(Object object) {
        return Javolution.j2meToCharSeq(object);
    }
}

