/*
 * Decompiled with CFR 0.152.
 */
package javolution.context;

import javax.realtime.MemoryArea;
import javolution.Javolution;
import javolution.context.ObjectFactory;
import javolution.context.ObjectPool;
import javolution.util.FastTable;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;

final class LocalPools {
    static final XMLFormat XML = new XMLFormat(Javolution.j2meGetClass("javolution.context.LocalPools")){

        public Object newInstance(Class clazz, XMLFormat.InputElement inputElement) throws XMLStreamException {
            return new LocalPools(inputElement.getAttribute("isStack", false));
        }

        public void read(XMLFormat.InputElement inputElement, Object object) throws XMLStreamException {
            LocalPools localPools = (LocalPools)object;
            while (inputElement.hasNext()) {
                ObjectPool objectPool;
                Class clazz = (Class)inputElement.get("Factory", CLASS_CLASS);
                int n = (Integer)inputElement.get("PoolSize", INTEGER_CLASS);
                ObjectFactory objectFactory = ObjectFactory.getInstance(clazz);
                ((LocalPools)localPools)._pools[objectFactory._index] = objectPool = localPools._isStack ? objectFactory.newStackPool() : objectFactory.newHeapPool();
                objectPool.setSize(n);
            }
        }

        public void write(Object object, XMLFormat.OutputElement outputElement) throws XMLStreamException {
            LocalPools localPools = (LocalPools)object;
            outputElement.setAttribute("isStack", localPools._isStack);
            int n = ObjectFactory._Count;
            for (int i = 0; i < n; ++i) {
                ObjectPool objectPool = localPools._pools[i];
                if (objectPool == null) continue;
                outputElement.add(ObjectFactory._Instances[i].getClass(), "Factory", CLASS_CLASS);
                outputElement.add(new Integer(objectPool.getSize()), "PoolSize", INTEGER_CLASS);
            }
        }
    };
    private static final Class INTEGER_CLASS = new Integer(0).getClass();
    private static final Class CLASS_CLASS = "".getClass().getClass();
    private final ObjectPool[] _pools = new ObjectPool[ObjectFactory._Instances.length];
    private final FastTable _inUsePools = new FastTable();
    Thread _owner;
    private final boolean _isStack;

    LocalPools(boolean bl) {
        this._isStack = bl;
    }

    ObjectPool getPool(final ObjectFactory objectFactory, boolean bl) {
        int n = objectFactory._index;
        ObjectPool objectPool = this._pools[n];
        if (objectPool == null) {
            MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

                public void run() {
                    ((LocalPools)LocalPools.this)._pools[objectFactory._index] = LocalPools.this._isStack ? objectFactory.newStackPool() : objectFactory.newHeapPool();
                }
            });
            objectPool = this._pools[n];
        }
        if (!objectPool._inUse) {
            objectPool._inUse = true;
            this._inUsePools.add(objectPool);
        }
        if (bl) {
            objectPool._user = this._owner;
        }
        return objectPool;
    }

    void clear() {
        int n = ObjectFactory._Count;
        for (int i = 0; i < n; ++i) {
            ObjectPool objectPool = this._pools[i];
            if (objectPool == null) continue;
            objectPool._user = null;
            objectPool._inUse = false;
            objectPool.clearAll();
        }
        this._inUsePools.clear();
    }

    void deactivatePools() {
        int n = 0;
        int n2 = this._inUsePools.size();
        while (n < n2) {
            ObjectPool objectPool = (ObjectPool)this._inUsePools.get(n++);
            objectPool._user = null;
        }
    }

    void activatePools() {
        int n = 0;
        int n2 = this._inUsePools.size();
        while (n < n2) {
            ObjectPool objectPool = (ObjectPool)this._inUsePools.get(n++);
            objectPool._user = this._owner;
        }
    }

    public void reset() {
        int n = 0;
        int n2 = this._inUsePools.size();
        while (n < n2) {
            ObjectPool objectPool = (ObjectPool)this._inUsePools.get(n++);
            objectPool.recycleAll();
            objectPool._user = null;
            objectPool._inUse = false;
        }
        this._inUsePools.clear();
    }

    public String toString() {
        String string = (this._isStack ? "StackPool@" : "HeapPool@") + this.hashCode() + ": ";
        int n = ObjectFactory._Count;
        for (int i = 0; i < n; ++i) {
            ObjectPool objectPool = this._pools[i];
            if (objectPool == null) continue;
            string = string + ObjectFactory._Instances[i].getClass().getName() + "(" + this._pools[i].getSize() + ") ";
        }
        return string;
    }
}

