/*
 * Decompiled with CFR 0.152.
 */
package javolution.context;

import javolution.context.Context;
import javolution.context.RealtimeObject;
import javolution.util.FastMap;

public class LocalContext
extends Context {
    private static RealtimeObject.Factory FACTORY = new RealtimeObject.Factory(){

        protected Object create() {
            return new LocalContext();
        }
    };
    final FastMap _references = new FastMap();
    private transient boolean _isInternal;

    public static LocalContext current() {
        for (Context context = Context.current(); context != null; context = context.getOuter()) {
            if (!(context instanceof LocalContext)) continue;
            return (LocalContext)context;
        }
        return null;
    }

    public static void enter() {
        LocalContext localContext = (LocalContext)FACTORY.object();
        localContext._isInternal = true;
        Context.enter(localContext);
    }

    public static void exit() {
        LocalContext localContext = (LocalContext)Context.current();
        if (!localContext._isInternal) {
            throw new UnsupportedOperationException("The context to exit must be specified");
        }
        localContext._isInternal = false;
        Context.exitNoCheck(localContext);
        FACTORY.recycle(localContext);
    }

    protected void enterAction() {
    }

    protected void exitAction() {
        this._references.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Reference<T>
    implements javolution.lang.Reference<T> {
        private T _defaultValue;
        private boolean _hasBeenLocallyOverriden;

        public Reference() {
            this(null);
        }

        public Reference(T t) {
            this._defaultValue = t;
        }

        @Override
        public final T get() {
            return this._hasBeenLocallyOverriden ? this.retrieveValue() : this._defaultValue;
        }

        private T retrieveValue() {
            for (Context context = Context.current(); context != null; context = context.getOuter()) {
                if (!(context instanceof LocalContext)) continue;
                LocalContext localContext = (LocalContext)context;
                Object v = localContext._references.get(this);
                if (v == null) continue;
                return (T)v;
            }
            return this._defaultValue;
        }

        @Override
        public void set(T t) {
            LocalContext localContext = LocalContext.current();
            if (localContext != null) {
                FastMap fastMap = localContext._references;
                fastMap.put(this, t);
                this._hasBeenLocallyOverriden = true;
                return;
            }
            this._defaultValue = t;
        }

        public T getDefault() {
            return this._defaultValue;
        }

        public T getLocal() {
            LocalContext localContext = LocalContext.current();
            return (T)(localContext != null ? localContext._references.get(this) : this._defaultValue);
        }

        public void setDefault(T t) {
            this._defaultValue = t;
        }

        public String toString() {
            return String.valueOf(this.get());
        }
    }
}

