/*
 * Decompiled with CFR 0.152.
 */
package javolution.context;

import java.io.Serializable;
import javolution.context.ConcurrentContext;
import javolution.context.HeapContext;
import javolution.context.LocalPools;
import javolution.context.RealtimeObject;

public abstract class Context
extends RealtimeObject
implements Serializable {
    public static final HeapContext ROOT = new HeapContext();
    private static final ThreadLocal CURRENT = new ThreadLocal(){

        protected Object initialValue() {
            return ROOT;
        }
    };
    transient Thread _owner;
    transient Context _outer;

    protected Context() {
    }

    public static Context current() {
        return (Context)CURRENT.get();
    }

    public final Thread getOwner() {
        return this._owner;
    }

    public final Context getOuter() {
        return this._outer;
    }

    protected abstract void enterAction();

    protected abstract void exitAction();

    public static void enter(Context context) {
        Context context2;
        if (context._owner != null) {
            throw new IllegalStateException("Context is currently in use");
        }
        context._outer = context2 = Context.current();
        context._owner = Thread.currentThread();
        CURRENT.set(context);
        context.enterAction();
    }

    public static void exit(Context context) {
        if (context != Context.current()) {
            throw new IllegalStateException("The Specified context is not the current context");
        }
        if (context._owner != Thread.currentThread()) {
            throw new IllegalStateException("Cannot exit context belonging to another thread");
        }
        Context.exitNoCheck(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void exitNoCheck(Context context) {
        try {
            context.exitAction();
        }
        finally {
            CURRENT.set(context._outer);
            context._outer = null;
            context._owner = null;
        }
    }

    static void setCurrent(ConcurrentContext concurrentContext) {
        CURRENT.set(concurrentContext);
    }

    void setPoolsActive(boolean bl) {
        this._outer.setPoolsActive(bl);
    }

    LocalPools getLocalPools() {
        return this._outer.getLocalPools();
    }
}

