/*
 * Decompiled with CFR 0.152.
 */
package javolution.context;

import javolution.context.ConcurrentException;
import javolution.context.ConcurrentExecutor;
import javolution.context.ConcurrentThread;
import javolution.context.Context;
import javolution.context.LocalContext;
import javolution.context.RealtimeObject;
import javolution.lang.Configurable;
import javolution.lang.Reflection;

public class ConcurrentContext
extends Context {
    private static RealtimeObject.Factory FACTORY = new RealtimeObject.Factory(){

        protected Object create() {
            return new ConcurrentContext();
        }
    };
    public static final Configurable<Integer> CONCURRENCY = new Configurable<Integer>(ConcurrentContext.concurrency());
    private static final LocalContext.Reference ENABLED = new LocalContext.Reference<Boolean>(new Boolean(true));
    private static final ThreadLocal ARGUMENTS = new ThreadLocal();
    private static final Class CLASS = new ConcurrentContext().getClass();
    private static transient ConcurrentExecutor[] _DefaultExecutors;
    private int _initiatedCount;
    private int _completedCount;
    private Throwable _error;
    private ConcurrentExecutor[] _executors;
    private boolean _isEnabled;
    private ConcurrentExecutor[] _inheritedExecutors;
    private transient boolean _isInternal;
    private static final Boolean TRUE;
    private static final Boolean FALSE;

    public ConcurrentContext() {
        this(null);
    }

    public ConcurrentContext(ConcurrentExecutor[] concurrentExecutorArray) {
        this._executors = concurrentExecutorArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConcurrentExecutor[] getDefaultExecutors() {
        if (_DefaultExecutors != null) {
            return _DefaultExecutors;
        }
        Class clazz = CLASS;
        synchronized (clazz) {
            if (_DefaultExecutors != null) {
                return _DefaultExecutors;
            }
            int n = CONCURRENCY.get();
            ConcurrentThread[] concurrentThreadArray = new ConcurrentThread[n];
            for (int i = 0; i < n; ++i) {
                concurrentThreadArray[i] = new ConcurrentThread();
                concurrentThreadArray[i].start();
            }
            _DefaultExecutors = concurrentThreadArray;
            return _DefaultExecutors;
        }
    }

    public static void setDefaultExecutors(ConcurrentExecutor[] concurrentExecutorArray) {
        _DefaultExecutors = concurrentExecutorArray;
    }

    final ConcurrentExecutor[] getExecutors() {
        if (this._executors != null) {
            return this._executors;
        }
        for (Context context = this.getOuter(); context != null; context = context.getOuter()) {
            if (!(context instanceof ConcurrentContext)) continue;
            ConcurrentContext concurrentContext = (ConcurrentContext)context;
            if (concurrentContext._executors == null) continue;
            return concurrentContext._executors;
        }
        return ConcurrentContext.getDefaultExecutors();
    }

    public void clear() {
        if (this._executors != null) {
            for (int i = 0; i < this._executors.length; ++i) {
                this._executors[i].terminate();
            }
            this._executors = null;
        }
    }

    public static ConcurrentContext current() {
        for (Context context = Context.current(); context != null; context = context.getOuter()) {
            if (!(context instanceof ConcurrentContext)) continue;
            return (ConcurrentContext)context;
        }
        return null;
    }

    public static void enter() {
        ConcurrentContext concurrentContext = (ConcurrentContext)FACTORY.object();
        concurrentContext._isInternal = true;
        concurrentContext._isEnabled = ConcurrentContext.isEnabled();
        Context.enter(concurrentContext);
    }

    public static void exit() {
        ConcurrentContext concurrentContext = (ConcurrentContext)Context.current();
        if (!concurrentContext._isInternal) {
            throw new UnsupportedOperationException("The context to exit must be specified");
        }
        concurrentContext._isInternal = false;
        Context.exitNoCheck(concurrentContext);
        FACTORY.recycle(concurrentContext);
    }

    public static void setEnabled(boolean bl) {
        ENABLED.set(bl ? TRUE : FALSE);
    }

    public static boolean isEnabled() {
        return (Boolean)ENABLED.get();
    }

    public static void execute(Logic logic) {
        ConcurrentContext concurrentContext = ConcurrentContext.current();
        StatusImpl statusImpl = (StatusImpl)StatusImpl.FACTORY.object();
        statusImpl._args = statusImpl._args0;
        if (concurrentContext != null && concurrentContext.doExecute(logic, statusImpl)) {
            return;
        }
        ARGUMENTS.set(statusImpl._args);
        logic.run();
        StatusImpl.FACTORY.recycle(statusImpl);
    }

    public static void execute(Logic logic, Object object) {
        ConcurrentContext concurrentContext = ConcurrentContext.current();
        StatusImpl statusImpl = (StatusImpl)StatusImpl.FACTORY.object();
        statusImpl._args = statusImpl._args1;
        statusImpl._args[0] = object;
        if (concurrentContext != null && concurrentContext.doExecute(logic, statusImpl)) {
            return;
        }
        ARGUMENTS.set(statusImpl._args);
        logic.run();
        StatusImpl.FACTORY.recycle(statusImpl);
    }

    public static void execute(Logic logic, Object object, Object object2) {
        ConcurrentContext concurrentContext = ConcurrentContext.current();
        StatusImpl statusImpl = (StatusImpl)StatusImpl.FACTORY.object();
        statusImpl._args = statusImpl._args2;
        statusImpl._args[0] = object;
        statusImpl._args[1] = object2;
        if (concurrentContext != null && concurrentContext.doExecute(logic, statusImpl)) {
            return;
        }
        ARGUMENTS.set(statusImpl._args);
        logic.run();
        StatusImpl.FACTORY.recycle(statusImpl);
    }

    public static void execute(Logic logic, Object object, Object object2, Object object3) {
        ConcurrentContext concurrentContext = ConcurrentContext.current();
        StatusImpl statusImpl = (StatusImpl)StatusImpl.FACTORY.object();
        statusImpl._args = statusImpl._args3;
        statusImpl._args[0] = object;
        statusImpl._args[1] = object2;
        statusImpl._args[2] = object3;
        if (concurrentContext != null && concurrentContext.doExecute(logic, statusImpl)) {
            return;
        }
        ARGUMENTS.set(statusImpl._args);
        logic.run();
        StatusImpl.FACTORY.recycle(statusImpl);
    }

    public static void execute(Logic logic, Object object, Object object2, Object object3, Object object4) {
        ConcurrentContext concurrentContext = ConcurrentContext.current();
        StatusImpl statusImpl = (StatusImpl)StatusImpl.FACTORY.object();
        statusImpl._args = statusImpl._args4;
        statusImpl._args[0] = object;
        statusImpl._args[1] = object2;
        statusImpl._args[2] = object3;
        statusImpl._args[3] = object4;
        if (concurrentContext != null && concurrentContext.doExecute(logic, statusImpl)) {
            return;
        }
        ARGUMENTS.set(statusImpl._args);
        logic.run();
        StatusImpl.FACTORY.recycle(statusImpl);
    }

    public static void execute(Logic logic, Object object, Object object2, Object object3, Object object4, Object object5) {
        ConcurrentContext concurrentContext = ConcurrentContext.current();
        StatusImpl statusImpl = (StatusImpl)StatusImpl.FACTORY.object();
        statusImpl._args = statusImpl._args5;
        statusImpl._args[0] = object;
        statusImpl._args[1] = object2;
        statusImpl._args[2] = object3;
        statusImpl._args[3] = object4;
        statusImpl._args[4] = object5;
        if (concurrentContext != null && concurrentContext.doExecute(logic, statusImpl)) {
            return;
        }
        ARGUMENTS.set(statusImpl._args);
        logic.run();
        StatusImpl.FACTORY.recycle(statusImpl);
    }

    public static void execute(Logic logic, Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        ConcurrentContext concurrentContext = ConcurrentContext.current();
        StatusImpl statusImpl = (StatusImpl)StatusImpl.FACTORY.object();
        statusImpl._args = statusImpl._args6;
        statusImpl._args[0] = object;
        statusImpl._args[1] = object2;
        statusImpl._args[2] = object3;
        statusImpl._args[3] = object4;
        statusImpl._args[4] = object5;
        statusImpl._args[5] = object6;
        if (concurrentContext != null && concurrentContext.doExecute(logic, statusImpl)) {
            return;
        }
        ARGUMENTS.set(statusImpl._args);
        logic.run();
        StatusImpl.FACTORY.recycle(statusImpl);
    }

    protected void enterAction() {
        this._inheritedExecutors = this.getExecutors();
        this._error = null;
        this._initiatedCount = 0;
        this._completedCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exitAction() {
        ConcurrentContext concurrentContext = this;
        synchronized (concurrentContext) {
            while (this._initiatedCount != this._completedCount) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new ConcurrentException(interruptedException);
                }
            }
        }
        if (this._error != null) {
            if (this._error instanceof RuntimeException) {
                throw (RuntimeException)this._error;
            }
            if (this._error instanceof Error) {
                throw (Error)this._error;
            }
            throw new ConcurrentException(this._error);
        }
    }

    private boolean doExecute(Logic logic, StatusImpl statusImpl) {
        if (this._isEnabled) {
            statusImpl._context = this;
            ConcurrentExecutor[] concurrentExecutorArray = this._inheritedExecutors;
            for (int i = 0; i < concurrentExecutorArray.length; ++i) {
                if (!concurrentExecutorArray[i].execute(logic, statusImpl)) continue;
                ++this._initiatedCount;
                return true;
            }
        }
        return false;
    }

    private static Integer concurrency() {
        Reflection.Method method = Reflection.getMethod("java.lang.Runtime.availableProcessors()");
        if (method != null) {
            Integer n = (Integer)method.invoke(Runtime.getRuntime());
            return new Integer(n);
        }
        return new Integer(1);
    }

    static {
        TRUE = new Boolean(true);
        FALSE = new Boolean(false);
    }

    private static class StatusImpl
    extends RealtimeObject
    implements ConcurrentExecutor.Status {
        private static RealtimeObject.Factory FACTORY = new RealtimeObject.Factory(){

            protected Object create() {
                return new StatusImpl();
            }

            protected void cleanup(Object object) {
                ((StatusImpl)object).reset();
            }
        };
        volatile Object[] _args;
        Object[] _args0 = new Object[0];
        Object[] _args1 = new Object[1];
        Object[] _args2 = new Object[2];
        Object[] _args3 = new Object[3];
        Object[] _args4 = new Object[4];
        Object[] _args5 = new Object[5];
        Object[] _args6 = new Object[6];
        ConcurrentContext _context;

        private StatusImpl() {
        }

        public void started() {
            ARGUMENTS.set(this._args);
            Context.setCurrent(this._context);
            this._context.getLocalPools().activatePools();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void completed() {
            this._context.getLocalPools().deactivatePools();
            ConcurrentContext concurrentContext = this._context;
            synchronized (concurrentContext) {
                this._context._completedCount++;
                this._context.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void error(Throwable throwable) {
            ConcurrentContext concurrentContext = this._context;
            synchronized (concurrentContext) {
                if (this._context._error == null) {
                    this._context._error = throwable;
                }
            }
        }

        void reset() {
            for (int i = 0; i < this._args.length; ++i) {
                this._args[i] = null;
            }
            this._context = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Logic
    implements Runnable {
        public Object[] getArguments() {
            return (Object[])ARGUMENTS.get();
        }

        public <T> T getArgument(int n) {
            return (T)((Object[])ARGUMENTS.get())[n];
        }

        @Override
        public abstract void run();
    }
}

