/*
 * Decompiled with CFR 0.152.
 */
package javolution;

import javolution.Javolution;
import javolution.context.ConcurrentContext;
import javolution.context.ObjectFactory;
import javolution.context.PoolContext;
import javolution.context.RealtimeObject;
import javolution.lang.MathLib;
import javolution.util.FastComparator;
import javolution.util.FastTable;

final class PerfContext
extends Javolution
implements Runnable {
    Object[] _objects = new Object[1000];
    private static final int N = 10000;
    private static final FastComparator INTEGER_COMPARATOR = new FastComparator(){

        public boolean areEqual(Object object, Object object2) {
            return ((Integer)object).intValue() == ((Integer)object2).intValue();
        }

        public int compare(Object object, Object object2) {
            return (Integer)object2 - (Integer)object;
        }

        public int hashCodeOf(Object object) {
            return (Integer)object;
        }
    };
    private static final ObjectFactory CHAR256_FACTORY = new ObjectFactory(){

        public Object create() {
            return new char[256];
        }
    };
    private static final ObjectFactory CHAR512_FACTORY = new ObjectFactory(){

        public Object create() {
            return new char[512];
        }
    };

    PerfContext() {
    }

    public void run() {
        this.println("//////////////////////////////////");
        this.println("// Package: javolution.context //");
        this.println("//////////////////////////////////");
        this.println("");
        this.benchmarkConcurrency();
        this.benchmarkSmallObjects();
        this.benchmarkHeapArrays();
        this.benchmarkStackArrays();
        this.println("");
    }

    private void benchmarkConcurrency() {
        FastTable fastTable;
        int n;
        this.println("-- Concurrent Context --");
        this.print("Quick Sort 10000 elements - Concurrency disabled: ");
        ConcurrentContext.setEnabled(false);
        for (n = 0; n < 1000; ++n) {
            fastTable = this.randomTable();
            this.startTime();
            this.quickSort(fastTable);
            this.keepBestTime(1);
        }
        this.println(this.endTime());
        this.print("Quick Sort 10000 elements - Concurrency (" + ConcurrentContext.CONCURRENCY.get() + ") enabled: ");
        ConcurrentContext.setEnabled(true);
        for (n = 0; n < 1000; ++n) {
            fastTable = this.randomTable();
            this.startTime();
            this.quickSort(fastTable);
            this.keepBestTime(1);
        }
        this.println(this.endTime());
        this.println("");
    }

    private FastTable randomTable() {
        FastTable<Integer> fastTable = new FastTable<Integer>(10000);
        for (int i = 0; i < 10000; ++i) {
            fastTable.add(new Integer(MathLib.random(Integer.MIN_VALUE, Integer.MAX_VALUE)));
        }
        return fastTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void quickSort(final FastTable fastTable) {
        final int n = fastTable.size();
        if (n < 100) {
            fastTable.setValueComparator(INTEGER_COMPARATOR);
            fastTable.sort();
        } else {
            final FastTable fastTable2 = FastTable.newInstance();
            final FastTable fastTable3 = FastTable.newInstance();
            ConcurrentContext.enter();
            try {
                ConcurrentContext.execute(new ConcurrentContext.Logic(){

                    public void run() {
                        fastTable2.addAll(fastTable.subList(0, n / 2));
                        PerfContext.this.quickSort(fastTable2);
                    }
                });
                ConcurrentContext.execute(new ConcurrentContext.Logic(){

                    public void run() {
                        fastTable3.addAll(fastTable.subList(n / 2, n));
                        PerfContext.this.quickSort(fastTable3);
                    }
                });
            }
            finally {
                ConcurrentContext.exit();
            }
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                if (n2 >= fastTable2.size()) {
                    fastTable.set(i, fastTable3.get(n3++));
                    continue;
                }
                if (n3 >= fastTable3.size()) {
                    fastTable.set(i, fastTable2.get(n2++));
                    continue;
                }
                Integer n4 = (Integer)fastTable2.get(n2);
                Integer n5 = (Integer)fastTable3.get(n3);
                if (n4 < n5) {
                    fastTable.set(i, n4);
                    ++n2;
                    continue;
                }
                fastTable.set(i, n5);
                ++n3;
            }
            FastTable.recycle(fastTable2);
            FastTable.recycle(fastTable3);
        }
    }

    private void benchmarkSmallObjects() {
        int n;
        int n2;
        this.println("-- Heap versus Stack Allocation (Pool-Context) --");
        this.print("Small object heap creation: ");
        for (n2 = 0; n2 < 100000; ++n2) {
            this.startTime();
            n = 0;
            while (n < this._objects.length) {
                this._objects[n++] = new SmallObject();
            }
            this.keepBestTime(this._objects.length);
        }
        this.println(this.endTime());
        this.print("Small object stack creation: ");
        for (n2 = 0; n2 < 100000; ++n2) {
            this.startTime();
            PoolContext.enter();
            n = 0;
            while (n < this._objects.length) {
                this._objects[n++] = SmallObject.FACTORY.object();
            }
            PoolContext.exit();
            this.keepBestTime(this._objects.length);
        }
        this.println(this.endTime());
    }

    private void benchmarkHeapArrays() {
        int n;
        int n2;
        this.print("char[256] heap creation: ");
        for (n2 = 0; n2 < 1000; ++n2) {
            this.startTime();
            n = 0;
            while (n < this._objects.length) {
                this._objects[n++] = new char[256];
            }
            this.keepBestTime(this._objects.length);
        }
        this.println(this.endTime());
        this.print("char[512] heap creation: ");
        for (n2 = 0; n2 < 1000; ++n2) {
            this.startTime();
            n = 0;
            while (n < this._objects.length) {
                this._objects[n++] = new char[512];
            }
            this.keepBestTime(this._objects.length);
        }
        this.println(this.endTime());
    }

    private void benchmarkStackArrays() {
        int n;
        int n2;
        this.print("char[256] stack creation: ");
        for (n2 = 0; n2 < 1000; ++n2) {
            this.startTime();
            PoolContext.enter();
            n = 0;
            while (n < this._objects.length) {
                this._objects[n++] = CHAR256_FACTORY.object();
            }
            PoolContext.exit();
            this.keepBestTime(this._objects.length);
        }
        this.println(this.endTime());
        this.print("char[512] stack creation: ");
        for (n2 = 0; n2 < 1000; ++n2) {
            this.startTime();
            PoolContext.enter();
            n = 0;
            while (n < this._objects.length) {
                this._objects[n++] = CHAR512_FACTORY.object();
            }
            PoolContext.exit();
            this.keepBestTime(this._objects.length);
        }
        this.println(this.endTime());
    }

    private static final class SmallObject
    extends RealtimeObject {
        long longValue;
        int intValue;
        SmallObject refValue;
        static final RealtimeObject.Factory FACTORY = new RealtimeObject.Factory(){

            public Object create() {
                return new SmallObject();
            }
        };

        private SmallObject() {
        }
    }
}

