package net.sf.l2j.gameserver.handler.itemhandlers;


import net.sf.l2j.gameserver.datatables.NpcTable;
import net.sf.l2j.gameserver.handler.IItemHandler;
import net.sf.l2j.gameserver.idfactory.IdFactory;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2Spawn;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.model.actor.instance.L2MonsterInstance;
import net.sf.l2j.gameserver.model.actor.instance.L2PcInstance;
import net.sf.l2j.gameserver.model.actor.instance.L2PlayableInstance;
import net.sf.l2j.gameserver.network.SystemMessageId;
import net.sf.l2j.gameserver.network.serverpackets.MagicSkillUse;
import net.sf.l2j.gameserver.network.serverpackets.SystemMessage;
import net.sf.l2j.gameserver.templates.chars.L2NpcTemplate;
import net.sf.l2j.util.Rnd;

public class Nectar implements IItemHandler
{
    // lN^[
    private static int[] _itemIds = { 6391 };
    
	final static int _npcId_Young_Squash = 13008;		// c|i
	final static int _npcId_Large_Young_Squash = 13011;	// c傫ȃ|i

    public void useItem(L2PlayableInstance playable, L2ItemInstance item)
    {
        L2PcInstance activeChar = (L2PcInstance)playable;
        L2NpcTemplate template1 = null;
        
        // ^[QbgL2MonsterInstancełȂꍇ̓G[
        if(!(activeChar.getTarget() instanceof L2MonsterInstance))
        {
            activeChar.sendPacket(new SystemMessage(SystemMessageId.INCORRECT_TARGET));
            return;
        }
        // ^[Qbgc|iAc傫ȃ|iłȂꍇ̓G[
        if (!(((L2MonsterInstance)activeChar.getTarget()).getNpcId() == _npcId_Young_Squash || 
                ((L2MonsterInstance)activeChar.getTarget()).getNpcId() == _npcId_Large_Young_Squash))
        {
            activeChar.sendPacket(new SystemMessage(SystemMessageId.INCORRECT_TARGET));
            return;
        }

        L2MonsterInstance targetObj = (L2MonsterInstance)activeChar.getTarget();
        
        // ^[Qbg݂ĂāAłȂꍇ̂ݎs
        if(targetObj != null && !targetObj.isDead())
        {
            // lN^[gpۂ̉ʌ
            MagicSkillUse MSU = new MagicSkillUse(activeChar,targetObj,2103,1,0,0);
            activeChar.sendPacket(MSU);
            activeChar.broadcastPacket(MSU);

            try
            {
                // ǎȃ|iɂȂ邩̔
                if(isQualityHigh(targetObj.getNpcId()))
                {
                    // ǎȃ|iNPC Template擾
                    template1 = NpcTable.getInstance().getTemplate(targetObj.getNpcId()+1);
                    // NPC Templateɏof[^쐬
                    L2Spawn spawn = new L2Spawn(template1);
                    spawn.setId(IdFactory.getInstance().getNextId());
                    spawn.setLocx(targetObj.getX());
                    spawn.setLocy(targetObj.getY());
                    spawn.setLocz(targetObj.getZ());
                    // ^[Qbg(c|i)
                    targetObj.deleteMe();
                    // ǎȃ|io
                    L2World.getInstance().storeObject(spawn.spawnOne(/**/false));
                }
                else
                {
                    // sǂȃ|iNPC Template擾
                    template1 = NpcTable.getInstance().getTemplate(targetObj.getNpcId()+2);
                    // NPC Templateɏof[^쐬
                    L2Spawn spawn = new L2Spawn(template1);
                    spawn.setId(IdFactory.getInstance().getNextId());
                    spawn.setLocx(targetObj.getX());
                    spawn.setLocy(targetObj.getY());
                    spawn.setLocz(targetObj.getZ());
                    // ^[Qbg(c|i)
                    targetObj.deleteMe();
                    // sǂȃ|io
                    L2World.getInstance().storeObject(spawn.spawnOne(/**/false));
                }
    
                // gIlN^[
                activeChar.destroyItem("Consume", item.getObjectId(), 1, null, false);
            }
            catch (Exception e)
            {
                activeChar.sendPacket(new SystemMessage(SystemMessageId.INCORRECT_TARGET));
            }
        }
    }
    
    public int[] getItemIds()
    {
        return _itemIds;
    }
    
    // ǎȃ|iɂȂ邩̔֐
    private boolean isQualityHigh(int npcId)
    {
        // c|i͂RO̊mŗǎȃ|iɂȂ
        if(npcId == _npcId_Young_Squash && Rnd.get(100) < 30)
            return true;
        // c傫ȃ|i͂PT̊mŗǎȑ傫ȃ|iɂȂ
        else if (npcId == _npcId_Large_Young_Squash && Rnd.get(100) < 15)
            return true;
        // ȊO͕sǂȃ|i^sǂȑ傫ȃ|iɂȂ
        else
            return false;
    }
}