/*
 * Decompiled with CFR 0.152.
 */
package javolution.xml.ws;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import javolution.io.AppendableWriter;
import javolution.io.UTF8StreamWriter;
import javolution.text.Text;
import javolution.text.TextBuilder;
import javolution.xml.XMLObjectReader;
import javolution.xml.XMLObjectWriter;
import javolution.xml.stream.XMLStreamException;
import javolution.xml.stream.XMLStreamReader;
import javolution.xml.stream.XMLStreamWriter;

public abstract class WebServiceClient {
    public static final String ENVELOPE_PREFIX = "env";
    public static final String ENVELOPE_URI = "http://schemas.xmlsoap.org/soap/envelope/";
    Object _url;
    private final TextBuilder _buffer = new TextBuilder();
    private final AppendableWriter _out = new AppendableWriter();
    private final XMLObjectWriter _writer = new XMLObjectWriter();
    private final UTF8StreamWriter _utf8Writer = new UTF8StreamWriter();
    private final XMLObjectReader _reader = new XMLObjectReader();

    public WebServiceClient setAddress(String string) {
        try {
            this._url = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("Malformed URL: " + string);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke() throws IOException, XMLStreamException {
        try {
            this._out.setOutput(this._buffer);
            this._writer.setOutput(this._out);
            XMLStreamWriter xMLStreamWriter = this._writer.getStreamWriter();
            xMLStreamWriter.setPrefix(WebServiceClient.csq(ENVELOPE_PREFIX), WebServiceClient.csq(ENVELOPE_URI));
            xMLStreamWriter.writeStartElement(WebServiceClient.csq(ENVELOPE_URI), WebServiceClient.csq("Envelope"));
            xMLStreamWriter.writeNamespace(WebServiceClient.csq(ENVELOPE_PREFIX), WebServiceClient.csq(ENVELOPE_URI));
            xMLStreamWriter.writeStartElement(WebServiceClient.csq(ENVELOPE_URI), WebServiceClient.csq("Header"));
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeStartElement(WebServiceClient.csq(ENVELOPE_URI), WebServiceClient.csq("Body"));
            this.writeRequest(this._writer);
            this._writer.close();
            if (this._url == null) {
                throw new IOException("URL not set");
            }
            HttpURLConnection httpURLConnection = (HttpURLConnection)((URL)this._url).openConnection();
            httpURLConnection.setRequestProperty("Content-Length", String.valueOf(this._buffer.length()));
            httpURLConnection.setRequestProperty("Content-Type", "text/xml; charset=utf-8");
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            this._utf8Writer.setOutput(httpURLConnection.getOutputStream());
            this._buffer.print(this._utf8Writer);
            this._utf8Writer.close();
            this._reader.setInput(httpURLConnection.getInputStream());
            XMLStreamReader xMLStreamReader = this._reader.getStreamReader();
            while (xMLStreamReader.hasNext()) {
                if (xMLStreamReader.next() != 1 || !xMLStreamReader.getLocalName().equals("Body") || !xMLStreamReader.getNamespaceURI().equals(ENVELOPE_URI)) continue;
                xMLStreamReader.next();
                this.readResponse(this._reader);
                break;
            }
        }
        finally {
            this._reader.close();
            this._writer.reset();
            this._out.reset();
            this._buffer.reset();
            this._utf8Writer.reset();
            this._reader.reset();
        }
    }

    protected abstract void writeRequest(XMLObjectWriter var1) throws XMLStreamException;

    protected void readResponse(XMLObjectReader xMLObjectReader) throws XMLStreamException {
        XMLStreamReader xMLStreamReader = xMLObjectReader.getStreamReader();
        block10: while (xMLStreamReader.hasNext()) {
            switch (xMLStreamReader.next()) {
                case 7: {
                    System.out.println("Start Document");
                    continue block10;
                }
                case 8: {
                    System.out.println("End Document.");
                    continue block10;
                }
                case 1: {
                    System.out.println("Start Element: " + xMLStreamReader.getLocalName() + "(" + xMLStreamReader.getNamespaceURI() + ")");
                    int n = xMLStreamReader.getAttributeCount();
                    for (int i = 0; i < n; ++i) {
                        System.out.println("   Attribute: " + xMLStreamReader.getAttributeLocalName(i) + "(" + xMLStreamReader.getAttributeNamespace(i) + "), Value: " + xMLStreamReader.getAttributeValue(i));
                    }
                    continue block10;
                }
                case 2: {
                    if (xMLStreamReader.getLocalName().equals("Body") && xMLStreamReader.getNamespaceURI().equals(ENVELOPE_URI)) {
                        return;
                    }
                    System.out.println("End Element: " + xMLStreamReader.getLocalName() + "(" + xMLStreamReader.getNamespaceURI() + ")");
                    continue block10;
                }
                case 4: {
                    System.out.println("Characters: " + xMLStreamReader.getText());
                    continue block10;
                }
                case 12: {
                    System.out.println("CDATA: " + xMLStreamReader.getText());
                    continue block10;
                }
                case 5: {
                    System.out.println("Comment: " + xMLStreamReader.getText());
                    continue block10;
                }
                case 6: {
                    System.out.println("Space");
                    continue block10;
                }
            }
            System.out.println(xMLStreamReader);
        }
    }

    private static final CharSequence csq(Object object) {
        return object instanceof CharSequence ? (CharSequence)object : Text.valueOf(object);
    }
}

