/*
 * Decompiled with CFR 0.152.
 */
package javolution.xml.sax;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javolution.lang.Reflection;
import javolution.lang.Reusable;
import javolution.text.CharArray;
import javolution.xml.sax.ContentHandler;
import javolution.xml.sax.DefaultHandler;
import javolution.xml.sax.XMLReader;
import javolution.xml.stream.XMLStreamException;
import javolution.xml.stream.XMLStreamReaderImpl;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class XMLReaderImpl
implements XMLReader,
Reusable {
    private static DefaultHandler DEFAULT_HANDLER = new DefaultHandler();
    private ContentHandler _contentHandler;
    private ErrorHandler _errorHandler;
    private final XMLStreamReaderImpl _xmlReader = new XMLStreamReaderImpl();
    private static final Reflection.Constructor NEW_URL = Reflection.getConstructor("java.net.URL(java.lang.String)");
    private static final Reflection.Method OPEN_STREAM = Reflection.getMethod("java.net.URL.openStream()");
    private static final Reflection.Constructor NEW_FILE_INPUT_STREAM = Reflection.getConstructor("java.io.FileInputStream(java.lang.String)");
    private EntityResolver _entityResolver;
    private DTDHandler _dtdHandler;
    private static final CharArray NO_CHAR = new CharArray("");

    public XMLReaderImpl() {
        this.setContentHandler(DEFAULT_HANDLER);
        this.setErrorHandler(DEFAULT_HANDLER);
    }

    public void parse(InputStream inputStream) throws IOException, SAXException {
        try {
            this._xmlReader.setInput(inputStream);
            this.parseAll();
        }
        catch (XMLStreamException xMLStreamException) {
            if (xMLStreamException.getNestedException() instanceof IOException) {
                throw (IOException)xMLStreamException.getNestedException();
            }
            throw new SAXException(xMLStreamException);
        }
        finally {
            this._xmlReader.reset();
        }
    }

    public void parse(InputStream inputStream, String string) throws IOException, SAXException {
        try {
            this._xmlReader.setInput(inputStream, string);
            this.parseAll();
        }
        catch (XMLStreamException xMLStreamException) {
            if (xMLStreamException.getNestedException() instanceof IOException) {
                throw (IOException)xMLStreamException.getNestedException();
            }
            throw new SAXException(xMLStreamException);
        }
        finally {
            this._xmlReader.reset();
        }
    }

    public void parse(Reader reader) throws IOException, SAXException {
        try {
            this._xmlReader.setInput(reader);
            this.parseAll();
        }
        catch (XMLStreamException xMLStreamException) {
            if (xMLStreamException.getNestedException() instanceof IOException) {
                throw (IOException)xMLStreamException.getNestedException();
            }
            throw new SAXException(xMLStreamException);
        }
        finally {
            this._xmlReader.reset();
        }
    }

    @Override
    public void parse(InputSource inputSource) throws IOException, SAXException {
        Reader reader = inputSource.getCharacterStream();
        if (reader != null) {
            this.parse(reader);
        } else {
            InputStream inputStream = inputSource.getByteStream();
            if (inputStream != null) {
                this.parse(inputStream, inputSource.getEncoding());
            } else {
                this.parse(inputSource.getSystemId());
            }
        }
    }

    @Override
    public void parse(String string) throws IOException, SAXException {
        InputStream inputStream;
        try {
            Object object = NEW_URL.newInstance(string);
            inputStream = (InputStream)OPEN_STREAM.invoke(object);
        }
        catch (Exception exception) {
            try {
                inputStream = (InputStream)NEW_FILE_INPUT_STREAM.newInstance(string);
            }
            catch (Exception exception2) {
                throw new UnsupportedOperationException("Cannot parse " + string);
            }
        }
        this.parse(inputStream);
    }

    @Override
    public void setContentHandler(ContentHandler contentHandler) {
        if (contentHandler == null) {
            throw new NullPointerException();
        }
        this._contentHandler = contentHandler;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this._contentHandler == DEFAULT_HANDLER ? null : this._contentHandler;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        if (errorHandler == null) {
            throw new NullPointerException();
        }
        this._errorHandler = errorHandler;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this._errorHandler == DEFAULT_HANDLER ? null : this._errorHandler;
    }

    @Override
    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals("http://xml.org/sax/features/namespaces")) {
            return true;
        }
        if (string.equals("http://xml.org/sax/features/namespace-prefixes")) {
            return true;
        }
        throw new SAXNotRecognizedException("Feature " + string + " not recognized");
    }

    @Override
    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals("http://xml.org/sax/features/namespaces") || string.equals("http://xml.org/sax/features/namespace-prefixes")) {
            return;
        }
        throw new SAXNotRecognizedException("Feature " + string + " not recognized");
    }

    @Override
    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException("Property " + string + " not recognized");
    }

    @Override
    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException("Property " + string + " not recognized");
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
        this._entityResolver = entityResolver;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this._entityResolver;
    }

    @Override
    public void setDTDHandler(DTDHandler dTDHandler) {
        this._dtdHandler = dTDHandler;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this._dtdHandler;
    }

    @Override
    public void reset() {
        this.setContentHandler(DEFAULT_HANDLER);
        this.setErrorHandler(DEFAULT_HANDLER);
        this._xmlReader.reset();
    }

    private void parseAll() throws XMLStreamException, SAXException {
        int n = this._xmlReader.getEventType();
        if (n != 7) {
            throw new SAXException("Currently parsing");
        }
        this._contentHandler.startDocument();
        boolean bl = true;
        block9: while (bl) {
            switch (this._xmlReader.next()) {
                case 1: {
                    CharArray charArray;
                    CharArray charArray2;
                    int n2;
                    int n3 = this._xmlReader.getNamespaceCount();
                    for (n2 = 0; n2 < n3; ++n2) {
                        charArray2 = this._xmlReader.getNamespacePrefix(n2);
                        charArray2 = charArray2 == null ? NO_CHAR : charArray2;
                        charArray = this._xmlReader.getNamespaceURI(n2);
                        this._contentHandler.startPrefixMapping(charArray2, charArray);
                    }
                    charArray = this._xmlReader.getNamespaceURI();
                    charArray = charArray == null ? NO_CHAR : charArray;
                    CharArray charArray3 = this._xmlReader.getLocalName();
                    CharArray charArray4 = this._xmlReader.getQName();
                    this._contentHandler.startElement(charArray, charArray3, charArray4, this._xmlReader.getAttributes());
                    break;
                }
                case 2: {
                    CharArray charArray2;
                    int n2;
                    CharArray charArray = this._xmlReader.getNamespaceURI();
                    charArray = charArray == null ? NO_CHAR : charArray;
                    CharArray charArray3 = this._xmlReader.getLocalName();
                    CharArray charArray4 = this._xmlReader.getQName();
                    this._contentHandler.endElement(charArray, charArray3, charArray4);
                    int n3 = this._xmlReader.getNamespaceCount();
                    for (n2 = 0; n2 < n3; ++n2) {
                        charArray2 = this._xmlReader.getNamespacePrefix(n2);
                        charArray2 = charArray2 == null ? NO_CHAR : charArray2;
                        this._contentHandler.endPrefixMapping(charArray2);
                    }
                    continue block9;
                }
                case 4: 
                case 12: {
                    CharArray charArray = this._xmlReader.getText();
                    this._contentHandler.characters(charArray.array(), charArray.offset(), charArray.length());
                    break;
                }
                case 6: {
                    CharArray charArray = this._xmlReader.getText();
                    this._contentHandler.ignorableWhitespace(charArray.array(), charArray.offset(), charArray.length());
                    break;
                }
                case 3: {
                    this._contentHandler.processingInstruction(this._xmlReader.getPITarget(), this._xmlReader.getPIData());
                    break;
                }
                case 5: {
                    break;
                }
                case 8: {
                    bl = false;
                    this._xmlReader.close();
                }
            }
        }
    }
}

