/*
 * Decompiled with CFR 0.152.
 */
package javolution.lang;

import java.lang.reflect.InvocationTargetException;
import javolution.JavolutionError;
import javolution.util.FastMap;

public final class Reflection {
    private static final FastMap _NameToClass = new FastMap();
    private static final Object[] ARRAY_0 = new Object[0];
    private static final ThreadLocal ARRAY_1 = new ThreadLocal(){

        protected Object initialValue() {
            return new Object[1];
        }
    };
    private static final ThreadLocal ARRAY_2 = new ThreadLocal(){

        protected Object initialValue() {
            return new Object[2];
        }
    };
    private static final ThreadLocal ARRAY_3 = new ThreadLocal(){

        protected Object initialValue() {
            return new Object[3];
        }
    };
    private static final ThreadLocal ARRAY_4 = new ThreadLocal(){

        protected Object initialValue() {
            return new Object[4];
        }
    };

    private Reflection() {
    }

    public static Class getClass(CharSequence charSequence) throws ClassNotFoundException {
        Class clazz = (Class)_NameToClass.get(charSequence);
        return clazz != null ? clazz : Reflection.searchClass(((Object)charSequence).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class searchClass(String string) throws ClassNotFoundException {
        Class<?> clazz;
        block7: {
            clazz = null;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    clazz = Class.forName(string, true, classLoader);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                    clazz = Class.forName(string, true, classLoader);
                }
                if (clazz != null) break block7;
                throw new ClassNotFoundException("Cannot found class " + string);
            }
        }
        FastMap fastMap = _NameToClass;
        synchronized (fastMap) {
            _NameToClass.put(string, clazz);
        }
        return clazz;
    }

    public static Class getClass(String string) throws ClassNotFoundException {
        Class clazz = (Class)_NameToClass.get(string);
        return clazz != null ? clazz : Reflection.searchClass(string);
    }

    public static Constructor getConstructor(String string) {
        Class[] classArray;
        Class clazz;
        int n = string.indexOf(40) + 1;
        if (n < 0) {
            throw new IllegalArgumentException("Parenthesis '(' not found");
        }
        int n2 = string.indexOf(41);
        if (n2 < 0) {
            throw new IllegalArgumentException("Parenthesis ')' not found");
        }
        String string2 = string.substring(0, n - 1);
        try {
            clazz = Reflection.getClass(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        String string3 = string.substring(n, n2);
        if (string3.length() == 0) {
            return new DefaultConstructor(clazz);
        }
        try {
            classArray = Reflection.classesFor(string3);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        try {
            return new ReflectConstructor(clazz.getConstructor(classArray), string);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static Method getMethod(String string) {
        int n = string.indexOf(40) + 1;
        if (n < 0) {
            throw new IllegalArgumentException("Parenthesis '(' not found");
        }
        int n2 = string.indexOf(41);
        if (n2 < 0) {
            throw new IllegalArgumentException("Parenthesis ')' not found");
        }
        int n3 = string.substring(0, n).lastIndexOf(46) + 1;
        try {
            Class[] classArray;
            Class clazz;
            String string2 = string.substring(0, n3 - 1);
            try {
                clazz = Reflection.getClass(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
            String string3 = string.substring(n3, n - 1);
            String string4 = string.substring(n, n2);
            try {
                classArray = Reflection.classesFor(string4);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
            return new ReflectMethod(clazz.getMethod(string3, classArray), string);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Class[] classesFor(String string) throws ClassNotFoundException {
        if ((string = string.trim()).length() == 0) {
            return new Class[0];
        }
        int n = 0;
        int n2 = 0;
        while (true) {
            n2 = string.indexOf(44, n2);
            if (n2++ < 0) break;
            ++n;
        }
        Class[] classArray = new Class[n + 1];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            int n4 = string.indexOf(44, n3);
            classArray[i] = Reflection.classFor(string.substring(n3, n4).trim());
            if (classArray[i] == null) {
                return null;
            }
            n3 = n4 + 1;
        }
        classArray[n] = Reflection.classFor(string.substring(n3).trim());
        if (classArray[n] == null) {
            return null;
        }
        return classArray;
    }

    private static Class classFor(String string) throws ClassNotFoundException {
        int n = string.indexOf("[]");
        if (n >= 0) {
            if (string.indexOf("[][]") >= 0) {
                if (string.indexOf("[][][]") >= 0) {
                    if (string.indexOf("[][][][]") >= 0) {
                        throw new UnsupportedOperationException("The maximum array dimension is 3");
                    }
                    return Reflection.getClass("[[[" + Reflection.descriptorFor(string.substring(0, n)));
                }
                return Reflection.getClass("[[" + Reflection.descriptorFor(string.substring(0, n)));
            }
            return Reflection.getClass("[" + Reflection.descriptorFor(string.substring(0, n)));
        }
        if (string.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (string.equals("byte")) {
            return Byte.TYPE;
        }
        if (string.equals("char")) {
            return Character.TYPE;
        }
        if (string.equals("short")) {
            return Short.TYPE;
        }
        if (string.equals("int")) {
            return Integer.TYPE;
        }
        if (string.equals("long")) {
            return Long.TYPE;
        }
        if (string.equals("float")) {
            return Float.TYPE;
        }
        if (string.equals("double")) {
            return Double.TYPE;
        }
        return Reflection.getClass(string);
    }

    private static String descriptorFor(String string) {
        if (string.equals("boolean")) {
            return "Z";
        }
        if (string.equals("byte")) {
            return "B";
        }
        if (string.equals("char")) {
            return "C";
        }
        if (string.equals("short")) {
            return "S";
        }
        if (string.equals("int")) {
            return "I";
        }
        if (string.equals("long")) {
            return "J";
        }
        if (string.equals("float")) {
            return "F";
        }
        if (string.equals("double")) {
            return "D";
        }
        return "L" + string + ";";
    }

    public static abstract class Method {
        private final Class[] _parameterTypes;

        protected Method(Class[] classArray) {
            this._parameterTypes = classArray;
        }

        public Class[] getParameterTypes() {
            return this._parameterTypes;
        }

        protected abstract Object execute(Object var1, Object[] var2);

        public final Object invoke(Object object) {
            return this.execute(object, ARRAY_0);
        }

        public final Object invoke(Object object, Object object2) {
            if (this._parameterTypes.length != 1) {
                throw new IllegalArgumentException("Expected number of parameters is " + this._parameterTypes.length);
            }
            Object[] objectArray = (Object[])ARRAY_1.get();
            objectArray[0] = object2;
            Object object3 = this.execute(object, objectArray);
            objectArray[0] = null;
            return object3;
        }

        public final Object invoke(Object object, Object object2, Object object3) {
            if (this._parameterTypes.length != 2) {
                throw new IllegalArgumentException("Expected number of parameters is " + this._parameterTypes.length);
            }
            Object[] objectArray = (Object[])ARRAY_2.get();
            objectArray[0] = object2;
            objectArray[1] = object3;
            Object object4 = this.execute(object, objectArray);
            objectArray[0] = null;
            objectArray[1] = null;
            return object4;
        }

        public final Object invoke(Object object, Object object2, Object object3, Object object4) {
            if (this._parameterTypes.length != 3) {
                throw new IllegalArgumentException("Expected number of parameters is " + this._parameterTypes.length);
            }
            Object[] objectArray = (Object[])ARRAY_3.get();
            objectArray[0] = object2;
            objectArray[1] = object3;
            objectArray[2] = object4;
            Object object5 = this.execute(object, objectArray);
            objectArray[0] = null;
            objectArray[1] = null;
            objectArray[2] = null;
            return object5;
        }

        public final Object invoke(Object object, Object object2, Object object3, Object object4, Object object5) {
            if (this._parameterTypes.length != 3) {
                throw new IllegalArgumentException("Expected number of parameters is " + this._parameterTypes.length);
            }
            Object[] objectArray = (Object[])ARRAY_3.get();
            objectArray[0] = object2;
            objectArray[1] = object3;
            objectArray[2] = object4;
            objectArray[3] = object5;
            Object object6 = this.execute(object, objectArray);
            objectArray[0] = null;
            objectArray[1] = null;
            objectArray[2] = null;
            objectArray[3] = null;
            return object6;
        }
    }

    public static abstract class Constructor {
        private final Class[] _parameterTypes;

        protected Constructor(Class[] classArray) {
            this._parameterTypes = classArray;
        }

        public Class[] getParameterTypes() {
            return this._parameterTypes;
        }

        protected abstract Object allocate(Object[] var1);

        public final Object newInstance() {
            if (this._parameterTypes.length != 0) {
                throw new IllegalArgumentException("Expected number of parameters is " + this._parameterTypes.length);
            }
            return this.allocate(ARRAY_0);
        }

        public final Object newInstance(Object object) {
            if (this._parameterTypes.length != 1) {
                throw new IllegalArgumentException("Expected number of parameters is " + this._parameterTypes.length);
            }
            Object[] objectArray = (Object[])ARRAY_1.get();
            objectArray[0] = object;
            Object object2 = this.allocate(objectArray);
            objectArray[0] = null;
            return object2;
        }

        public final Object newInstance(Object object, Object object2) {
            if (this._parameterTypes.length != 2) {
                throw new IllegalArgumentException("Expected number of parameters is " + this._parameterTypes.length);
            }
            Object[] objectArray = (Object[])ARRAY_2.get();
            objectArray[0] = object;
            objectArray[1] = object2;
            Object object3 = this.allocate(objectArray);
            objectArray[0] = null;
            objectArray[1] = null;
            return object3;
        }

        public final Object newInstance(Object object, Object object2, Object object3) {
            if (this._parameterTypes.length != 3) {
                throw new IllegalArgumentException("Expected number of parameters is " + this._parameterTypes.length);
            }
            Object[] objectArray = (Object[])ARRAY_3.get();
            objectArray[0] = object;
            objectArray[1] = object2;
            objectArray[2] = object3;
            Object object4 = this.allocate(objectArray);
            objectArray[0] = null;
            objectArray[1] = null;
            objectArray[2] = null;
            return object4;
        }

        public final Object newInstance(Object object, Object object2, Object object3, Object object4) {
            if (this._parameterTypes.length != 4) {
                throw new IllegalArgumentException("Expected number of parameters is " + this._parameterTypes.length);
            }
            Object[] objectArray = (Object[])ARRAY_4.get();
            objectArray[0] = object;
            objectArray[1] = object2;
            objectArray[2] = object3;
            objectArray[3] = object4;
            Object object5 = this.allocate(objectArray);
            objectArray[0] = null;
            objectArray[1] = null;
            objectArray[2] = null;
            objectArray[3] = null;
            return object5;
        }
    }

    private static final class ReflectMethod
    extends Method {
        private final java.lang.reflect.Method _value;
        private final String _signature;

        public ReflectMethod(java.lang.reflect.Method method, String string) {
            super(method.getParameterTypes());
            this._value = method;
            this._signature = string;
        }

        @Override
        public Object execute(Object object, Object[] objectArray) {
            try {
                return this._value.invoke(object, objectArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new JavolutionError("Illegal argument for " + this._signature + " method", illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new JavolutionError("Illegal access error for " + this._signature + " method", illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new JavolutionError("Invocation exception for " + this._signature + " method", (InvocationTargetException)invocationTargetException.getTargetException());
            }
        }

        public String toString() {
            return this._signature + " method";
        }
    }

    private static final class ReflectConstructor
    extends Constructor {
        private final java.lang.reflect.Constructor _value;
        private final String _signature;

        public ReflectConstructor(java.lang.reflect.Constructor constructor, String string) {
            super(constructor.getParameterTypes());
            this._value = constructor;
            this._signature = string;
        }

        @Override
        public Object allocate(Object[] objectArray) {
            try {
                return this._value.newInstance(objectArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new JavolutionError("Illegal argument for " + this._signature + " constructor", illegalArgumentException);
            }
            catch (InstantiationException instantiationException) {
                throw new JavolutionError("Instantiation error for " + this._signature + " constructor", instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new JavolutionError("Illegal access error for " + this._signature + " constructor", illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new JavolutionError("Invocation exception  for " + this._signature + " constructor", (InvocationTargetException)invocationTargetException.getTargetException());
            }
        }

        public String toString() {
            return this._signature + " constructor";
        }
    }

    private static class DefaultConstructor
    extends Constructor {
        final Class _class;

        DefaultConstructor(Class clazz) {
            super(new Class[0]);
            this._class = clazz;
        }

        @Override
        public Object allocate(Object[] objectArray) {
            try {
                return this._class.newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new JavolutionError("Instantiation error for " + this._class.getName() + " default constructor", instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new JavolutionError("Illegal access error for " + this._class.getName() + " constructor", illegalAccessException);
            }
        }

        public String toString() {
            return this._class + " default constructor";
        }
    }
}

