## Active Perl 5.8.8
use utf8;
use warnings;
use strict;
binmode STDOUT,'encoding(cp932)';

open CSV, '<:utf8', 'temp/questname-j.txt'  or die $!;
my $mtime = (stat CSV)[9];

open SQL, '>:utf8', 'questname_ja.sql'  or die $!;
print SQL "--
-- from 'questname-j.dat'
--
DROP TABLE IF EXISTS questname_ja;
CREATE TABLE questname_ja (
	 id INTEGER NOT NULL
	,name VARCHAR(200) DEFAULT ''
	,PRIMARY KEY (id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

";

my $count = 0;
my $delim = ' ';
<CSV>; # skip header
while (not eof CSV) {
	my $buf = <CSV>;
	chomp $buf;
	my @field = split /\t/, $buf;
	foreach (@field) {s/^[ua],//; s/\\0//}
	my ($id,$order,$name) = ($field[1],$field[2],$field[3]);
	next if $order != 1;
	$name =~ s/'/''/g;
	print "$id\r";

	if (++$count > 500) {
		print SQL ";\n";
		$count = 1;
	}
	if ($count == 1) {
		print SQL "INSERT INTO questname_ja (id,name) VALUES\n";
		$delim = ' ';
	}
	print SQL $delim,"($id,'$name')\n";
	$delim = ',';
}
print SQL ";\n";
close SQL;
utime $mtime,$mtime,'questname_ja.sql';

close CSV;
print "\n";
