DROP TABLE IF EXISTS `npcaidata`;
CREATE TABLE `npcaidata` (
  `npcId` smallint(5) unsigned NOT NULL,
  `minSkillChance` tinyint(3) unsigned NOT NULL DEFAULT '7',
  `maxSkillChance` tinyint(3) unsigned NOT NULL DEFAULT '15',
  `primarySkillId` smallint(5) unsigned DEFAULT '0',
  `agroRange` smallint(4) unsigned NOT NULL DEFAULT '0',
  `canMove` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `targetable` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `showName` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `minRangeSkill` smallint(5) unsigned DEFAULT '0',
  `minRangeChance` tinyint(3) unsigned DEFAULT '0',
  `maxRangeSkill` smallint(5) unsigned DEFAULT '0',
  `maxRangeChance` tinyint(3) unsigned DEFAULT '0',
  `soulShot` smallint(4) unsigned DEFAULT '0',
  `spiritShot` smallint(4) unsigned DEFAULT '0',
  `spsChance` tinyint(3) unsigned DEFAULT '0',
  `ssChance` tinyint(3) unsigned DEFAULT '0',
  `aggro` smallint(4) unsigned NOT NULL DEFAULT '0',
  `isChaos` smallint(4) unsigned DEFAULT '0',
  `clan` varchar(40) DEFAULT NULL,
  `clanRange` smallint(4) unsigned DEFAULT '0',
  `enemyClan` varchar(40) DEFAULT NULL,
  `enemyRange` smallint(4) unsigned DEFAULT '0',
  `dodge` tinyint(3) unsigned DEFAULT '0',
  `aiType` varchar(8) NOT NULL DEFAULT 'fighter',
  PRIMARY KEY (`npcId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `npcaidata` VALUES
(100, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Thomas D. Turkey
(101, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), --
(102, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Santa Trainee
(103, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Christmas Santa
(104, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Christmas Santa
(105, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Christmas Sled
(106, 7, 15, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Birthday Cake
(107, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Spirit of Fire
(108, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Reckless Spirit of Fire
(109, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Steve Shyagel
(110, 7, 15, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Eva's Obelisk
(111, 7, 15, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), --
(112, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Friendly Sno
(113, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Friendly Sno
(114, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Friendly Sno
(115, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Friendly Sno
(116, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Friendly Sno
(117, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Friendly Sno
(118, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Uldie
(119, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Belldandy
(120, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Skooldie
(121, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Lucky Lamp
(122, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Environment Lamp
(123, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Rolling Lamp
(124, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Peace Lamp
(125, 7, 15, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Halloween Event Manager
(126, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kadomas
(127, 7, 15, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kotatz
(128, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Flame Box
(129, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- White-Bearded Santa
(130, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), --
(131, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Jetbike
(132, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trejuo
(133, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Sujin
(134, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Dragon Master Lee
(135, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Dragon Master Karin
(136, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Shiny Platform
(137, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Big Wedding Cake
(138, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Jetbike
(139, 7, 15, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Birthday Cake
(140, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Block Checker Blue
(141, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Dimensional Door
(142, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Dimensional Door
(143, 7, 15, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Totem of Body
(144, 7, 15, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Totem of Spirit
(145, 7, 15, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Totem of Bravery
(146, 7, 15, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Totem of Fortitude
(147, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Party Cake
(148, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Campfire
(149, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Bad Bunny
(150, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Bad Bunny Captain
(151, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Liverless Bunny
(152, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Liverless Bunny Captain
(153, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Employee of Magic Research Institute
(154, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), --
(155, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), --
(156, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Big Liver Bunny
(157, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Big Liver Bunny Captain
(158, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Wood Horse
(1501, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Majo Agathion
(1502, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Gold Crown Agathion
(1503, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Black Crown Agathion
(1504, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Plaipitak Agathion
(1505, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Baby Panda Agathion
(1506, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Bamboo Panda Agathion
(1507, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Sexy Panda Agathion
(1508, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- White Cupid Agathion
(1509, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Dark Cupid Agathion
(1510, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- White Maneki Neko Agathion
(1511, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Black Maneki Neko Agathion
(1512, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Brown Maneki Neko Agathion
(1513, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- One-eyed Bat Drove Agathion
(1514, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Pegasus Agathion
(1515, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Yellow-robed Tojigong Agathion
(1516, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Blue-robed Tojigong Agathion
(1517, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Green-robed Tojigong Agathion
(1518, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Bugbear Agathion
(1519, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Red Sumo Wrestler Agathion
(1520, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Blue Sumo Wrestler Agathion
(1521, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Great Sumo Match Agathion
(1522, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Button-Eyed Bear Doll
(1523, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- God of Fortune
(1524, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Dryad Agathion
(1525, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Wonboso Agathion
(1526, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Daewoonso Agathion
(1527, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Pomona Agathion
(1528, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Weaver Agathion
(1529, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Slow Agathion
(1530, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Noisy Agathion
(1531, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Dancing Child of Fortune Agathion
(1532, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Son-o-gong Agathion
(1533, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Wutangka Agathion
(1534, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Bonus B Agathion
(1535, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Frozen Corpse Agathion
(1536, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Bluebird Agathion
(1537, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Hatbird Agathion
(1538, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Baby Rudolph
(1539, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Iken Agathion
(1540, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Lana Agathion
(1541, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Gnosian Agathion
(1542, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Orodriel Agathion
(1543, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Lakinos Agathion
(1544, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mortia Agathion
(1545, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Heintz Agathion
(1546, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Meruril Agathion
(1547, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Taman Zu Rapatui Agathion
(1548, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kaurin Agathion
(1549, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Ahertbein Agathion
(1550, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Naonin Agathion
(1551, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Guangong Agathion
(1552, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Gwanseum Nyang Nyang Agathion
(1553, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Blue Opera Agathion
(1554, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Red Opera Agathion
(1555, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Opera Agathion
(1556, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mandarin Dress Agathion
(1557, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Nepal Snow Agathion
(1558, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Round Ball Snow Agathion
(1559, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Ladder Snow Agathion
(1560, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Blue Opera Agathion
(1561, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Baby Rudolph
(1562, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Desheloph
(1563, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Hyum
(1564, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Lekang
(1565, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Lilias
(1566, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Lapham
(1567, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mafum
(1568, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Desheloph
(1569, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Hyum
(1570, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Lekang
(1571, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Lilias
(1572, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Lapham
(1573, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mafum
(1574, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Phoenix
(1575, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Samduyong
(1576, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Ball Trapping Gnosian
(1577, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Ball Trapping Orodriel
(1578, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Penalty Kick
(1579, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Ball Trapping Gnosian
(1580, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Ball Trapping Orodriel
(1581, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Penalty Kick
(1582, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Ball Trapping Gnosian
(1583, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Ball Trapping Orodriel
(1584, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Penalty Kick
(1585, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Granny Tiger
(1586, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Flower Fairy Spirit
(1587, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Cheerleader Orodriel
(1588, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Cheerleader Lana
(1589, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Cheerleader Naonin
(1590, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Cheerleader Mortia
(1591, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Cheerleader Kaurin
(1592, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Cheerleader Meruril
(1593, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Handy
(1594, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Singer and Dancer Agathion
(1595, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Zakensword Agathion
(1596, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Cow Agathion
(1597, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Tow Agathion
(1598, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Rudolph Agathion
(1599, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Zinyanzi Agathion
(1600, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Zinyanzi Agathion
(1601, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Super Feline Queen Z
(1602, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Super Kat the Cat Z
(1603, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Super Mew the Cat Z
(1604, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Hanbok Agathion
(1605, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Chuchu Agathion
(2081, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Canabion of Plague
(2082, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Canabion of Plague
(2083, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Canabion of Plague
(2501, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Lucky Pig
(2502, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Wingless Lucky Pig
(2503, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Wingless Lucky Pig
(4301, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Miss Queen
(4302, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Master Dugi
(4303, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Skooldie
(4304, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- White-Bearded Santa
(4305, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Rosalia
(4306, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Steve Shyagel
(4307, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Santa Claus
(4308, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Angel Cat
(4309, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Prophet
(4310, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Prophet
(4311, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Prophet
(4312, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Prophet
(4313, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Angel Cat
(4314, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Teleport Device
(4315, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Warehouse Keeper
(4316, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Photo Snow
(4317, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Photo Snow
(4318, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Photo Snow
(4319, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Photo Snow
(4320, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Photo Snow
(4321, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Photo Snow
(4322, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Photo Snow
(4323, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Photo Snow
(4324, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Worshipper
(4325, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Altar Guard
(4326, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Proclaimer of Tersi
(4327, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Worshipper
(4328, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Altar Guard
(4329, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Miss Queen
(12077, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Wolf
(12311, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Hatchling of the Wind
(12312, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Hatchling of the Stars
(12313, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Hatchling of Twilight
(12526, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Wind Strider
(12527, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Star Strider
(12528, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Twilight Strider
(12564, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Sin Eater
(12621, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Wyvern
(12774, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Young Squash
(12775, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- High Quality Squash
(12776, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Low Quality Squash
(12777, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Large Young Squash
(12778, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- High Quality Large Squash
(12779, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Low Quality Large Squash
(12780, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Baby Buffalo
(12781, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Baby Kookaburra
(12782, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Baby Cougar
(13001, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Heart of Warding
(13002, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Life Control Tower
(13003, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Life Control Tower
(13004, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Flame Control Tower
(13005, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Flame Control Tower
(13006, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Holiday Tree
(13007, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Special Holiday Tree
(13014, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fire_clan", 300, "null", 0, 0, "fighter"), --
(13015, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "andreas_clan", 0, "null", 0, 0, "fighter"), --
(13016, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- King Squash
(13017, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Emperor Squash
(13018, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), --
(13019, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), --
(13020, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), --
(13021, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), --
(13022, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), --
(13023, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), --
(13024, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), --
(13025, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), --
(13026, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), --
(13027, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), --
(13028, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), --
(13029, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), --
(13030, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), --
(13031, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "pig_clan", 1000, "null", 0, 0, "fighter"), -- Huge Pig
(13032, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "pig_clan", 1000, "null", 0, 0, "fighter"), -- Huge Pig
(13033, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "pig_clan", 1000, "null", 0, 0, "fighter"), -- Huge Pig
(13034, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "pig_clan", 1000, "null", 0, 0, "fighter"), -- Super Huge Pig
(13035, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "pig_clan", 1000, "null", 0, 0, "fighter"), -- Golden Pig
(13036, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Treasure Chest
(13037, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Trap
(13038, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Trap
(13039, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Trap
(13040, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Trap
(13041, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Trap
(13042, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Trap
(13043, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Trap
(13044, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Trap
(13045, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Trap
(13046, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Trap
(13047, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Trap
(13048, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Trap
(13049, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Trap
(13050, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Trap
(13051, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Trap
(13052, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Trap
(13053, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Trap
(13054, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Trap
(13055, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Trap
(13056, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Trap
(13057, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Trap
(13058, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Trap
(13059, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Trap
(13060, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Trap
(13061, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Trap
(13062, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Trap
(13063, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Trap
(13064, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Trap
(13065, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Trap
(13066, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Trap
(13067, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Trap
(13068, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Trap
(13069, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Trap
(13070, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Trap
(13071, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Virtual Image
(13072, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Virtual Image
(13073, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Virtual Image
(13074, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Virtual Image
(13075, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Virtual Image
(13076, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Virtual Image
(13077, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Onyx Beast
(13078, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Doom Wraith
(13079, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Grail Apostle
(13080, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Grail Apostle
(13081, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Unicorn
(13082, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Lilim Knight
(13083, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Golem Guardian
(13084, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Inferno Drake
(13085, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Dragon Bomber
(13086, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Zariche
(13087, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Akamanah
(13088, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Final Form
(13089, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Final Form
(13090, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Native
(13091, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Yeti
(13092, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Buffalo
(13093, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Pig
(13094, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Zombie
(13095, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Pixy
(13096, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Rabbit
(13097, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), --
(13098, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Event Treasure Chest
(13099, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Zaken
(13100, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Anakim
(13101, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Venom
(13102, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Gordon
(13103, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Ranku
(13104, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Kiyachi
(13105, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Demon Prince
(13106, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Heretic Male
(13107, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Heretic Female
(13108, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Veil Master
(13109, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Saber Tooth Tiger
(13110, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Ol Mahum
(13111, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Doll Blader
(13112, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Divine Knight
(13113, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Divine Warrior
(13114, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Divine Rogue
(13115, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Divine Healer
(13116, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Divine Wizard
(13117, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Divine Enchanter
(13118, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Divine Summoner
(13119, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Dwarf Golem
(13120, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "rat_clan", 1000, "null", 0, 0, "balanced"), -- Giant Rat
(13121, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "rat_clan", 1000, "null", 0, 0, "balanced"), -- Giant Rat
(13122, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "rat_clan", 1000, "null", 0, 0, "balanced"), -- Giant Rat
(13123, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "rat_clan", 1000, "null", 0, 0, "balanced"), -- Super Giant Rat
(13124, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "rat_clan", 1000, "null", 0, 0, "balanced"), -- Giant Rat
(13125, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Trap
(13126, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Trap
(13127, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Trap
(13128, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Golem Trader
(13129, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Teleporter
(13130, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Light Purple Maned Horse
(13131, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Grizzly Bear
(13132, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Timitran
(13133, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Lava Golem
(13134, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Yeti
(13135, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Pumpkin Ghost
(13136, 7, 15, 0, 0, 1, 0, 0, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), --
(13137, 7, 15, 0, 0, 1, 0, 0, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), --
(13138, 7, 15, 0, 0, 1, 0, 0, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), --
(13139, 7, 15, 0, 0, 1, 0, 0, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), --
(13140, 7, 15, 0, 0, 1, 0, 0, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), --
(13141, 7, 15, 0, 0, 1, 0, 0, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), --
(13142, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Final Form
(13143, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Final Form
(13144, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Aurabird-Falcon
(13145, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Aurabird-Owl
(13146, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Tawny-Maned Lion
(13147, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Steam Sledge
(13148, 7, 15, 0, 0, 1, 0, 0, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Lindvior
(13149, 7, 15, 0, 1000, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fire_clan", 300, "null", 0, 0, "balanced"), -- For Presentation 1
(13150, 7, 15, 0, 1000, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fire_clan", 300, "null", 0, 0, "balanced"), -- For Presentation 2
(13151, 7, 15, 0, 1000, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fire_clan", 300, "null", 0, 0, "balanced"), -- For Presentation 3
(13152, 7, 15, 0, 1000, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fire_clan", 300, "null", 0, 0, "balanced"), -- For Presentation 4
(13153, 7, 15, 0, 1000, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fire_clan", 300, "null", 0, 0, "balanced"), -- For Presentation 5
(13154, 7, 15, 0, 0, 1, 0, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Demon Race
(13155, 7, 15, 0, 0, 1, 1, 0, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Unicorniun
(13156, 7, 15, 0, 0, 1, 0, 0, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Myo Race
(13157, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Frog
(13158, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Young Child
(13159, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Mercenary
(13160, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Snowman
(13161, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Scarecrow
(13162, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Tin Plate Golem
(13163, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Tow
(13164, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Lure Tow
(13165, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Heavy Tow
(13166, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Wing Tow
(13167, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Main Role A
(13168, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Main Role B
(13169, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Human Male Mercenary
(13170, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Male Elf Mercenary
(13171, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Dark Elf Female Mercenary
(13172, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Orc Male Mercenary
(13173, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Dwarf Male Mercenary
(13174, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Kamael Male Mercenary
(13175, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Knight Level Mercenary
(13176, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Archer Level Mercenary
(13177, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Wizard Level Mercenary
(13178, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Trooper Level Mercenary
(13179, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Knight Leader Elite Mercenary
(13180, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Commander Elite Mercenary
(13181, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Treasure Chest
(13182, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Free Gift Merchant
(13183, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Thomas D. Turkey
(13184, 7, 15, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Santa Claus
(13185, 7, 15, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Santa Claus
(13186, 7, 15, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Santa Claus
(13187, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Milk Cow
(13188, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Head Milk Cow
(13189, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Bull
(13190, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Head Bull
(13191, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Gloomy Milk Cow
(13192, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Gloomy Head Milk Cow
(13193, 7, 15, 0, 0, 1, 0, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), --
(13194, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), --
(13195, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), --
(13196, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Huge Pig
(13197, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Guardian's Strider
(13198, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Native
(13199, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Native
(13200, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Young Child
(13201, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Guards of the Dawn
(13202, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13203, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13204, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13205, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13206, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13207, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13208, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13209, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13210, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13211, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13212, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13213, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13214, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13215, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13216, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13217, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13218, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13219, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13220, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13221, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13222, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13223, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13224, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13225, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13226, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13227, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13228, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13229, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13230, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13231, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13232, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13233, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13234, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13235, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13236, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13237, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13238, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13239, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13240, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13241, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13242, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13243, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13244, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13245, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13246, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13247, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13248, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13249, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13250, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13251, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13252, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13253, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13254, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13255, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13256, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trap
(13257, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Virtual Image
(13258, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Virtual Image
(13259, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Virtual Image
(13260, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Virtual Image
(13261, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Virtual Image
(13262, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Virtual Image
(13263, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Virtual Image
(13264, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Virtual Image
(13265, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Virtual Image
(13266, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Virtual Image
(13267, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Virtual Image
(13268, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Aqua Elf
(13269, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Hot Weather
(13270, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Sultriness
(13271, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Young Watermelon
(13272, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Defective Watermelon
(13273, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Rain Watermelon
(13274, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Large Rain Watermelon
(13275, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Young Honey Watermelon
(13276, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Defective Honey Watermelon
(13277, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Rain Honey Watermelon
(13278, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Large Rain Honey Watermelon
(13279, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Uldie
(13280, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Belldandy
(13281, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Skooldie
(13282, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Skooldie
(13283, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Treykan
(13284, 7, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), --
(13285, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Santa Claus
(13286, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Baby White Tiger
(13287, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Baby White Tiger Captain
(13288, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Gloomy Baby White Tiger
(13289, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Gloomy Baby White Tiger Captain
(13290, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- White Tiger
(13291, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- White Tiger Captain
(13292, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Employee of Magic Research Institute
(13293, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), --
(13294, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), --
(13295, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- White Lady
(13296, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Freya
(13297, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- World Cup Cat
(13298, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Game Manager
(14001, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Reanimated Man
(14002, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Reanimated Man
(14003, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Reanimated Man
(14004, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Reanimated Man
(14005, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Reanimated Man
(14006, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Reanimated Man
(14007, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Reanimated Man
(14008, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Reanimated Man
(14009, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Reanimated Man
(14010, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Reanimated Man
(14011, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Reanimated Man
(14012, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Reanimated Man
(14013, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Reanimated Man
(14014, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Reanimated Man
(14015, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Reanimated Man
(14016, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Reanimated Man
(14017, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Reanimated Man
(14018, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Reanimated Man
(14019, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Reanimated Man
(14020, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Reanimated Man
(14021, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Reanimated Man
(14022, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Reanimated Man
(14023, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Reanimated Man
(14024, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Reanimated Man
(14025, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Reanimated Man
(14026, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Reanimated Man
(14027, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Reanimated Man
(14028, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Reanimated Man
(14029, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Reanimated Man
(14030, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Reanimated Man
(14031, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Reanimated Man
(14032, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Reanimated Man
(14033, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Reanimated Man
(14034, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Reanimated Man
(14035, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Reanimated Man
(14036, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Reanimated Man
(14037, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Reanimated Man
(14038, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Corrupted Man
(14039, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Corrupted Man
(14040, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Corrupted Man
(14041, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Corrupted Man
(14042, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Corrupted Man
(14043, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Corrupted Man
(14044, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Corrupted Man
(14045, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Corrupted Man
(14046, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Corrupted Man
(14047, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Corrupted Man
(14048, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Corrupted Man
(14049, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Corrupted Man
(14050, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Corrupted Man
(14051, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Corrupted Man
(14052, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Corrupted Man
(14053, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Corrupted Man
(14054, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Corrupted Man
(14055, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Corrupted Man
(14056, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Corrupted Man
(14057, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Corrupted Man
(14058, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Corrupted Man
(14059, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Corrupted Man
(14060, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Corrupted Man
(14061, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Corrupted Man
(14062, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Corrupted Man
(14063, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Corrupted Man
(14064, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Corrupted Man
(14065, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Corrupted Man
(14066, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Corrupted Man
(14067, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Corrupted Man
(14068, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Corrupted Man
(14069, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Corrupted Man
(14070, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Corrupted Man
(14071, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Corrupted Man
(14072, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Corrupted Man
(14073, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Corrupted Man
(14074, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Cursed Man
(14075, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Cursed Man
(14076, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Cursed Man
(14077, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Cursed Man
(14078, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Cursed Man
(14079, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Cursed Man
(14080, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Cursed Man
(14081, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Cursed Man
(14082, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Cursed Man
(14083, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Cursed Man
(14084, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Cursed Man
(14085, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Cursed Man
(14086, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Cursed Man
(14087, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Cursed Man
(14088, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Cursed Man
(14089, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Cursed Man
(14090, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Cursed Man
(14091, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Cursed Man
(14092, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Cursed Man
(14093, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Cursed Man
(14094, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Cursed Man
(14095, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Cursed Man
(14096, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Cursed Man
(14097, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Cursed Man
(14098, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Cursed Man
(14099, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Cursed Man
(14100, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Cursed Man
(14101, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Cursed Man
(14102, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Cursed Man
(14103, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Cursed Man
(14104, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Cursed Man
(14105, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Cursed Man
(14106, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Cursed Man
(14107, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Cursed Man
(14108, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Cursed Man
(14109, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Cursed Man
(14110, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Cursed Man
(14111, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kat the Cat
(14112, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kat the Cat
(14113, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kat the Cat
(14114, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kat the Cat
(14115, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kat the Cat
(14116, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kat the Cat
(14117, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kat the Cat
(14118, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kat the Cat
(14119, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kat the Cat
(14120, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kat the Cat
(14121, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kat the Cat
(14122, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kat the Cat
(14123, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kat the Cat
(14124, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kat the Cat
(14125, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kat the Cat
(14126, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kat the Cat
(14127, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kat the Cat
(14128, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kat the Cat
(14129, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kat the Cat
(14130, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kat the Cat
(14131, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kat the Cat
(14132, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kat the Cat
(14133, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kat the Cat
(14134, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kat the Cat
(14135, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kat the Cat
(14136, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kat the Cat
(14137, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Kat the Cat
(14138, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Kat the Cat
(14139, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Kat the Cat
(14140, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Kat the Cat
(14141, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Kat the Cat
(14142, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Kat the Cat
(14143, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Kat the Cat
(14144, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Kat the Cat
(14145, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Kat the Cat
(14146, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Kat the Cat
(14147, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Kat the Cat
(14148, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Kat the Cat
(14149, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Kat the Cat
(14150, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Kat the Cat
(14151, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Kat the Cat
(14152, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Kat the Cat
(14153, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Kat the Cat
(14154, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Kat the Cat
(14155, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Kat the Cat
(14156, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Kat the Cat
(14157, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Kat the Cat
(14158, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Kat the Cat
(14159, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mew the Cat
(14160, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mew the Cat
(14161, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mew the Cat
(14162, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mew the Cat
(14163, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mew the Cat
(14164, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mew the Cat
(14165, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mew the Cat
(14166, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mew the Cat
(14167, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mew the Cat
(14168, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mew the Cat
(14169, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mew the Cat
(14170, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mew the Cat
(14171, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mew the Cat
(14172, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mew the Cat
(14173, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mew the Cat
(14174, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mew the Cat
(14175, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mew the Cat
(14176, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mew the Cat
(14177, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mew the Cat
(14178, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mew the Cat
(14179, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mew the Cat
(14180, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mew the Cat
(14181, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mew the Cat
(14182, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mew the Cat
(14183, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mew the Cat
(14184, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mew the Cat
(14185, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Mew the Cat
(14186, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Mew the Cat
(14187, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Mew the Cat
(14188, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Mew the Cat
(14189, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Mew the Cat
(14190, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Mew the Cat
(14191, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Mew the Cat
(14192, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Mew the Cat
(14193, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Mew the Cat
(14194, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Mew the Cat
(14195, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Mew the Cat
(14196, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Mew the Cat
(14197, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Mew the Cat
(14198, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Mew the Cat
(14199, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Mew the Cat
(14200, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Mew the Cat
(14201, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Mew the Cat
(14202, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Mew the Cat
(14203, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Mew the Cat
(14204, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Mew the Cat
(14205, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Mew the Cat
(14206, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Mew the Cat
(14207, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kai the Cat
(14208, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kai the Cat
(14209, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kai the Cat
(14210, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kai the Cat
(14211, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kai the Cat
(14212, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kai the Cat
(14213, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kai the Cat
(14214, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kai the Cat
(14215, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kai the Cat
(14216, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kai the Cat
(14217, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kai the Cat
(14218, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kai the Cat
(14219, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kai the Cat
(14220, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kai the Cat
(14221, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kai the Cat
(14222, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kai the Cat
(14223, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kai the Cat
(14224, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kai the Cat
(14225, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kai the Cat
(14226, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kai the Cat
(14227, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kai the Cat
(14228, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kai the Cat
(14229, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kai the Cat
(14230, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kai the Cat
(14231, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kai the Cat
(14232, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kai the Cat
(14233, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kai the Cat
(14234, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kai the Cat
(14235, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kai the Cat
(14236, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kai the Cat
(14237, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kai the Cat
(14238, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kai the Cat
(14239, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kai the Cat
(14240, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kai the Cat
(14241, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kai the Cat
(14242, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kai the Cat
(14243, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kai the Cat
(14244, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kai the Cat
(14245, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Kai the Cat
(14246, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Kai the Cat
(14247, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Kai the Cat
(14248, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Kai the Cat
(14249, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Kai the Cat
(14250, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Kai the Cat
(14251, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Feline Queen
(14252, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Feline Queen
(14253, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Feline Queen
(14254, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Feline Queen
(14255, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Feline Queen
(14256, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Feline Queen
(14257, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Feline Queen
(14258, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Feline Queen
(14259, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Feline Queen
(14260, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Feline Queen
(14265, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Feline Queen
(14266, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Feline Queen
(14267, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Feline Queen
(14268, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Feline Queen
(14269, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Feline Queen
(14270, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Feline Queen
(14271, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Feline Queen
(14272, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Feline Queen
(14273, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Feline Queen
(14274, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Feline Queen
(14275, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Feline Queen
(14276, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Feline Queen
(14277, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Feline Queen
(14278, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Feline Queen
(14279, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Feline Queen
(14280, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Feline Queen
(14281, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Feline Queen
(14282, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Feline Queen
(14283, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Feline Queen
(14284, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Feline Queen
(14285, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Feline Queen
(14286, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Feline Queen
(14287, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Feline Queen
(14288, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Feline Queen
(14289, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Feline Queen
(14290, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Feline Queen
(14291, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Feline Queen
(14292, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Feline Queen
(14293, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Feline Queen
(14294, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Feline Queen
(14295, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Boxer the Unicorn
(14296, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Boxer the Unicorn
(14297, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Boxer the Unicorn
(14298, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Boxer the Unicorn
(14299, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Boxer the Unicorn
(14300, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Boxer the Unicorn
(14301, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Boxer the Unicorn
(14302, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Boxer the Unicorn
(14303, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Boxer the Unicorn
(14304, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Boxer the Unicorn
(14305, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Boxer the Unicorn
(14306, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Boxer the Unicorn
(14307, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Boxer the Unicorn
(14308, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Boxer the Unicorn
(14309, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Boxer the Unicorn
(14310, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Boxer the Unicorn
(14311, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Boxer the Unicorn
(14312, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Boxer the Unicorn
(14313, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Boxer the Unicorn
(14314, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Boxer the Unicorn
(14315, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Boxer the Unicorn
(14316, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Boxer the Unicorn
(14317, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Boxer the Unicorn
(14318, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Boxer the Unicorn
(14319, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Boxer the Unicorn
(14320, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Boxer the Unicorn
(14321, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Boxer the Unicorn
(14322, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Boxer the Unicorn
(14323, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Boxer the Unicorn
(14324, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Boxer the Unicorn
(14325, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Boxer the Unicorn
(14326, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Boxer the Unicorn
(14327, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Boxer the Unicorn
(14328, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Boxer the Unicorn
(14329, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Boxer the Unicorn
(14330, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Boxer the Unicorn
(14331, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Boxer the Unicorn
(14332, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Boxer the Unicorn
(14333, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Boxer the Unicorn
(14334, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Boxer the Unicorn
(14335, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Boxer the Unicorn
(14336, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Boxer the Unicorn
(14337, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Boxer the Unicorn
(14338, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Boxer the Unicorn
(14339, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Boxer the Unicorn
(14340, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Boxer the Unicorn
(14341, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Boxer the Unicorn
(14342, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Boxer the Unicorn
(14343, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mirage the Unicorn
(14344, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mirage the Unicorn
(14345, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mirage the Unicorn
(14346, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mirage the Unicorn
(14347, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mirage the Unicorn
(14348, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mirage the Unicorn
(14349, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mirage the Unicorn
(14350, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mirage the Unicorn
(14351, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mirage the Unicorn
(14352, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mirage the Unicorn
(14353, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mirage the Unicorn
(14354, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mirage the Unicorn
(14355, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mirage the Unicorn
(14356, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mirage the Unicorn
(14357, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mirage the Unicorn
(14358, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mirage the Unicorn
(14359, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mirage the Unicorn
(14360, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mirage the Unicorn
(14361, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mirage the Unicorn
(14362, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mirage the Unicorn
(14363, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mirage the Unicorn
(14364, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mirage the Unicorn
(14365, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mirage the Unicorn
(14366, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mirage the Unicorn
(14367, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mirage the Unicorn
(14368, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mirage the Unicorn
(14369, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Mirage the Unicorn
(14370, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Mirage the Unicorn
(14371, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Mirage the Unicorn
(14372, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Mirage the Unicorn
(14373, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Mirage the Unicorn
(14374, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Mirage the Unicorn
(14375, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Mirage the Unicorn
(14376, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Mirage the Unicorn
(14377, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Mirage the Unicorn
(14378, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Mirage the Unicorn
(14379, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Mirage the Unicorn
(14380, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Mirage the Unicorn
(14381, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Mirage the Unicorn
(14382, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Mirage the Unicorn
(14383, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Mirage the Unicorn
(14384, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Mirage the Unicorn
(14385, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Mirage the Unicorn
(14386, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Mirage the Unicorn
(14387, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Mirage the Unicorn
(14388, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Mirage the Unicorn
(14389, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Mirage the Unicorn
(14390, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Mirage the Unicorn
(14391, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Merrow the Unicorn
(14392, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Merrow the Unicorn
(14393, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Merrow the Unicorn
(14394, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Merrow the Unicorn
(14395, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Merrow the Unicorn
(14396, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Merrow the Unicorn
(14397, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Merrow the Unicorn
(14398, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Merrow the Unicorn
(14399, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Merrow the Unicorn
(14400, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Merrow the Unicorn
(14401, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Merrow the Unicorn
(14402, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Merrow the Unicorn
(14403, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Merrow the Unicorn
(14404, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Merrow the Unicorn
(14405, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Merrow the Unicorn
(14406, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Merrow the Unicorn
(14407, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Merrow the Unicorn
(14408, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Merrow the Unicorn
(14409, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Merrow the Unicorn
(14410, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Merrow the Unicorn
(14411, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Merrow the Unicorn
(14412, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Merrow the Unicorn
(14413, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Merrow the Unicorn
(14414, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Merrow the Unicorn
(14415, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Merrow the Unicorn
(14416, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Merrow the Unicorn
(14417, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Merrow the Unicorn
(14418, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Merrow the Unicorn
(14419, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Merrow the Unicorn
(14420, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Merrow the Unicorn
(14421, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Merrow the Unicorn
(14422, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Merrow the Unicorn
(14423, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Merrow the Unicorn
(14424, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Merrow the Unicorn
(14425, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Merrow the Unicorn
(14426, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Merrow the Unicorn
(14427, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Merrow the Unicorn
(14428, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Merrow the Unicorn
(14429, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Merrow the Unicorn
(14430, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Merrow the Unicorn
(14431, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Merrow the Unicorn
(14432, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Merrow the Unicorn
(14433, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Merrow the Unicorn
(14434, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Merrow the Unicorn
(14435, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Unicorn Seraphim
(14436, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Unicorn Seraphim
(14437, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Unicorn Seraphim
(14438, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Unicorn Seraphim
(14439, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Unicorn Seraphim
(14440, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Unicorn Seraphim
(14441, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Unicorn Seraphim
(14442, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Unicorn Seraphim
(14443, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Unicorn Seraphim
(14444, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Unicorn Seraphim
(14449, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Unicorn Seraphim
(14450, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Unicorn Seraphim
(14451, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Unicorn Seraphim
(14452, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Unicorn Seraphim
(14453, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Unicorn Seraphim
(14454, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Unicorn Seraphim
(14455, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Unicorn Seraphim
(14456, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Unicorn Seraphim
(14457, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Unicorn Seraphim
(14458, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Unicorn Seraphim
(14459, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Unicorn Seraphim
(14460, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Unicorn Seraphim
(14461, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Unicorn Seraphim
(14462, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Unicorn Seraphim
(14463, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Unicorn Seraphim
(14464, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Unicorn Seraphim
(14465, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Unicorn Seraphim
(14466, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Unicorn Seraphim
(14467, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Unicorn Seraphim
(14468, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Unicorn Seraphim
(14469, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Unicorn Seraphim
(14470, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Unicorn Seraphim
(14471, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Unicorn Seraphim
(14472, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Unicorn Seraphim
(14473, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Unicorn Seraphim
(14474, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Unicorn Seraphim
(14475, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Unicorn Seraphim
(14476, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Unicorn Seraphim
(14477, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Unicorn Seraphim
(14478, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Unicorn Seraphim
(14479, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Shadow
(14480, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Shadow
(14481, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Shadow
(14482, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Shadow
(14483, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Shadow
(14484, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Shadow
(14485, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Shadow
(14486, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Shadow
(14487, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Shadow
(14488, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Shadow
(14489, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Shadow
(14490, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Shadow
(14491, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Shadow
(14492, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Shadow
(14493, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Shadow
(14494, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Shadow
(14495, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Shadow
(14496, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Shadow
(14497, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Shadow
(14498, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Shadow
(14499, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Shadow
(14500, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Shadow
(14501, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Shadow
(14502, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Shadow
(14503, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Shadow
(14504, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Shadow
(14505, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Shadow
(14506, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Shadow
(14507, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Shadow
(14508, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Shadow
(14509, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Shadow
(14510, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Shadow
(14511, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Shadow
(14512, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Shadow
(14513, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Shadow
(14514, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Shadow
(14515, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Shadow
(14516, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Shadow
(14517, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Shadow
(14518, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Shadow
(14519, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Shadow
(14520, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Shadow
(14521, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Shadow
(14522, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Shadow
(14523, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Shadow
(14524, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Shadow
(14525, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Shadow
(14526, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Shadow
(14527, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Silhouette
(14528, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Silhouette
(14529, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Silhouette
(14530, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Silhouette
(14531, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Silhouette
(14532, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Silhouette
(14533, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Silhouette
(14534, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Silhouette
(14535, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Silhouette
(14536, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Silhouette
(14537, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Silhouette
(14538, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Silhouette
(14539, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Silhouette
(14540, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Silhouette
(14541, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Silhouette
(14542, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Silhouette
(14543, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Silhouette
(14544, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Silhouette
(14545, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Silhouette
(14546, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Silhouette
(14547, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Silhouette
(14548, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Silhouette
(14549, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Silhouette
(14550, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Silhouette
(14551, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Silhouette
(14552, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Silhouette
(14553, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Silhouette
(14554, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Silhouette
(14555, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Silhouette
(14556, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Silhouette
(14557, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Silhouette
(14558, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Silhouette
(14559, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Silhouette
(14560, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Silhouette
(14561, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Silhouette
(14562, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Silhouette
(14563, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Silhouette
(14564, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Silhouette
(14565, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Silhouette
(14566, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Silhouette
(14567, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Silhouette
(14568, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Silhouette
(14569, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Silhouette
(14570, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Silhouette
(14571, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Silhouette
(14572, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Silhouette
(14573, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Silhouette
(14574, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Silhouette
(14575, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Soulless
(14576, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Soulless
(14577, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Soulless
(14578, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Soulless
(14579, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Soulless
(14580, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Soulless
(14581, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Soulless
(14582, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Soulless
(14583, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Soulless
(14584, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Soulless
(14585, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Soulless
(14586, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Soulless
(14587, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Soulless
(14588, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Soulless
(14589, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Soulless
(14590, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Soulless
(14591, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Soulless
(14592, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Soulless
(14593, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Soulless
(14594, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Soulless
(14595, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Soulless
(14596, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Soulless
(14597, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Soulless
(14598, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Soulless
(14599, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Soulless
(14600, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Soulless
(14601, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Soulless
(14602, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Soulless
(14603, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Soulless
(14604, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Soulless
(14605, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Soulless
(14606, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Soulless
(14607, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Soulless
(14608, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Soulless
(14609, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Soulless
(14610, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Soulless
(14611, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Soulless
(14612, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Soulless
(14613, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Soulless
(14614, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Soulless
(14615, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Soulless
(14616, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Soulless
(14617, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Soulless
(14618, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Soulless
(14619, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Nightshade
(14620, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Nightshade
(14621, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Nightshade
(14622, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Nightshade
(14623, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Nightshade
(14624, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Nightshade
(14625, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Nightshade
(14626, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Nightshade
(14627, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Nightshade
(14628, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Nightshade
(14633, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Nightshade
(14634, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Nightshade
(14635, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Nightshade
(14636, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Nightshade
(14637, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Nightshade
(14638, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Nightshade
(14639, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Nightshade
(14640, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Nightshade
(14641, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Nightshade
(14642, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Nightshade
(14643, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Nightshade
(14644, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Nightshade
(14645, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Nightshade
(14646, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Nightshade
(14647, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Nightshade
(14648, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Nightshade
(14649, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Nightshade
(14650, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Nightshade
(14651, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Nightshade
(14652, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Nightshade
(14653, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Nightshade
(14654, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Nightshade
(14655, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Nightshade
(14656, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Nightshade
(14657, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Nightshade
(14658, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Nightshade
(14659, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Nightshade
(14660, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Nightshade
(14661, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Nightshade
(14662, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Nightshade
(14663, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mechanic Golem
(14664, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mechanic Golem
(14665, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mechanic Golem
(14666, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mechanic Golem
(14667, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mechanic Golem
(14668, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mechanic Golem
(14669, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mechanic Golem
(14670, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mechanic Golem
(14671, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mechanic Golem
(14672, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mechanic Golem
(14673, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mechanic Golem
(14674, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mechanic Golem
(14675, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mechanic Golem
(14676, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mechanic Golem
(14677, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mechanic Golem
(14678, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mechanic Golem
(14679, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mechanic Golem
(14680, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mechanic Golem
(14681, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mechanic Golem
(14682, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mechanic Golem
(14683, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mechanic Golem
(14684, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mechanic Golem
(14685, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mechanic Golem
(14686, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mechanic Golem
(14687, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mechanic Golem
(14688, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mechanic Golem
(14689, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mechanic Golem
(14690, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mechanic Golem
(14691, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mechanic Golem
(14692, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mechanic Golem
(14693, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mechanic Golem
(14694, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mechanic Golem
(14695, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mechanic Golem
(14696, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mechanic Golem
(14697, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mechanic Golem
(14698, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mechanic Golem
(14699, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mechanic Golem
(14700, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mechanic Golem
(14701, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mechanic Golem
(14702, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 99, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Big Boom
(14703, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 99, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Big Boom
(14704, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 99, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Big Boom
(14705, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 99, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Big Boom
(14706, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 99, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Big Boom
(14707, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 99, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Big Boom
(14708, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 99, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Big Boom
(14709, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 99, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Big Boom
(14710, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 99, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Big Boom
(14711, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 99, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Big Boom
(14712, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 99, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Big Boom
(14713, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 99, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Big Boom
(14714, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 99, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Big Boom
(14715, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 99, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Big Boom
(14716, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 99, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Big Boom
(14717, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 99, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Big Boom
(14718, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 99, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Big Boom
(14719, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 99, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Big Boom
(14720, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 99, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Big Boom
(14721, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 99, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Big Boom
(14722, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 99, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Big Boom
(14723, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 99, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Big Boom
(14724, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 99, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Big Boom
(14725, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 99, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Big Boom
(14726, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 99, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Big Boom
(14727, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 99, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Big Boom
(14728, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 99, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Big Boom
(14729, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 99, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Big Boom
(14730, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 99, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Big Boom
(14731, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 99, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Big Boom
(14732, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 99, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Big Boom
(14733, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 99, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Big Boom
(14734, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 99, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Big Boom
(14735, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 99, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Big Boom
(14736, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 99, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Big Boom
(14737, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 30, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Siege Golem
(14738, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 30, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Siege Golem
(14739, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 30, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Siege Golem
(14740, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 30, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Siege Golem
(14741, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 30, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Siege Golem
(14742, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 30, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Siege Golem
(14743, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 30, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Siege Golem
(14744, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 30, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Siege Golem
(14745, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 30, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Siege Golem
(14746, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 30, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Siege Golem
(14747, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 30, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Siege Golem
(14748, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 30, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Siege Golem
(14749, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 30, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Siege Golem
(14750, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 30, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Siege Golem
(14751, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 30, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Siege Golem
(14752, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 30, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Siege Golem
(14753, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 30, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Siege Golem
(14754, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 30, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Siege Golem
(14755, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 30, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Siege Golem
(14756, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 30, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Siege Golem
(14757, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 30, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Siege Golem
(14758, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 30, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Siege Golem
(14759, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 30, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Siege Golem
(14760, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 30, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Siege Golem
(14761, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 30, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Siege Golem
(14762, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 30, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Siege Golem
(14763, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 30, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Siege Golem
(14764, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 30, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Siege Golem
(14765, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 30, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Siege Golem
(14766, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 30, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Siege Golem
(14767, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 30, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Siege Golem
(14768, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 100, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Wild Hog Cannon
(14769, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 100, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Wild Hog Cannon
(14770, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 100, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Wild Hog Cannon
(14771, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 100, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Wild Hog Cannon
(14772, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 100, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Wild Hog Cannon
(14773, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 100, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Wild Hog Cannon
(14774, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 100, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Wild Hog Cannon
(14775, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 100, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Wild Hog Cannon
(14776, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 100, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Wild Hog Cannon
(14777, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 100, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Wild Hog Cannon
(14778, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 100, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Wild Hog Cannon
(14779, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 100, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Wild Hog Cannon
(14780, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 100, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Wild Hog Cannon
(14781, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 100, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Wild Hog Cannon
(14782, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 100, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Wild Hog Cannon
(14783, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 100, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Wild Hog Cannon
(14784, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 100, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Wild Hog Cannon
(14785, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 100, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Wild Hog Cannon
(14786, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 100, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Wild Hog Cannon
(14787, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 100, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Wild Hog Cannon
(14788, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 100, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Wild Hog Cannon
(14789, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 100, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Wild Hog Cannon
(14790, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 100, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Wild Hog Cannon
(14791, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 100, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Wild Hog Cannon
(14792, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 100, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Wild Hog Cannon
(14793, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 100, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Wild Hog Cannon
(14794, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 100, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Wild Hog Cannon
(14795, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 100, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Wild Hog Cannon
(14796, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 100, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Wild Hog Cannon
(14797, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 100, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Wild Hog Cannon
(14798, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 100, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Wild Hog Cannon
(14799, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Dark Panther
(14800, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3, 1, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Dark Panther
(14801, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Dark Panther
(14802, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Dark Panther
(14803, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Dark Panther
(14804, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Dark Panther
(14805, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Dark Panther
(14806, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Dark Panther
(14807, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Dark Panther
(14808, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Dark Panther
(14809, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Dark Panther
(14810, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Dark Panther
(14811, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Dark Panther
(14812, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Dark Panther
(14813, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Dark Panther
(14814, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Dark Panther
(14815, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Dark Panther
(14816, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Dark Panther
(14817, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Dark Panther
(14818, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Dark Panther
(14819, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Dark Panther
(14820, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Dark Panther
(14821, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Dark Panther
(14822, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Dark Panther
(14823, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Dark Panther
(14824, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Dark Panther
(14825, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Dark Panther
(14826, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Dark Panther
(14827, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Dark Panther
(14828, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Dark Panther
(14829, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Dark Panther
(14830, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Dark Panther
(14831, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Dark Panther
(14832, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Dark Panther
(14833, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Dark Panther
(14834, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Dark Panther
(14835, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 5, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Dark Panther
(14836, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Feline King
(14837, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Magnus the Unicorn
(14838, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Spectral Lord
(14839, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Swoop Cannon
(14840, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Swoop Cannon
(14841, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Swoop Cannon
(14842, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Swoop Cannon
(14843, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Swoop Cannon
(14844, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Swoop Cannon
(14845, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Swoop Cannon
(14846, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Swoop Cannon
(14847, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Swoop Cannon
(14848, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Swoop Cannon
(14849, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Swoop Cannon
(14850, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Swoop Cannon
(14851, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Swoop Cannon
(14852, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Swoop Cannon
(14853, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Swoop Cannon
(14854, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Swoop Cannon
(14855, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Swoop Cannon
(14856, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Swoop Cannon
(14857, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Swoop Cannon
(14858, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Swoop Cannon
(14859, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Swoop Cannon
(14860, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Swoop Cannon
(14861, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Swoop Cannon
(14862, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Swoop Cannon
(14863, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Swoop Cannon
(14864, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Swoop Cannon
(14865, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Swoop Cannon
(14866, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Swoop Cannon
(14867, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Swoop Cannon
(14868, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Swoop Cannon
(14869, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Swoop Cannon
(14870, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Divine Beast
(14871, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Feline King
(14872, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Feline King
(14873, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Feline King
(14874, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Feline King
(14875, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Feline King
(14876, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Feline King
(14877, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Feline King
(14878, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Feline King
(14879, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Feline King
(14880, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Feline King
(14881, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Feline King
(14882, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Feline King
(14883, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Feline King
(14884, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Feline King
(14885, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Feline King
(14886, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Magnus the Unicorn
(14887, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Magnus the Unicorn
(14888, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Magnus the Unicorn
(14889, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Magnus the Unicorn
(14890, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Magnus the Unicorn
(14891, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Magnus the Unicorn
(14892, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Magnus the Unicorn
(14893, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Magnus the Unicorn
(14894, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Magnus the Unicorn
(14895, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Magnus the Unicorn
(14896, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Magnus the Unicorn
(14897, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Magnus the Unicorn
(14898, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Magnus the Unicorn
(14899, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Magnus the Unicorn
(14900, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Magnus the Unicorn
(14901, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Spectral Lord
(14902, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Spectral Lord
(14903, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Spectral Lord
(14904, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Spectral Lord
(14905, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Spectral Lord
(14906, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Spectral Lord
(14907, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Spectral Lord
(14908, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Spectral Lord
(14909, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Spectral Lord
(14910, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Spectral Lord
(14911, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Spectral Lord
(14912, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Spectral Lord
(14913, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Spectral Lord
(14914, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Spectral Lord
(14915, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Spectral Lord
(14916, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Tigress
(14917, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 4, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Tigress
(14918, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Imperial Phoenix
(16013, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "pet_clan;nonpet_clan", 400, "null", 0, 0, "fighter"), -- Trained Buffalo
(16014, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "pet_clan;nonpet_clan", 400, "null", 0, 0, "fighter"), -- Trained Buffalo
(16015, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "pet_clan;nonpet_clan", 400, "null", 0, 0, "fighter"), -- Trained Cougar
(16016, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "pet_clan;nonpet_clan", 400, "null", 0, 0, "fighter"), -- Trained Cougar
(16017, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "pet_clan;nonpet_clan", 400, "null", 0, 0, "fighter"), -- Trained Kookaburra
(16018, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "pet_clan;nonpet_clan", 400, "null", 0, 0, "fighter"), -- Trained Kookaburra
(16019, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "pet_clan;nonpet_clan", 400, "null", 0, 0, "balanced"), -- Tiny Baby Buffalo
(16020, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "pet_clan;nonpet_clan", 400, "null", 0, 0, "balanced"), -- Trained Tiny Baby Buffalo
(16021, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "pet_clan;nonpet_clan", 400, "null", 0, 0, "balanced"), -- Tiny Baby Cougar
(16022, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "pet_clan;nonpet_clan", 400, "null", 0, 0, "balanced"), -- Trained Tiny Baby Cougar
(16023, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "pet_clan;nonpet_clan", 400, "null", 0, 0, "balanced"), -- Tiny Baby Kookaburra
(16024, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "pet_clan;nonpet_clan", 400, "null", 0, 0, "balanced"), -- Trained Tiny Baby Kookaburra
(16025, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Great Wolf
(16026, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Beastly Agathion
(16027, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Rainbow Agathion
(16028, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Lord Agathion
(16029, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Fortress Agasion
(16030, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Great Wolf
(16031, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Little Angel Agathion
(16032, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Little Devil Agathion
(16033, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Rudolph Agathion
(16034, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Improved Baby Buffalo
(16035, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Improved Baby Kookaburra
(16036, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Improved Baby Cougar
(16037, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Great Snow Wolf
(16038, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Red Wind Strider
(16039, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Red Star Strider
(16040, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Red Twilight Strider
(16041, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Fenrir
(16042, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Snow Fenrir
(16043, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Fox Shaman
(16044, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Wild Beast Fighter
(16045, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- White Weasel
(16046, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Fairy Princess
(16049, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Love Agathion
(16050, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Owl Monk
(16051, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Spirit Shaman
(16052, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Toy Knight
(16053, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Turtle Ascetic
(16054, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Monkey
(16055, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Griffon
(16056, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Joy
(16057, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Sorrow
(16058, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Anger
(16059, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Boy Bear
(16060, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Girl Bear
(16061, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Collection Device
(16062, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Knight
(16063, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Neolithica
(16064, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Juju
(16065, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Oink Oink
(16066, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Light of Dawn
(16067, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Deinonychus
(16068, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Guardian's Strider
(16069, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Pona
(16070, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Towbat
(16071, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Maguen
(16072, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Elite Maguen
(16073, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Rudolph Agathion
(16074, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Ball Trapping Gnosian
(16075, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Ball Trapping Orodriel
(16076, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Penalty Kick
(16077, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Antharas
(16078, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Nevit's Messenger Kanna
(16079, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Guardian of Dawn Kallesin
(18001, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "cave_servant_clan", 400, "null", 0, 0, "fighter"), -- Blood Queen
(18002, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "cave_servant_clan", 300, "null", 0, 0, "fighter"), -- Blood Queen
(18003, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Bearded Keltir
(18004, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Susceptor Prime
(18005, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mimic
(18006, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "malruk_clan", 300, "null", 0, 0, "fighter"), -- Maluk Lord
(18007, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "malruk_clan", 300, "null", 0, 0, "fighter"), -- Limal Karinness
(18008, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Karik
(18009, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "door_clan;mercenary_siege_clan", 500, "null", 0, 0, "fighter"), -- Offering of the Branded, Elder
(18010, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Offering of the Branded
(18011, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 15, "archer"), -- Offering of the Branded, Archer
(18012, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Offering of the Branded, Warrior
(18013, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "balanced"), -- Offering of the Branded, Follower
(18014, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Offering of the Branded, Berserker
(18015, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Offering of the Branded, Zealot
(18016, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 15, "archer"), -- Offering of the Branded, Marksman
(18017, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Offering of the Branded, Disciple
(18018, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Offering of the Branded, Saint
(18019, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Apostate's Offering, Elder
(18020, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Apostate's Offering
(18021, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 15, "archer"), -- Apostate's Offering, Archer
(18022, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Apostate's Offering, Warrior
(18023, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "balanced"), -- Apostate's Offering, Follower
(18024, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Apostate's Offering, Berserker
(18025, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Apostate's Offering, Zealot
(18026, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 15, "archer"), -- Apostate's Offering, Marksman
(18027, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Apostate's Offering, Disciple
(18028, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Apostate's Offering, Saint
(18029, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Witch's Offering, Elder
(18030, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Witch's Offering
(18031, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 15, "archer"), -- Witch's Offering, Archer
(18032, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Witch's Offering, Warrior
(18033, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "balanced"), -- Witch's Offering, Follower
(18034, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Witch's Offering, Berserker
(18035, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Witch's Offering, Zealot
(18036, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 15, "archer"), -- Witch's Offering, Marksman
(18037, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Witch's Offering, Disciple
(18038, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Witch's Offering, Saint
(18039, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Dark Omen Offering Elder
(18040, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "balanced"), -- Dark Omen Offering
(18041, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 15, "archer"), -- Dark Omen Offering Archer
(18042, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Dark Omen Offering Warrior
(18043, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "balanced"), -- Dark Omen Offering Follower
(18044, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Dark Omen Offering Berserker
(18045, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "balanced"), -- Dark Omen Offering Zealot
(18046, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 15, "archer"), -- Dark Omen Offering Marksman
(18047, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Dark Omen Offering Disciple
(18048, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Dark Omen Offering Saint
(18049, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Offering of Forbidden Path, Elder
(18050, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "balanced"), -- Offering of Forbidden Path
(18051, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 15, "archer"), -- Offering of Forbidden Path, Archer
(18052, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Offering of Forbidden Path, Warrior
(18053, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "balanced"), -- Offering of Forbidden Path, Follower
(18054, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Offering of Forbidden Path, Berserker
(18055, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "balanced"), -- Offering of Forbidden Path, Zealot
(18056, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 15, "archer"), -- Offering of Forbidden Path, Marksman
(18057, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Offering of Forbidden Path, Disciple
(18058, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Offering of Forbidden Path, Saint
(18059, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Offering of the Branded, Elder
(18060, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Offering of the Branded
(18061, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 15, "archer"), -- Offering of the Branded, Archer
(18062, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Offering of the Branded, Warrior
(18063, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "balanced"), -- Offering of the Branded, Follower
(18064, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Offering of the Branded, Berserker
(18065, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Offering of the Branded, Zealot
(18066, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 15, "archer"), -- Offering of the Branded, Marksman
(18067, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Offering of the Branded, Disciple
(18068, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Offering of the Branded, Saint
(18069, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Apostate's Offering, Elder
(18070, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Apostate's Offering
(18071, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 15, "archer"), -- Apostate's Offering, Archer
(18072, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Apostate's Offering, Warrior
(18073, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "balanced"), -- Apostate's Offering, Follower
(18074, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Apostate's Offering, Berserker
(18075, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Apostate's Offering, Zealot
(18076, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 15, "archer"), -- Apostate's Offering, Marksman
(18077, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Apostate's Offering, Disciple
(18078, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Apostate's Offering, Saint
(18079, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Witch's Offering, Elder
(18080, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Witch's Offering,
(18081, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 15, "archer"), -- Witch's Offering, Archer
(18082, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Witch's Offering, Warrior
(18083, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "balanced"), -- Witch's Offering, Follower
(18084, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Witch's Offering, Berserker
(18085, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Witch's Offering, Zealot
(18086, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 15, "archer"), -- Witch's Offering, Marksman
(18087, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Witch's Offering, Disciple
(18088, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Witch's Offering, Saint
(18089, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Dark Omen Offering Elder
(18090, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "balanced"), -- Dark Omen Offering
(18091, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 15, "archer"), -- Dark Omen Offering Archer
(18092, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Dark Omen Offering Warrior
(18093, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "balanced"), -- Dark Omen Offering Follower
(18094, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Dark Omen Offering Berserker
(18095, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "balanced"), -- Dark Omen Offering Zealot
(18096, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 15, "archer"), -- Dark Omen Offering Marksman
(18097, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Dark Omen Offering Disciple
(18098, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Dark Omen Offering Saint
(18099, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Offering of Forbidden Path, Elder
(18100, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "balanced"), -- Offering of Forbidden Path
(18101, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 15, "archer"), -- Offering of Forbidden Path, Archer
(18102, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Offering of Forbidden Path, Warrior
(18103, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "balanced"), -- Offering of Forbidden Path, Follower
(18104, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Offering of Forbidden Path, Berserker
(18105, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "balanced"), -- Offering of Forbidden Path, Zealot
(18106, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 15, "archer"), -- Offering of Forbidden Path, Marksman
(18107, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Offering of Forbidden Path, Disciple
(18108, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Offering of Forbidden Path, Saint
(18109, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 200, "null", 0, 0, "fighter"), -- Treasures of the Festival
(18110, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 200, "null", 0, 0, "fighter"), -- Treasures of the Festival
(18111, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 200, "null", 0, 0, "fighter"), -- Treasures of the Festival
(18112, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 200, "null", 0, 0, "fighter"), -- Treasures of the Festival
(18113, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 200, "null", 0, 0, "fighter"), -- Treasures of the Festival
(18114, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 200, "null", 0, 0, "fighter"), -- Treasures of the Festival
(18115, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 200, "null", 0, 0, "fighter"), -- Treasures of the Festival
(18116, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 200, "null", 0, 0, "fighter"), -- Treasures of the Festival
(18117, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 200, "null", 0, 0, "fighter"), -- Treasures of the Festival
(18118, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 200, "null", 0, 0, "fighter"), -- Treasures of the Festival
(18119, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Corpse of Deadman
(18120, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb1_clan", 600, "null", 0, 0, "balanced"), -- Halisha's Officer
(18121, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb1_clan", 600, "null", 0, 0, "fighter"), -- Halisha's Officer
(18122, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb1_clan", 600, "null", 0, 0, "fighter"), -- Halisha's Officer
(18123, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb1_clan", 600, "null", 0, 0, "balanced"), -- Halisha's Officer
(18124, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb1_clan", 600, "null", 0, 0, "fighter"), -- Halisha's Officer
(18125, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb1_clan", 600, "null", 0, 0, "fighter"), -- Halisha's Officer
(18126, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb1_clan", 600, "null", 0, 0, "balanced"), -- Halisha's Officer
(18127, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb1_clan", 600, "null", 0, 0, "fighter"), -- Halisha's Officer
(18128, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb1_clan", 600, "null", 0, 0, "fighter"), -- Halisha's Officer
(18129, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb1_clan", 600, "null", 0, 0, "balanced"), -- Halisha's Officer
(18130, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb1_clan", 600, "null", 0, 0, "fighter"), -- Halisha's Officer
(18131, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb1_clan", 600, "null", 0, 0, "fighter"), -- Halisha's Officer
(18132, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb1_clan", 600, "null", 0, 0, "fighter"), -- Imperial Healer
(18133, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb1_clan", 600, "null", 0, 0, "balanced"), -- Imperial Mosaic
(18134, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb1_clan", 600, "null", 0, 0, "balanced"), -- Imperial Mosaic
(18135, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb1_clan", 600, "null", 0, 0, "balanced"), -- Imperial Mosaic
(18136, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb1_clan", 600, "null", 0, 0, "balanced"), -- Imperial Mosaic
(18137, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb1_clan", 600, "null", 0, 0, "fighter"), -- Imperial Mosaic
(18138, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb1_clan", 600, "null", 0, 0, "fighter"), -- Imperial Mosaic
(18139, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb1_clan", 600, "null", 0, 0, "fighter"), -- Imperial Mosaic
(18140, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb1_clan", 600, "null", 0, 0, "fighter"), -- Imperial Mosaic
(18141, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb2_clan", 600, "null", 0, 0, "balanced"), -- Beetle of Grave
(18142, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb2_clan", 600, "null", 0, 0, "balanced"), -- Beetle of Grave
(18143, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb2_clan", 600, "null", 0, 0, "balanced"), -- Beetle of Grave
(18144, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb2_clan", 600, "null", 0, 0, "balanced"), -- Beetle of Grave
(18145, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb2_clan", 600, "null", 0, 0, "balanced"), -- Beetle of Grave
(18146, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb2_clan", 600, "null", 0, 0, "balanced"), -- Beetle of Grave
(18147, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb2_clan", 600, "null", 0, 0, "balanced"), -- Beetle of Grave
(18148, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb2_clan", 600, "null", 0, 0, "balanced"), -- Beetle of Grave
(18149, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb2_clan", 600, "null", 0, 0, "balanced"), -- Beetle of Grave
(18150, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb3_clan", 600, "null", 0, 0, "fighter"), -- Victim
(18151, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb3_clan", 600, "null", 0, 0, "fighter"), -- Victim
(18152, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb3_clan", 600, "null", 0, 0, "fighter"), -- Victim
(18153, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb3_clan", 600, "null", 0, 0, "fighter"), -- Victim
(18154, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb3_clan", 600, "null", 0, 0, "fighter"), -- Victim
(18155, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb3_clan", 600, "null", 0, 0, "fighter"), -- Victim
(18156, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb3_clan", 600, "null", 0, 0, "fighter"), -- Victim
(18157, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb3_clan", 600, "null", 0, 0, "fighter"), -- Victim
(18158, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb3_clan", 600, "null", 0, 0, "balanced"), -- Executioner of Halisha
(18159, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb3_clan", 600, "null", 0, 0, "balanced"), -- Executioner of Halisha
(18160, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb3_clan", 600, "null", 0, 0, "balanced"), -- Executioner of Halisha
(18161, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb3_clan", 600, "null", 0, 0, "balanced"), -- Executioner of Halisha
(18162, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb3_clan", 600, "null", 0, 0, "balanced"), -- Executioner of Halisha
(18163, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb3_clan", 600, "null", 0, 0, "balanced"), -- Executioner of Halisha
(18164, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb3_clan", 600, "null", 0, 0, "balanced"), -- Executioner of Halisha
(18165, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb3_clan", 600, "null", 0, 0, "balanced"), -- Executioner of Halisha
(18166, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb3_clan", 600, "null", 0, 0, "balanced"), -- Imperial Guard
(18167, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb3_clan", 600, "null", 0, 0, "fighter"), -- Imperial Guard
(18168, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb3_clan", 600, "null", 0, 0, "fighter"), -- Imperial Guard
(18169, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb3_clan", 600, "null", 0, 0, "fighter"), -- Imperial Guard
(18170, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb3_clan", 600, "null", 0, 0, "balanced"), -- Imperial Guard
(18171, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb3_clan", 600, "null", 0, 0, "fighter"), -- Imperial Guard
(18172, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb3_clan", 600, "null", 0, 0, "balanced"), -- Imperial Guard
(18173, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb4_clan", 600, "null", 0, 0, "balanced"), -- Halisha's Foreman
(18174, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb4_clan", 600, "null", 0, 0, "balanced"), -- Halisha's Foreman
(18175, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb4_clan", 600, "null", 0, 0, "balanced"), -- Halisha's Foreman
(18176, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb4_clan", 600, "null", 0, 0, "balanced"), -- Halisha's Foreman
(18177, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb4_clan", 600, "null", 0, 0, "balanced"), -- Halisha's Foreman
(18178, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb4_clan", 600, "null", 0, 0, "balanced"), -- Halisha's Foreman
(18179, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb4_clan", 600, "null", 0, 0, "balanced"), -- Halisha's Foreman
(18180, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb4_clan", 600, "null", 0, 0, "balanced"), -- Halisha's Foreman
(18181, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb4_clan", 600, "null", 0, 0, "balanced"), -- Halisha's Foreman
(18182, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb4_clan", 600, "null", 0, 0, "balanced"), -- Halisha's Foreman
(18183, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb4_clan", 600, "null", 0, 0, "balanced"), -- Halisha's Foreman
(18184, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb4_clan", 600, "null", 0, 0, "balanced"), -- Halisha's Foreman
(18185, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb4_clan", 600, "null", 0, 0, "fighter"), -- Evil Astrologer
(18186, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb4_clan", 600, "null", 0, 0, "fighter"), -- Evil Astrologer
(18187, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb4_clan", 600, "null", 0, 0, "balanced"), -- Knight of Darkness
(18188, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb4_clan", 600, "null", 0, 0, "balanced"), -- Knight of Darkness
(18189, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb4_clan", 600, "null", 0, 0, "balanced"), -- Knight of Darkness
(18190, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb4_clan", 600, "null", 0, 0, "balanced"), -- Knight of Darkness
(18191, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb4_clan", 600, "null", 0, 0, "mage"), -- Witch of dust
(18192, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb4_clan", 600, "null", 0, 0, "mage"), -- Witch of dust
(18193, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb4_clan", 600, "null", 0, 0, "mage"), -- Witch of dust
(18194, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb4_clan", 600, "null", 0, 0, "mage"), -- Witch of dust
(18195, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb4_clan", 600, "null", 0, 0, "balanced"), -- Signet of Emperor
(18196, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb4_clan", 600, "null", 0, 0, "fighter"), -- Charm of Corner
(18197, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb4_clan", 600, "null", 0, 0, "fighter"), -- Charm of Corner
(18198, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb4_clan", 600, "null", 0, 0, "fighter"), -- Charm of Corner
(18199, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb4_clan", 600, "null", 0, 0, "fighter"), -- Charm of Corner
(18200, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb4_clan", 600, "null", 0, 0, "fighter"), -- Charm of Corner
(18201, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb4_clan", 600, "null", 0, 0, "fighter"), -- Charm of Corner
(18202, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb4_clan", 600, "null", 0, 0, "fighter"), -- Charm of Corner
(18203, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb4_clan", 600, "null", 0, 0, "fighter"), -- Charm of Corner
(18204, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb4_clan", 600, "null", 0, 0, "fighter"), -- Charm of Corner
(18205, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb4_clan", 600, "null", 0, 0, "fighter"), -- Charm of Corner
(18206, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb4_clan", 600, "null", 0, 0, "fighter"), -- Charm of Corner
(18207, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb4_clan", 600, "null", 0, 0, "fighter"), -- Charm of Corner
(18208, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb4_clan", 600, "null", 0, 0, "fighter"), -- Charm of Corner
(18209, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb4_clan", 600, "null", 0, 0, "fighter"), -- Charm of Corner
(18210, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb4_clan", 600, "null", 0, 0, "fighter"), -- Charm of Corner
(18211, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb4_clan", 600, "null", 0, 0, "fighter"), -- Charm of Corner
(18212, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb5_clan", 600, "null", 0, 0, "fighter"), -- Archon of Halisha
(18213, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb5_clan", 600, "null", 0, 0, "fighter"), -- Archon of Halisha
(18214, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb5_clan", 600, "null", 0, 0, "fighter"), -- Archon of Halisha
(18215, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb5_clan", 600, "null", 0, 0, "fighter"), -- Archon of Halisha
(18216, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb5_clan", 600, "null", 0, 0, "fighter"), -- Archon of Halisha
(18217, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb5_clan", 600, "null", 0, 0, "fighter"), -- Archon of Halisha
(18218, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb5_clan", 600, "null", 0, 0, "fighter"), -- Archon of Halisha
(18219, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb5_clan", 600, "null", 0, 0, "fighter"), -- Archon of Halisha
(18220, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb5_clan", 600, "null", 0, 0, "balanced"), -- Shaman of Darkness
(18221, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb5_clan", 600, "null", 0, 0, "balanced"), -- Shaman of Darkness
(18222, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb5_clan", 600, "null", 0, 0, "balanced"), -- Assassin of Darkness
(18223, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb5_clan", 600, "null", 0, 0, "fighter"), -- Assassin of Darkness
(18224, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb5_clan", 600, "null", 0, 0, "balanced"), -- Assassin of Darkness
(18225, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb5_clan", 600, "null", 0, 0, "fighter"), -- Assassin of Darkness
(18226, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb5_clan", 600, "null", 0, 0, "balanced"), -- Caster of Darkness
(18227, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb5_clan", 600, "null", 0, 0, "fighter"), -- Caster of Darkness
(18228, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb5_clan", 600, "null", 0, 0, "balanced"), -- Caster of Darkness
(18229, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb5_clan", 600, "null", 0, 0, "fighter"), -- Caster of Darkness
(18230, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb5_clan", 600, "null", 0, 0, "balanced"), -- Signet of Emperor
(18231, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 600, "null", 0, 0, "fighter"), -- Statue of Protection
(18232, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 600, "null", 0, 0, "fighter"), -- Statue of Protection
(18233, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 600, "null", 0, 0, "fighter"), -- Statue of Protection
(18234, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 600, "null", 0, 0, "fighter"), -- Statue of Protection
(18235, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 600, "null", 0, 0, "fighter"), -- Statue of Protection
(18236, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 600, "null", 0, 0, "fighter"), -- Statue of Protection
(18237, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 600, "null", 0, 0, "fighter"), -- Statue of Protection
(18238, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 600, "null", 0, 0, "fighter"), -- Statue of Protection
(18239, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 600, "null", 0, 0, "fighter"), -- Statue of Protection
(18240, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 600, "null", 0, 0, "fighter"), -- Statue of Protection
(18241, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 600, "null", 0, 0, "fighter"), -- Statue of Protection
(18242, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 600, "null", 0, 0, "fighter"), -- Statue of Protection
(18243, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 600, "null", 0, 0, "fighter"), -- Statue of Protection
(18244, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb1_clan", 600, "null", 0, 0, "balanced"), -- Watchman of Grave
(18245, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb1_clan", 600, "null", 0, 0, "fighter"), -- Watchman of Grave
(18246, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb1_clan", 600, "null", 0, 0, "fighter"), -- Watchman of Grave
(18247, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb2_clan", 600, "null", 0, 0, "balanced"), -- Watchman of Grave
(18248, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb2_clan", 600, "null", 0, 0, "fighter"), -- Watchman of Grave
(18249, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb2_clan", 600, "null", 0, 0, "fighter"), -- Watchman of Grave
(18250, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb3_clan", 600, "null", 0, 0, "balanced"), -- Watchman of Grave
(18251, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb3_clan", 600, "null", 0, 0, "fighter"), -- Watchman of Grave
(18252, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb3_clan", 600, "null", 0, 0, "fighter"), -- Watchman of Grave
(18253, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb4_clan", 600, "null", 0, 0, "balanced"), -- Watchman of Grave
(18254, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb4_clan", 600, "null", 0, 0, "fighter"), -- Watchman of Grave
(18255, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb4_clan", 600, "null", 0, 0, "fighter"), -- Watchman of Grave
(18256, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Halisha's Treasure Chest
(18257, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Treasure Chest
(18258, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Treasure Chest
(18259, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Treasure Chest
(18260, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Treasure Chest
(18261, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Treasure Chest
(18262, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Treasure Chest
(18263, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Treasure Chest
(18264, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Treasure Chest
(18265, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Treasure Chest
(18266, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Treasure Chest
(18267, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Treasure Chest
(18268, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Treasure Chest
(18269, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Treasure Chest
(18270, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Treasure Chest
(18271, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Treasure Chest
(18272, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Treasure Chest
(18273, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Treasure Chest
(18274, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Treasure Chest
(18275, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Treasure Chest
(18276, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Treasure Chest
(18277, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Treasure Chest
(18278, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Treasure Chest
(18279, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Treasure Chest
(18280, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Treasure Chest
(18281, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Treasure Chest
(18282, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Treasure Chest
(18283, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Treasure Chest
(18284, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Treasure Chest
(18285, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Treasure Chest
(18286, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Treasure Chest
(18287, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Otherworldly Invader Food
(18288, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Otherworldly Invader Food
(18289, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Dimension Invader Food
(18290, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Dimension Invader Food
(18291, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Purgatory Invader Food
(18292, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Purgatory Invader Food
(18293, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Forbidden Path Invader Food
(18294, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Forbidden Path Invader Food
(18295, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Dark Omen Invader Food
(18296, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Dark Omen Invader Food
(18297, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Messenger Invader Food
(18298, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Messenger Invader Food
(18299, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Flame of the Branded
(18300, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Offering of the Branded, Evoked Spirit
(18301, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Flame of Apostates
(18302, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Apostate's Offering, Evoked Spirit
(18303, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Flame of the Witch
(18304, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Witch's Offering, Evoked Spirit
(18305, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Flame of Dark Omen
(18306, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Offering of Dark Omen, Evoked Spirit
(18307, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Flame of Forbidden Path
(18308, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Offering of Forbidden Path, Evoked Spirit
(18309, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Flame of the Branded
(18310, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Offering of the Branded, Evoked Spirit
(18311, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Flame of Apostates
(18312, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Apostate's Offering, Evoked Spirit
(18313, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Flame of the Witch
(18314, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Witch's Offering, Evoked Spirit
(18315, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Flame of Dark Omen
(18316, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Offering of Dark Omen, Evoked Spirit
(18317, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Flame of Forbidden Path
(18318, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Offering of Forbidden Path, Evoked Spirit
(18319, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Caught Frog
(18320, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Caught Undine
(18321, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Caught Rakul
(18322, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Caught Sea Giant
(18323, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Caught Sea Horse Soldier
(18324, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Caught Homunculus
(18325, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Caught Flava
(18326, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Caught Gigantic Eye
(18327, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "ice_clan", 300, "null", 0, 0, "balanced"), -- Freya's Servant
(18328, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "corpse"), -- Hall Alarm Device
(18329, 7, 15, 0, 250, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "hallguard_clan", 4000, "null", 0, 0, "fighter"), -- Hall Keeper Captain
(18330, 7, 15, 0, 250, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "hallguard_clan", 4000, "null", 0, 0, "mage"), -- Hall Keeper Wizard
(18331, 7, 15, 0, 250, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "hallguard_clan", 4000, "null", 0, 0, "fighter"), -- Hall Keeper Guard
(18332, 7, 15, 0, 250, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "hallguard_clan", 4000, "null", 0, 0, "fighter"), -- Hall Keeper Patrol
(18333, 7, 15, 0, 250, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "hallguard_clan", 4000, "null", 0, 0, "fighter"), -- Hall Keeper Suicidal Soldier
(18334, 7, 15, 0, 700, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "darkband_clan", 1500, "null", 0, 0, "balanced"), -- Dark Choir Captain
(18335, 7, 15, 0, 700, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "darkband_clan", 1500, "null", 0, 0, "balanced"), -- Dark Choir Prima Donna
(18336, 7, 15, 0, 700, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "darkband_clan", 1500, "null", 0, 0, "fighter"), -- Dark Choir Lancer
(18337, 7, 15, 0, 700, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "darkband_clan", 500, "null", 0, 15, "archer"), -- Dark Choir Archer
(18338, 7, 15, 0, 700, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "darkband_clan", 500, "null", 0, 0, "balanced"), -- Dark Choir Witch Doctor
(18339, 7, 15, 0, 700, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "darkband_clan", 1500, "null", 0, 0, "balanced"), -- Dark Choir Player
(18340, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "darkband_clan", 1000, "null", 0, 0, "balanced"), -- Hall Keeper Suicidal Soldier
(18341, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "darkband_clan", 1000, "null", 0, 0, "balanced"), -- Hall Keeper Suicidal Soldier
(18342, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gremlin
(18343, 7, 15, 0, 700, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "trioll_clan", 1200, "null", 0, 0, "balanced"), -- Doorman Zombie
(18344, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Ancient Egg
(18345, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "balanced"), -- Sprigant
(18346, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "balanced"), -- Sprigant
(18347, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "ndg_clan", 300, "null", 0, 0, "balanced"), -- Garden Guard
(18348, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "ndg_clan", 300, "null", 0, 0, "balanced"), -- Garden Guard
(18349, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "ndg_clan", 300, "null", 0, 0, "balanced"), -- Garden Guard
(18350, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "ndg_clan", 300, "null", 0, 0, "balanced"), -- Garden Guard
(18351, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "ndg_clan", 300, "null", 0, 0, "balanced"), -- Garden Guard
(18352, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 200, 0, "ndg_clan", 300, "null", 0, 0, "balanced"), -- Kamael Guard
(18353, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 200, 0, "ndg_clan", 300, "null", 0, 0, "balanced"), -- Guardian of Records
(18354, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 200, 0, "ndg_clan", 300, "null", 0, 0, "balanced"), -- Guardian of Observation
(18355, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 200, 0, "ndg_clan", 300, "null", 0, 0, "balanced"), -- Spicula's Guard
(18356, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 200, 0, "ndg_clan", 300, "null", 0, 0, "balanced"), -- Harkilgamed's Gatekeeper
(18357, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 200, 0, "ndg_clan", 300, "null", 0, 0, "balanced"), -- Rodenpicula's Gatekeeper
(18358, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 200, 0, "ndg_clan", 300, "null", 0, 0, "balanced"), -- Guardian of Secrets
(18359, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 200, 0, "ndg_clan", 300, "null", 0, 0, "balanced"), -- Arviterre's Guardian
(18360, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 200, 0, "ndg_clan", 300, "null", 0, 0, "balanced"), -- Katenar's Gatekeeper
(18361, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 200, 0, "ndg_clan", 300, "null", 0, 0, "balanced"), -- Guardian of Prediction
(18362, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "ndg_clan", 300, "null", 0, 0, "balanced"), -- Garden Guard
(18363, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "ndg_clan", 300, "null", 0, 0, "archer"), -- Garden Guard
(18364, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Witch Warder
(18365, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Witch Warder
(18366, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Witch Warder
(18367, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "oracle_clan", 400, "null", 0, 0, "fighter"), -- Prison Guard
(18368, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "oracle_clan", 400, "null", 0, 0, "fighter"), -- Prison Guard
(18369, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "oracle_clan", 500, "null", 0, 0, "balanced"), -- Chromatic Crystalline Golem
(18370, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "oracle_clan", 500, "null", 0, 0, "balanced"), -- Chromatic Crystalline Golem
(18371, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Beleth's Sample
(18372, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Beleth's Sample
(18373, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Beleth's Sample
(18374, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Beleth's Sample
(18375, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Beleth's Sample
(18376, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Beleth's Sample
(18377, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Beleth's Sample
(18378, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Trap
(18379, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18380, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18381, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18382, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18383, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18384, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18385, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18386, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18387, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18388, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18389, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18390, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18391, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18392, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18393, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18394, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18395, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18396, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18397, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18398, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18399, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18400, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18401, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18402, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18403, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18404, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18405, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18406, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18407, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18408, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18409, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18410, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18411, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18412, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18413, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18414, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Warrior's Gatekeeper
(18415, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Midway Gatekeeper
(18416, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Doorman
(18417, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Bridge Keeper
(18418, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Bridge Keeper
(18419, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Bridge Keeper
(18420, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18427, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(18428, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(18429, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(18430, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(18431, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18432, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Trap
(18433, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18434, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18435, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18436, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18437, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(18438, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18441, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Kamael Gatekeeper
(18442, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18443, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18444, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "null", 300, "null", 0, 0, "balanced"), -- Garden Guard
(18445, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Tully's Gatekeeper
(18446, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Tully's Gatekeeper
(18447, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Tully's Gatekeeper
(18448, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Tully's Gatekeeper
(18449, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Tully's Gatekeeper
(18450, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Tully's Gatekeeper
(18451, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Tully's Gatekeeper
(18452, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Tully's Gatekeeper
(18453, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Tully's Gatekeeper
(18454, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Tully's Gatekeeper
(18455, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Tully's Gatekeeper
(18456, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Tully's Gatekeeper
(18457, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Tully's Gatekeeper
(18458, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Tully's Gatekeeper
(18459, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Tully's Gatekeeper
(18460, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Tully's Gatekeeper
(18461, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Tully's Gatekeeper
(18463, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "ruin_clan", 400, "null", 0, 0, "balanced"), -- Remnant Diabolist
(18464, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "ruin_clan", 400, "null", 0, 0, "mage"), -- Remnant Diviner
(18465, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ruin_clan", 600, "null", 0, 0, "mage"), -- Derek
(18466, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "castleout_clan", 1000, "null", 0, 0, "balanced"), -- Outpost Captain
(18467, 7, 15, 0, 450, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "test_clan", 300, "null", 0, 0, "balanced"), -- Wounded Land Guard
(18468, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Doorman
(18469, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "oracle_clan", 500, "null", 0, 0, "balanced"), -- Hall Guard
(18470, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "oracle_clan", 500, "null", 0, 0, "balanced"), -- Hall Guard
(18471, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "oracle_clan", 500, "null", 0, 0, "balanced"), -- Hall Guard
(18472, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "oracle_clan", 500, "null", 0, 0, "balanced"), -- Hall Guard
(18473, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "oracle_clan", 500, "null", 0, 0, "balanced"), -- Hall Captain
(18474, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "oracle_clan", 500, "null", 0, 0, "balanced"), -- Alarm
(18475, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "oracle_clan", 500, "null", 0, 0, "balanced"), -- Hall Guard
(18476, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "oracle_clan", 500, "null", 0, 0, "balanced"), -- Hall Guard
(18477, 7, 15, 0, 450, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "balanced"), -- Coral Treasure Chest
(18478, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ndg_clan", 300, "null", 0, 0, "corpse"), -- Herb Jar
(18479, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Inner Castle Sentry
(18480, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Inner Castle Guard
(18481, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Inner Castle Seer
(18482, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "dark_clan", 500, "null", 0, 0, "balanced"), -- Fafurion Kindred
(18483, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "ndg_clan", 300, "null", 0, 0, "archer"), -- Garden Guard
(18484, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "hell_clan", 800, "null", 0, 0, "balanced"), -- Naia Failan
(18485, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(18486, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(18487, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(18488, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(18489, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(18490, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 1500, "null", 0, 0, "balanced"), -- Beleth's Slave
(18491, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Lock
(18492, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Controller
(18493, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Ward
(18494, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Ingenious Contraption
(18495, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Ingenious Contraption
(18496, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Ingenious Contraption
(18497, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Ingenious Contraption
(18498, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Ingenious Contraption
(18499, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Ingenious Contraption
(18500, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Ingenious Contraption
(18501, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Ingenious Contraption
(18502, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Ingenious Contraption
(18503, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Ingenious Contraption
(18504, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Ingenious Contraption
(18505, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Ingenious Contraption
(18506, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Soul Crystal Pillar
(18507, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(18508, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(18509, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(18510, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(18511, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(18512, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(18513, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(18514, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(18515, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(18516, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(18517, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(18518, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(18519, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(18520, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(18521, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(18522, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(18523, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(18524, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(18525, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(18526, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(18527, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(18528, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(18529, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(18530, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(18531, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"); --

INSERT INTO `npcaidata` VALUES
(18532, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(18533, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(18534, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Kertang's Treasure Chest
(18535, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Kertang's Treasure Chest
(18536, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Kertang's Treasure Chest
(18537, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Kertang's Treasure Chest
(18538, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Kertang's Treasure Chest
(18539, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Resurrection Tower
(18540, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Resurrection Tower
(18541, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Resurrection Tower
(18542, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Resurrection Tower
(18543, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Resurrection Tower
(18544, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Cruma Border
(18545, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Ancient Experiment
(18546, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Ancient Experiment
(18547, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Ancient Experiment
(18548, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Ancient Experiment
(18549, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Ancient Experiment
(18550, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Cruma Phantom
(18551, 7, 15, 0, 1700, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Cruma Phantom
(18552, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Cruma Phantom
(18553, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Cruma Phantom
(18554, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Tomlan Kamos
(18555, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Ol Ariosh
(18556, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Follower of Ariosh
(18557, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Ranc Deumus
(18558, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Crimson Hatu Otis
(18559, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Seer Flouros
(18560, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Follower of Flouros
(18561, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Granitick Duerga
(18562, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Blade Otis
(18563, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Follower of Otis
(18564, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Weird Bunei
(18565, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Brave Martim
(18566, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Kaim Abigore
(18567, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Follower of Abigore
(18568, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Knight Montagnar
(18569, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Follower of Montagnar
(18570, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Summer Yaganitan
(18571, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Venomous Storace
(18572, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Follower of Storace
(18573, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Kel Bilette
(18574, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Follower of Bilette
(18575, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Warlord Tamuze
(18576, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Follower of Tamuze
(18577, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- White Allosce
(18578, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Follower of Allosce
(18579, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Hunting Ground Keeper
(18580, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Cursed Girl
(18581, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Gardener
(18582, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Turned Girl
(18583, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Housekeeper
(18584, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Turned Boy
(18585, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Cursed Girl
(18586, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Gardener
(18587, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Begrudged Maid
(18588, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Hunting Ground Keeper
(18589, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Cursed Gardener
(18590, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Baroness' Employee
(18591, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Begrudged Boy
(18592, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Kratei's Steward
(18593, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Housekeeper
(18594, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Mansion Guide
(18595, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Baroness' Employee
(18596, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Cursed Gardener
(18597, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Begrudged Maid
(18598, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Cursed Head Maid
(18599, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Mansion Manager
(18600, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Kratei's Steward
(18601, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Kratei's Watcher
(18602, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Kratei's Watcher
(18603, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(18604, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(18605, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(18606, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(18607, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "boostup_clan", 300, "null", 0, 0, "balanced"), -- Gargos
(18608, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "boostup_clan", 300, "null", 0, 0, "balanced"), -- Kinsus
(18609, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "boostup_clan", 300, "null", 0, 0, "balanced"), -- Papion
(18610, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "boostup_clan", 300, "null", 0, 0, "balanced"), -- Hillas
(18611, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "boostup_clan", 300, "null", 0, 0, "balanced"), -- Spirit of Water
(18612, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "boostup_clan", 300, "null", 0, 0, "balanced"), -- Spirit of Water
(18613, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "boostup_clan", 300, "null", 0, 0, "balanced"), -- Spirit of Water
(18614, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "boostup_clan", 300, "null", 0, 0, "balanced"), -- Spirit of Fire
(18615, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "boostup_clan", 300, "null", 0, 0, "balanced"), -- Spirit of Fire
(18616, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "boostup_clan", 300, "null", 0, 0, "balanced"), -- Bloom
(18617, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(18618, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(18619, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(18620, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Adiantum
(18621, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(18622, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "pailaka_devil", 500, 0, "balanced"), -- Powder Keg
(18623, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "boostup_clan", 300, "null", 0, 15, "archer"), -- Begrudged Archer
(18624, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "boostup_clan", 300, "null", 0, 0, "balanced"), -- Deadman's Grudge
(18625, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "boostup_clan", 300, "null", 0, 0, "balanced"), -- Deadman's Grudge
(18626, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "boostup_clan", 300, "null", 0, 0, "balanced"), -- Deadman's Grudge
(18627, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "boostup_clan", 300, "null", 0, 0, "balanced"), -- Deadman's Grudge
(18628, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "boostup_clan", 300, "null", 0, 0, "balanced"), -- Atan
(18629, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "boostup_clan", 300, "null", 0, 0, "balanced"), -- Kams
(18630, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "boostup_clan", 300, "null", 0, 0, "balanced"), -- Hikoro
(18631, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "boostup_clan", 300, "null", 0, 0, "balanced"), -- Alkaso
(18632, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "boostup_clan", 300, "null", 0, 0, "balanced"), -- Gerbera
(18633, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "null", 300, "null", 0, 0, "balanced"), -- Lematan
(18634, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "healer"), -- Lematan's Follower
(18635, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "varka_silenos_clan", 600, "null", 0, 0, "balanced"), -- Varka Silenos Recruit
(18636, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "varka_silenos_clan", 600, "null", 0, 0, "balanced"), -- Varka Silenos Footman
(18637, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "varka_silenos_clan", 600, "null", 0, 0, "balanced"), -- Grazing Antelope
(18638, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "varka_silenos_clan", 600, "null", 0, 0, "balanced"), -- Varka Silenos Scout
(18639, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "varka_silenos_clan", 600, "null", 0, 0, "balanced"), -- Varka Silenos Hunter
(18640, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "varka_silenos_clan", 600, "null", 0, 0, "balanced"), -- Varka Silenos Shaman
(18641, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "varka_silenos_clan", 600, "null", 0, 0, "balanced"), -- Varka Silenos Priest
(18642, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "varka_silenos_clan", 600, "null", 0, 0, "balanced"), -- Varka Silenos Warrior
(18643, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "varka_silenos_clan", 600, "null", 0, 0, "balanced"), -- Grazing Antelope
(18644, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "varka_silenos_clan", 600, "null", 0, 0, "balanced"), -- Varka Silenos Medium
(18645, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "varka_silenos_clan", 600, "null", 0, 0, "balanced"), -- Varka Silenos Magus
(18646, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "varka_silenos_clan", 600, "null", 0, 0, "balanced"), -- Varka Silenos Officer
(18647, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "varka_silenos_clan", 600, "null", 0, 0, "balanced"), -- Grazing Flava
(18648, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "varka_silenos_clan", 600, "null", 0, 0, "balanced"), -- Varka Silenos Priest
(18649, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "varka_silenos_clan", 600, "null", 0, 0, "balanced"), -- Varka Silenos Great Magus
(18650, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "varka_silenos_clan", 600, "null", 0, 0, "balanced"), -- Varka Silenos General
(18651, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "varka_silenos_clan", 600, "null", 0, 0, "balanced"), -- Grazing Elder Antelope
(18652, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "varka_silenos_clan", 600, "null", 0, 0, "balanced"), -- Varka Silenos Great Seer
(18653, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "varka_silenos_clan", 600, "null", 0, 0, "balanced"), -- Varka's Elite Guard
(18654, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "varka_silenos_clan", 600, "null", 0, 0, "balanced"), -- Varka's Commander
(18655, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "varka_silenos_clan", 600, "null", 0, 0, "balanced"), -- Varka's Head Guard
(18656, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "varka_silenos_clan", 600, "null", 0, 0, "balanced"), -- Varka's Head Magus
(18657, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "varka_silenos_clan", 600, "null", 0, 0, "balanced"), -- Prophet's Guard
(18658, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "varka_silenos_clan", 600, "null", 0, 0, "balanced"), -- Disciple of Prophet
(18659, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "varka_silenos_clan", 600, "null", 0, 0, "balanced"), -- Varka's Prophet
(18660, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 800, 0, "null", 300, "null", 0, 0, "fighter"), -- Latana
(18661, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(18662, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(18663, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(18664, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Lucky Pig
(18665, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Lucky Pig
(18666, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Lucky Pig
(18667, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Ward of Death
(18668, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Ward of Death
(18669, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(18670, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(18671, 7, 15, 0, 300, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Block
(18672, 7, 15, 0, 300, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Block
(18673, 7, 15, 0, 300, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Block
(18674, 7, 15, 0, 300, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Block
(18675, 7, 15, 0, 300, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Block
(18676, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Block-Carrying Girl
(18677, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Dragon Steed Troop Messenger
(18678, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Energy Seed - Water
(18679, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Energy Seed - Fire
(18680, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Energy Seed - Wind
(18681, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Energy Seed - Earth
(18682, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Energy Seed - Holy
(18683, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Energy Seed - Dark
(18684, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Red Star Stone
(18685, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Red Star Stone
(18686, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Red Star Stone
(18687, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Blue Star Stone
(18688, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Blue Star Stone
(18689, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Blue Star Stone
(18690, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Green Star Stone
(18691, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Green Star Stone
(18692, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Green Star Stone
(18693, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ancients_treasure_clan", 600, "null", 0, 0, "balanced"), -- Treasure Chest of the Ancient Giants
(18694, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ancients_treasure_clan", 600, "null", 0, 0, "balanced"), -- Treasure Chest Guard
(18695, 7, 15, 0, 600, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ancients_treasure_clan", 600, "null", 0, 0, "balanced"), -- Treasure Chest Guard
(18696, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "des_dragon", 300, "null", 0, 0, "balanced"), -- Dimension Moving Device
(18697, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18698, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18699, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18700, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(18701, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(18702, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "des_dragon", 300, "null", 0, 0, "balanced"), -- Dimension Moving Device
(18703, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Defeated Troops Controller
(18704, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Tumor of Death
(18705, 7, 15, 0, 300, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Destroyed Tumor
(18706, 7, 15, 0, 300, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Soul Coffin
(18707, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), --
(18708, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Tumor of Death
(18709, 7, 15, 0, 300, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Soul Coffin
(18710, 7, 15, 0, 300, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Soul Coffin
(18711, 7, 15, 0, 300, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Soul Coffin
(18712, 7, 15, 0, 300, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Soul Coffin
(18713, 7, 15, 0, 300, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Soul Coffin
(18714, 7, 15, 0, 300, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Soul Coffin
(18715, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Conquered Soul
(18716, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Conquered Soul
(18717, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Conquered Soul
(18718, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Sacrificed Fanatic
(18719, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Sacrificed Fanatic
(18720, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18721, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18722, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18723, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18724, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18725, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18726, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18727, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18728, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18729, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18730, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18731, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18732, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18733, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18734, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18735, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18736, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18737, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18738, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18739, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18740, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18741, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18742, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18743, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18744, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18745, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18746, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18747, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18748, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18749, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18750, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18751, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18752, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18753, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18754, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18755, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18756, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18757, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18758, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18759, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18760, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18761, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18762, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18763, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18764, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18765, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18766, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18767, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18768, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18769, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18770, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18771, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18772, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18773, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18774, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Trap
(18775, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Seed of Destruction Control Device
(18776, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Obelisk
(18777, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Great Powerful Device
(18778, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Throne of Destruction Powerful Device
(18779, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(18780, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Symbol of Cohemenes
(18781, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Young Drake Wing
(18782, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "zealot_clan", 300, "airport_patrol", 0, 0, "balanced"), -- Zealot of Shilen
(18783, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Defeated Troops Commander
(18784, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Defeated Troops No 1 Battalion Commander
(18785, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Defeated Troops White Dragon Leader
(18786, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Defeated Troops Infantry
(18787, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Defeated Troops Magic Leader
(18788, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Defeated Troops Magician
(18789, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Defeated Troops Magic Soldier
(18790, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Defeated Troops Healer
(18791, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Defeated Troops Javelin Thrower
(18792, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Defeated Troops Javelin Thrower
(18793, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "corpse"), -- Bizarre Cocoon
(18794, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "corpse"), -- Bizarre Cocoon
(18795, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "corpse"), -- Bizarre Cocoon
(18796, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "corpse"), -- Bizarre Cocoon
(18797, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "corpse"), -- Bizarre Cocoon
(18798, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "corpse"), -- Bizarre Cocoon
(18799, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "fire_clan", 300, "null", 0, 0, "fighter"), -- Newborn Lavasaurus
(18800, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "fire_clan", 300, "null", 0, 0, "fighter"), -- Fledgling Lavasaurus
(18801, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "fire_clan", 300, "null", 0, 0, "fighter"), -- Adult Lavasaurus
(18802, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "fire_clan", 300, "null", 0, 0, "fighter"), -- Elderly Lavasaurus
(18803, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "fire_clan", 300, "null", 0, 0, "fighter"), -- Ancient Lavasaurus
(18804, 7, 15, 0, 300, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "null", 300, "null", 0, 0, "fighter"), -- Tar Beetle
(18805, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Waste Landfill Machine
(18806, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Brazier of Purity
(18807, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Frightened Ragna Orc
(18808, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "baranka_clan", 300, "null", 0, 0, "fighter"), -- Dark Shaman Varangka
(18809, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "baranka_clan", 300, "null", 0, 0, "fighter"), -- Varangka's Retainer
(18810, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "baranka_clan", 300, "null", 0, 0, "fighter"), -- Varangka's Page
(18811, 7, 15, 0, 450, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of the Altar
(18812, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "corpse"), -- Kasha's Eye
(18813, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "corpse"), -- Kasha's Eye
(18814, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "corpse"), -- Kasha's Eye
(18815, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "legendorc_clan", 300, "null", 0, 0, "fighter"), -- Guard of the Grave
(18816, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Chieftain's Treasure Chest
(18817, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fantasy_clan", 300, "null", 0, 0, "fighter"), -- Invader Martyr of Nightmare
(18818, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fantasy_clan", 300, "null", 0, 0, "fighter"), -- Nihil Invader Martyr
(18819, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Nihil Invader Treasure Chest
(18820, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Nihil Invader Treasure Chest
(18821, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fantasy_clan", 300, "null", 0, 0, "fighter"), -- Mutant Martyr
(18822, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mutant Treasure Chest
(18823, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mutant Treasure Chest
(18824, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Merchant of Mammon A
(18825, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Merchant of Mammon B
(18826, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Shilen's Evil Thoughts For Presentation
(18827, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Priest Cain for Presentation
(18828, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- High Priest of Dawn
(18829, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Shilen's Evil Thoughts Leader For Presentation
(18830, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- ssq For Presentation Camera Dummy 1
(18831, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- ssq For Presentation Camera Dummy 2
(18832, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- ssq For Presentation Camera Dummy 3
(18833, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Emperor's Seal Device
(18834, 7, 15, 0, 150, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 200, 0, "null", 300, "null", 0, 0, "fighter"), -- Guards of the Dawn
(18835, 7, 15, 0, 150, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 200, 0, "null", 300, "null", 0, 0, "fighter"), -- Guards of the Dawn
(18836, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "baranka_clan", 300, "null", 0, 0, "fighter"), -- Varangka's Guardian
(18837, 7, 15, 0, 150, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), --
(18838, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Treasure Chest of Invader Soldier of Nightmare
(18839, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Wild Maguen
(18840, 7, 15, 0, 300, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), --
(18841, 7, 15, 0, 300, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), --
(18842, 7, 15, 0, 300, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), --
(18843, 7, 15, 0, 300, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Cokrakon's Ward
(18844, 7, 15, 0, 300, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Reptilikon's Ward
(18845, 7, 15, 0, 300, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Torumba's Telegraph
(18846, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kegor
(18847, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Freya
(18848, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Battalion Leader
(18849, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Legionnaire
(18850, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Jinia
(18851, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kegor
(18852, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sirra
(18853, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Glacier
(18854, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Archer's Breath
(18855, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "freya_clan", 300, "null", 0, 0, "fighter"), -- Archery Knight
(18856, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "freya_clan", 300, "null", 0, 0, "fighter"), -- Archery Knight
(18857, 7, 15, 0, 300, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), --
(18858, 7, 15, 0, 300, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), --
(18859, 7, 15, 0, 300, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), --
(18860, 7, 15, 0, 300, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), --
(18861, 7, 15, 0, 300, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), --
(18862, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tanta Lizardman Guard
(18863, 7, 100, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tantaar_lizard_clan", 300, "dummy", 1000, 0, "mage"), -- Priest Ugoros
(18864, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "dummy", 1000, 0, "corpse"), -- Fantasy Mushroom
(18865, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "corpse"), -- Sticky Mushroom
(18866, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "corpse"), -- Rainbow Frog
(18867, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tantaar_lizard_clan", 300, "null", 0, 0, "corpse"), -- Abyss Weed
(18868, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "corpse"), -- Energy Plant
(18869, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kookaburra
(18870, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Cougar
(18871, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Buffalo
(18872, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Grendel
(18873, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Baby Alpine Kookaburra
(18874, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Young Kookaburra
(18875, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Young Kookaburra
(18876, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adult Kookaburra
(18877, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adult Kookaburra
(18878, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Full Grown Kookaburra
(18879, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Full Grown Kookaburra
(18880, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Baby Alpine Cougar
(18881, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Young Cougar
(18882, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Young Cougar
(18883, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adult Cougar
(18884, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adult Cougar
(18885, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Full Grown Cougar
(18886, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Full Grown Cougar
(18887, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Baby Alpine Buffalo
(18888, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Young Buffalo
(18889, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Young Buffalo
(18890, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adult Buffalo
(18891, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adult Buffalo
(18892, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Full Grown Buffalo
(18893, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Full Grown Buffalo
(18894, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Baby Alpine Grendel
(18895, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Young Grendel
(18896, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Young Grendel
(18897, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adult Grendel
(18898, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adult Grendel
(18899, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Full Grown Grendel
(18900, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Full Grown Grendel
(18901, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kookaburra
(18902, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Cougar
(18903, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Buffalo
(18904, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Grendel
(18905, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Farm Ravager
(18906, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 300, "null", 0, 0, "fighter"), -- Farm Bandit
(18907, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 300, "null", 0, 0, "fighter"), -- Beast Devourer
(18908, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sel Mahum Chef
(18909, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 200, 0, "n_solina_clan", 300, "monastery_scarecrow", 400, 0, "fighter"), -- Solina Knights
(18910, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 200, 0, "n_solina_clan", 300, "null", 0, 0, "fighter"), -- Solina Knight Captain
(18911, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Abbey Treasure Chest
(18912, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 200, 0, "null", 300, "dummy_clan", 400, 0, "corpse"), -- Scarecrow
(18913, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Furnace
(18914, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Furnace
(18915, 7, 15, 0, 300, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Divine Furnace
(18916, 7, 15, 0, 300, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), --
(18917, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Pavel Safety Device
(18918, 7, 15, 0, 300, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), --
(18919, 7, 15, 0, 300, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), --
(18920, 7, 15, 0, 300, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), --
(18921, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Square Base
(18922, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Door Golem
(18923, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Door Golem
(18924, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Door Golem
(18925, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Trap
(18926, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mercenary Archer
(18927, 7, 15, 0, 300, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Fire
(18928, 7, 15, 0, 300, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Annihilation Furnace
(18929, 7, 15, 0, 300, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1500, 0, "grail_clan", 1500, "null", 0, 0, "fighter"), -- Ward of the Grail
(18930, 7, 15, 0, 300, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), --
(18931, 7, 15, 0, 300, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), --
(18932, 7, 15, 0, 300, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), --
(18933, 7, 15, 0, 300, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Fire Feed
(18934, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Abbey Treasure Chest
(18935, 7, 15, 0, 300, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Divine Sword Protection
(18936, 7, 15, 0, 300, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), --
(18937, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Target Dummy
(18938, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Target Dummy
(18939, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Target Dummy
(18940, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Target Dummy
(18941, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Target Dummy
(18942, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Target Dummy
(18943, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Target Dummy
(18944, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Target Dummy
(18945, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Target Dummy
(18946, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Target Dummy
(18947, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Target Dummy
(18948, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Etis van Etina
(18949, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Etis van Etina
(18950, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Etis van Etina's Phantom
(18951, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Etis van Etina's Phantom
(18952, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Solina's Guardian
(18953, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Solina's Guardian
(18954, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Solina's Guardian
(18955, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Solina's Guardian
(18956, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Guardian of the Tomb
(18957, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Guardian of the Tomb
(18958, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Guardian of the Tomb
(18959, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Guardian of the Tomb
(18960, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Drake Lord
(18961, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Behemoth Leader
(18962, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Dragon Beast
(18963, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), --
(18964, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Antharas' Symbol
(18965, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Antharas' Symbol
(18966, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Antharas' Symbol
(18967, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), --
(18968, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), --
(18969, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Magma Drake Mother
(18970, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Magma Drake Hatchling
(18971, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Gem Dragon Hatchling
(20001, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gremlin
(20002, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Rabbit
(20003, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "goblin_clan", 300, "null", 0, 0, "fighter"), -- Goblin
(20004, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "demonic_clan", 300, "null", 0, 0, "fighter"), -- Imp
(20005, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "demonic_clan", 300, "null", 0, 0, "fighter"), -- Imp Elder
(20006, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "orc_clan", 300, "null", 0, 15, "archer"), -- Orc Archer
(20007, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Green Fungus
(20008, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "lizardman_clan", 300, "null", 0, 0, "fighter"), -- Felim Lizardman
(20009, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Vuku Orc
(20010, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "lizardman_clan", 300, "null", 0, 0, "fighter"), -- Felim Lizardman Scout
(20011, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "orc_clan", 300, "null", 0, 15, "archer"), -- Vuku Orc Archer
(20012, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "werewolf_clan", 300, "null", 0, 0, "fighter"), -- Gora Werewolf
(20013, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "elemental1_clan", 300, "null", 0, 0, "fighter"), -- Dryad
(20014, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "lizardman_clan", 300, "null", 0, 0, "fighter"), -- Felim Lizardman Warrior
(20015, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Marsh Zombie
(20016, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Stone Golem
(20017, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Vuku Orc Fighter
(20018, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Carnivorous Fungus
(20019, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "elemental1_clan", 300, "null", 0, 0, "fighter"), -- Dryad Elder
(20020, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Marsh Zombie Lord
(20021, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Red Bear
(20022, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "skeleton_clan", 300, "null", 0, 0, "fighter"), -- Misery Skeleton
(20023, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Shadow Beast
(20024, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Langk Lizardman Warrior
(20025, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Lesser Dark Horror
(20026, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ruin Zombie
(20027, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "lizardman_clan", 300, "null", 0, 0, "fighter"), -- Langk Lizardman Scout
(20028, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Pincher
(20029, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ruin Zombie Leader
(20030, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "lizardman_clan", 300, "null", 0, 0, "fighter"), -- Langk Lizardman
(20031, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Omen Beast
(20032, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Pinrul
(20033, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Shade Horror
(20034, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Prowler
(20035, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "skeleton_clan", 300, "null", 0, 0, "fighter"), -- Skeleton Tracker
(20036, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "elemental2_clan", 300, "null", 0, 0, "fighter"), -- Lirein
(20037, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mana Seeker
(20038, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Venomous Spider
(20039, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "wererat_clan", 300, "null", 0, 0, "fighter"), -- Scavenger Wererat
(20040, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "wererat_clan", 300, "null", 0, 0, "fighter"), -- Sukar Wererat
(20041, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tainted Zombie
(20042, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "skeleton_clan", 300, "null", 0, 0, "fighter"), -- Skeleton Tracker Leader
(20043, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Arachnid Tracker
(20044, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "elemental1_clan", 300, "null", 0, 0, "fighter"), -- Lirein Elder
(20045, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "skeleton_clan", 300, "null", 0, 15, "archer"), -- Skeleton Scout
(20046, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Stink Zombie
(20047, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "wererat_clan", 300, "null", 0, 0, "fighter"), -- Sukar Wererat Leader
(20048, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "demonic_clan", 300, "null", 0, 0, "fighter"), -- Lesser Succubus
(20049, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "werewolf_clan", 300, "null", 0, 0, "fighter"), -- Lycanthrope
(20050, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Arachnid Predator
(20051, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "skeleton_clan", 300, "null", 0, 15, "archer"), -- Skeleton Bowman
(20052, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "demonic_clan", 300, "null", 0, 0, "fighter"), -- Lesser Succubus Turen
(20053, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ol_mahum_clan", 300, "null", 0, 15, "archer"), -- Ol Mahum Patrol
(20054, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "skeleton_clan", 300, "null", 0, 0, "fighter"), -- Ruin Spartoi
(20055, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Wandering Eye
(20056, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "demonic_clan", 300, "null", 0, 0, "fighter"), -- Dre Vanul Disposer
(20057, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "demonic_clan", 300, "null", 0, 0, "fighter"), -- Lesser Succubus Tilfo
(20058, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ol_mahum_clan", 300, "null", 0, 0, "fighter"), -- Ol Mahum Guard
(20059, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Hungry Eye
(20060, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "skeleton_clan", 300, "null", 0, 0, "fighter"), -- Raging Spartoi
(20061, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "ol_mahum_clan", 300, "null", 0, 0, "fighter"), -- Ol Mahum Straggler
(20062, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "bugbear_clan", 300, "null", 0, 0, "fighter"), -- Tumran Bugbear
(20063, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ol_mahum_clan", 300, "null", 0, 15, "archer"), -- Ol Mahum Shooter
(20064, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "bugbear_clan", 300, "null", 0, 0, "fighter"), -- Tumran Bugbear Warrior
(20065, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ol_mahum_clan", 300, "null", 0, 0, "fighter"), -- Ol Mahum Patrolman
(20066, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "ol_mahum_clan", 300, "null", 0, 0, "fighter"), -- Ol Mahum Captain
(20067, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Monster Eye Watcher
(20068, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Monster Eye Destroyer
(20069, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "lizardman_clan", 300, "null", 0, 0, "fighter"), -- Selu Lizardman Scout
(20070, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Lesser Basilisk
(20071, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "lizardman_clan", 300, "null", 0, 0, "fighter"), -- Selu Lizardman Warrior
(20072, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Basilisk
(20073, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ol_mahum_clan", 300, "null", 0, 0, "fighter"), -- Ol Mahum Legionnaire
(20074, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "scropio_clan", 300, "null", 0, 0, "fighter"), -- Androscorpio
(20075, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ant_clan", 300, "null", 0, 0, "fighter"), -- Ant Larva
(20076, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "ol_mahum_clan", 300, "null", 0, 0, "fighter"), -- Ol Mahum Commander
(20077, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "scropio_clan", 300, "null", 0, 0, "fighter"), -- Androscorpio Hunter
(20078, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "elemental2_clan", 300, "null", 0, 0, "fighter"), -- Whispering Wind
(20079, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ant_clan", 300, "null", 0, 0, "fighter"), -- Ant
(20080, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "ant_clan", 300, "null", 0, 0, "fighter"), -- Ant Captain
(20081, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ant_clan", 300, "null", 0, 0, "fighter"), -- Ant Overseer
(20082, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ant_clan", 300, "null", 0, 0, "fighter"), -- Ant Recruit
(20083, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Granite Golem
(20084, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ant_clan", 300, "null", 0, 0, "fighter"), -- Ant Patrol
(20085, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Puncher
(20086, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ant_clan", 300, "null", 0, 0, "fighter"), -- Ant Guard
(20087, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "ant_clan", 300, "null", 0, 0, "fighter"), -- Ant Soldier
(20088, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "ant_clan", 300, "null", 0, 0, "fighter"), -- Ant Warrior Captain
(20089, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ant_clan", 300, "null", 0, 0, "fighter"), -- Noble Ant
(20090, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "ant_clan", 300, "null", 0, 0, "fighter"), -- Noble Ant Leader
(20091, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Young Fox
(20092, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Monster Eye
(20093, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Orc Fighter
(20094, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "orc_clan", 300, "null", 0, 15, "archer"), -- Orc Marksman
(20095, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Vampire Bat
(20096, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Orc Lieutenant
(20097, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Drill Bat
(20098, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Orc Fighter Leader
(20099, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "skeleton_clan", 300, "null", 0, 0, "fighter"), -- Skeleton
(20100, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "skeleton_clan", 300, "null", 0, 15, "archer"), -- Skeleton Archer
(20101, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Crasher
(20102, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "skeleton_clan", 300, "null", 0, 15, "archer"), -- Skeleton Marksman
(20103, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Giant Spider
(20104, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "skeleton_clan", 300, "null", 0, 0, "fighter"), -- Skeleton Lord
(20105, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Dark Horror
(20106, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Talon Spider
(20107, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "wererat_clan", 300, "null", 0, 0, "fighter"), -- Wererat
(20108, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Blade Spider
(20109, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "elemental3_clan", 300, "null", 0, 0, "fighter"), -- Salamander
(20110, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "elemental4_clan", 300, "null", 0, 0, "fighter"), -- Undine
(20111, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "wererat_clan", 300, "null", 0, 0, "fighter"), -- Wererat Leader
(20112, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "elemental3_clan", 300, "null", 0, 0, "fighter"), -- Salamander Elder
(20113, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "elemental4_clan", 300, "null", 0, 0, "fighter"), -- Undine Elder
(20114, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "elemental3_clan", 300, "null", 0, 0, "fighter"), -- Salamander Noble
(20115, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "elemental4_clan", 300, "null", 0, 0, "fighter"), -- Undine Noble
(20116, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Fox
(20117, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "demonic_clan", 300, "null", 0, 0, "fighter"), -- Dre Vanul
(20118, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "demonic_clan", 300, "null", 0, 0, "fighter"), -- Dre Vanul Scout
(20119, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Elder Fox
(20120, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Wolf
(20121, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Giant Toad
(20130, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Orc
(20131, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Orc Grunt
(20132, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "werewolf_clan", 300, "null", 0, 0, "fighter"), -- Werewolf
(20133, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "bugbear_clan", 300, "null", 0, 0, "fighter"), -- Bugbear
(20134, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Cave Maiden
(20135, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "croc_clan2", 300, "null", 0, 0, "fighter"), -- Alligator
(20136, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "undead_clan", 300, "null", 0, 0, "fighter"), -- Death Knight
(20137, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "dragon_clan", 300, "null", 0, 0, "fighter"), -- Drake
(20138, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Gargoyle
(20139, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Giant Bee
(20140, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Giant Leech
(20141, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Giant Wild Hog
(20142, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Griffon
(20143, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Grizzly
(20144, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Hangman Tree
(20145, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Harpy
(20146, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Headless Knight
(20147, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "goblin_clan", 300, "null", 0, 0, "fighter"), -- Hobgoblin
(20148, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Hungry Spirit
(20149, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Iron Golem
(20150, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "bugbear_clan", 300, "null", 0, 0, "fighter"), -- King Bugbear
(20151, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "goblin_clan", 300, "null", 0, 0, "fighter"), -- Kobold
(20152, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "lizardman_clan", 300, "null", 0, 0, "fighter"), -- Lizardman
(20153, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Magical Weaver
(20154, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "mandragora_clan", 300, "null", 0, 0, "fighter"), -- Mandragora Sprout
(20155, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "mandragora_clan", 300, "null", 0, 0, "fighter"), -- Mandragora Sapling
(20156, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "mandragora_clan", 300, "null", 0, 0, "fighter"), -- Mandragora Blossom
(20157, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "stakato_clan", 300, "null", 0, 0, "fighter"), -- Marsh Stakato
(20158, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Medusa
(20159, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Minotaur
(20160, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "neer_crawler_clan", 300, "null", 0, 0, "fighter"), -- Neer Crawler
(20161, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "oel_mahum_clan", 300, "null", 0, 0, "fighter"), -- Oel Mahum
(20162, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Ogre
(20163, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ol_mahum_clan", 300, "null", 0, 0, "fighter"), -- Ol Mahum
(20164, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "ol_mahum_clan", 300, "null", 0, 15, "archer"), -- Ol Mahum Archer
(20165, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "ol_mahum_clan", 300, "null", 0, 0, "fighter"), -- Ol Mahum Champion
(20166, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "demonic_clan", 300, "null", 0, 0, "fighter"), -- Succubus
(20167, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "serpent_clan", 300, "null", 0, 0, "fighter"), -- Serpent Slave
(20168, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "silenos_clan", 300, "null", 0, 0, "fighter"), -- Silenos
(20169, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "skeleton_clan", 300, "null", 0, 0, "fighter"), -- Skeleton Royal Guard
(20170, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "skeleton_clan", 300, "null", 0, 0, "fighter"), -- Spartoi
(20171, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Specter
(20172, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "elemental2_clan", 300, "null", 0, 0, "fighter"), -- Sylph
(20173, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Troll
(20174, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Two-Headed Giant
(20175, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Walking Fungus
(20176, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Wyrm
(20177, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Zombie
(20189, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Puma
(20190, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "skeleton_clan", 300, "null", 0, 15, "archer"), -- Skeleton Marauder
(20191, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "skeleton_clan", 300, "null", 0, 0, "fighter"), -- Skeleton Raider
(20192, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "tyrant_clan", 300, "null", 0, 0, "fighter"), -- Tyrant
(20193, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "tyrant_clan", 300, "null", 0, 0, "fighter"), -- Tyrant Kingpin
(20194, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Queen Undine
(20197, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sorrow Maiden
(20198, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "neer_crawler_clan", 300, "null", 0, 0, "fighter"), -- Neer Ghoul Berserker
(20199, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Amber Basilisk
(20200, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Strain
(20201, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ghoul
(20202, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dead Seeker
(20203, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dion Grizzly
(20204, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Bloody Bee
(20205, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "wolf_clan", 300, "null", 0, 0, "fighter"), -- Dire Wolf
(20206, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kadif Werewolf
(20207, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ol_mahum_clan", 300, "null", 0, 0, "fighter"), -- Ol Mahum Guerilla
(20208, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ol_mahum_clan", 300, "null", 0, 0, "fighter"), -- Ol Mahum Raider
(20209, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ol_mahum_clan", 300, "null", 0, 15, "archer"), -- Ol Mahum Marksman
(20210, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ol_mahum_clan", 300, "null", 0, 0, "fighter"), -- Ol Mahum Sergeant
(20211, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "ol_mahum_clan", 300, "null", 0, 0, "fighter"), -- Ol Mahum Captain
(20212, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "ol_mahum_clan", 300, "null", 0, 0, "fighter"), -- Bloody Axe Turmak
(20213, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "porta_clan", 400, "null", 0, 0, "fighter"), -- Porta
(20214, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "porta_clan", 400, "null", 0, 0, "fighter"), -- Excuro
(20215, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "porta_clan", 400, "null", 0, 0, "fighter"), -- Mordeo
(20216, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "porta_clan", 400, "null", 0, 0, "fighter"), -- Ricenseo
(20217, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "porta_clan", 400, "null", 0, 0, "fighter"), -- Krator
(20218, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "porta_clan", 400, "null", 0, 0, "fighter"), -- Premo
(20219, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "torfe_clan", 400, "null", 0, 0, "fighter"), -- Validus
(20220, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "torfe_clan", 400, "null", 0, 0, "fighter"), -- Dicor
(20221, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "torfe_clan", 300, "null", 0, 0, "fighter"), -- Perum
(20222, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "torfe_clan", 300, "null", 0, 0, "fighter"), -- Torfe
(20223, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "mandragora_clan", 300, "null", 0, 0, "fighter"), -- Mandragora Sprout
(20224, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ol_mahum_clan", 300, "null", 0, 15, "archer"), -- Ol Mahum Ranger
(20225, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "giant_leech_clan", 300, "null", 0, 0, "fighter"), -- Giant Mist Leech
(20226, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ant_clan", 300, "null", 0, 0, "fighter"), -- Gray Ant
(20227, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Horror Mist Ripper
(20228, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ant_clan", 300, "null", 0, 0, "fighter"), -- Giant Crimson Ant
(20229, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Stinger Wasp
(20230, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "stakato_clan", 300, "null", 0, 0, "fighter"), -- Marsh Stakato Worker
(20231, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Toad Lord
(20232, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "stakato_clan", 300, "null", 0, 0, "fighter"), -- Marsh Stakato Soldier
(20233, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Marsh Spider
(20234, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "stakato_clan", 300, "null", 0, 0, "fighter"), -- Marsh Stakato Drone
(20235, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Shackle
(20236, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "cave_servant_clan", 300, "null", 0, 0, "fighter"), -- Cave Servant
(20237, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "cave_servant_clan", 300, "null", 0, 15, "archer"), -- Cave Servant Archer
(20238, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "cave_servant_clan", 300, "null", 0, 0, "fighter"), -- Cave Servant Warrior
(20239, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "cave_servant_clan", 300, "null", 0, 0, "fighter"), -- Cave Servant Captain
(20240, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "cave_servant_clan", 400, "null", 0, 0, "balanced"), -- Royal Cave Servant
(20241, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Hunter Gargoyle
(20242, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dustwind Gargoyle
(20243, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Thunder Wyrm
(20244, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "succubus_clan", 300, "null", 0, 0, "fighter"), -- Maluk Succubus
(20245, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "succubus_clan", 300, "null", 0, 0, "fighter"), -- Maluk Succubus Turen
(20246, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "cave_servant_clan", 300, "null", 0, 0, "fighter"), -- Cave Keeper
(20248, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "bugbear_clan", 300, "null", 0, 0, "fighter"), -- Turak Bugbear
(20249, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "bugbear_clan", 300, "null", 0, 0, "fighter"), -- Turak Bugbear Warrior
(20250, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Glass Jaguar
(20251, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Delu Lizardman
(20252, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Delu Lizardman Scout
(20253, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Delu Lizardman Warrior
(20254, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "skeleton_clan", 300, "null", 0, 0, "fighter"), -- Skeleton Axeman
(20255, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Batur Orc
(20256, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "orc_clan", 300, "null", 0, 15, "archer"), -- Batur Orc Archer
(20257, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Batur Orc Warrior
(20258, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "orc_clan", 300, "null", 0, 0, "balanced"), -- Batur Orc Shaman
(20259, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Batur Orc Overlord
(20260, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Orc Champion
(20261, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "orc_clan", 300, "null", 0, 0, "balanced"), -- Orc Shaman
(20265, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Monster Eye Searcher
(20266, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Monster Eye Gazer
(20267, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Breka Orc
(20268, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "orc_clan", 300, "null", 0, 15, "archer"), -- Breka Orc Archer
(20269, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "orc_clan", 300, "null", 0, 0, "balanced"), -- Breka Orc Shaman
(20270, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Breka Orc Overlord
(20271, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Breka Orc Warrior
(20272, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "cave_servant_clan", 300, "null", 0, 0, "fighter"), -- Cave Servant
(20273, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "cave_servant_clan", 300, "null", 0, 15, "archer"), -- Cave Servant Archer
(20274, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "cave_servant_clan", 300, "null", 0, 0, "fighter"), -- Cave Servant Warrior
(20275, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "cave_servant_clan", 300, "null", 0, 0, "fighter"), -- Cave Servant Captain
(20276, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "cave_servant_clan", 300, "null", 0, 0, "balanced"), -- Royal Cave Servant
(20277, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "cave_servant_clan", 300, "null", 0, 0, "fighter"), -- Cave Keeper
(20279, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Shackle
(20280, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Headless Knight
(20281, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dustwind Gargoyle
(20282, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Thunder Wyrm
(20283, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "succubus_clan", 300, "null", 0, 0, "fighter"), -- Maluk Succubus
(20284, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "succubus_clan", 300, "null", 0, 0, "fighter"), -- Maluk Succubus Turen
(20285, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "dragon_clan", 300, "null", 0, 0, "fighter"), -- Drake
(20286, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Hunter Gargoyle
(20287, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Cave Maiden
(20291, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Enku Orc Champion
(20292, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "orc_clan", 300, "null", 0, 0, "balanced"), -- Enku Orc Shaman
(20293, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "lizardman_clan", 300, "null", 0, 0, "fighter"), -- Virud Lizardman
(20294, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "lizardman_clan", 300, "null", 0, 0, "fighter"), -- Virud Lizardman Matriarch
(20295, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "lizardman_clan", 300, "null", 0, 0, "fighter"), -- Virud Lizardman Warrior
(20296, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "lizardman_clan", 300, "null", 0, 0, "fighter"), -- Virud Lizardman Scout
(20297, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "lizardman_clan", 300, "null", 0, 0, "balanced"), -- Virud Lizardman Shaman
(20298, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "lizardman_clan", 300, "null", 0, 0, "balanced"), -- Virud Lizardman Shaman
(20299, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "lizardman_clan", 300, "null", 0, 0, "fighter"), -- Zenta Lizardman
(20300, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "lizardman_clan", 300, "null", 0, 0, "fighter"), -- Zenta Lizardman Matriarch
(20301, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "lizardman_clan", 300, "null", 0, 0, "fighter"), -- Zenta Lizardman Scout
(20302, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "lizardman_clan", 300, "null", 0, 0, "fighter"), -- Zenta Lizardman Warrior
(20303, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "lizardman_clan", 300, "null", 0, 0, "balanced"), -- Zenta Lizardman Shaman
(20304, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "stakato_clan", 300, "null", 0, 0, "fighter"), -- Marsh Stakato Queen
(20305, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Grave
(20307, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "werewolf_clan", 300, "null", 0, 0, "fighter"), -- Garum Werewolf
(20308, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Hook Spider
(20309, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Brown Fox
(20310, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Brown Bear
(20311, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "demonic_clan", 300, "null", 0, 0, "fighter"), -- Rakeclaw Imp
(20312, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "demonic_clan", 300, "null", 0, 0, "fighter"), -- Rakeclaw Imp Hunter
(20313, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "demonic_clan", 300, "null", 0, 0, "fighter"), -- Rakeclaw Imp Chieftain
(20314, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Great White Shark
(20316, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Darkwing Bat
(20317, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Black Wolf
(20318, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Black Timber Wolf
(20319, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "goblin_clan", 300, "null", 0, 0, "fighter"), -- Goblin Grave Robber
(20320, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "goblin_clan", 300, "null", 0, 0, "fighter"), -- Goblin Tomb Raider Leader
(20321, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "goblin_clan", 300, "null", 0, 0, "fighter"), -- Goblin Thief
(20322, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "goblin_clan", 300, "null", 0, 0, "fighter"), -- Goblin Brigand
(20323, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "goblin_clan", 300, "null", 0, 0, "fighter"), -- Goblin Brigand Leader
(20324, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "goblin_clan", 300, "null", 0, 0, "fighter"), -- Goblin Brigand Lieutenant
(20325, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "goblin_clan", 300, "null", 0, 0, "fighter"), -- Goblin Raider
(20326, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "goblin_clan", 300, "null", 0, 0, "fighter"), -- Goblin Scout
(20327, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "goblin_clan", 300, "null", 0, 0, "fighter"), -- Goblin Snooper
(20328, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "goblin_clan", 300, "null", 0, 0, "fighter"), -- Goblin Lookout
(20329, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Ghost Guardian
(20330, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mineshaft Bat
(20331, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Monster Eye Tracker
(20333, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Greystone Golem
(20334, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gremlin Scavenger
(20335, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Grizzly Bear
(20336, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Green Dryad
(20337, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Longtail Fox
(20338, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Nightmare Weaver
(20340, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "skeleton_clan", 300, "null", 0, 0, "fighter"), -- Slave Skeleton
(20341, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Undead Slave
(20342, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "werewolf_clan", 300, "null", 0, 0, "fighter"), -- Werewolf Chieftain
(20343, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "werewolf_clan", 300, "null", 0, 0, "fighter"), -- Werewolf Hunter
(20345, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Dark Terror
(20346, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Darkstone Golem
(20347, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "undead_clan", 300, "null", 0, 0, "fighter"), -- Doom Wraith
(20348, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Cave Spider
(20349, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Cave Bat
(20350, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Cave Fang Spider
(20351, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "demonic_clan", 300, "null", 0, 0, "fighter"), -- Dre Vanul Tracker
(20352, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "demonic_clan", 300, "null", 0, 0, "fighter"), -- Dre Vanul Slayer
(20353, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "demonic_clan", 300, "null", 0, 0, "fighter"), -- Dre Vanul Beholder
(20354, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "ghost_clan", 300, "null", 0, 0, "fighter"), -- Dwarf Ghost
(20356, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "lizardman_clan", 300, "null", 0, 0, "fighter"), -- Langk Lizardman Leader
(20357, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "lizardman_clan", 300, "null", 0, 0, "fighter"), -- Langk Lizardman Lieutenant
(20358, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "wererat_clan", 300, "null", 0, 0, "fighter"), -- Ratman Hunter
(20359, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "wererat_clan", 300, "null", 0, 0, "fighter"), -- Ratman Warrior
(20360, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "wererat_clan", 300, "null", 0, 0, "fighter"), -- Ratman Spy
(20361, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "orc_clan", 300, "null", 0, 15, "archer"), -- Tunath Orc Marksman
(20362, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Tunath Orc Warrior
(20363, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "werewolf_clan", 300, "null", 0, 0, "fighter"), -- Maraku Werewolf
(20364, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "werewolf_clan", 300, "null", 0, 0, "fighter"), -- Maraku Werewolf Chieftain
(20365, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mountain Fungus
(20367, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "skeleton_clan", 300, "null", 0, 0, "fighter"), -- Merkenis' Escort
(20368, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Grave Keeper
(20369, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Moonstone Beast
(20370, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Barbed Bat
(20371, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Mist Terror
(20372, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Baraq Orc Fighter
(20373, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Baraq Orc Warrior Leader
(20374, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "skeleton_clan", 300, "null", 0, 0, "fighter"), -- Varangka's Guard
(20375, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "skeleton_clan", 300, "null", 0, 0, "fighter"), -- Varangka's Escort
(20376, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "goblin_clan", 300, "null", 0, 0, "fighter"), -- Varikan Brigand Leader
(20377, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "goblin_clan", 300, "null", 0, 0, "fighter"), -- Varika's Bandit
(20378, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Stone Giant
(20379, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Stone Soldier
(20380, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Stone Guardian
(20381, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Vaiss Orc
(20382, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Vaiss Orc Warrior Leader
(20383, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "undead_clan", 300, "null", 0, 0, "fighter"), -- Arachnid Hunter
(20385, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "orc_clan", 300, "null", 0, 15, "archer"), -- Balor Orc Archer
(20386, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Balor Orc Fighter
(20387, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Balor Orc Fighter Leader
(20388, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Balor Orc Lieutenant
(20389, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "wererat_clan", 300, "null", 0, 0, "fighter"), -- Boogle Ratman
(20390, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "wererat_clan", 300, "null", 0, 0, "fighter"), -- Boogle Ratman Leader
(20391, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Red Fox
(20392, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Redeye Bat
(20393, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Red Scavenger Spider
(20394, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Crimson Tarantula
(20398, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "werewolf_clan", 300, "null", 0, 0, "fighter"), -- Vrykolakas
(20399, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Vrykolakas Wolfkin
(20400, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Blood Fungus
(20401, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "bugbear_clan", 300, "null", 0, 0, "fighter"), -- Veelan Bugbear
(20402, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "bugbear_clan", 300, "null", 0, 0, "fighter"), -- Veelan Bugbear Warrior
(20403, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Hunter Tarantula
(20404, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Silent Horror
(20405, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Young Brown Fox
(20406, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Young Red Fox
(20407, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Young Crimson Fox
(20410, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Scavenger Spider
(20411, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Scavenger Bat
(20412, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Susceptor
(20415, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "elemental3_clan", 300, "null", 0, 0, "fighter"), -- Scarlet Salamander
(20416, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "elemental3_clan", 300, "null", 0, 0, "fighter"), -- Scarlet Salamander Elder
(20418, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Crystalline Beast
(20419, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "succubus_clan", 300, "null", 0, 0, "fighter"), -- Akaste Succubus
(20420, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "succubus_clan", 300, "null", 0, 0, "fighter"), -- Akaste Succubus Turen
(20421, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "succubus_clan", 300, "null", 0, 0, "fighter"), -- Akaste Succubus Tilfo
(20422, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "skeleton_clan", 300, "null", 0, 0, "fighter"), -- Akaste Bone Warlord
(20423, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "skeleton_clan", 300, "null", 0, 15, "archer"), -- Akaste Bone Archer
(20424, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "skeleton_clan", 300, "null", 0, 0, "fighter"), -- Akaste Bone Lord
(20425, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "skeleton_clan", 300, "null", 0, 0, "fighter"), -- Akaste Bone Soldier
(20426, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Evil Eye
(20427, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Evil Eye Watcher
(20428, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Evil Eye Patroller
(20429, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Evil Eye Lookout
(20431, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Elf Ghost
(20432, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Elpy
(20433, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Festering Bat
(20435, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Opal Beast
(20436, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ol_mahum_clan", 300, "null", 0, 0, "fighter"), -- Ol Mahum Supplier
(20437, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ol_mahum_clan", 300, "null", 0, 0, "fighter"), -- Ol Mahum Recruit
(20438, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "ol_mahum_clan", 300, "null", 0, 0, "fighter"), -- Ol Mahum General
(20439, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ol_mahum_clan", 300, "null", 0, 0, "fighter"), -- Ol Mahum Officer
(20440, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Elder Brown Fox
(20441, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Elder Longtail Fox
(20442, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Elder Wolf
(20443, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Elder Red Fox
(20444, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Elder Prairie Fox
(20445, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Uthanka Pirate
(20446, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Utuku Orc
(20447, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "orc_clan", 300, "null", 0, 15, "archer"), -- Utuku Orc Archer
(20448, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Utuku Orc Grunt
(20449, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Will-O-Wisp
(20450, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "werewolf_clan", 300, "null", 0, 0, "fighter"), -- Relic Werewolf
(20451, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "skeleton_clan", 300, "null", 0, 0, "fighter"), -- Relic Spartoi
(20453, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "ghost_clan", 300, "null", 0, 0, "fighter"), -- Human Ghost
(20454, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Oblivion Watcher
(20455, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "skeleton_clan", 300, "null", 0, 0, "fighter"), -- Doom Soldier
(20456, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ashen Wolf
(20457, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Zombie Soldier
(20458, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Zombie Warrior
(20460, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Crimson Spider
(20461, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Dungeon Spider
(20462, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Cave Blade Spider
(20463, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "skeleton_clan", 300, "null", 0, 15, "archer"), -- Dungeon Skeleton Archer
(20464, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "skeleton_clan", 300, "null", 0, 0, "fighter"), -- Dungeon Skeleton
(20465, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Prairie Fox
(20466, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Pincer Spider
(20468, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Kaboo Orc
(20469, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "orc_clan", 300, "null", 0, 15, "archer"), -- Kaboo Orc Archer
(20470, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Kaboo Orc Grunt
(20471, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Kaboo Orc Fighter
(20472, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Kaboo Orc Fighter Leader
(20473, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Kaboo Orc Fighter Lieutenant
(20474, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kasha Spider
(20475, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kasha Wolf
(20476, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kasha Fang Spider
(20477, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kasha Timber Wolf
(20478, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kasha Blade Spider
(20479, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Kasha Bear
(20480, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Blade Bat
(20481, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Bearded Keltir
(20483, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Corpse Candle
(20487, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "wererat_clan", 300, "null", 0, 0, "fighter"), -- Kuruka Ratman
(20488, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "wererat_clan", 300, "null", 0, 0, "fighter"), -- Kuruka Ratman Hunter
(20489, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Quicksilver Beast
(20490, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "undead_clan", 300, "null", 0, 0, "fighter"), -- Death Doll
(20491, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Crypt Horror
(20492, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "kirunak_clan", 300, "null", 0, 0, "fighter"), -- Kirunak's Guards
(20494, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Turek War Hound
(20495, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Turek Orc Warlord
(20496, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "orc_clan", 400, "null", 0, 15, "archer"), -- Turek Orc Archer
(20497, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Turek Orc Skirmisher
(20498, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Turek Orc Supplier
(20499, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Turek Orc Footman
(20500, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Turek Orc Sentinel
(20501, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "orc_clan", 300, "null", 0, 0, "balanced"), -- Turek Orc Shaman
(20502, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Twink Puma
(20504, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "skeleton_clan", 300, "null", 0, 0, "fighter"), -- Dread Soldier
(20505, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ruin Bat
(20506, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "demonic_clan", 300, "null", 0, 0, "fighter"), -- Ruin Imp
(20507, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "demonic_clan", 300, "null", 0, 0, "fighter"), -- Ruin Imp Elder
(20508, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Plunder Tarantula
(20509, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Spore Fungus
(20510, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Puma
(20511, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Pitchstone Golem
(20512, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "monster_eye_clan", 300, "null", 0, 0, "fighter"), -- Field Stalker
(20513, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "skeleton_clan", 300, "null", 0, 0, "fighter"), -- Skeleton Knight
(20514, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "skeleton_clan", 300, "null", 0, 0, "fighter"), -- Shield Skeleton
(20515, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "skeleton_clan", 300, "null", 0, 0, "fighter"), -- Skeleton Infantryman
(20516, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "skeleton_clan", 300, "null", 0, 0, "fighter"), -- Skeleton Sentinel
(20517, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "skeleton_clan", 300, "null", 0, 0, "fighter"), -- Skeleton Hunter
(20518, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "skeleton_clan", 300, "null", 0, 15, "archer"), -- Skeleton Hunter Archer
(20519, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "skeleton_clan", 300, "null", 0, 0, "fighter"), -- Skeleton Pikeman
(20520, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Pirate Captain Uthanka
(20521, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Whinstone Golem
(20522, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- White Fang
(20524, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Grey Wolf Elder
(20525, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gray Wolf
(20526, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Obsidian Golem
(20527, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "wolf_clan", 300, "null", 0, 0, "fighter"), -- Great Snow Wolf
(20528, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Goblin Lord
(20529, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Young Brown Keltir
(20530, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Young Red Keltir
(20531, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Young Prairie Keltir
(20532, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Brown Keltir
(20533, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Longtail Keltir
(20534, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Red Keltir
(20535, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Prairie Keltir
(20536, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Elder Brown Keltir
(20537, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Elder Red Keltir
(20538, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Elder Prairie Keltir
(20539, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Elder Longtail Keltir
(20540, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gemstone Beast
(20541, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ore Bat
(20542, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 15, "archer"), -- Skeleton Longbowman
(20543, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Ghost
(20544, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Elder Keltir
(20545, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Young Keltir
(20546, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "orc_clan", 300, "null", 0, 0, "balanced"), -- Turek Orc Elder
(20547, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ol_mahum_clan", 300, "null", 0, 0, "fighter"), -- Ol Mahum Reserve
(20548, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "ol_mahum_clan", 300, "null", 0, 0, "fighter"), -- Ol Mahum Deserter
(20549, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "ol_mahum_clan", 300, "null", 0, 0, "fighter"), -- Ol Mahum Lord
(20550, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian Basilisk
(20551, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Road Scavenger
(20552, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Fettered Soul
(20553, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Windsus
(20554, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Grandis
(20555, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Giant Fungus
(20556, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Giant Monstereye
(20557, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Dire Wyrm
(20558, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Rotting tree
(20559, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Rotting Golem
(20560, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Trisalim Spider
(20561, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Trisalim Tarantula
(20562, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Spore Zombie
(20563, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Manashen Gargoyle
(20564, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Enchanted Monstereye
(20565, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Enchanted Stone Golem
(20566, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Enchanted Iron Golem
(20567, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Enchanted Gargoyle
(20568, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "beast_clan", 300, "null", 0, 0, "fighter"), -- Formor
(20569, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "beast_clan", 300, "null", 0, 0, "fighter"), -- Formor Elder
(20570, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "bugbear_clan", 300, "null", 0, 0, "fighter"), -- Tarlk Bugbear
(20571, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "bugbear_clan", 300, "null", 0, 0, "fighter"), -- Tarlk Bugbear Warrior
(20572, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "bugbear_clan", 300, "null", 0, 0, "fighter"), -- Tarlk Bugbear High Warrior
(20573, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tarlk Basilisk
(20574, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Elder Tarlk Basilisk
(20575, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "oel_mahum_clan", 300, "null", 0, 0, "fighter"), -- Oel Mahum Warrior
(20576, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "oel_mahum_clan", 300, "null", 0, 0, "mage"), -- Oel Mahum Witch Doctor
(20577, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "lizardman_clan", 300, "null", 0, 0, "fighter"), -- Leto Lizardman
(20578, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "lizardman_clan", 300, "null", 0, 15, "archer"), -- Leto Lizardman Archer
(20579, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "lizardman_clan", 300, "null", 0, 0, "fighter"), -- Leto Lizardman Soldier
(20580, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "lizardman_clan", 300, "null", 0, 0, "fighter"), -- Leto Lizardman Warrior
(20581, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "lizardman_clan", 300, "null", 0, 0, "balanced"), -- Leto Lizardman Shaman
(20582, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "lizardman_clan", 300, "null", 0, 0, "fighter"), -- Leto Lizardman Overlord
(20583, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Timak Orc
(20584, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "orc_clan", 300, "null", 0, 15, "archer"), -- Timak Orc Archer
(20585, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Timak Orc Soldier
(20586, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Timak Orc Warrior
(20587, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "orc_clan", 300, "null", 0, 0, "balanced"), -- Timak Orc Shaman
(20588, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Timak Orc Overlord
(20589, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "elemental_clan", 400, "null", 0, 0, "balanced"), -- Fline
(20590, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "elemental_clan", 300, "null", 0, 0, "balanced"), -- Liele
(20591, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "elemental_clan", 300, "null", 0, 0, "fighter"), -- Valley Treant
(20592, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "elemental_clan", 300, "null", 0, 0, "fighter"), -- Satyr
(20593, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "elemental_clan", 300, "null", 0, 0, "fighter"), -- Unicorn
(20594, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "elemental_clan", 300, "null", 0, 0, "fighter"), -- Forest Runner
(20595, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "elemental_clan", 300, "null", 0, 0, "balanced"), -- Fline Elder
(20596, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "elemental_clan", 300, "null", 0, 0, "balanced"), -- Liele Elder
(20597, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "elemental_clan", 300, "null", 0, 0, "fighter"), -- Valley Treant Elder
(20598, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "elemental_clan", 300, "null", 0, 0, "fighter"), -- Satyr Elder
(20599, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "elemental_clan", 300, "null", 0, 0, "fighter"), -- Unicorn Elder
(20600, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Karul Bugbear
(20601, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Tamlin Orc
(20602, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "orc_clan", 300, "null", 0, 15, "archer"), -- Tamlin Orc Archer
(20603, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Kronbe Spider
(20604, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lakin
(20605, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Weird Drake
(20606, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "kobold_clan", 300, "null", 0, 0, "fighter"), -- Kuran Kobold
(20607, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "kobold_clan", 300, "null", 0, 0, "fighter"), -- Kuran Kobold Warrior
(20608, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 400, "null", 0, 15, "archer"), -- Patin Archer
(20609, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "elemental_clan", 300, "null", 0, 0, "fighter"), -- Lakin Salamander
(20610, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "elemental_clan", 300, "null", 0, 0, "fighter"), -- Sentinel Of Water
(20611, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "demonic_clan", 300, "null", 0, 0, "fighter"), -- Dre Vanul Warrior
(20612, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "elemental_clan", 300, "null", 0, 0, "fighter"), -- Salamander Rowin
(20613, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "lizardman_clan", 300, "null", 0, 0, "fighter"), -- Lafi Lizardman
(20614, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "lizardman_clan", 300, "null", 0, 0, "fighter"), -- Lafi Lizardman Scout
(20615, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 400, "null", 0, 0, "fighter"), -- Ritmal Swordsman
(20616, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "elemental_clan", 300, "null", 0, 0, "fighter"), -- Lakin Undine
(20617, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 400, "null", 0, 0, "fighter"), -- Sentinel Of Water
(20618, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "demonic_clan", 300, "null", 0, 0, "fighter"), -- Kanil Succubus
(20619, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "elemental_clan", 300, "null", 0, 0, "fighter"), -- Rowin Undine
(20620, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 500, "null", 0, 0, "fighter"), -- Cave Beast
(20621, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 500, "null", 0, 0, "fighter"), -- Death Wave
(20622, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "malruk_clan", 500, "null", 0, 0, "fighter"), -- Maluk Soldier
(20623, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 500, "null", 0, 0, "fighter"), -- Plando
(20624, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 500, "null", 0, 0, "fighter"), -- Cave Howler
(20625, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "malruk_clan", 500, "null", 0, 0, "fighter"), -- Maluk Knight
(20626, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "malruk_clan", 500, "null", 0, 0, "fighter"), -- Maluk Berserker
(20627, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "malruk_clan", 500, "null", 0, 0, "fighter"), -- Maluk Lord
(20628, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "malruk_clan", 500, "null", 0, 0, "fighter"), -- Limal Karinness
(20629, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 500, "null", 0, 0, "fighter"), -- Karik
(20630, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Taik Orc
(20631, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "orc_clan", 300, "null", 0, 15, "archer"), -- Taik Orc Archer
(20632, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "orc_clan", 400, "null", 0, 0, "fighter"), -- Taik Orc Warrior
(20633, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "orc_clan", 300, "null", 0, 0, "balanced"), -- Taik Orc Shaman
(20634, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Taik Orc Captain
(20635, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Carinkain
(20636, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "mirrorforest_clan", 200, "null", 0, 0, "fighter"), -- Forest of Mirrors Ghost
(20637, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "mirrorforest_clan", 200, "null", 0, 0, "fighter"), -- Forest of Mirrors Ghost
(20638, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "mirrorforest_clan", 200, "null", 0, 0, "fighter"), -- Forest of Mirrors Ghost
(20639, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mirror
(20640, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "lizardman_clan", 300, "null", 0, 0, "fighter"), -- Harit Lizardman
(20641, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "lizardman_clan", 300, "null", 0, 0, "fighter"), -- Harit Lizardman Grunt
(20642, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "lizardman_clan", 300, "null", 0, 15, "archer"), -- Harit Lizardman Archer
(20643, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "lizardman_clan", 400, "null", 0, 0, "fighter"), -- Harit Lizardman Warrior
(20644, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "lizardman_clan", 300, "null", 0, 0, "balanced"), -- Harit Lizardman Shaman
(20645, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "lizardman_clan", 300, "null", 0, 0, "fighter"), -- Harit Lizardman Matriarch
(20646, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "beast_clan", 300, "null", 0, 0, "fighter"), -- Halingka
(20647, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "beast_clan", 300, "null", 0, 0, "fighter"), -- Yintzu
(20648, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "beast_clan", 300, "null", 0, 0, "fighter"), -- Paliote
(20649, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "beast_clan", 300, "null", 0, 0, "fighter"), -- Hamrut
(20650, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "beast_clan", 300, "null", 0, 0, "fighter"), -- Kranrot
(20651, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "giant_clan", 400, "null", 0, 0, "fighter"), -- Gamlin
(20652, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "giant_clan", 400, "null", 0, 0, "fighter"), -- Leogul
(20653, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "giant_clan", 300, "null", 0, 0, "fighter"), -- Lesser Giant
(20654, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "giant_clan", 300, "null", 0, 0, "fighter"), -- Lesser Giant Soldier
(20655, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "giant_clan", 300, "null", 0, 0, "fighter"), -- Lesser Giant Shooter
(20656, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "giant_clan", 300, "null", 0, 0, "fighter"), -- Lesser Giant Scout
(20657, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "giant_clan", 300, "null", 0, 0, "mage"), -- Lesser Giant Mage
(20658, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "giant_clan", 300, "null", 0, 0, "mage"), -- Lesser Giant Elder
(20659, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Grave Wanderer
(20660, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 15, "archer"), -- Archer of Greed
(20661, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "hatar_clan", 300, "null", 0, 0, "fighter"), -- Hatar Ratman Thief
(20662, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "hatar_clan", 300, "null", 0, 0, "fighter"), -- Hatar Ratman Boss
(20663, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "hatar_clan", 300, "null", 0, 0, "fighter"), -- Hatar Hanishee
(20664, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Deprive
(20665, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Taik Orc Supply
(20666, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Taik Orc Seeker
(20667, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Farcran
(20668, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Grave Guard
(20669, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Taik Orc Supply Leader
(20670, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 200, 0, "null", 300, "null", 0, 0, "fighter"), -- Crimson Drake
(20671, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 200, 0, "null", 300, "null", 0, 0, "fighter"), -- Kadios
(20672, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Trives
(20673, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 300, 0, "null", 300, "null", 0, 0, "fighter"), -- Falibati
(20674, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 300, 0, "doom_clan", 300, "null", 0, 0, "fighter"), -- Doom Knight
(20675, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tairim
(20676, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Judge of Marsh
(20677, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tulben
(20678, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tortured Undead
(20679, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Marsh Stalker
(20680, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Marsh Drake
(20681, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "silenos_clan", 300, "null", 0, 0, "fighter"), -- Vanor Silenos
(20682, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "silenos_clan", 300, "null", 0, 0, "fighter"), -- Vanor Silenos Grunt
(20683, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "silenos_clan", 400, "null", 0, 0, "fighter"), -- Vanor Silenos Scout
(20684, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "silenos_clan", 300, "null", 0, 0, "fighter"), -- Vanor Silenos Warrior
(20685, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "silenos_clan", 300, "null", 0, 0, "balanced"), -- Vanor Silenos Shaman
(20686, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "silenos_clan", 300, "null", 0, 0, "fighter"), -- Vanor Silenos Chieftain
(20738, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "partisan_clan", 300, "null", 0, 0, "fighter"), -- Kobold Looter Bepook
(20739, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "partisan_clan", 300, "null", 0, 0, "fighter"), -- Bepook's Pet
(20742, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "partisan_clan", 300, "null", 0, 0, "fighter"), -- Mystical Weaver
(20743, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "partisan_clan", 300, "null", 0, 0, "fighter"), -- Howler
(20744, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "partisan_clan", 300, "null", 0, 0, "fighter"), -- Red Eye Vampire Bat
(20745, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "ant_clan", 300, "null", 0, 0, "fighter"), -- Gigantiops
(20746, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ant_clan", 300, "null", 0, 0, "fighter"), -- Young Gigantiops
(20747, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "demonic_clan", 300, "null", 0, 0, "fighter"), -- Roxide
(20748, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "demonic_clan", 300, "null", 0, 0, "fighter"), -- Roxide Cohort
(20749, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "demonic_clan", 300, "null", 0, 0, "fighter"), -- Death Fire
(20750, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "demonic_clan", 300, "null", 0, 15, "archer"), -- Fire Archer
(20751, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Snipe
(20752, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Snipe Cohort
(20753, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "undead_clan", 300, "null", 0, 0, "fighter"), -- Dark Lord
(20754, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "undead_clan", 300, "null", 0, 0, "fighter"), -- Dark Knight
(20755, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "ol_mahum_clan", 300, "null", 0, 0, "fighter"), -- Talakin
(20756, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ol_mahum_clan", 300, "null", 0, 15, "archer"), -- Talakin Archer
(20757, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ol_mahum_clan", 300, "null", 0, 0, "fighter"), -- Talakin Raider
(20758, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "cave_servant_clan", 300, "null", 0, 0, "fighter"), -- Dragon Bearer Chief
(20759, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "cave_servant_clan", 300, "null", 0, 0, "fighter"), -- Dragon Bearer Warrior
(20760, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "cave_servant_clan", 300, "null", 0, 15, "archer"), -- Dragon Bearer Archer
(20761, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "malruk_clan", 500, "null", 0, 0, "fighter"), -- Pytan
(20762, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "malruk_clan", 500, "null", 0, 0, "fighter"), -- Pytan Knight
(20763, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "lizardman_clan", 300, "null", 0, 0, "fighter"), -- Lord of the Plains
(20764, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "lizardman_clan", 300, "null", 0, 0, "balanced"), -- Shaman of the Plains
(20765, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "lizardman_clan", 300, "null", 0, 0, "fighter"), -- Warrior of the Plains
(20766, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "lizardman_clan", 300, "null", 0, 0, "fighter"), -- Scout of the Plains
(20767, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Timak Orc Troop Leader
(20768, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "orc_clan", 300, "null", 0, 0, "balanced"), -- Timak Orc Troop Shaman
(20769, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Timak Orc Troop Warrior
(20770, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "orc_clan", 300, "null", 0, 15, "archer"), -- Timak Orc Troop Archer
(20771, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "giant_clan", 400, "null", 0, 0, "mage"), -- Barif
(20772, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "giant_clan", 300, "null", 0, 0, "fighter"), -- Barif's Pet
(20773, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "giant_clan", 300, "null", 0, 0, "balanced"), -- Conjurer Bat Lord
(20774, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "giant_clan", 300, "null", 0, 0, "balanced"), -- Conjurer Bat
(20775, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Bugbear Raider
(20776, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dark Succubus
(20777, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Hunter Bear
(20778, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Ragna Orc Overlord
(20779, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "orc_clan", 300, "null", 0, 0, "balanced"), -- Ragna Orc Priest
(20780, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Bloody Axe Elite
(20781, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "lizardman_clan", 300, "null", 0, 0, "balanced"), -- Delu Lizardman Shaman
(20782, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "ol_mahum_clan", 300, "null", 0, 0, "fighter"), -- Ol Mahum Novice
(20783, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Dread Wolf
(20784, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "lizardman_clan1", 300, "null", 0, 0, "fighter"), -- Tasaba Lizardman
(20785, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "lizardman_clan1", 300, "null", 0, 0, "balanced"), -- Tasaba Lizardman Shaman
(20786, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "lienrik_clan", 300, "null", 0, 0, "fighter"), -- Lienrik
(20787, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "lienrik_clan", 300, "null", 0, 0, "fighter"), -- Lienrik Lad
(20788, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Rakul
(20789, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "croc_clan", 300, "null", 0, 0, "fighter"), -- Crokian
(20790, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "croc_clan", 300, "null", 0, 0, "fighter"), -- Dailaon
(20791, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "croc_clan", 300, "null", 0, 0, "fighter"), -- Crokian Warrior
(20792, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "croc_clan", 300, "null", 0, 0, "fighter"), -- Farhite
(20793, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "croc_clan", 300, "null", 0, 0, "fighter"), -- Nos
(20794, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "stakato_clan", 300, "null", 0, 0, "fighter"), -- Blade Stakato
(20795, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "stakato_clan", 300, "null", 0, 0, "fighter"), -- Blade Stakato Worker
(20796, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "stakato_clan", 300, "null", 0, 0, "fighter"), -- Blade Stakato Warrior
(20797, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "stakato_clan", 300, "null", 0, 0, "fighter"), -- Blade Stakato Drone
(20798, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Water Giant
(20799, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Queen Undine Lad
(20800, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Eva's Seeker
(20801, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "theeder_clan", 300, "null", 0, 0, "fighter"), -- Theeder Piker
(20802, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "theeder_clan", 300, "null", 0, 0, "fighter"), -- Theeder Mage
(20803, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Doll Master
(20804, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "croc_clan2", 300, "null", 0, 0, "fighter"), -- Crokian Lad
(20805, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "croc_clan2", 300, "null", 0, 0, "fighter"), -- Dailaon Lad
(20806, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "croc_clan2", 300, "null", 0, 0, "fighter"), -- Crokian Lad Warrior
(20807, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "croc_clan2", 300, "null", 0, 0, "fighter"), -- Farhite Lad
(20808, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "croc_clan2", 300, "null", 0, 0, "fighter"), -- Nos Lad
(20809, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "tower_ghost_clan", 400, "null", 0, 0, "fighter"), -- Ghost of the Tower
(20810, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "hallate_clan", 400, "null", 0, 0, "balanced"), -- Hallate's Seer
(20811, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "tower_ghost_clan", 400, "null", 0, 0, "balanced"), -- Ghastly Warrior
(20812, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "tower_ghost_clan", 400, "null", 0, 15, "archer"), -- Archer of Despair
(20813, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "tower_ghost_clan", 300, "null", 0, 0, "fighter"), -- Crendion
(20814, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "tower_ghost_clan", 400, "null", 0, 0, "fighter"), -- Blader of Despair
(20815, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "hallate_clan", 400, "null", 0, 0, "fighter"), -- Hound Dog of Hallate
(20816, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "hallate_clan", 400, "null", 0, 0, "balanced"), -- Hallate's Royal Guard
(20817, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "tower_ghost_clan", 400, "null", 0, 0, "fighter"), -- Corrupt Sage
(20818, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "hallate_clan", 400, "null", 0, 0, "fighter"), -- Hallate's Warrior
(20819, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "tower_ghost_clan", 400, "null", 0, 15, "archer"), -- Archer of Abyss
(20820, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "hallate_clan", 400, "null", 0, 0, "fighter"), -- Hallate's Knight
(20821, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "tower_guard_clan", 400, "null", 0, 0, "fighter"), -- Erin Ediunce
(20822, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "hallate_clan", 400, "null", 0, 0, "balanced"), -- Hallate's Maid
(20823, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "tower_guard_clan", 400, "null", 0, 0, "fighter"), -- Platinum Tribe Soldier
(20824, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "hallate_clan", 400, "null", 0, 0, "fighter"), -- Hallate's Commander
(20825, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "hallate_clan", 400, "null", 0, 0, "fighter"), -- Hallate's Inspector
(20826, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "tower_guard_clan", 400, "null", 0, 15, "archer"), -- Platinum Tribe Archer
(20827, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "tower_guard_clan", 400, "null", 0, 0, "fighter"), -- Platinum Tribe Warrior
(20828, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "tower_guard_clan", 400, "null", 0, 0, "mage"), -- Platinum Tribe Shaman
(20829, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "tower_guard_clan", 400, "null", 0, 0, "balanced"), -- Platinum Tribe Overlord
(20830, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "tower_guard_clan", 400, "null", 0, 0, "fighter"), -- Guardian Angel
(20831, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "tower_guard_clan", 400, "null", 0, 0, "fighter"), -- Seal Angel
(20832, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "undead_clan1", 300, "null", 0, 0, "balanced"), -- Zaken's Pikeman
(20833, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "undead_clan1", 300, "null", 0, 15, "archer"), -- Zaken's Archer
(20834, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Mardian
(20835, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "balanced"), -- Zaken's Seer
(20836, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "undead_clan1", 300, "null", 0, 0, "fighter"), -- Pirate Zombie
(20837, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "undead_clan1", 300, "null", 0, 0, "fighter"), -- Tainted Ogre
(20838, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Bloody Bat
(20839, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "undead_clan", 300, "null", 0, 0, "balanced"), -- Unpleasant Humming
(20840, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "undead_clan", 300, "null", 0, 0, "balanced"), -- Death Flyer
(20841, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "demonic_clan", 300, "null", 0, 15, "archer"), -- Fiend Archer
(20842, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "undead_clan", 300, "null", 0, 0, "balanced"), -- Musveren
(20843, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "undead_clan", 300, "null", 0, 0, "balanced"), -- Zaken's Royal Guard
(20844, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "demonic_clan", 300, "null", 0, 0, "balanced"), -- Kaim Vanul
(20845, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "zaken_clan", 300, "null", 0, 0, "balanced"), -- Pirate Zombie Captain
(20846, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "zaken_clan", 300, "null", 0, 0, "balanced"), -- Doll Blader
(20847, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "zaken_clan", 300, "null", 0, 0, "balanced"), -- Veil Master
(20848, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Light Bringer
(20849, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Light Worm
(20850, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Golden Stag Lord
(20851, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Theeder
(20852, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Banshee
(20853, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "kel_mahum_clan", 300, "null", 0, 0, "balanced"), -- Kel Mahum
(20854, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "kel_mahum_clan", 300, "null", 0, 0, "fighter"), -- Kel Mahum Warrior
(20855, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "kel_mahum_clan", 300, "null", 0, 15, "archer"), -- Kel Mahum Archer
(20856, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "kel_mahum_clan", 300, "null", 0, 0, "mage"), -- Kel Mahum Shaman
(20857, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "kel_mahum_clan", 300, "null", 0, 0, "fighter"), -- Kel Mahum Champion
(20858, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "tower_guard_clan", 300, "null", 0, 0, "fighter"), -- Angel
(20859, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "tower_guard_clan", 400, "null", 0, 0, "fighter"), -- Guardian Angel
(20860, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "tower_guard_clan", 400, "null", 0, 0, "balanced"), -- Seal Angel
(20861, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "oel_mahum_clan", 300, "null", 0, 0, "fighter"), -- Oel Mahum Champion
(20862, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "demonic_clan", 300, "null", 0, 0, "fighter"), -- Death Lord
(20919, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "lizardman_clan", 300, "null", 0, 0, "fighter"), -- Maille Lizardman
(20920, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "lizardman_clan", 300, "null", 0, 0, "fighter"), -- Maille Lizardman Scout
(20921, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "lizardman_clan", 300, "null", 0, 0, "fighter"), -- Maille Lizardman Guard
(20922, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "lizardman_clan", 300, "null", 0, 0, "fighter"), -- Maille Lizardman Warrior
(20923, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "lizardman_clan", 300, "null", 0, 0, "balanced"), -- Maille Lizardman Shaman
(20924, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "lizardman_clan", 300, "null", 0, 0, "fighter"), -- Maille Lizardman Matriarch
(20925, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "lizardman_clan", 300, "null", 0, 0, "fighter"), -- Giant Araneid
(20926, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "lizardman_clan", 300, "null", 0, 0, "fighter"), -- Poison Araneid
(20927, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "lizardman_clan", 300, "null", 0, 0, "fighter"), -- King of the Araneid
(20928, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "hatu_clan", 300, "null", 0, 0, "fighter"), -- Hatu Weird Bee
(20929, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "hatu_clan", 300, "null", 0, 0, "fighter"), -- Hatu Dire Wolf
(20930, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 300, 0, "hatu_clan", 300, "null", 0, 0, "fighter"), -- Hatu Brown Bear
(20931, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "hatu_clan", 300, "null", 0, 0, "fighter"), -- Hatu Onyx Beast
(20932, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "hatu_clan", 300, "null", 0, 0, "fighter"), -- Hatu Crimson Bear
(20933, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "hatu_clan", 300, "null", 0, 0, "fighter"), -- Hatu Windsus
(20934, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Wasp Worker
(20935, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 300, 0, "null", 300, "null", 0, 0, "fighter"), -- Wasp Leader
(20936, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "silenos_clan", 300, "null", 0, 0, "fighter"), -- Tanor Silenos
(20937, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "silenos_clan", 300, "null", 0, 0, "fighter"), -- Tanor Silenos Grunt
(20938, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "silenos_clan", 300, "null", 0, 0, "fighter"), -- Tanor Silenos Scout
(20939, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "silenos_clan", 300, "null", 0, 0, "fighter"), -- Tanor Silenos Warrior
(20940, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "silenos_clan", 300, "null", 0, 0, "balanced"), -- Tanor Silenos Shaman
(20941, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "silenos_clan", 300, "null", 0, 0, "fighter"), -- Tanor Silenos Chieftain
(20942, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Nightmare Guide
(20943, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Nightmare Keeper
(20944, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Nightmare Lord
(20945, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "green_clan", 300, "null", 0, 0, "fighter"), -- Cadeine
(20946, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "green_clan", 300, "null", 0, 0, "fighter"), -- Sanhidro
(20947, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "green_clan", 300, "null", 0, 0, "fighter"), -- Connabi
(20948, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "green_clan", 300, "null", 0, 0, "fighter"), -- Bartal
(20949, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "green_clan", 300, "null", 0, 0, "fighter"), -- Luminun
(20950, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "green_clan", 300, "null", 0, 0, "fighter"), -- Innersen
(20951, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "green_clan", 300, "null", 0, 0, "fighter"), -- Pobby's Maid
(20952, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "green_clan", 300, "null", 0, 0, "fighter"), -- Pobby Escort
(20953, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "green_clan", 300, "null", 0, 0, "fighter"), -- Pobby
(20954, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "bloody_clan", 300, "null", 0, 0, "fighter"), -- Hungered Corpse
(20955, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "bloody_clan", 300, "null", 0, 0, "fighter"), -- Ghostly Warrior
(20956, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "bloody_clan", 300, "null", 0, 0, "fighter"), -- Past Knight
(20957, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "bloody_clan", 300, "null", 0, 0, "fighter"), -- Nihil Invader
(20958, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "bloody_clan", 300, "null", 0, 0, "fighter"), -- Death Agent
(20959, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "bloody_clan", 300, "null", 0, 0, "fighter"), -- Dark Guard
(20960, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "bloody_clan", 300, "null", 0, 0, "fighter"), -- Bloody Ghost
(20961, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "bloody_clan", 300, "null", 0, 0, "fighter"), -- Bloody Knight
(20962, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "bloody_clan", 300, "null", 0, 0, "balanced"), -- Bloody Priest
(20963, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "bloody_clan", 300, "null", 0, 0, "fighter"), -- Bloody Lord
(20964, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Huge Footmark
(20965, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Chimera Piece
(20966, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Changed Creation
(20967, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ancient Creature
(20968, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Forgotten Face
(20969, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Giant's Shadow
(20970, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Soldier of Ancient Times
(20971, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Warrior of Ancient Times
(20972, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Shaman of Ancient Times
(20973, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Forgotten Ancient People
(20974, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "undead_clan", 300, "null", 0, 0, "fighter"), -- Spiteful Soul Leader
(20975, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Spiteful Soul Wizard
(20976, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Spiteful Soul Fighter
(20977, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "tower_ghost_clan", 400, "null", 0, 0, "fighter"), -- Elmoreden's Lady
(20978, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "tower_ghost_clan", 400, "null", 0, 15, "archer"), -- Elmoreden's Archer Escort
(20979, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "tower_ghost_clan", 400, "null", 0, 0, "fighter"), -- Elmoreden's Maid
(20980, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "hallate_clan", 400, "null", 0, 0, "fighter"), -- Hallate's Follower Mul
(20981, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "hallate_clan", 400, "null", 0, 0, "fighter"), -- Mul's Wizard
(20982, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "hallate_clan", 400, "null", 0, 0, "fighter"), -- Mul's Knight
(20983, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "tower_guard_clan", 400, "null", 0, 0, "fighter"), -- Binder
(20984, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "tower_guard_clan", 50, "null", 0, 0, "fighter"), -- Bound Warrior
(20985, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "tower_guard_clan", 50, "null", 0, 15, "archer"), -- Bound Archer
(20986, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "demonic_clan", 300, "null", 0, 0, "fighter"), -- Sairon
(20987, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sairon's Doll
(20988, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sairon's Puppet
(20989, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lageos
(20990, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Pageos
(20991, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "croc_clan", 300, "null", 0, 0, "fighter"), -- Swamp Tribe
(20992, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Swamp Alligator
(20993, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Swamp Warrior
(20994, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "theeder_clan", 300, "null", 0, 0, "fighter"), -- Garden Guard Leader
(20995, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Garden Guard
(20996, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "undead_clan", 300, "null", 0, 0, "fighter"), -- Spiteful Ghost of Ruins
(20997, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "undead_clan", 300, "null", 0, 0, "fighter"), -- Soldier of Grief
(20998, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "undead_clan", 300, "null", 0, 0, "fighter"), -- Cruel Punisher
(20999, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "undead_clan", 300, "null", 0, 0, "fighter"), -- Roving Soul
(21000, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "undead_clan", 300, "null", 0, 0, "fighter"), -- Soul of Ruins
(21001, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "undead_clan", 300, "null", 0, 15, "archer"), -- Wretched Archer
(21002, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "doom_clan", 300, "null", 0, 0, "fighter"), -- Doom Scout
(21003, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "undead_clan", 300, "null", 0, 0, "fighter"), -- Grave Lich
(21004, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "undead_clan", 300, "null", 0, 0, "fighter"), -- Dismal Pole
(21005, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Grave Predator
(21006, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "doom_clan", 300, "null", 0, 0, "fighter"), -- Doom Servant
(21007, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "doom_clan", 300, "null", 0, 0, "fighter"), -- Doom Guard
(21008, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "doom_clan", 300, "null", 0, 15, "archer"), -- Doom Archer
(21009, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "doom_clan", 300, "null", 0, 0, "fighter"), -- Doom Trooper
(21010, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "doom_clan", 300, "null", 0, 0, "fighter"), -- Doom Warrior
(21011, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "wererat_clan", 300, "null", 0, 0, "fighter"), -- Ol Mahum Van Grunt
(21012, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Magical Eye
(21013, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "wererat_clan", 300, "null", 0, 15, "archer"), -- Ol Mahum Van Archer
(21014, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "kinpin_clan", 300, "null", 0, 0, "fighter"), -- Lesser Warlike Tyrant
(21015, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "wererat_clan", 300, "null", 0, 0, "fighter"), -- Ol Mahum Van Leader
(21016, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "kinpin_clan", 300, "null", 0, 0, "fighter"), -- Warlike Tyrant
(21017, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Fallen Orc
(21018, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Ancient Gargoyle
(21019, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "orc_clan", 300, "null", 0, 15, "archer"), -- Fallen Orc Archer
(21020, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "orc_clan", 300, "null", 0, 0, "balanced"), -- Fallen Orc Shaman
(21021, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "beast_clan", 300, "null", 0, 0, "fighter"), -- Sharp Talon Tiger
(21022, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Fallen Orc Captain
(21023, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "elemental2_clan", 300, "null", 0, 0, "fighter"), -- Sobbing Wind
(21024, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "elemental2_clan", 300, "null", 0, 0, "fighter"), -- Babbling Wind
(21025, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "elemental2_clan", 300, "null", 0, 0, "fighter"), -- Giggling Wind
(21026, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "elemental2_clan", 300, "null", 0, 0, "fighter"), -- Singing Wind
(21034, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "lizardman_clan1", 300, "null", 0, 0, "fighter"), -- Ogre
(21035, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "porta_clan", 300, "null", 0, 0, "fighter"), -- Catherok
(21036, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "porta_clan", 300, "null", 0, 0, "fighter"), -- Shindebarn
(21037, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "torfe_clan", 300, "null", 0, 0, "fighter"), -- Ossiud
(21038, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "undead_clan", 300, "null", 0, 0, "fighter"), -- Liangma
(21039, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Snipe Cohort
(21040, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "undead_clan", 300, "null", 0, 0, "fighter"), -- Soldier of Darkness
(21058, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "beast_clan", 400, "null", 0, 0, "fighter"), -- Beast Lord
(21059, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "beast_clan", 300, "null", 0, 0, "fighter"), -- Beast Guardian
(21060, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "beast_clan", 300, "null", 0, 0, "fighter"), -- Beast Seer
(21061, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "hallate_clan", 400, "null", 0, 0, "fighter"), -- Hallate's Guardian
(21062, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "tower_guard_clan", 400, "null", 0, 0, "fighter"), -- Messenger Angel
(21063, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "tower_guard_clan", 400, "null", 0, 0, "balanced"), -- Messenger Angel
(21064, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "tower_guard_clan", 400, "null", 0, 15, "archer"), -- Platinum Guardian Archer
(21065, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "tower_guard_clan", 400, "null", 0, 0, "balanced"), -- Platinum Guardian Warrior
(21066, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "tower_guard_clan", 400, "null", 0, 0, "mage"), -- Platinum Guardian Shaman
(21067, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "tower_guard_clan", 400, "null", 0, 0, "fighter"), -- Guardian Archangel
(21068, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "tower_guard_clan", 400, "null", 0, 0, "fighter"), -- Guardian Archangel
(21069, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "tower_guard_clan", 400, "null", 0, 0, "fighter"), -- Platinum Guardian Prefect
(21070, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "tower_guard_clan", 400, "null", 0, 0, "fighter"), -- Seal Archangel
(21071, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "tower_guard_clan", 400, "null", 0, 0, "balanced"), -- Seal Archangel
(21072, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "tower_guard_clan", 400, "null", 0, 0, "mage"), -- Platinum Guardian Chief
(21073, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "tower_ghost_clan", 400, "null", 0, 0, "fighter"), -- Elmoreden's Guardian Warrior
(21074, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "tower_guard_clan", 400, "null", 0, 0, "mage"), -- Bound Shaman
(21075, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "hallate_clan", 200, "null", 0, 0, "fighter"), -- Slaughter Bathin
(21076, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "hallate_clan", 200, "null", 0, 0, "fighter"), -- Bathin's Knight
(21077, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "hallate_clan", 200, "null", 0, 0, "fighter"), -- Bathin's Wizard
(21078, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "hallate_clan", 200, "null", 0, 0, "fighter"), -- Magus Valac
(21079, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "hallate_clan", 200, "null", 0, 0, "fighter"), -- Valac's Creature
(21080, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "hallate_clan", 200, "null", 0, 0, "balanced"), -- Valac's Guardian Spirit
(21081, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "tower_guard_clan", 200, "null", 0, 0, "fighter"), -- Power Angel Amon
(21082, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "tower_guard_clan", 200, "null", 0, 0, "fighter"), -- Amon's Captain of the Guards
(21083, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "tower_guard_clan", 200, "null", 0, 0, "fighter"), -- Amon's Spirits
(21084, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "bloody_clan", 400, "null", 0, 0, "fighter"), -- Bloody Lady
(21085, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "bloody_clan", 400, "null", 0, 15, "archer"), -- Bloody Sniper
(21086, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "bloody_clan", 400, "null", 0, 0, "fighter"), -- Bloody Liviona
(21087, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "bloody_clan", 400, "null", 0, 0, "fighter"), -- Bloody Knight
(21088, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "bloody_clan", 400, "null", 0, 0, "fighter"), -- Bloody Banshee
(21089, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "bloody_clan", 400, "null", 0, 0, "fighter"), -- Bloody Lord
(21090, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "bloody_clan", 400, "null", 0, 0, "fighter"), -- Bloody Guardian
(21091, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "bloody_clan", 400, "null", 0, 0, "fighter"), -- Bloody Keeper
(21092, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "bloody_clan", 400, "null", 0, 0, "fighter"), -- Bloody Mystic
(21093, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 400, 0, "wererat_clan", 300, "null", 0, 0, "fighter"), -- Ratman Sub Chieftain
(21094, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "wererat_clan", 300, "null", 0, 0, "fighter"), -- Ratman Chieftain
(21095, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Giant Poison Bee
(21096, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 400, 0, "beast_clan", 300, "null", 0, 0, "fighter"), -- Cloudy Beast
(21097, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 400, 0, "null", 300, "null", 0, 0, "fighter"), -- Young Araneid
(21098, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Plain Grizzly
(21099, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 400, 0, "beast_clan", 300, "null", 0, 0, "fighter"), -- Cloudy Beast Turen
(21100, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "lizardman_clan", 300, "null", 0, 0, "fighter"), -- Langk Lizardman Sentinel
(21101, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "lizardman_clan", 300, "null", 0, 0, "balanced"), -- Langk Lizardman Shaman
(21102, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "monster_eye_clan", 300, "null", 0, 0, "fighter"), -- Watchman of the Plains
(21103, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Roughly Hewn Rock Golem
(21104, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Delu Lizardman Supplier
(21105, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Delu Lizardman Special Agent
(21106, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "monster_eye_clan", 300, "null", 0, 0, "fighter"), -- Cursed Seer
(21107, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Delu Lizardman Commander
(21108, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Glow Wisp
(21109, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "orc_clan", 400, "null", 0, 0, "balanced"), -- Hames Orc Scout
(21110, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 200, "null", 0, 0, "fighter"), -- Marsh Predator
(21111, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Lava Wyrm
(21112, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Hames Orc Footsoldier
(21113, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "orc_clan", 300, "null", 0, 15, "archer"), -- Hames Orc Sniper
(21114, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 200, "null", 0, 0, "fighter"), -- Cursed Guardian
(21115, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "orc_clan", 400, "null", 0, 0, "balanced"), -- Hames Orc Shaman
(21116, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "orc_clan", 500, "null", 0, 0, "fighter"), -- Hames Orc Overlord
(21117, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kasha Imp
(21118, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 400, 0, "demonic_clan", 300, "null", 0, 0, "fighter"), -- Baar Dre Vanul
(21119, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "goblin_clan", 300, "null", 0, 0, "fighter"), -- Hobgoblin
(21120, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 400, 0, "null", 300, "null", 0, 0, "fighter"), -- Kasha Imp Turen
(21121, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 400, 0, "null", 300, "null", 0, 0, "fighter"), -- Kasha Dire Wolf
(21122, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 400, 0, "null", 300, "null", 0, 0, "fighter"), -- Kasha Bugbear
(21123, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 400, 0, "demonic_clan", 300, "null", 0, 0, "fighter"), -- Baar Dre Vanul Destroyer
(21124, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Red Eye Barbed Bat
(21125, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 400, 0, "null", 300, "null", 0, 0, "fighter"), -- Northern Trimden
(21126, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "werewolf_clan", 300, "null", 0, 0, "fighter"), -- Kerope Werewolf
(21127, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "goblin_clan", 300, "null", 0, 0, "fighter"), -- Northern Goblin
(21128, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Spine Golem
(21129, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 400, 0, "werewolf_clan", 300, "null", 0, 0, "fighter"), -- Kerope Werewolf Chief
(21130, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 400, 0, "goblin_clan", 300, "null", 0, 0, "fighter"), -- Northern Goblin Leader
(21131, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Enchanted Spine Golem
(21132, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "kobold_clan", 300, "null", 0, 0, "fighter"), -- Underground Kobold
(21133, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "undead_clan", 300, "null", 0, 15, "archer"), -- Dead Pit Skeleton Archer
(21134, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 400, 0, "undead_clan", 300, "null", 0, 0, "fighter"), -- Dead Pit Spartoi
(21135, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "kobold_clan", 300, "null", 0, 0, "fighter"), -- Underground Kobold Warrior
(21136, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "undead_clan", 300, "null", 0, 0, "fighter"), -- Dead Pit Horror
(21137, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 400, 0, "null", 300, "null", 0, 0, "fighter"), -- Iron Ore Golem
(21138, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "undead_clan", 300, "null", 0, 0, "fighter"), -- Greedy Geist
(21139, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Catacomb Barbed Bat
(21140, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Catacomb Wisp
(21141, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Catacomb Serpent
(21142, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Grave Keeper Spartoi
(21143, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Catacomb Scavenger Bat
(21144, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Catacomb Shadow
(21145, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Catacomb Stakato Soldier
(21146, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Grave Keeper Dark Horror
(21147, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Catacomb Gargoyle
(21148, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Catacomb Liviona
(21149, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Decayed Ancient Pikeman
(21150, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Decayed Ancient Soldier
(21151, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Decayed Ancient Knight
(21152, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Purgatory Wisp
(21153, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Purgatory Serpent
(21154, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Hell Keeper Medusa
(21155, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Purgatory Conjurer
(21156, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Purgatory Shadow
(21157, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Purgatory Tarantula
(21158, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Hell Keeper Crimson Doll
(21159, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Purgatory Gargoyle
(21160, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Purgatory Liviona
(21161, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Lesser Ancient Soldier
(21162, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Lesser Ancient Scout
(21163, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Lesser Ancient Shaman
(21164, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Guardian Spirit of Ancient Holy Ground
(21165, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Lesser Ancient Warrior
(21166, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 400, "null", 0, 0, "fighter"), -- Lith Scout
(21167, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 400, "null", 0, 0, "fighter"), -- Lith Witch
(21168, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 400, "null", 0, 0, "fighter"), -- Lith Warrior
(21169, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 400, "null", 0, 0, "fighter"), -- Lith Guard
(21170, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 400, "null", 0, 0, "fighter"), -- Lith Medium
(21171, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 400, "null", 0, 0, "fighter"), -- Lith Overlord
(21172, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 400, "null", 0, 0, "fighter"), -- Lith Patrolman
(21173, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 400, "null", 0, 0, "fighter"), -- Lith Shaman
(21174, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 400, "null", 0, 0, "fighter"), -- Lith Commander
(21175, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 400, "null", 0, 0, "fighter"), -- Lilim Butcher
(21176, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 400, "null", 0, 0, "mage"), -- Lilim Magus
(21177, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 400, "null", 0, 0, "fighter"), -- Lilim Knight-Errant
(21178, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 400, "null", 0, 0, "fighter"), -- Lilim Marauder
(21179, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 400, "null", 0, 0, "balanced"), -- Lilim Priest
(21180, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 400, "null", 0, 0, "fighter"), -- Lilim Knight
(21181, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 400, "null", 0, 0, "fighter"), -- Lilim Assassin
(21182, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 400, "null", 0, 0, "balanced"), -- Lilim Soldier
(21183, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 400, "null", 0, 0, "fighter"), -- Lilim Knight Commander
(21184, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 400, "null", 0, 0, "fighter"), -- Lilim Slayer
(21185, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 400, "null", 0, 0, "mage"), -- Lilim Great Magus
(21186, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 400, "null", 0, 0, "fighter"), -- Lilim Guard Knight
(21187, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 400, "null", 0, 0, "fighter"), -- Gigant Slave
(21188, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 400, "null", 0, 0, "fighter"), -- Gigant Acolyte
(21189, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 400, "null", 0, 0, "fighter"), -- Gigant Overseer
(21190, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 400, "null", 0, 0, "fighter"), -- Gigant Footman
(21191, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 400, "null", 0, 0, "fighter"), -- Gigant Cleric
(21192, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 400, "null", 0, 0, "fighter"), -- Gigant Officer
(21193, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 400, "null", 0, 0, "fighter"), -- Gigant Raider
(21194, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 400, "null", 0, 0, "fighter"), -- Gigant Confessor
(21195, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 400, "null", 0, 0, "fighter"), -- Gigant Commander
(21196, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 400, "null", 0, 0, "fighter"), -- Nephilim Sentinel
(21197, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 400, "null", 0, 0, "fighter"), -- Nephilim Priest
(21198, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 400, "null", 0, 0, "fighter"), -- Nephilim Swordsman
(21199, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 400, "null", 0, 0, "fighter"), -- Nephilim Guard
(21200, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 400, "null", 0, 0, "fighter"), -- Nephilim Bishop
(21201, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 400, "null", 0, 0, "fighter"), -- Nephilim Centurion
(21202, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 400, "null", 0, 0, "fighter"), -- Nephilim Scout
(21203, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 400, "null", 0, 0, "fighter"), -- Nephilim Archbishop
(21204, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 400, "null", 0, 0, "fighter"), -- Nephilim Praetorian
(21205, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 400, "null", 0, 0, "fighter"), -- Nephilim Royal Guard
(21206, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 400, "null", 0, 0, "fighter"), -- Nephilim Cardinal
(21207, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 400, "null", 0, 0, "fighter"), -- Nephilim Commander
(21208, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Hallowed Watchman
(21209, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Hallowed Seer
(21210, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Vault Guardian
(21211, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Vault Seer
(21212, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Hallowed Sentinel
(21213, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Hallowed Monk
(21214, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Vault Sentinel
(21215, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Vault Monk
(21216, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Overlord of the Holy Lands
(21217, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Hallowed Priest
(21218, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Vault Overlord
(21219, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Vault Priest
(21220, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Sepulcher Archon
(21221, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Sepulcher Inquisitor
(21222, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Sepulcher Archon
(21223, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Sepulcher Inquisitor
(21224, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Sepulcher Guardian
(21225, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Sepulcher Sage
(21226, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Sepulcher Guardian
(21227, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Sepulcher Sage
(21228, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Sepulcher Guard
(21229, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Sepulcher Preacher
(21230, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Sepulcher Guard
(21231, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Sepulcher Preacher
(21232, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Barrow Guardian
(21233, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Barrow Seer
(21234, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Grave Guardian
(21235, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Grave Seer
(21236, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Barrow Sentinel
(21237, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Barrow Monk
(21238, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Grave Sentinel
(21239, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Grave Monk
(21240, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Barrow Overlord
(21241, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Barrow Priest
(21242, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Grave Overlord
(21243, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Grave Priest
(21244, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Crypt Archon
(21245, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Crypt Inquisitor
(21246, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Tomb Archon
(21247, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Tomb Inquisitor
(21248, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Crypt Guardian
(21249, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Crypt Sage
(21250, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Tomb Guardian
(21251, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Tomb Sage
(21252, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Crypt Guard
(21253, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Crypt Preacher
(21254, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Tomb Guard
(21255, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "c_dungeon_clan", 300, "null", 0, 0, "fighter"), -- Tomb Preacher
(21256, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 400, 0, "null", 600, "null", 0, 0, "fighter"), -- Underground Werewolf
(21257, 7, 15, 0, 800, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 600, "null", 0, 0, "fighter"), -- Evil Eye Seer
(21258, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 1000, "null", 0, 0, "balanced"), -- Fallen Orc Shaman
(21259, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "beast_clan", 1000, "null", 0, 0, "fighter"), -- Fallen Orc Shaman
(21260, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 1000, "null", 0, 0, "fighter"), -- Betrayer Orc Hero
(21261, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 1000, "null", 0, 0, "fighter"), -- Ol Mahum Transcender
(21262, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 1000, "null", 0, 0, "fighter"), -- Ol Mahum Transcender
(21263, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 1000, "null", 0, 0, "fighter"), -- Ol Mahum Transcender
(21264, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 1000, "null", 0, 0, "fighter"), -- Ol Mahum Transcender
(21265, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ant_clan", 500, "null", 0, 0, "fighter"), -- Cave Ant Larva
(21266, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ant_clan", 500, "null", 0, 0, "fighter"), -- Cave Ant Larva
(21267, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ant_clan", 500, "null", 0, 0, "fighter"), -- Cave Ant Larva
(21268, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ant_clan", 500, "null", 0, 0, "fighter"), -- Cave Ant Larva
(21269, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "ant_clan", 300, "null", 0, 0, "fighter"), -- Cave Ant
(21270, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "ant_clan", 300, "null", 0, 0, "fighter"), -- Cave Ant Soldier
(21271, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "ant_clan", 300, "null", 0, 0, "fighter"), -- Cave Ant
(21272, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "ant_clan", 300, "null", 0, 0, "fighter"), -- Cave Ant Soldier
(21273, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "ant_clan", 300, "null", 0, 0, "fighter"), -- Cave Noble Ant
(21274, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "animal_clan", 300, "null", 0, 0, "fighter"), -- Kookaburra
(21275, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "animal_clan", 300, "null", 0, 0, "fighter"), -- Kookaburra
(21276, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "animal_clan", 300, "null", 0, 0, "fighter"), -- Kookaburra
(21278, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "antelope_clan", 300, "null", 0, 0, "fighter"), -- Antelope
(21279, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "antelope_clan", 300, "null", 0, 0, "fighter"), -- Antelope
(21280, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "antelope_clan", 300, "null", 0, 0, "fighter"), -- Antelope
(21282, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "bandersnatch_clan", 300, "null", 0, 0, "fighter"), -- Bandersnatch
(21283, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "bandersnatch_clan", 300, "null", 0, 0, "fighter"), -- Bandersnatch
(21284, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "bandersnatch_clan", 300, "null", 0, 0, "fighter"), -- Bandersnatch
(21286, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "buffalo_clan", 300, "null", 0, 0, "fighter"), -- Buffalo
(21287, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "buffalo_clan", 300, "null", 0, 0, "fighter"), -- Buffalo
(21288, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "buffalo_clan", 300, "null", 0, 0, "fighter"), -- Buffalo
(21290, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "grendel_clan", 300, "null", 0, 0, "fighter"), -- Grendel
(21291, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "grendel_clan", 300, "null", 0, 0, "fighter"), -- Grendel
(21292, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "grendel_clan", 300, "null", 0, 0, "fighter"), -- Grendel
(21294, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Canyon Antelope
(21295, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 300, 0, "eye_clan", 400, "null", 0, 0, "fighter"), -- Canyon Antelope Slave
(21296, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 300, 0, "null", 300, "null", 0, 0, "fighter"), -- Canyon Bandersnatch
(21297, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 200, 0, "eye_clan", 400, "null", 0, 0, "fighter"), -- Canyon Bandersnatch Slave
(21298, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "eye_clan", 400, "null", 0, 0, "balanced"), -- Eye of Restrainer
(21299, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 300, 0, "eye_clan", 400, "null", 0, 0, "fighter"), -- Buffalo Slave
(21300, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "eye_clan", 400, "null", 0, 0, "balanced"), -- Eye of Guide
(21301, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "eye_clan", 400, "null", 0, 0, "balanced"), -- Gaze of Nightmare
(21302, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 300, 0, "eye_clan", 400, "null", 0, 0, "fighter"), -- Eye of Watchman
(21303, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "eye_clan", 400, "null", 0, 0, "fighter"), -- Homunculus
(21304, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 200, 0, "eye_clan", 400, "null", 0, 0, "fighter"), -- Grendel Slave
(21305, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "eye_clan", 400, "null", 0, 0, "balanced"), -- Eye of Pilgrim
(21306, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "divine_clan", 600, "null", 0, 0, "fighter"), -- Disciples of Protection
(21307, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "eye_clan", 400, "null", 0, 0, "fighter"), -- Elder Homunculus
(21308, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "divine_clan", 600, "null", 0, 0, "fighter"), -- Disciples of Punishment
(21309, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "divine_clan", 600, "null", 0, 0, "fighter"), -- Disciples of Punishment
(21310, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "divine_clan", 600, "null", 0, 0, "mage"), -- Disciples of Authority
(21311, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "divine_clan", 600, "null", 0, 0, "mage"), -- Disciples of Authority
(21312, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 300, 0, "eye_clan", 400, "null", 0, 0, "balanced"), -- Eye of Ruler
(21313, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sly Hound Dog
(21314, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 400, 0, "null", 300, "null", 0, 0, "fighter"), -- Hot Springs Bandersnatchling
(21315, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Hot Springs Buffalo
(21316, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 450, 0, "null", 300, "null", 0, 0, "fighter"), -- Hot Springs Flava
(21317, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Hot Springs Atroxspawn
(21318, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Hot Springs Antelope
(21319, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 350, 0, "null", 300, "null", 0, 0, "fighter"), -- Hot Springs Nepenthes
(21320, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Hot Springs Yeti
(21321, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Hot Springs Atrox
(21322, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 300, "null", 0, 0, "fighter"), -- Hot Springs Bandersnatch
(21323, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Hot Springs Grendel
(21324, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "ketra_orc_clan", 300, "null", 0, 0, "fighter"), -- Ketra Orc Footman
(21325, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "ketra_orc_clan", 300, "null", 0, 0, "fighter"), -- Ketra's War Hound
(21326, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "balanced"), -- Grazing Kookaburra
(21327, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "ketra_orc_clan", 300, "null", 0, 0, "fighter"), -- Ketra Orc Raider
(21328, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "ketra_orc_clan", 300, "null", 0, 15, "archer"), -- Ketra Orc Scout
(21329, 7, 15, 1, 300, 1, 1, 1, 1, 90, 1, 90, 0, 0, 30, 30, 150, 0, "ketra_orc_clan", 300, "null", 0, 0, "balanced"), -- Ketra Orc Shaman
(21330, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Grazing Buffalo
(21331, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "ketra_orc_clan", 300, "null", 0, 0, "fighter"), -- Ketra Orc Warrior
(21332, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 400, 0, "ketra_orc_clan", 300, "null", 0, 0, "fighter"), -- Ketra Orc Lieutenant
(21333, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "balanced"), -- Grazing Windsus
(21334, 7, 15, 1, 300, 1, 1, 1, 1, 90, 1, 90, 0, 0, 30, 30, 400, 0, "ketra_orc_clan", 300, "null", 0, 0, "balanced"), -- Ketra Orc Medium
(21335, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 300, 0, "ketra_orc_clan", 300, "null", 0, 0, "fighter"), -- Ketra Orc Elite Soldier
(21336, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 300, 0, "ketra_orc_clan", 300, "null", 0, 0, "balanced"), -- Ketra Orc White Captain
(21337, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Grazing Elder Buffalo
(21338, 7, 15, 1, 300, 1, 1, 1, 1, 90, 1, 90, 0, 0, 30, 30, 350, 0, "ketra_orc_clan", 300, "null", 0, 0, "balanced"), -- Ketra Orc Priest
(21339, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ketra_orc_clan", 300, "null", 0, 0, "fighter"), -- Ketra Orc General
(21340, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 60, 60, 150, 0, "ketra_orc_clan", 300, "null", 0, 0, "fighter"), -- Ketra Orc Battalion Commander
(21341, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "balanced"), -- Grazing Elder Kookaburra
(21342, 7, 15, 1, 300, 1, 1, 1, 1, 90, 1, 90, 0, 0, 50, 50, 150, 0, "ketra_orc_clan", 300, "null", 0, 0, "balanced"), -- Ketra Orc Grand Priest
(21343, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ketra_orc_clan", 300, "null", 0, 0, "balanced"), -- Ketra Commander
(21344, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ketra_orc_clan", 300, "null", 0, 0, "fighter"), -- Ketra Elite Guard
(21345, 7, 15, 1, 300, 1, 1, 1, 1, 90, 1, 90, 0, 0, 30, 30, 150, 0, "ketra_orc_clan", 300, "null", 0, 0, "balanced"), -- Ketra's Head Shaman
(21346, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ketra_orc_clan", 300, "null", 0, 0, "fighter"), -- Ketra's Head Guard
(21347, 7, 15, 1, 300, 1, 1, 1, 1, 90, 1, 90, 0, 0, 50, 50, 150, 0, "ketra_orc_clan", 300, "null", 0, 0, "balanced"), -- Ketra Prophet
(21348, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ketra_orc_clan", 300, "null", 0, 0, "fighter"), -- Prophet's Guard
(21349, 7, 15, 1, 300, 1, 1, 1, 1, 90, 1, 90, 0, 0, 30, 30, 0, 0, "ketra_orc_clan", 300, "null", 0, 0, "balanced"), -- Prophet's Aide
(21350, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "varka_silenos_clan", 300, "null", 0, 0, "fighter"), -- Varka Silenos Recruit
(21351, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 400, 0, "varka_silenos_clan", 300, "null", 0, 0, "fighter"), -- Varka Silenos Footman
(21352, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "balanced"), -- Grazing Antelope
(21353, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 350, 0, "varka_silenos_clan", 300, "null", 0, 0, "fighter"), -- Varka Silenos Scout
(21354, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 300, 0, "varka_silenos_clan", 300, "null", 0, 15, "archer"), -- Varka Silenos Hunter
(21355, 7, 15, 1, 300, 1, 1, 1, 1, 90, 1, 90, 0, 0, 30, 30, 300, 0, "varka_silenos_clan", 300, "null", 0, 0, "balanced"), -- Varka Silenos Shaman
(21356, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Grazing Nepenthes
(21357, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 450, 0, "varka_silenos_clan", 300, "null", 0, 0, "balanced"), -- Varka Silenos Priest
(21358, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "varka_silenos_clan", 300, "null", 0, 0, "balanced"), -- Varka Silenos Warrior
(21359, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Grazing Bandersnatch
(21360, 7, 15, 1, 300, 1, 1, 1, 1, 90, 1, 90, 0, 0, 30, 30, 150, 0, "varka_silenos_clan", 300, "null", 0, 0, "balanced"), -- Varka Silenos Medium
(21361, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "varka_silenos_clan", 300, "null", 0, 0, "mage"), -- Varka Silenos Magus
(21362, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "varka_silenos_clan", 300, "null", 0, 0, "fighter"), -- Varka Silenos Officer
(21363, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "balanced"), -- Grazing Flava
(21364, 7, 15, 1, 300, 1, 1, 1, 1, 90, 1, 90, 0, 0, 30, 30, 150, 0, "varka_silenos_clan", 300, "null", 0, 0, "balanced"), -- Varka Silenos Priest
(21365, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "varka_silenos_clan", 300, "null", 0, 0, "balanced"), -- Varka Silenos Great Magus
(21366, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 60, 60, 150, 0, "varka_silenos_clan", 300, "null", 0, 0, "fighter"), -- Varka Silenos General
(21367, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "balanced"), -- Grazing Elder Antelope
(21368, 7, 15, 1, 300, 1, 1, 1, 1, 90, 1, 90, 0, 0, 50, 50, 150, 0, "varka_silenos_clan", 300, "null", 0, 0, "balanced"), -- Varka Silenos Grand Priest
(21369, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "varka_silenos_clan", 300, "null", 0, 0, "fighter"), -- Varka's Commander
(21370, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "varka_silenos_clan", 300, "null", 0, 0, "fighter"), -- Varka's Elite Guard
(21371, 7, 15, 1, 300, 1, 1, 1, 1, 90, 1, 90, 0, 0, 50, 50, 150, 0, "varka_silenos_clan", 300, "null", 0, 0, "balanced"), -- Varka's Head Magus
(21372, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "varka_silenos_clan", 300, "null", 0, 0, "balanced"), -- Varka's Head Guard
(21373, 7, 15, 1, 300, 1, 1, 1, 1, 90, 1, 90, 0, 0, 50, 50, 150, 0, "varka_silenos_clan", 300, "null", 0, 0, "balanced"), -- Varka's Prophet
(21374, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "varka_silenos_clan", 300, "null", 0, 0, "balanced"), -- Prophet's Guard
(21375, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "varka_silenos_clan", 300, "null", 0, 0, "balanced"), -- Disciple of Prophet
(21376, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "fire_clan", 300, "null", 0, 0, "fighter"), -- Scarlet Stakato Worker
(21377, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "fire_clan", 300, "null", 0, 0, "fighter"), -- Scarlet Stakato Soldier
(21378, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 450, 0, "fire_clan", 300, "null", 0, 0, "fighter"), -- Scarlet Stakato Noble
(21379, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "fire_clan", 300, "null", 0, 0, "balanced"), -- Tepra Scorpion
(21380, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "fire_clan", 300, "null", 0, 0, "fighter"), -- Tepra Scarab
(21381, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "fire_clan", 300, "null", 0, 0, "fighter"), -- Assassin Beetle
(21382, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "fire_clan", 300, "null", 0, 0, "fighter"), -- Mercenary of Destruction
(21383, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "fire_clan", 300, "null", 0, 0, "fighter"), -- Knight of Destruction
(21384, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "fire_clan", 300, "null", 0, 0, "fighter"), -- Necromancer of Destruction
(21385, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "fire_clan", 300, "null", 0, 0, "fighter"), -- Lavastone Golem
(21386, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "fire_clan", 300, "null", 0, 0, "balanced"), -- Magma Golem
(21387, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 40, 40, 150, 0, "fire_clan", 300, "null", 0, 0, "fighter"), -- Arimanes of Destruction
(21388, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "fire_clan", 300, "null", 0, 15, "archer"), -- Iblis of Destruction
(21389, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 20, 20, 150, 0, "fire_clan", 300, "null", 0, 0, "fighter"), -- Balor of Destruction
(21390, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "fire_clan", 300, "null", 0, 0, "fighter"), -- Ashuras of Destruction
(21391, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "fire_clan", 300, "null", 0, 0, "fighter"), -- Lavasillisk
(21392, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "fire_clan", 300, "null", 0, 0, "balanced"), -- Blazing Ifrit
(21393, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "fire_clan", 300, "null", 0, 0, "balanced"), -- Magma Drake
(21394, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 20, 20, 400, 0, "fire_clan", 300, "null", 0, 0, "balanced"), -- Lavasaurus
(21395, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "fire_clan", 300, "null", 0, 0, "balanced"), -- Elder Lavasaurus
(21396, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 20, 20, 0, 0, "tomb_clan", 300, "null", 0, 0, "balanced"), -- Carrion Scarab
(21397, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb_clan", 300, "null", 0, 0, "fighter"), -- Carrion Scarab
(21398, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 350, 0, "tomb_clan", 300, "null", 0, 0, "fighter"), -- Soldier Scarab
(21399, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 350, 0, "tomb_clan", 300, "null", 0, 0, "mage"), -- Soldier Scarab
(21400, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 350, 0, "tomb_clan", 300, "null", 0, 0, "fighter"), -- Hexa Beetle
(21401, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 350, 0, "tomb_clan", 300, "null", 0, 0, "fighter"), -- Hexa Beetle
(21402, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "tomb_clan", 300, "null", 0, 0, "balanced"), -- Katraxis
(21403, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "tomb_clan", 300, "null", 0, 0, "balanced"), -- Katraxis
(21404, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb_clan", 300, "null", 0, 0, "balanced"), -- Tera Beetle
(21405, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb_clan", 300, "null", 0, 0, "balanced"), -- Tera Beetle
(21406, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 300, 0, "tomb_clan", 300, "null", 0, 0, "mage"), -- Knight of Empire
(21407, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "tomb_clan", 300, "null", 0, 0, "fighter"), -- Knight of Empire
(21408, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb_clan", 300, "null", 0, 0, "fighter"), -- Royal Guard of Empire
(21409, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "tomb_clan", 300, "null", 0, 0, "balanced"), -- Royal Guard of Empire
(21410, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "tomb_clan", 300, "null", 0, 0, "fighter"), -- Guardian Scarab
(21411, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb_clan", 300, "null", 0, 0, "fighter"), -- Guardian Scarab
(21412, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "tomb_clan", 300, "null", 0, 0, "mage"), -- Ustralith
(21413, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "tomb_clan", 300, "null", 0, 0, "balanced"), -- Ustralith
(21414, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb_clan", 300, "null", 0, 0, "mage"), -- Assassin of Empire
(21415, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "tomb_clan", 300, "null", 0, 0, "balanced"), -- Assassin of Empire
(21416, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 350, 0, "tomb_clan", 300, "null", 0, 0, "mage"), -- Imperial Commander
(21417, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 350, 0, "tomb_clan", 300, "null", 0, 0, "balanced"), -- Imperial Commander
(21418, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb_clan", 300, "null", 0, 0, "fighter"), -- Imperial Royal Guard
(21419, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb_clan", 300, "null", 0, 0, "fighter"), -- Imperial Royal Guard
(21420, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "tomb_clan", 300, "null", 0, 0, "balanced"), -- Ashuras
(21421, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "tomb_clan", 300, "null", 0, 0, "fighter"), -- Ashuras
(21422, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "tomb_clan", 300, "null", 0, 0, "mage"), -- Dancer of Empire
(21423, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "tomb_clan", 300, "null", 0, 0, "mage"), -- Dancer of Empire
(21424, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 350, 0, "tomb_clan", 300, "null", 0, 0, "balanced"), -- Ashkenas
(21425, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 350, 0, "tomb_clan", 300, "null", 0, 0, "balanced"), -- Ashkenas
(21426, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 350, 0, "tomb_clan", 300, "null", 0, 0, "fighter"), -- Abraxion
(21427, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 350, 0, "tomb_clan", 300, "null", 0, 0, "fighter"), -- Abraxion
(21428, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "tomb_clan", 300, "null", 0, 0, "balanced"), -- Hasturan
(21429, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "tomb_clan", 300, "null", 0, 0, "balanced"), -- Hasturan
(21430, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "tomb_clan", 300, "null", 0, 0, "mage"), -- Arimanes
(21431, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "tomb_clan", 300, "null", 0, 0, "fighter"), -- Arimanes
(21432, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb_clan", 300, "null", 0, 0, "fighter"), -- Chakram Beetle
(21433, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Jamadar Beetle
(21434, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb_clan", 300, "null", 0, 0, "fighter"), -- Priest of Blood
(21435, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guide of Offering
(21436, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Leader of Offering
(21437, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Offering Bug
(21438, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "undead_clan", 300, "null", 0, 0, "fighter"), -- Heathen Warrior
(21439, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "undead_clan", 300, "null", 0, 0, "fighter"), -- Heathen Executed
(21440, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "undead_clan", 300, "null", 0, 15, "archer"), -- Heathen Archer
(21441, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "undead_clan", 300, "null", 0, 0, "fighter"), -- Heathen Grunt
(21442, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "undead_clan", 300, "null", 0, 0, "fighter"), -- Heathen Knight
(21443, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "nonpet_clan", 300, "null", 0, 0, "balanced"), -- Raider of Pastureland
(21444, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "nonpet_clan", 300, "null", 0, 0, "balanced"), -- Raider of Pastureland
(21445, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "nonpet_clan", 300, "null", 0, 0, "fighter"), -- Alpine Bandersnatch
(21446, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "nonpet_clan", 300, "null", 0, 0, "balanced"), -- Raider of Pastureland
(21447, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "nonpet_clan", 300, "null", 0, 0, "balanced"), -- Raider of Pastureland
(21448, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "nonpet_clan", 300, "null", 0, 0, "balanced"), -- Raider of Pastureland
(21449, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "nonpet_clan", 300, "null", 0, 0, "balanced"), -- Raider of Pastureland
(21450, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "nonpet_clan", 300, "null", 0, 0, "fighter"), -- Alpine Grendel
(21451, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "pet_clan", 300, "null", 0, 0, "fighter"), -- Alpine Kookaburra
(21452, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "pet_clan", 300, "null", 0, 0, "balanced"), -- Alpine Kookaburra
(21453, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "pet_clan", 300, "null", 0, 0, "balanced"), -- Alpine Kookaburra
(21454, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "pet_clan", 300, "null", 0, 0, "balanced"), -- Alpine Kookaburra
(21455, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "pet_clan", 300, "null", 0, 0, "balanced"), -- Alpine Kookaburra
(21456, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "pet_clan", 300, "null", 0, 0, "balanced"), -- Alpine Kookaburra
(21457, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "pet_clan", 300, "null", 0, 0, "balanced"), -- Alpine Kookaburra
(21458, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "pet_clan", 300, "null", 0, 0, "balanced"), -- Alpine Kookaburra
(21459, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "pet_clan", 300, "null", 0, 0, "balanced"), -- Alpine Kookaburra
(21460, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "pet_clan", 300, "null", 0, 0, "fighter"), -- Alpine Kookaburra
(21461, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "pet_clan", 300, "null", 0, 0, "fighter"), -- Alpine Kookaburra
(21462, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "pet_clan", 300, "null", 0, 0, "fighter"), -- Alpine Kookaburra
(21463, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "pet_clan", 300, "null", 0, 0, "fighter"), -- Alpine Kookaburra
(21464, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "pet_clan", 300, "null", 0, 0, "fighter"), -- Alpine Kookaburra
(21465, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "pet_clan", 300, "null", 0, 0, "fighter"), -- Alpine Kookaburra
(21466, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "pet_clan", 300, "null", 0, 0, "fighter"), -- Alpine Kookaburra
(21467, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "pet_clan", 300, "null", 0, 0, "fighter"), -- Alpine Kookaburra
(21468, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "pet_clan", 300, "null", 0, 0, "fighter"), -- Alpine Kookaburra
(21469, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "pet_clan", 300, "null", 0, 0, "fighter"), -- Alpine Kookaburra
(21470, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "pet_clan", 300, "null", 0, 0, "fighter"), -- Alpine Buffalo
(21471, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "pet_clan", 300, "null", 0, 0, "balanced"), -- Alpine Buffalo
(21472, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "pet_clan", 300, "null", 0, 0, "balanced"), -- Alpine Buffalo
(21473, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "pet_clan", 300, "null", 0, 0, "balanced"), -- Alpine Buffalo
(21474, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "pet_clan", 300, "null", 0, 0, "balanced"), -- Alpine Buffalo
(21475, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "pet_clan", 300, "null", 0, 0, "balanced"), -- Alpine Buffalo
(21476, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "pet_clan", 300, "null", 0, 0, "balanced"), -- Alpine Buffalo
(21477, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "pet_clan", 300, "null", 0, 0, "balanced"), -- Alpine Buffalo
(21478, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "pet_clan", 300, "null", 0, 0, "balanced"), -- Alpine Buffalo
(21479, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "pet_clan", 300, "null", 0, 0, "fighter"), -- Alpine Buffalo
(21480, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "pet_clan", 300, "null", 0, 0, "fighter"), -- Alpine Buffalo
(21481, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "pet_clan", 300, "null", 0, 0, "fighter"), -- Alpine Buffalo
(21482, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "pet_clan", 300, "null", 0, 0, "fighter"), -- Alpine Buffalo
(21483, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "pet_clan", 300, "null", 0, 0, "fighter"), -- Alpine Buffalo
(21484, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "pet_clan", 300, "null", 0, 0, "fighter"), -- Alpine Buffalo
(21485, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "pet_clan", 300, "null", 0, 0, "fighter"), -- Alpine Buffalo
(21486, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "pet_clan", 300, "null", 0, 0, "fighter"), -- Alpine Buffalo
(21487, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "pet_clan", 300, "null", 0, 0, "fighter"), -- Alpine Buffalo
(21488, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "pet_clan", 300, "null", 0, 0, "fighter"), -- Alpine Buffalo
(21489, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "pet_clan", 300, "null", 0, 0, "fighter"), -- Alpine Cougar
(21490, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "pet_clan", 300, "null", 0, 0, "balanced"), -- Alpine Cougar
(21491, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "pet_clan", 300, "null", 0, 0, "balanced"), -- Alpine Cougar
(21492, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "pet_clan", 300, "null", 0, 0, "balanced"), -- Alpine Cougar
(21493, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "pet_clan", 300, "null", 0, 0, "balanced"), -- Alpine Cougar
(21494, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "pet_clan", 300, "null", 0, 0, "balanced"), -- Alpine Cougar
(21495, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "pet_clan", 300, "null", 0, 0, "balanced"), -- Alpine Cougar
(21496, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "pet_clan", 300, "null", 0, 0, "balanced"), -- Alpine Cougar
(21497, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "pet_clan", 300, "null", 0, 0, "balanced"), -- Alpine Cougar
(21498, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "pet_clan", 300, "null", 0, 0, "fighter"), -- Alpine Cougar
(21499, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "pet_clan", 300, "null", 0, 0, "fighter"), -- Alpine Cougar
(21500, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "pet_clan", 300, "null", 0, 0, "fighter"), -- Alpine Cougar
(21501, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "pet_clan", 300, "null", 0, 0, "fighter"), -- Alpine Cougar
(21502, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "pet_clan", 300, "null", 0, 0, "fighter"), -- Alpine Cougar
(21503, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "pet_clan", 300, "null", 0, 0, "fighter"), -- Alpine Cougar
(21504, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "pet_clan", 300, "null", 0, 0, "fighter"), -- Alpine Cougar
(21505, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "pet_clan", 300, "null", 0, 0, "fighter"), -- Alpine Cougar
(21506, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "pet_clan", 300, "null", 0, 0, "fighter"), -- Alpine Cougar
(21507, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "pet_clan", 300, "null", 0, 0, "fighter"), -- Alpine Cougar
(21508, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "stakato_clan", 300, "null", 0, 0, "fighter"), -- Splinter Stakato
(21509, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 20, 20, 150, 0, "stakato_clan", 300, "null", 0, 0, "fighter"), -- Splinter Stakato Worker
(21510, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "stakato_clan", 300, "null", 0, 0, "fighter"), -- Splinter Stakato Soldier
(21511, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "stakato_clan", 300, "null", 0, 0, "fighter"), -- Splinter Stakato Drone
(21512, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "stakato_clan", 300, "null", 0, 0, "balanced"), -- Splinter Stakato Drone
(21513, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "stakatonew_clan", 300, "null", 0, 0, "fighter"), -- Needle Stakato
(21514, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "stakatonew_clan", 300, "null", 0, 0, "fighter"), -- Needle Stakato Worker
(21515, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "stakatonew_clan", 300, "null", 0, 0, "fighter"), -- Needle Stakato Soldier
(21516, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "stakatonew_clan", 300, "null", 0, 0, "fighter"), -- Needle Stakato Drone
(21517, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "stakatonew_clan", 300, "null", 0, 0, "balanced"), -- Needle Stakato Drone
(21518, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Frenzied Stakato Soldier
(21519, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Frenzied Stakato Drone
(21520, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "saint_clan", 300, "null", 0, 0, "fighter"), -- Eye of Splendor
(21521, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "saint_clan", 300, "null", 0, 0, "balanced"), -- Claws of Splendor
(21522, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "saint_clan", 300, "null", 0, 0, "fighter"), -- Claws of Splendor
(21523, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "saint_clan", 300, "null", 0, 0, "mage"), -- Flash of Splendor
(21524, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "saint_clan", 300, "null", 0, 0, "fighter"), -- Blade of Splendor
(21525, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "saint_clan", 300, "null", 0, 0, "fighter"), -- Blade of Splendor
(21526, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "saint_clan", 300, "null", 0, 0, "fighter"), -- Wisdom of Splendor
(21527, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "saint_clan", 300, "null", 0, 0, "fighter"), -- Fury of Splendor
(21528, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "saint_clan", 300, "null", 0, 0, "fighter"), -- Fury of Splendor
(21529, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "saint_clan", 300, "null", 0, 0, "mage"), -- Soul of Splendor
(21530, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "saint_clan", 300, "null", 0, 0, "fighter"), -- Victory of Splendor
(21531, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "saint_clan", 300, "null", 0, 0, "mage"), -- Punishment of Splendor
(21532, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "saint_clan", 300, "null", 0, 0, "fighter"), -- Shout of Splendor
(21533, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "saint_clan", 300, "null", 0, 0, "mage"), -- Alliance of Splendor
(21534, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "saint_clan", 300, "null", 0, 0, "fighter"), -- Alliance of Splendor
(21535, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "saint_clan", 300, "null", 0, 0, "fighter"), -- Signet of Splendor
(21536, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "saint_clan", 300, "null", 0, 0, "fighter"), -- Crown of Splendor
(21537, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "saint_clan", 300, "null", 0, 0, "mage"), -- Fang of Splendor
(21538, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "saint_clan", 300, "null", 0, 0, "fighter"), -- Fang of Splendor
(21539, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "saint_clan", 300, "null", 0, 0, "fighter"), -- Wailing of Splendor
(21540, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "saint_clan", 300, "null", 0, 0, "fighter"), -- Wailing of Splendor
(21541, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "saint_clan", 300, "null", 0, 0, "mage"), -- Pilgrim of Splendor
(21542, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "saint_clan", 300, "null", 0, 0, "fighter"), -- Disciple of Pilgrim
(21543, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "saint_clan", 300, "null", 0, 0, "fighter"), -- Page of Pilgrim
(21544, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "saint_clan", 300, "null", 0, 0, "fighter"), -- Judge of Splendor
(21545, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "saint_clan", 300, "null", 0, 0, "mage"), -- Judge of Fire
(21546, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "saint_clan", 300, "null", 0, 0, "fighter"), -- Judge of Light
(21547, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "necro_clan", 300, "null", 0, 0, "fighter"), -- Corrupted Knight
(21548, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "necro_clan", 300, "null", 0, 0, "fighter"), -- Resurrected Knight
(21549, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "necro_clan", 300, "null", 0, 0, "balanced"), -- Corrupted Guard
(21550, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "necro_clan", 300, "null", 0, 0, "fighter"), -- Corrupted Guard
(21551, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "necro_clan", 300, "null", 0, 0, "balanced"), -- Resurrected Guard
(21552, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "necro_clan", 300, "null", 0, 0, "fighter"), -- Resurrected Guard
(21553, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "necro_clan", 300, "null", 0, 0, "fighter"), -- Trampled Man
(21554, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "necro_clan", 300, "null", 0, 0, "fighter"), -- Trampled Man
(21555, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "necro_clan", 300, "null", 0, 0, "fighter"), -- Slaughter Executioner
(21556, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "necro_clan", 300, "null", 0, 0, "fighter"), -- Slaughter Executioner
(21557, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "necro_clan", 300, "null", 0, 0, "fighter"), -- Bone Snatcher
(21558, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "necro_clan", 300, "null", 0, 0, "fighter"), -- Bone Snatcher
(21559, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "necro_clan", 300, "null", 0, 0, "fighter"), -- Bone Maker
(21560, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "necro_clan", 300, "null", 0, 0, "fighter"), -- Bone Shaper
(21561, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "necro_clan", 300, "null", 0, 0, "fighter"), -- Sacrificed Man
(21562, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "necro_clan", 300, "null", 0, 0, "fighter"), -- Guillotine's Ghost
(21563, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "necro_clan", 300, "null", 0, 0, "fighter"), -- Bone Collector
(21564, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "necro_clan", 300, "null", 0, 0, "fighter"), -- Skull Collector
(21565, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "necro_clan", 300, "null", 0, 0, "fighter"), -- Bone Animator
(21566, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "necro_clan", 300, "null", 0, 0, "fighter"), -- Skull Animator
(21567, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "necro_clan", 300, "null", 0, 0, "fighter"), -- Bone Slayer
(21568, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "vampire_clan", 300, "null", 0, 0, "fighter"), -- Devil Bat
(21569, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "vampire_clan", 300, "null", 0, 0, "fighter"), -- Devil Bat
(21570, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "necro_clan", 300, "null", 0, 0, "fighter"), -- Ghost of Betrayer
(21571, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "necro_clan", 300, "null", 0, 0, "fighter"), -- Ghost of Rebellion Soldier
(21572, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "necro_clan", 300, "null", 0, 0, "fighter"), -- Bone Sweeper
(21573, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "vampire_clan", 300, "null", 0, 0, "fighter"), -- Atrox
(21574, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "necro_clan", 300, "null", 0, 0, "balanced"), -- Bone Grinder
(21575, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "necro_clan", 300, "null", 0, 0, "fighter"), -- Bone Grinder
(21576, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "vampire_clan", 300, "null", 0, 0, "fighter"), -- Ghost of Guillotine
(21577, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "vampire_clan", 300, "null", 0, 0, "fighter"), -- Ghost of Guillotine
(21578, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "necro_clan", 300, "null", 0, 0, "balanced"), -- Behemoth Zombie
(21579, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "necro_clan", 300, "null", 0, 0, "balanced"), -- Ghost of Rebellion Leader
(21580, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "necro_clan", 300, "null", 0, 0, "fighter"), -- Bone Caster
(21581, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "necro_clan", 300, "null", 0, 0, "fighter"), -- Bone Puppeteer
(21582, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "vampire_clan", 300, "null", 0, 0, "fighter"), -- Vampire Soldier
(21583, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "necro_clan", 300, "null", 0, 0, "fighter"), -- Bone Scavenger
(21584, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "necro_clan", 300, "null", 0, 0, "balanced"), -- Bone Scavenger
(21585, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "vampire_clan", 300, "null", 0, 0, "mage"), -- Vampire Magician
(21586, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "vampire_clan", 300, "null", 0, 0, "balanced"), -- Vampire Adept
(21587, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "vampire_clan", 300, "null", 0, 0, "fighter"), -- Vampire Warrior
(21588, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "vampire_clan", 300, "null", 0, 0, "mage"), -- Vampire Wizard
(21589, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "vampire_clan", 300, "null", 0, 0, "mage"), -- Vampire Wizard
(21590, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "vampire_clan", 300, "null", 0, 0, "mage"), -- Vampire Magister
(21591, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "vampire_clan", 300, "null", 0, 0, "mage"), -- Vampire Magister
(21592, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "vampire_clan", 300, "null", 0, 0, "mage"), -- Vampire Magister
(21593, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "vampire_clan", 300, "null", 0, 0, "fighter"), -- Vampire Warlord
(21594, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "vampire_clan", 300, "null", 0, 0, "fighter"), -- Vampire Warlord
(21595, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "vampire_clan", 300, "null", 0, 0, "fighter"), -- Vampire Warlord
(21596, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "necro_clan", 300, "null", 0, 0, "fighter"), -- Requiem Lord
(21597, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "necro_clan", 300, "null", 0, 0, "fighter"), -- Requiem Behemoth
(21598, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "necro_clan", 300, "null", 0, 0, "fighter"), -- Requiem Behemoth
(21599, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "necro_clan", 300, "null", 0, 0, "balanced"), -- Requiem Priest
(21600, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "necro_clan", 300, "null", 0, 0, "fighter"), -- Requiem Behemoth
(21601, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "necro_clan", 300, "null", 0, 0, "fighter"), -- Requiem Behemoth
(21602, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "undead_clan1", 300, "null", 0, 0, "fighter"), -- Zaken's Pikeman
(21603, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "undead_clan1", 300, "null", 0, 0, "fighter"), -- Zaken's Pikeman
(21604, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "undead_clan1", 300, "null", 0, 0, "fighter"), -- Zaken's Elite Pikeman
(21605, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "undead_clan1", 300, "null", 0, 15, "archer"), -- Zaken's Archer
(21606, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "undead_clan1", 300, "null", 0, 15, "archer"), -- Zaken's Archer
(21607, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "undead_clan1", 300, "null", 0, 15, "archer"), -- Zaken's Elite Archer
(21608, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Zaken's Watchman
(21609, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Zaken's Watchman
(21610, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Zaken's High Grade Watchman
(21611, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "undead_clan", 300, "null", 0, 0, "fighter"), -- Unpleasant Humming
(21612, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "undead_clan", 300, "null", 0, 0, "fighter"), -- Unpleasant Humming
(21613, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "undead_clan", 300, "null", 0, 0, "fighter"), -- Unpleasant Shout
(21614, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "undead_clan", 300, "null", 0, 0, "fighter"), -- Death Flyer
(21615, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "undead_clan", 300, "null", 0, 0, "fighter"), -- Death Flyer
(21616, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "undead_clan", 300, "null", 0, 0, "fighter"), -- Gigantic Flyer
(21617, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "null", 300, "null", 0, 15, "archer"), -- Fiend Archer
(21618, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "null", 300, "null", 0, 15, "archer"), -- Fiend Archer
(21619, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "null", 300, "null", 0, 15, "archer"), -- Pit Archer
(21620, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Musveren
(21621, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Musveren
(21622, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Greater Musveren
(21623, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "undead_clan", 300, "null", 0, 0, "fighter"), -- Zaken's Guard
(21624, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "undead_clan", 300, "null", 0, 0, "fighter"), -- Zaken's Guard
(21625, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "undead_clan", 300, "null", 0, 0, "fighter"), -- Zaken's Elite Guard
(21626, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "demonic_clan", 300, "null", 0, 0, "fighter"), -- Kaim Vanul
(21627, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "demonic_clan", 300, "null", 0, 0, "fighter"), -- Kaim Vanul
(21628, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "demonic_clan", 300, "null", 0, 0, "fighter"), -- Kaim Vanul Lad
(21629, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "zaken_clan", 300, "null", 0, 0, "fighter"), -- Pirate Zombie Captain
(21630, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "zaken_clan", 300, "null", 0, 0, "fighter"), -- Pirate Zombie Captain
(21631, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "zaken_clan", 300, "null", 0, 0, "fighter"), -- Zombie Captain's Spiritual Body
(21632, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "zaken_clan", 300, "null", 0, 0, "fighter"), -- Doll Blader
(21633, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "zaken_clan", 300, "null", 0, 0, "fighter"), -- Doll Blader
(21634, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "zaken_clan", 300, "null", 0, 0, "fighter"), -- Crimson Doll Blader
(21635, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "zaken_clan", 300, "null", 0, 0, "fighter"), -- Veil Master
(21636, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "zaken_clan", 300, "null", 0, 0, "fighter"), -- Veil Master
(21637, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "zaken_clan", 300, "null", 0, 0, "fighter"), -- Crimson Veil Master
(21638, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Dread Wolf
(21639, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "lizardman_clan", 300, "null", 0, 0, "fighter"), -- Tasaba Lizardman
(21640, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "lizardman_clan", 300, "null", 0, 0, "balanced"), -- Tasaba Lizardman Shaman
(21641, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "lizardman_clan", 300, "null", 0, 0, "fighter"), -- Ogre
(21642, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "lizardman_clan", 300, "null", 0, 0, "fighter"), -- Tasaba Lizardman Sniper
(21643, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "lizardman_clan", 300, "null", 0, 0, "fighter"), -- Tasaba Lizardman Sniper
(21644, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "lienrik_clan", 300, "null", 0, 0, "fighter"), -- Lienrik
(21645, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "lienrik_clan", 300, "null", 0, 0, "fighter"), -- Lienrik Lad
(21646, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Grave Scarab
(21647, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Scavenger Scarab
(21648, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Grave Ant
(21649, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Scavenger Ant
(21650, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Shrine Knight
(21651, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Shrine Guard
(21652, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 450, 0, "fire_clan", 300, "null", 0, 0, "balanced"), -- Scarlet Stakato Noble
(21653, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "fire_clan", 300, "null", 0, 0, "fighter"), -- Assassin Beetle
(21654, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "fire_clan", 300, "null", 0, 0, "fighter"), -- Necromancer of Destruction
(21655, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "fire_clan", 300, "null", 0, 0, "fighter"), -- Arimanes of Destruction
(21656, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "fire_clan", 300, "null", 0, 0, "fighter"), -- Ashuras of Destruction
(21657, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "fire_clan", 300, "null", 0, 0, "fighter"), -- Magma Drake
(21658, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "saint_clan", 300, "null", 0, 0, "fighter"), -- Punishment of Splendor
(21659, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Otherworldly Invader Soldier
(21660, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "ssq_clan", 300, "null", 0, 0, "balanced"), -- Otherworldly Invader Soldier
(21661, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "ssq_clan", 300, "null", 0, 15, "archer"), -- Otherworldly Invader Archer
(21662, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Otherworldly Invader Elite Soldier
(21663, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Otherworldly Invader Shaman
(21664, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Otherworldly Invader Priest
(21665, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Otherworldly Invader Magus
(21666, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Otherworldly Invader Martyrs
(21667, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Otherworldly Invader Warrior
(21668, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Otherworldly Invader Soldier
(21669, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 0, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Otherworldly Invader Discipline
(21670, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Otherworldly Invader Berserker
(21671, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Otherworldly Invader Food
(21672, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Otherworldly Invader Elite Soldier
(21673, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Otherworldly Invader Elite Soldier
(21674, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 0, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Otherworldly Invader Elite Soldier
(21675, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 0, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Otherworldly Invader Elite Soldier
(21676, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Otherworldly Invader Warrior
(21677, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Otherworldly Invader Elite Soldier
(21678, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Otherworldly Invader Elite Soldier
(21679, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Otherworldly Invader Elite Soldier
(21680, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Otherworldly Invader Elite Soldier
(21681, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Otherworldly Invader Magus
(21682, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Dimension Invader Soldier
(21683, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "ssq_clan", 300, "null", 0, 0, "balanced"), -- Dimension Invader Soldier
(21684, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 15, "archer"), -- Dimension Invader Archer
(21685, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Dimension Invader Elite Soldier
(21686, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Dimension Invader Shaman
(21687, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Dimension Invader Priest
(21688, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Dimension Invader Magus
(21689, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Dimension Invader Martyrs
(21690, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Dimension Invader Warrior
(21691, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Dimension Invader Soldier
(21692, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 0, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Dimension Invader Discipline
(21693, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Dimension Invader Berserker
(21694, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Dimension Invader Food
(21695, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Dimension Invader Elite Soldier
(21696, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Dimension Invader Elite Soldier
(21697, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 0, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Dimension Invader Elite Soldier
(21698, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 0, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Dimension Invader Elite Soldier
(21699, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Dimension Invader Warrior
(21700, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Dimension Invader Elite Soldier
(21701, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Dimension Invader Elite Soldier
(21702, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Dimension Invader Elite Soldier
(21703, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Dimension Invader Elite Soldier
(21704, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Dimension Invader Magus
(21705, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Purgatory Invader Soldier
(21706, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "ssq_clan", 300, "null", 0, 0, "balanced"), -- Purgatory Invader Soldier
(21707, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 15, "archer"), -- Purgatory Invader Archer
(21708, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Purgatory Invader Elite Soldier
(21709, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Purgatory Invader Shaman
(21710, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Purgatory Invader Priest
(21711, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "ssq_clan", 300, "null", 0, 0, "mage"), -- Purgatory Invader Magus
(21712, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Purgatory Invader Martyrs
(21713, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Purgatory Invader Warrior
(21714, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Purgatory Invader Soldier
(21715, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 0, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Purgatory Invader Disciples
(21716, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 0, "balanced"), -- Purgatory Invader Berserker
(21717, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Purgatory Invader Food
(21718, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Purgatory Invader Elite Soldier
(21719, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Purgatory Invader Elite Soldier
(21720, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 0, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Purgatory Invader Elite Soldier
(21721, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 0, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Purgatory Invader Elite Soldier
(21722, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Purgatory Invader Warrior
(21723, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Purgatory Invader Elite Soldier
(21724, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Purgatory Invader Elite Soldier
(21725, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Purgatory Invader Elite Soldier
(21726, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Purgatory Invader Elite Soldier
(21727, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ssq_clan", 300, "null", 0, 0, "mage"), -- Purgatory Invader Magus
(21728, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Forbidden Path Invader Elite Soldier
(21729, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "ssq_clan", 300, "null", 0, 0, "balanced"), -- Forbidden Path Invader Elite Soldier
(21730, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 15, "archer"), -- Forbidden Path Invader Archer
(21731, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Forbidden Path Invader Elite Soldier
(21732, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Forbidden Path Invader Shaman
(21733, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Forbidden Path Invader Priest
(21734, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "ssq_clan", 300, "null", 0, 0, "mage"), -- Forbidden Path Invader Magus
(21735, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Forbidden Path Invader Martyrs
(21736, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Forbidden Path Invader Warrior
(21737, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Forbidden Path Invader Soldier
(21738, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 0, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Forbidden Path Invader Disciple
(21739, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 0, "balanced"), -- Forbidden Path Invader Berserker
(21740, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Forbidden Path Invader Food
(21741, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Forbidden Path Invader Elite Soldier
(21742, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Forbidden Path Invader Elite Soldier
(21743, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 0, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Forbidden Path Invader Elite Soldier
(21744, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 0, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Forbidden Path Invader Elite Soldier
(21745, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Forbidden Path Invader Warrior
(21746, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 0, "balanced"), -- Forbidden Path Invader Elite Soldier
(21747, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Forbidden Path Invader Elite Soldier
(21748, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 0, "balanced"), -- Forbidden Path Invader Elite Soldier
(21749, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Forbidden Path Invader Elite Soldier
(21750, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ssq_clan", 300, "null", 0, 0, "mage"), -- Forbidden Path Invader Magus
(21751, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Dark Omen Invader Soldier
(21752, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "ssq_clan", 300, "null", 0, 0, "balanced"), -- Dark Omen Invader Soldier
(21753, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 15, "archer"), -- Dark Omen Invader Archer
(21754, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "ssq_clan", 300, "null", 0, 0, "balanced"), -- Dark Omen Invader Elite Soldier
(21755, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "ssq_clan", 300, "null", 0, 0, "balanced"), -- Dark Omen Invader Shaman
(21756, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ssq_clan", 300, "null", 0, 0, "balanced"), -- Dark Omen Invader Priest
(21757, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"); -- Dark Omen Invader Magus

INSERT INTO `npcaidata` VALUES
(21758, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ssq_clan", 300, "null", 0, 0, "balanced"), -- Dark Omen Invader Martyrs
(21759, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Dark Omen Invader Warrior
(21760, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Dark Omen Invader Soldier
(21761, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 0, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Dark Omen Invader Disciple
(21762, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 0, "balanced"), -- Dark Omen Invader Berserker
(21763, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Dark Omen Invader Food
(21764, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Dark Omen Invader Elite Soldier
(21765, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Dark Omen Invader Elite Soldier
(21766, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 0, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Dark Omen Invader Elite Soldier
(21767, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 0, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Dark Omen Invader Elite Soldier
(21768, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Dark Omen Invader Warrior
(21769, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 0, "balanced"), -- Dark Omen Invader Elite Soldier
(21770, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Dark Omen Invader Elite Soldier
(21771, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 0, "balanced"), -- Dark Omen Invader Elite Soldier
(21772, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Dark Omen Invader Elite Soldier
(21773, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ssq_clan", 300, "null", 0, 0, "balanced"), -- Dark Omen Invader Magus
(21774, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Messenger Invader Soldier
(21775, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "ssq_clan", 300, "null", 0, 0, "balanced"), -- Messenger Invader Soldier
(21776, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 15, "archer"), -- Messenger Invader Archer
(21777, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "ssq_clan", 300, "null", 0, 0, "balanced"), -- Messenger Invader Elite Soldier
(21778, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "ssq_clan", 300, "null", 0, 0, "balanced"), -- Messenger Invader Shaman
(21779, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ssq_clan", 300, "null", 0, 0, "balanced"), -- Messenger Invader Priest
(21780, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Messenger Invader Magus
(21781, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ssq_clan", 300, "null", 0, 0, "balanced"), -- Messenger Invader Martyrs
(21782, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Messenger Invader Warrior
(21783, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Messenger Invader Soldier
(21784, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 0, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Messenger Invader Disciple
(21785, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 0, "balanced"), -- Messenger Invader Berserker
(21786, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Messenger Invader Food
(21787, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Messenger Invader Elite Soldier
(21788, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Messenger Invader Elite Soldier
(21789, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 0, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Messenger Invader Elite Soldier
(21790, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 0, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Messenger Invader Elite Soldier
(21791, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Messenger Invader Warrior
(21792, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 0, "balanced"), -- Messenger Invader Elite Soldier
(21793, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Messenger Invader Elite Soldier
(21794, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 0, "balanced"), -- Messenger Invader Elite Soldier
(21795, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 50, 50, 150, 0, "ssq_clan", 300, "null", 0, 0, "fighter"), -- Messenger Invader Elite Soldier
(21796, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ssq_clan", 300, "null", 0, 0, "mage"), -- Messenger Invader Magus
(21797, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "timiniel_clan", 300, "null", 0, 0, "fighter"), -- Spirit of Timiniel
(21798, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ghost of a Doorman
(21799, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ghost of a Doorman
(21800, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Vassal Ghost
(21801, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Treasure Chest
(21802, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Treasure Chest
(21803, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Treasure Chest
(21804, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Treasure Chest
(21805, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Treasure Chest
(21806, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Treasure Chest
(21807, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Treasure Chest
(21808, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Treasure Chest
(21809, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Treasure Chest
(21810, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Treasure Chest
(21811, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Treasure Chest
(21812, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Treasure Chest
(21813, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Treasure Chest
(21814, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Treasure Chest
(21815, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Treasure Chest
(21816, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Treasure Chest
(21817, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Treasure Chest
(21818, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Treasure Chest
(21819, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Treasure Chest
(21820, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Treasure Chest
(21821, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Treasure Chest
(21822, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Treasure Chest
(21823, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "tomb_clan", 300, "null", 0, 0, "fighter"), -- Executor of Offerings
(21824, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "pet_clan", 300, "null", 0, 0, "fighter"), -- Alpine Kookaburra
(21825, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "pet_clan", 300, "null", 0, 0, "fighter"), -- Alpine Kookaburra
(21826, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "pet_clan", 300, "null", 0, 0, "fighter"), -- Alpine Buffalo
(21827, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "pet_clan", 300, "null", 0, 0, "fighter"), -- Alpine Buffalo
(21828, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "pet_clan", 300, "null", 0, 0, "fighter"), -- Alpine Cougar
(21829, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "pet_clan", 300, "null", 0, 0, "fighter"), -- Alpine Cougar
(22001, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Grim Wolf
(22002, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Grim Grizzly
(22003, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "thief_clan", 300, "null", 0, 0, "fighter"), -- Grave Robber Scout
(22004, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "thief_clan", 300, "null", 0, 0, "balanced"), -- Grave Robber Lookout
(22005, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "thief_clan", 300, "null", 0, 0, "fighter"), -- Grave Robber Ranger
(22006, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "thief_clan", 300, "null", 0, 0, "fighter"), -- Grave Robber Guard
(22007, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "grudge_clan", 300, "null", 0, 0, "fighter"), -- Ghost of a Soldier
(22008, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "thief_clan", 300, "null", 0, 0, "fighter"), -- Grave Robber Fighter
(22009, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "grudge_clan", 300, "null", 0, 0, "balanced"), -- Ghost of a Loyal Vassal
(22010, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "grudge_clan", 300, "null", 0, 0, "fighter"), -- Ghost of a General
(22011, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "grudge_clan", 300, "null", 0, 0, "fighter"), -- Ghost of a Batur Chief
(22012, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "grudge_clan", 300, "null", 0, 0, "fighter"), -- Ghost of a Batur Chief
(22013, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "grudge_clan", 300, "null", 0, 0, "fighter"), -- Ghost of a Morek Chief
(22014, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "grudge_clan", 300, "null", 0, 0, "fighter"), -- Ghost of a Morek Chief
(22015, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "grudge_clan", 300, "null", 0, 0, "fighter"), -- Ghost of a Turka Chief
(22016, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "grudge_clan", 300, "null", 0, 0, "fighter"), -- Ghost of a Turka Chief
(22017, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "brigand_clan", 300, "null", 0, 0, "fighter"), -- Bandit Sweeper
(22018, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "brigand_clan", 300, "null", 0, 0, "fighter"), -- Bandit Hound
(22019, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "brigand_clan", 300, "null", 0, 15, "archer"), -- Bandit Watchman
(22020, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Snow Lynx
(22021, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "brigand_clan", 300, "null", 0, 0, "fighter"), -- Bandit Undertaker
(22022, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "brigand_clan", 300, "null", 0, 0, "fighter"), -- Bandit Assassin
(22023, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "brigand_clan", 300, "null", 0, 0, "fighter"), -- Bandit Warrior
(22024, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "brigand_clan", 300, "null", 0, 0, "fighter"), -- Bandit Inspector
(22025, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Frozen Wasteland Werewolf
(22026, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "brigand_clan", 300, "null", 0, 0, "fighter"), -- Bandit Captain
(22027, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "undead_clan", 300, "null", 0, 0, "fighter"), -- Forgotten Crewman
(22028, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "undead_clan", 300, "null", 0, 0, "mage"), -- Vagabond of the Ruins
(22029, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ragna_clan", 300, "null", 0, 0, "fighter"), -- Ragna Orc
(22030, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ragna_clan", 300, "null", 0, 0, "mage"), -- Ragna Orc Shaman
(22031, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ragna_clan", 300, "null", 0, 15, "archer"), -- Ragna Orc Archer
(22032, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "ragna_clan", 300, "null", 0, 0, "fighter"), -- Ragna Orc Warrior
(22033, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ragna_clan", 300, "null", 0, 0, "mage"), -- Ragna Orc Mage
(22034, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ragna_clan", 300, "null", 0, 0, "mage"), -- Ragna Orc Mage
(22035, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ragna_clan", 300, "null", 0, 0, "mage"), -- Ragna Orc Mage
(22036, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ragna_clan", 300, "null", 0, 0, "mage"), -- Ragna Orc Mage
(22037, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ragna_clan", 300, "null", 0, 0, "balanced"), -- Ragna Orc Healer
(22038, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "ragna_clan", 300, "null", 0, 0, "fighter"), -- Ragna Orc Hero
(22039, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "ragna_clan", 300, "null", 0, 0, "fighter"), -- Ragna Orc Commander
(22040, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ragna_clan", 300, "null", 0, 15, "archer"), -- Ragna Orc Sniper
(22041, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ragna_clan", 300, "null", 0, 0, "balanced"), -- Ragna Orc Sorcerer
(22042, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ragna_clan", 300, "null", 0, 0, "balanced"), -- Ragna Orc Sorcerer
(22043, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ragna_clan", 300, "null", 0, 0, "balanced"), -- Ragna Orc Sorcerer
(22044, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ragna_clan", 300, "null", 0, 0, "balanced"), -- Ragna Orc Sorcerer
(22045, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ragna_clan", 300, "null", 0, 0, "fighter"), -- Dark Corpse
(22046, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ragna_clan", 300, "null", 0, 0, "fighter"), -- Varangka's Dre Vanul
(22047, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ragna_clan", 300, "null", 0, 0, "mage"), -- Guardian of the Ghost Town
(22048, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ragna_clan", 300, "null", 0, 0, "fighter"), -- Dark Spider
(22049, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ragna_clan", 300, "null", 0, 0, "fighter"), -- Varangka's Succubus
(22050, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "golem_clan", 300, "null", 0, 0, "fighter"), -- Probe Golem Prodigy IV
(22051, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Spelunking Spider
(22052, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "golem_clan", 300, "null", 0, 0, "fighter"), -- Menacing Jackhammer Golem
(22053, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "golem_clan", 300, "null", 0, 0, "fighter"), -- Horrifying Cannon Golem I
(22054, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "golem_clan", 300, "null", 0, 0, "fighter"), -- Horrifying Cannon Golem IV
(22055, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "golem_clan", 300, "null", 0, 0, "fighter"), -- Cruel Vice Golem
(22056, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "golem_clan", 300, "null", 0, 0, "fighter"), -- Probe Golem Champion I
(22057, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Spelunking Ant
(22058, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "golem_clan", 300, "null", 0, 0, "fighter"), -- Horrifying Excavator Golem III
(22059, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "golem_clan", 300, "null", 0, 0, "fighter"), -- Bloodthirsty Ginzu Golem VII
(22060, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "golem_clan", 300, "null", 0, 0, "fighter"), -- Horrifying Cannon Golem
(22061, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "golem_clan", 300, "null", 0, 0, "fighter"), -- Horrifying Cannon Golem III
(22062, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "golem_clan", 300, "null", 0, 0, "fighter"), -- Horrifying Jackhammer Golem
(22063, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "golem_clan", 300, "null", 0, 0, "fighter"), -- Ginzu Golem Prodigy X
(22064, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "golem_clan", 300, "null", 0, 0, "fighter"), -- Bloodthirsty Ginzu Golem II
(22065, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "golem_clan", 300, "null", 0, 0, "fighter"), -- Horrifying Ginzu Golem V
(22066, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "golem_clan", 300, "null", 0, 0, "fighter"), -- Horrifying Cannon Golem VI
(22067, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "golem_clan", 300, "null", 0, 0, "fighter"), -- Horrifying Cannon Golem VI
(22068, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "golem_clan", 300, "null", 0, 0, "fighter"), -- Horrifying Cannon Golem VI
(22069, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "golem_clan", 300, "null", 0, 0, "fighter"), -- Horrifying Cannon Golem VI
(22070, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "golem_clan", 300, "null", 0, 0, "fighter"), -- Horrifying Cannon Golem VI
(22071, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "golem_clan", 300, "null", 0, 0, "fighter"), -- Horrifying Cannon Golem VI
(22072, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "golem_clan", 300, "null", 0, 0, "fighter"), -- Horrifying Cannon Golem VI
(22073, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "golem_clan", 300, "null", 0, 0, "fighter"), -- Horrifying Cannon Golem VI
(22074, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "golem_clan", 300, "null", 0, 0, "fighter"), -- Epic Cannon Golem
(22075, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "golem_clan", 300, "null", 0, 0, "fighter"), -- Epic Cannon Golem Adjunct
(22076, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "golem_clan", 300, "null", 0, 0, "fighter"), -- Deadly Ginzu Golem V
(22077, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "golem_clan", 300, "null", 0, 0, "fighter"), -- Horrifying Ginzu Golem VIII
(22078, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "golem_clan", 300, "null", 0, 0, "fighter"), -- Deadly Ginzu Golem VIII
(22079, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "wanimal_clan", 300, "null", 0, 0, "fighter"), -- Lost Bandersnatch
(22080, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "wanimal_clan", 300, "null", 0, 0, "fighter"), -- Massive Lost Bandersnatch
(22081, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "winter_maze_clan", 300, "null", 0, 0, "fighter"), -- Lost Watcher
(22082, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "winter_maze_clan", 300, "null", 0, 0, "fighter"), -- Elder Lost Watcher
(22083, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "wanimal_clan", 300, "null", 0, 0, "fighter"), -- Baby Panthera
(22084, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 300, 0, "wanimal_clan", 300, "null", 0, 0, "fighter"), -- Panthera
(22085, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "winter_maze_clan", 300, "null", 0, 0, "fighter"), -- Lost Gargoyle
(22086, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "winter_maze_clan", 300, "null", 0, 0, "fighter"), -- Lost Gargoyle Youngling
(22087, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "wanimal_clan", 300, "null", 0, 0, "fighter"), -- Pronghorn Spirit
(22088, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "wanimal_clan", 300, "null", 0, 0, "fighter"), -- Pronghorn
(22089, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "winter_maze_clan", 300, "null", 0, 0, "fighter"), -- Ice Tarantula
(22090, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "winter_maze_clan", 300, "null", 0, 0, "fighter"), -- Frost Tarantula
(22091, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "winter_maze_clan", 300, "null", 0, 0, "fighter"), -- Lost Iron Golem
(22092, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 300, 0, "winter_maze_clan", 300, "null", 0, 0, "fighter"), -- Frost Iron Golem
(22093, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "wanimal_clan", 300, "null", 0, 0, "fighter"), -- Lost Buffalo
(22094, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 300, 0, "wanimal_clan", 300, "null", 0, 0, "fighter"), -- Frost Buffalo
(22095, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "wanimal_clan", 300, "null", 0, 0, "fighter"), -- Ursus Cub
(22096, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "wanimal_clan", 300, "null", 0, 0, "fighter"), -- Ursus
(22097, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "winter_maze_clan", 300, "null", 0, 0, "fighter"), -- Lost Yeti
(22098, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "winter_maze_clan", 300, "null", 0, 0, "fighter"), -- Frost Yeti
(22099, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ice_clan", 700, "null", 0, 0, "fighter"), -- Freya's Buffalo
(22100, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "ice_clan", 700, "null", 0, 0, "fighter"), -- Freya's Gardener
(22101, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ice_clan", 700, "null", 0, 0, "fighter"), -- Freya's Servant
(22102, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "ice_clan", 700, "null", 0, 0, "fighter"), -- Freya's Servant
(22103, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ice_clan", 700, "null", 0, 0, "fighter"), -- Freya's White Bear
(22104, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "ice_clan", 700, "null", 0, 0, "fighter"), -- Freya's Dog
(22105, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "spike_clan", 500, "null", 0, 0, "fighter"), -- Spiked Stakato
(22106, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "spike_clan", 500, "null", 0, 0, "fighter"), -- Spiked Stakato Worker
(22107, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "spike_clan", 500, "null", 0, 0, "fighter"), -- Spiked Stakato Guard
(22108, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "spike_clan", 500, "null", 0, 0, "fighter"), -- Female Spiked Stakato
(22109, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "spike_clan", 500, "null", 0, 0, "fighter"), -- Male Spiked Stakato
(22110, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "spike_clan", 500, "null", 0, 0, "fighter"), -- Male Spiked Stakato
(22111, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "spike_clan", 500, "null", 0, 0, "fighter"), -- Spiked Stakato Sorcerer
(22112, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "spike_clan", 500, "null", 0, 0, "fighter"), -- Cannibalistic Stakato Follower
(22113, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "spike_clan", 500, "null", 0, 0, "fighter"), -- Cannibalistic Stakato Leader
(22114, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "spike_clan", 500, "null", 0, 0, "fighter"), -- Cannibalistic Stakato Leader
(22115, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "spike_clan", 500, "null", 0, 0, "fighter"), -- Spiked Stakato Soldier
(22116, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "spike_clan", 500, "null", 0, 0, "fighter"), -- Spiked Stakato Drone
(22117, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "spike_clan", 500, "null", 0, 0, "fighter"), -- Spiked Stakato Captain
(22118, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "spike_clan", 500, "null", 0, 0, "fighter"), -- Spiked Stakato Nurse
(22119, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "spike_clan", 500, "null", 0, 0, "fighter"), -- Spiked Stakato Nurse
(22120, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "spike_clan", 500, "null", 0, 0, "fighter"), -- Spiked Stakato Baby
(22121, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "spike_clan", 500, "null", 0, 0, "fighter"), -- Spiked Stakato Shaman
(22122, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "solina_clan", 300, "null", 0, 0, "fighter"), -- Monastic Pilgrim
(22123, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 200, 0, "solina_clan", 300, "null", 0, 0, "fighter"), -- Monastic Crusader
(22124, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "solina_clan", 300, "null", 0, 0, "fighter"), -- Solina Brother
(22125, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "solina_clan", 300, "null", 0, 0, "mage"), -- Solina Lay Brother
(22126, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "solina_clan", 300, "null", 0, 0, "fighter"), -- Silent Seeker
(22127, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "solina_clan", 300, "null", 0, 0, "mage"), -- Silent Brother
(22128, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "solina_clan", 300, "null", 0, 0, "fighter"), -- Monastic Guardian
(22129, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "solina_clan", 300, "null", 0, 0, "fighter"), -- Warrior Monk
(22130, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "solina_clan", 300, "null", 0, 0, "fighter"), -- Divine Advocate
(22131, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "solina_clan", 300, "null", 0, 0, "mage"), -- Pilgrim of Light
(22132, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 200, 0, "solina_clan", 300, "null", 0, 0, "fighter"), -- Judge of Light
(22133, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "solina_clan", 300, "null", 0, 0, "balanced"), -- Guardian of the Grail
(22134, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "solina_clan", 300, "null", 0, 0, "mage"), -- Guardian of the Holy Land
(22135, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "solina_clan", 300, "null", 0, 0, "fighter"), -- Beholder of Light
(22136, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "trioll_clan", 1000, "null", 0, 0, "balanced"), -- Doorman Zombie
(22137, 7, 15, 0, 200, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "null", 300, "null", 0, 0, "fighter"), -- Penance Guard
(22138, 7, 15, 0, 200, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "null", 300, "null", 0, 0, "fighter"), -- Chapel Guard
(22139, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "trioll_clan", 300, "null", 0, 0, "balanced"), -- Old Aristocrat's Soldier
(22140, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "trioll_clan", 300, "null", 0, 0, "fighter"), -- Zombie Worker
(22141, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "trioll_clan", 300, "null", 0, 0, "fighter"), -- Forgotten Victim
(22142, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "trioll_clan", 300, "null", 0, 0, "balanced"), -- Triol's Layperson
(22143, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "trioll_clan", 300, "null", 0, 0, "balanced"), -- Triol's Believer
(22144, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "trioll_clan", 300, "null", 0, 0, "balanced"), -- Resurrected Temple Knight
(22145, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "trioll_clan", 300, "null", 0, 0, "balanced"), -- Ritual Sacrifice
(22146, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "trioll_clan", 300, "null", 0, 0, "balanced"), -- Triol's Priest
(22147, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "trioll_clan", 300, "null", 0, 0, "balanced"), -- Ritual Offering
(22148, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "trioll_clan", 300, "null", 0, 0, "balanced"), -- Triol's Believer
(22149, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "trioll_clan", 300, "null", 0, 0, "balanced"), -- Ritual Offering
(22150, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "trioll_clan", 300, "null", 0, 0, "balanced"), -- Triol's Believer
(22151, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "trioll_clan", 300, "null", 0, 0, "balanced"), -- Triol's Priest
(22152, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "trioll_clan", 300, "null", 0, 0, "fighter"), -- Temple Guard
(22153, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "trioll_clan", 300, "null", 0, 0, "fighter"), -- Temple Guard Captain
(22154, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "trioll_clan", 300, "null", 0, 0, "balanced"), -- Ritual Sacrifice
(22155, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "trioll_clan", 300, "null", 0, 0, "balanced"), -- Triol's High Priest
(22156, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "trioll_clan", 500, "null", 0, 0, "balanced"), -- Triol's Priest
(22157, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "trioll_clan", 500, "null", 0, 0, "balanced"), -- Triol's Priest
(22158, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "trioll_clan", 500, "null", 0, 0, "balanced"), -- Triol's Believer
(22159, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "trioll_clan", 300, "null", 0, 0, "fighter"), -- Triol's High Priest
(22160, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "trioll_clan", 500, "null", 0, 0, "balanced"), -- Triol's Priest
(22161, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "trioll_clan", 500, "null", 0, 0, "balanced"), -- Ritual Sacrifice
(22162, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "trioll_clan", 500, "null", 0, 0, "fighter"), -- Triol's Believer
(22163, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "trioll_clan", 300, "null", 0, 0, "balanced"), -- Triol's High Priest
(22164, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "trioll_clan", 500, "null", 0, 0, "balanced"), -- Triol's Believer
(22165, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "trioll_clan", 500, "null", 0, 0, "balanced"), -- Triol's Priest
(22166, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "trioll_clan", 500, "null", 0, 0, "balanced"), -- Triol's Believer
(22167, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "trioll_clan", 300, "null", 0, 0, "fighter"), -- Triol's High Priest
(22168, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "trioll_clan", 500, "null", 0, 0, "balanced"), -- Triol's Priest
(22169, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "trioll_clan", 500, "null", 0, 0, "balanced"), -- Ritual Sacrifice
(22170, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "trioll_clan", 500, "null", 0, 0, "fighter"), -- Triol's Believer
(22171, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "trioll_clan", 300, "null", 0, 0, "balanced"), -- Triol's High Priest
(22172, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "trioll_clan", 500, "null", 0, 0, "balanced"), -- Ritual Sacrifice
(22173, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "trioll_clan", 500, "null", 0, 0, "balanced"), -- Triol's Priest
(22174, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "trioll_clan", 500, "null", 0, 0, "balanced"), -- Triol's Priest
(22175, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "andreas_clan", 300, "null", 0, 0, "balanced"), -- Andreas' Captain of the Royal Guard
(22176, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "andreas_clan", 300, "null", 0, 0, "fighter"), -- Andreas' Royal Guards
(22188, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "andreas_clan", 300, "null", 0, 0, "fighter"), -- Andreas' Captain of the Royal Guard
(22189, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "andreas_clan", 300, "null", 0, 0, "fighter"), -- Andreas' Royal Guards
(22190, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "andreas_clan", 300, "null", 0, 0, "fighter"), -- Ritual Sacrifice
(22191, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "andreas_clan", 1000, "null", 0, 0, "balanced"), -- Andreas' Captain of the Royal Guard
(22192, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "andreas_clan", 1000, "null", 0, 0, "balanced"), -- Andreas' Royal Guards
(22193, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "andreas_clan", 1000, "null", 0, 0, "balanced"), -- Andreas' Royal Guards
(22194, 7, 15, 0, 200, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "null", 300, "null", 0, 0, "fighter"), -- Penance Guard
(22195, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "andreas_clan", 300, "null", 0, 0, "fighter"), -- Ritual Sacrifice
(22196, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "velociraptor_clan", 600, "null", 0, 0, "fighter"), -- Velociraptor
(22197, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "velociraptor_clan", 600, "null", 0, 0, "fighter"), -- Velociraptor
(22198, 7, 15, 0, 500, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "velociraptor_clan", 600, "null", 0, 0, "fighter"), -- Velociraptor
(22199, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "null", 300, "null", 0, 0, "fighter"), -- Pterosaur
(22200, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "ornithomimus_clan", 500, "null", 0, 0, "fighter"), -- Ornithomimus
(22201, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ornithomimus_clan", 500, "null", 0, 0, "fighter"), -- Ornithomimus
(22202, 7, 15, 0, 500, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ornithomimus_clan", 500, "null", 0, 0, "fighter"), -- Ornithomimus
(22203, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "deinonychus_clan", 500, "null", 0, 0, "fighter"), -- Deinonychus
(22204, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "deinonychus_clan", 500, "null", 0, 0, "fighter"), -- Deinonychus
(22205, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "deinonychus_clan", 500, "null", 0, 0, "fighter"), -- Deinonychus
(22208, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 500, "null", 0, 0, "fighter"), -- Pachycephalosaurus
(22209, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "null", 500, "null", 0, 0, "fighter"), -- Pachycephalosaurus
(22210, 7, 15, 0, 500, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "null", 500, "null", 0, 0, "fighter"), -- Pachycephalosaurus
(22211, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 500, "null", 0, 0, "fighter"), -- Wild Strider
(22212, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "null", 500, "null", 0, 0, "fighter"), -- Wild Strider
(22213, 7, 15, 0, 500, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "null", 500, "null", 0, 0, "fighter"), -- Wild Strider
(22214, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "null", 300, "null", 0, 0, "fighter"), -- Elroki
(22215, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "balanced"), -- Tyrannosaurus
(22216, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "balanced"), -- Tyrannosaurus
(22217, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "balanced"), -- Tyrannosaurus
(22218, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "velociraptor_clan", 500, "null", 0, 0, "fighter"), -- Velociraptor
(22219, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ornithomimus_clan", 100, "null", 0, 0, "fighter"), -- Ornithomimus
(22220, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "deinonychus_clan", 100, "null", 0, 0, "fighter"), -- Deinonychus
(22221, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "null", 100, "null", 0, 0, "fighter"), -- Pachycephalosaurus
(22222, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "null", 100, "null", 0, 0, "fighter"), -- Wild Strider
(22223, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "velociraptor_clan", 500, "null", 0, 0, "fighter"), -- Velociraptor
(22224, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ornithomimus_clan", 500, "null", 0, 0, "fighter"), -- Ornithomimus
(22225, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "deinonychus_clan", 500, "null", 0, 0, "fighter"), -- Deinonychus
(22226, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 500, "null", 0, 0, "fighter"), -- Pachycephalosaurus
(22227, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 500, "null", 0, 0, "fighter"), -- Wild Strider
(22228, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Grey Elpy
(22229, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Young Grey Keltir
(22230, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Grey Keltir
(22231, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dominant Grey Keltir
(22232, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Black Wolf
(22233, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dominant Black Wolf
(22234, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Green Goblin
(22235, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "werewolf_clan", 300, "null", 0, 0, "fighter"), -- Mountain Werewolf
(22236, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "mostro_clan", 300, "null", 0, 15, "archer"), -- Muertos Archer
(22237, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mountain Fungus
(22238, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "werewolf_clan", 300, "null", 0, 0, "fighter"), -- Mountain Werewolf Chief
(22239, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "mostro_clan", 300, "null", 0, 0, "fighter"), -- Muertos Guard
(22240, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "mostro_clan", 300, "null", 0, 0, "fighter"), -- Muertos Scout
(22241, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Colossus
(22242, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "mostro_clan", 300, "null", 0, 0, "fighter"), -- Muertos Warrior
(22243, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "mostro_clan", 300, "null", 0, 0, "fighter"), -- Muertos Captain
(22244, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Crimson Spider
(22245, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "mostro_clan", 300, "null", 0, 0, "fighter"), -- Muertos Lieutenant
(22246, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 500, 0, "mostro_clan", 300, "null", 0, 0, "fighter"), -- Muertos Commander
(22247, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Grotto Golem
(22248, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "mostro_clan", 300, "null", 0, 0, "fighter"), -- Shady Muertos
(22249, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "mostro_clan", 300, "null", 0, 0, "fighter"), -- Shady Muertos Guard
(22250, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Grotto Leopard
(22251, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "mostro_clan", 300, "null", 0, 0, "fighter"), -- Shady Muertos Captain
(22252, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Grotto Grizzly
(22253, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "mostro_clan", 300, "null", 0, 0, "fighter"), -- Shady Muertos Warrior
(22254, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "mostro_clan", 300, "null", 0, 15, "archer"), -- Shady Muertos Archer
(22255, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "mostro_clan", 300, "null", 0, 0, "fighter"), -- Shady Muertos Commander
(22256, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "mostro_clan", 300, "null", 0, 0, "fighter"), -- Shady Muertos Wizard
(22257, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "oracle_clan", 500, "null", 0, 0, "fighter"), -- Island Guardian
(22258, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "oracle_clan", 500, "null", 0, 0, "fighter"), -- White Sand Mirage
(22259, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "oracle_clan", 500, "null", 0, 0, "mage"), -- Muddy Coral
(22260, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "oracle_clan", 500, "null", 0, 0, "mage"), -- Kleopora
(22261, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "oracle_clan", 500, "null", 0, 0, "fighter"), -- Seychelles
(22262, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "oracle_clan", 500, "null", 0, 0, "mage"), -- Naiad
(22263, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "oracle_clan", 500, "null", 0, 0, "fighter"), -- Sonneratia
(22264, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "oracle_clan", 500, "null", 0, 0, "mage"), -- Castalia
(22265, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 250, 0, "oracle_clan", 500, "null", 0, 0, "fighter"), -- Chrysocolla
(22266, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "oracle_clan", 500, "null", 0, 0, "mage"), -- Pythia
(22267, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "dark_clan", 500, "null", 0, 0, "fighter"), -- Dark Water Dragon
(22268, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 420, 0, "dark_clan", 500, "null", 0, 0, "mage"), -- Shade
(22269, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 420, 0, "dark_clan", 500, "null", 0, 0, "mage"), -- Shade
(22270, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "dark_clan", 500, "null", 0, 0, "fighter"), -- Water Dragon Detractor
(22271, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "dark_clan", 500, "null", 0, 0, "fighter"), -- Water Dragon Detractor
(22272, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "oracle_clan", 500, "null", 0, 0, "fighter"), -- Beleth's Minion
(22273, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "oracle_clan", 500, "null", 0, 0, "balanced"), -- Beleth's Minion
(22274, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "oracle_clan", 500, "null", 0, 0, "fighter"), -- Beleth's Minion
(22275, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "oracle_clan", 500, "null", 0, 0, "fighter"), -- Gatekeeper Lohan
(22276, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "oracle_clan", 500, "null", 0, 0, "fighter"), -- Gatekeeper of the Square
(22277, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "oracle_clan", 500, "null", 0, 0, "fighter"), -- Gatekeeper Provo
(22278, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "oracle_clan", 500, "null", 0, 0, "fighter"), -- Gatekeeper of Fire
(22279, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "oracle_clan", 500, "null", 0, 0, "fighter"), -- Chromatic Detainee
(22280, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "oracle_clan", 500, "null", 0, 0, "fighter"), -- Rodo Knight
(22281, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "oracle_clan", 500, "null", 0, 0, "fighter"), -- Plaza Caiman
(22282, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "oracle_clan", 500, "null", 0, 0, "fighter"), -- Chromatic Detainee
(22283, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "oracle_clan", 500, "null", 0, 0, "fighter"), -- Emerald Alligar
(22284, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "oracle_clan", 500, "null", 0, 0, "fighter"), -- Chromatic Detainee
(22285, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "oracle_clan", 500, "null", 0, 0, "fighter"), -- Chromatic Detainee
(22286, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "oracle_clan", 500, "null", 0, 0, "fighter"), -- Plaza Gaviel
(22287, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "oracle_clan", 500, "null", 0, 0, "fighter"), -- Crystalline Unicorn
(22288, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "oracle_clan", 500, "null", 0, 0, "fighter"), -- Emerald Boar
(22289, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "oracle_clan", 500, "null", 0, 0, "fighter"), -- Plaza Helm
(22290, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "oracle_clan", 500, "null", 0, 0, "fighter"), -- Terod's Minion
(22291, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "oracle_clan", 500, "null", 0, 0, "fighter"), -- Weylin's Minion
(22292, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "oracle_clan", 500, "null", 0, 0, "fighter"), -- Tourmaline
(22293, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "oracle_clan", 500, "null", 0, 0, "fighter"), -- Spinel
(22294, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "oracle_clan", 500, "null", 0, 0, "fighter"), -- Fire Opal
(22295, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "oracle_clan", 700, "null", 0, 0, "fighter"), -- Reef Golem
(22296, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "oracle_clan", 700, "null", 0, 0, "fighter"), -- Reef Golem
(22297, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "oracle_clan", 700, "null", 0, 0, "fighter"), -- Reef Golem
(22298, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "oracle_clan", 700, "null", 0, 0, "fighter"), -- Weylin
(22299, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "oracle_clan", 700, "null", 0, 0, "fighter"), -- Dolph
(22300, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "oracle_clan", 500, "null", 0, 0, "fighter"), -- Dolph's Minion
(22301, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "oracle_clan", 700, "null", 0, 0, "fighter"), -- Terod
(22302, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "oracle_clan", 500, "null", 0, 0, "fighter"), -- Darnel's Guardian
(22303, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "oracle_clan", 500, "null", 0, 0, "fighter"), -- Guardian of the Square
(22304, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "oracle_clan", 500, "null", 0, 0, "fighter"), -- Guardian of the Emerald
(22305, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "oracle_clan", 500, "null", 0, 0, "fighter"), -- Kechi's Captain
(22306, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "oracle_clan", 500, "null", 0, 0, "fighter"), -- Kechi's Captain
(22307, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "oracle_clan", 500, "null", 0, 0, "fighter"), -- Kechi's Captain
(22308, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "oracle_clan", 500, "null", 0, 0, "fighter"), -- Kechi's Guard
(22309, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "oracle_clan", 500, "null", 0, 0, "fighter"), -- Kechi's Guard
(22310, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "oracle_clan", 500, "null", 0, 0, "fighter"), -- Kechi's Guard
(22311, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "oracle_clan", 500, "null", 0, 0, "fighter"), -- Parme's Guardian
(22312, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "oracle_clan", 500, "null", 0, 0, "fighter"), -- Fafurion's Henchman
(22313, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "oracle_clan", 500, "null", 0, 0, "fighter"), -- Garden Stakato
(22314, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "oracle_clan", 500, "null", 0, 0, "fighter"), -- Garden Poison Moth
(22315, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "oracle_clan", 500, "null", 0, 0, "fighter"), -- Garden Guard
(22316, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "oracle_clan", 500, "null", 0, 0, "fighter"), -- Garden Guardian Tree
(22317, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "oracle_clan", 500, "null", 0, 0, "fighter"), -- Garden Castalia
(22320, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "hell_clan", 300, "null", 0, 0, "mage"), -- Junior Watchman
(22321, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "hell_clan", 300, "null", 0, 0, "mage"), -- Junior Summoner
(22322, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Subjugated Native
(22323, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Charmed Native
(22324, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "hell_clan", 300, "null", 0, 0, "fighter"), -- Blind Huntsman
(22325, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "hell_clan", 300, "null", 0, 0, "mage"), -- Blind Watchman
(22326, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "hell_clan", 1000, "null", 0, 0, "balanced"), -- Hellinark
(22327, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "hell_clan", 400, "null", 0, 0, "fighter"), -- Arcane Scout
(22328, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 420, 0, "hell_clan", 400, "null", 0, 0, "mage"), -- Arcane Guardian
(22329, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "hell_clan", 400, "null", 0, 0, "mage"), -- Arcane Watchman
(22330, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 420, 0, "null", 300, "null", 0, 0, "fighter"), -- Remnant Wraith
(22334, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "null", 300, "null", 0, 0, "fighter"), -- Sand Scorpion
(22335, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "null", 300, "null", 0, 0, "fighter"), -- Desert Scorpion
(22336, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "null", 300, "null", 0, 0, "fighter"), -- Sand Devil
(22337, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "null", 300, "null", 0, 0, "mage"), -- Desiccator
(22339, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "null", 300, "null", 0, 0, "fighter"), -- Wandering Caravan
(22340, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 420, 0, "null", 300, "null", 0, 0, "balanced"), -- Sandstorm
(22341, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "hell_clan", 300, "null", 0, 0, "balanced"), -- Keltas
(22342, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 420, 0, "hell_clan", 300, "null", 0, 0, "fighter"), -- Darion's Enforcer
(22343, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 420, 0, "hell_clan", 300, "null", 0, 0, "mage"), -- Darion's Executioner
(22344, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 420, 0, "hell_clan", 300, "quarry_slaves", 300, 0, "balanced"), -- Quarry Supervisor
(22345, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "hell_clan", 300, "quarry_slaves", 300, 0, "mage"), -- Quarry Bowman
(22346, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 420, 0, "hell_clan", 300, "quarry_slaves", 300, 0, "fighter"), -- Quarry Foreman
(22347, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 420, 0, "hell_clan", 300, "quarry_slaves", 300, 0, "fighter"), -- Quarry Patrolman
(22349, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "test_clan", 300, "null", 0, 0, "fighter"), -- Chimera of Earth
(22350, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "test_clan", 300, "null", 0, 0, "mage"), -- Chimera of Darkness
(22351, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "test_clan", 300, "null", 0, 0, "mage"), -- Chimera of Wind
(22352, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "test_clan", 300, "null", 0, 0, "balanced"), -- Chimera of Fire
(22353, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "test_clan", 300, "null", 0, 0, "balanced"), -- Celtus
(22355, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castleout_clan", 1000, "null", 0, 0, "balanced"), -- Enceinte Defender
(22356, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "castleout_clan", 1000, "null", 0, 0, "balanced"), -- Enceinte Defender
(22357, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "castleout_clan", 1000, "null", 0, 0, "balanced"), -- Enceinte Defender
(22358, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "castleout_clan", 1000, "null", 0, 0, "balanced"), -- Enceinte Defender
(22359, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Town Guard
(22360, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 420, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Town Patrolman
(22361, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 420, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Steel Citadel Keymaster
(22362, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 420, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Guzen
(22363, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 420, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Body Destroyer
(22364, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 420, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Soul Dominator
(22365, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Labyrinth Watchman
(22366, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Labyrinth Watchman
(22367, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Labyrinth Mystic
(22368, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 420, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Labyrinth Captain
(22369, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Labyrinth Priest
(22370, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 420, 0, "castle_clan", 300, "null", 0, 0, "fighter"), -- Passageway Captain
(22371, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Passageway Guards
(22372, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 420, 0, "castle_clan", 300, "null", 0, 0, "mage"), -- Passageway Mystic
(22373, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Cosmic Scout
(22374, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Cosmic Watcher
(22375, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 420, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Cosmic Priest
(22376, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 420, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Cosmic Lord
(22377, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "castle_clan", 300, "null", 0, 0, "fighter"), -- Master Zelos
(22378, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 420, 0, "castle_clan", 300, "null", 0, 0, "fighter"), -- Master's Minion
(22379, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Master's Minion
(22380, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 420, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Master Festina
(22381, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Master's Guard
(22382, 7, 15, 0, 300, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 420, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Master's Guard
(22383, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Tully's Toy
(22384, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Mystic's Toy
(22385, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "castle_clan", 300, "null", 0, 0, "fighter"), -- Tully's Golem Guard
(22386, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Foundry Mystic
(22387, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Foundry Mystic
(22388, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "castle_clan", 300, "null", 0, 0, "fighter"), -- Foundry Spirit Guard
(22389, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Foundry Spirit Guard
(22390, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Foundry Foreman
(22391, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Foundry Assistant Overseer
(22392, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Failed Experimental Timetwister Golem
(22393, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "castle_clan", 1500, "null", 0, 0, "balanced"), -- Beleth's Follower
(22394, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "castle_clan", 1500, "null", 0, 0, "balanced"), -- Beleth's Devotee
(22395, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 420, 0, "castle_clan", 1500, "null", 0, 0, "fighter"), -- Beleth's Projection
(22396, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Foundry Laborer
(22397, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Foundry Foreman
(22398, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Lesser Evil
(22399, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Greater Evil
(22400, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "oracle_clan", 1000, "null", 0, 0, "mage"), -- Parme's Healer
(22401, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "oracle_clan", 1000, "null", 0, 0, "mage"), -- Parme's Healer
(22402, 7, 15, 0, 1000, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "corpse"), -- Shadow Column
(22403, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Foundry Foreman
(22404, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "hell_clan", 700, "null", 0, 0, "balanced"), -- Arcane Captain
(22405, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Darion's Faithful Servant
(22406, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Darion's Faithful Servant
(22407, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Darion's Faithful Servant
(22408, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Darion's Faithful Servant
(22409, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Darion's Faithful Servant
(22410, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Darion's Faithful Servant
(22411, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 1500, "null", 0, 0, "balanced"), -- Beleth's Retainer
(22412, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 1500, "null", 0, 0, "balanced"), -- Beleth's Fighter
(22413, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 1500, "null", 0, 0, "balanced"), -- Beleth's Low Servant
(22414, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 1500, "null", 0, 0, "balanced"), -- Beleth's Follower
(22415, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 1500, "null", 0, 0, "balanced"), -- Beleth's Devotee
(22416, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "oracle_clan", 500, "null", 0, 0, "balanced"), -- Kechi's Captain
(22417, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "oracle_clan", 500, "null", 0, 0, "balanced"), -- Kechi's Guard
(22418, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "oracle_clan", 500, "null", 0, 0, "balanced"), -- Burning Iris
(22419, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "oracle_clan", 500, "null", 0, 0, "balanced"), -- Flame Iris
(22420, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "oracle_clan", 500, "null", 0, 0, "balanced"), -- Brimstone Iris
(22422, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "hell_clan", 400, "null", 0, 0, "balanced"), -- Failan's Guard
(22423, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Original Sin Warden
(22424, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Slave of Greed
(22425, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Slave of Lust
(22426, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Slave of Wrath
(22427, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Slave of Sloth
(22428, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Slave of Envy
(22429, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Slave of Pride
(22430, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Slave of Gluttony
(22431, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Original Sin Warden
(22432, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Slave of Greed
(22433, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Slave of Lust
(22434, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Slave of Wrath
(22435, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Slave of Sloth
(22436, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Slave of Envy
(22437, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Slave of Pride
(22438, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Slave of Gluttony
(22439, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 1500, "null", 0, 0, "balanced"), -- Beleth's Assassin
(22440, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 1500, "null", 0, 0, "balanced"), -- Beleth's Assassin
(22441, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 1500, "null", 0, 0, "balanced"), -- Beleth's Minion
(22442, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 1500, "null", 0, 0, "balanced"), -- Beleth's Minion
(22443, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Kertang's Messenger
(22444, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Kertang's Messenger
(22445, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Kertang's Messenger
(22446, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Kertang's Messenger
(22447, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Kertang's Messenger
(22448, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Leodas
(22449, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Amaskari
(22450, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Tortured Native
(22451, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Native Elite Soldier
(22452, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "rim_clan", 200, "null", 0, 0, "balanced"), -- White Skull Kanabion
(22453, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "rim_clan", 200, "null", 0, 0, "balanced"), -- White Skull Kanabion
(22454, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "rim_clan", 300, "null", 0, 0, "balanced"), -- White Skull Kanabion
(22455, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "rim_clan", 200, "null", 0, 0, "balanced"), -- Begrudged Kanabion
(22456, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "rim_clan", 200, "null", 0, 0, "balanced"), -- Begrudged Kanabion
(22457, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "rim_clan", 300, "null", 0, 0, "balanced"), -- Begrudged Kanabion
(22458, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "rim_clan", 200, "null", 0, 0, "balanced"), -- Rotten Kanabion
(22459, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "rim_clan", 200, "null", 0, 0, "balanced"), -- Rotten Kanabion
(22460, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "rim_clan", 300, "null", 0, 0, "balanced"), -- Rotten Kanabion
(22461, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "rim_clan", 200, "null", 0, 0, "balanced"), -- Gluttonous Kanabion
(22462, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "rim_clan", 200, "null", 0, 0, "balanced"), -- Gluttonous Kanabion
(22463, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "rim_clan", 300, "null", 0, 0, "balanced"), -- Gluttonous Kanabion
(22464, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "rim_clan", 200, "null", 0, 0, "balanced"), -- Callous Kanabion
(22465, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "rim_clan", 200, "null", 0, 0, "balanced"), -- Callous Kanabion
(22466, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "rim_clan", 300, "null", 0, 0, "balanced"), -- Callous Kanabion
(22467, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "rim_clan", 200, "null", 0, 0, "balanced"), -- Savage Kanabion
(22468, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "rim_clan", 200, "null", 0, 0, "balanced"), -- Savage Kanabion
(22469, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "rim_clan", 300, "null", 0, 0, "balanced"), -- Savage Kanabion
(22470, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "rim_clan", 200, "null", 0, 0, "balanced"), -- Peerless Kanabion
(22471, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "rim_clan", 200, "null", 0, 0, "balanced"), -- Peerless Kanabion
(22472, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "rim_clan", 300, "null", 0, 0, "balanced"), -- Peerless Kanabion
(22473, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "rim_clan", 200, "null", 0, 0, "balanced"), -- Massive Kanabion
(22474, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "rim_clan", 200, "null", 0, 0, "balanced"), -- Massive Kanabion
(22475, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "rim_clan", 300, "null", 0, 0, "balanced"), -- Massive Kanabion
(22476, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "rim_clan", 200, "null", 0, 0, "balanced"), -- Fervent Kanabion
(22477, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "rim_clan", 200, "null", 0, 0, "balanced"), -- Fervent Kanabion
(22478, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "rim_clan", 300, "null", 0, 0, "balanced"), -- Fervent Kanabion
(22479, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "rim_clan", 200, "null", 0, 0, "balanced"), -- Ruptured Kanabion
(22480, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "rim_clan", 200, "null", 0, 0, "balanced"), -- Ruptured Kanabion
(22481, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "rim_clan", 300, "null", 0, 0, "balanced"), -- Ruptured Kanabion
(22482, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "rim_clan", 200, "null", 0, 0, "balanced"), -- Sword Kanabion
(22483, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "rim_clan", 200, "null", 0, 0, "balanced"), -- Sword Kanabion
(22484, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "rim_clan", 300, "null", 0, 0, "balanced"), -- Sword Kanabion
(22485, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "abyss_clan", 1000, "null", 0, 0, "balanced"), -- Lost Watcher
(22486, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "abyss_clan", 1000, "null", 0, 0, "balanced"), -- Lost Watcher
(22487, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "abyss_clan", 1000, "null", 0, 0, "balanced"), -- Lost Beholder
(22488, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "abyss_clan", 1000, "null", 0, 0, "balanced"), -- Lost Watcher
(22489, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "abyss_clan", 1000, "null", 0, 0, "balanced"), -- Lost Watcher
(22490, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "abyss_clan", 1000, "null", 0, 0, "balanced"), -- Lost Beholder
(22491, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "abyss_clan", 1000, "null", 0, 0, "balanced"), -- Lost Watcher
(22492, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "abyss_clan", 1000, "null", 0, 0, "balanced"), -- Lost Watcher
(22493, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "abyss_clan", 1000, "null", 0, 0, "balanced"), -- Lost Beholder
(22494, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "abyss_clan", 1000, "null", 0, 0, "balanced"), -- Lost Watcher
(22495, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "abyss_clan", 1000, "null", 0, 0, "balanced"), -- Lost Watcher
(22496, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "abyss_clan", 1000, "null", 0, 0, "balanced"), -- Lost Beholder
(22497, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "abyss_clan", 1000, "null", 0, 0, "balanced"), -- Lost Watcher
(22498, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "abyss_clan", 1000, "null", 0, 0, "balanced"), -- Lost Watcher
(22499, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "abyss_clan", 1000, "null", 0, 0, "balanced"), -- Lost Beholder
(22500, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "abyss_clan", 1000, "null", 0, 0, "balanced"), -- Lost Watcher
(22501, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "abyss_clan", 1000, "null", 0, 0, "balanced"), -- Lost Watcher
(22502, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "abyss_clan", 1000, "null", 0, 0, "balanced"), -- Lost Beholder
(22503, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "abyss_clan", 1000, "null", 0, 0, "balanced"), -- Lost Watcher
(22504, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "abyss_clan", 1000, "null", 0, 0, "balanced"), -- Lost Watcher
(22505, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "abyss_clan", 1000, "null", 0, 0, "balanced"), -- Lost Beholder
(22506, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Boom - Child
(22507, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Boom - Child
(22508, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Boom - Child
(22509, 7, 40, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "aceed_clan", 1500, "null", 0, 0, "balanced"), -- Fanatic of Infinity
(22510, 7, 40, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "aceed_clan", 1500, "null", 0, 0, "balanced"), -- Rotten Messenger
(22511, 7, 40, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "aceed_clan", 1500, "null", 0, 0, "balanced"), -- Zealot of Infinity
(22512, 7, 40, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "aceed_clan", 1500, "null", 0, 0, "balanced"), -- Body Severer
(22513, 7, 40, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Body Harvester
(22514, 7, 40, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "aceed_clan", 1500, "null", 0, 0, "balanced"), -- Soul Exploiter
(22515, 7, 40, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "aceed_clan", 1500, "null", 0, 0, "balanced"), -- Soul Devourer
(22516, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Butcher of Infinity
(22517, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Disciple of Infinity
(22518, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Rotten Messenger
(22519, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Body Harvester
(22520, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Body Severer
(22521, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Soul Exploiter
(22522, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Soul Devourer
(22523, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 1500, "null", 0, 0, "balanced"), -- Soul Devourer
(22524, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Emissary of Death
(22525, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Emissary of Death
(22526, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Emissary of Death
(22527, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Emissary of Death
(22528, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Cursed Prefect
(22529, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Cursed Prefect
(22530, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Cursed Prefect
(22531, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Cursed Prefect
(22532, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Law Scholar of Conclusions
(22533, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Law Scholar of Conclusions
(22534, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Law Scholar of Conclusions
(22535, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Law Scholar of Conclusions
(22536, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Royal Guard Captain
(22537, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Dragon Steed Troop Grand Magician
(22538, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Dragon Steed Troop Commander
(22539, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Dragon Steed Troops No 1 Battalion Commander
(22540, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- White Dragon Leader
(22541, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Dragon Steed Troop Infantry
(22542, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Dragon Steed Troop Magic Leader
(22543, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Dragon Steed Troop Magician
(22544, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Dragon Steed Troop Magic Soldier
(22545, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Wife of the Dragon of Darkness
(22546, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Warrior of Light
(22547, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Dragon Steed Troop Healer
(22548, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Dragon Steed Troop Javelin Thrower
(22549, 7, 15, 0, 450, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Dragon Steed Troop Javelin Thrower
(22550, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Savage Warrior
(22551, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Priest of Darkness
(22552, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Mutated Drake
(22553, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Large Crystal Core
(22554, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Small Crystal Core
(22555, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Small Crystal Core
(22556, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Small Crystal Core
(22557, 7, 15, 0, 1000, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Defense Mechanism
(22558, 7, 15, 0, 1000, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Defense Battery
(22559, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Defeated Troops Commander
(22560, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Defeated Troops No 1 Battalion Commander
(22561, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Defeated Troops White Dragon Leader
(22562, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Defeated Troops Infantry
(22563, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Defeated Troops Magic Leader
(22564, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Defeated Troops Magician
(22565, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Defeated Troops Magic Soldier
(22566, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Defeated Troops Healer
(22567, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Defeated Troops Javelin Thrower
(22568, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Defeated Troops Javelin Thrower
(22569, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Soldiers of Bravery
(22570, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Royal Guard Captain
(22571, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Dragon Steed Troop Grand Magician
(22572, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Dragon Steed Troop Commander
(22573, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Dragon Steed Troops No 1 Battalion Commander
(22574, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- White Dragon Leader
(22575, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Dragon Steed Troop Infantry
(22576, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Dragon Steed Troop Magic Leader
(22577, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Dragon Steed Troop Magician
(22578, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Dragon Steed Troop Magic Soldier
(22579, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Warrior of Light
(22580, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Dragon Steed Troop Healer
(22581, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Dragon Steed Troop Javelin Thrower
(22582, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Dragon Steed Troop Javelin Thrower
(22583, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Dragon Steed Troop Magic Leader
(22584, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Dragon Steed Troop Magician
(22585, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Dragon Steed Troop Magic Soldier
(22586, 7, 15, 0, 450, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Dragon Steed Troop Commander
(22587, 7, 15, 0, 450, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- null
(22588, 7, 15, 0, 450, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- White Dragon Leader
(22589, 7, 15, 0, 450, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Dragon Steed Troop Infantry
(22590, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), --
(22591, 7, 15, 0, 450, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Dragon Steed Troop Magic Leader
(22592, 7, 15, 0, 450, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Dragon Steed Troop Magician
(22593, 7, 15, 0, 450, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Dragon Steed Troop Magic Soldier
(22594, 7, 15, 0, 450, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Dragon Steed Troop Commander
(22595, 7, 15, 0, 450, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Dragon Steed Troops No 1 Battalion Commander
(22596, 7, 15, 0, 450, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- White Dragon Leader
(22597, 7, 15, 0, 450, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Dragon Steed Troop Infantry
(22598, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Obelisk
(22599, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Great Powerful Device
(22600, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Throne of Destruction Powerful Device
(22601, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Heart Protection Device
(22602, 7, 15, 0, 400, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "loc_clan", 1000, "null", 0, 0, "mage"), -- Mutant Bird
(22603, 7, 15, 0, 400, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "loc_clan", 1000, "null", 0, 0, "mage"), -- Mutant Bird
(22604, 7, 15, 0, 400, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "loc_clan", 1000, "null", 0, 0, "mage"), -- Dra Hawk
(22605, 7, 15, 0, 400, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "loc_clan", 1000, "null", 0, 0, "mage"), -- Dra Hawk
(22606, 7, 15, 0, 400, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "bansheequeen_clan", 1000, "null", 0, 0, "mage"), -- Floating Skull
(22607, 7, 15, 0, 400, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "bansheequeen_clan", 1000, "null", 0, 0, "mage"), -- Floating Skull
(22608, 7, 15, 0, 400, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "bansheequeen_clan", 1000, "null", 0, 0, "mage"), -- Floating Zombie
(22609, 7, 15, 0, 400, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "bansheequeen_clan", 1000, "null", 0, 0, "mage"), -- Floating Zombie
(22610, 7, 15, 0, 400, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "mutantdrakewing_clan", 1000, "null", 0, 0, "mage"), -- Mutated Drake Wing
(22611, 7, 15, 0, 400, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "mutantdrakewing_clan", 1000, "null", 0, 0, "mage"), -- Mutated Drake Wing
(22612, 7, 15, 0, 400, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "mutantdrakewing_clan", 1000, "null", 0, 0, "mage"), -- Drak
(22613, 7, 15, 0, 400, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "mutantdrakewing_clan", 1000, "null", 0, 0, "mage"), -- Drak
(22614, 7, 15, 0, 400, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "masterrider_clan", 1000, "null", 0, 0, "mage"), -- Vulture Rider
(22615, 7, 15, 0, 400, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "masterrider_clan", 1000, "null", 0, 0, "mage"), -- Vulture Rider
(22616, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 1500, "null", 0, 0, "balanced"), -- Seed of Pain
(22617, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "spike_clan", 500, "null", 0, 0, "fighter"), -- Spiked Stakato
(22618, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "spike_clan", 500, "null", 0, 0, "fighter"), -- Spiked Stakato Worker
(22619, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "spike_clan", 500, "null", 0, 0, "fighter"), -- Spiked Stakato Guard
(22620, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "spike_clan", 500, "null", 0, 0, "balanced"), -- Female Spiked Stakato
(22621, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "spike_clan", 500, "null", 0, 0, "fighter"), -- Male Spiked Stakato
(22622, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "spike_clan", 500, "null", 0, 0, "balanced"), -- Male Spiked Stakato
(22623, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "spike_clan", 500, "null", 0, 0, "mage"), -- Spiked Stakato Sorcerer
(22624, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "spike_clan", 500, "null", 0, 0, "fighter"), -- Cannibalistic Stakato Follower
(22625, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "spike_clan", 500, "null", 0, 0, "balanced"), -- Cannibalistic Stakato Leader
(22626, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "spike_clan", 500, "null", 0, 0, "balanced"), -- Cannibalistic Stakato Leader
(22627, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "spike_clan", 500, "null", 0, 0, "fighter"), -- Spiked Stakato Soldier
(22628, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "spike_clan", 500, "null", 0, 0, "fighter"), -- Spiked Stakato Drone
(22629, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "spike_clan", 500, "null", 0, 0, "fighter"), -- Spiked Stakato Captain
(22630, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "spike_clan", 500, "null", 0, 0, "mage"), -- Spiked Stakato Nurse
(22631, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "spike_clan", 500, "null", 0, 0, "mage"), -- Spiked Stakato Nurse
(22632, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "spike_clan", 500, "null", 0, 0, "balanced"), -- Spiked Stakato Baby
(22633, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "spike_clan", 500, "null", 0, 0, "mage"), -- Spiked Stakato Shaman
(22634, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 450, 0, "fire_clan", 1000, "null", 0, 0, "fighter"), -- Scarlet Stakato Worker
(22635, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 450, 0, "fire_clan", 1000, "null", 0, 0, "fighter"), -- Scarlet Stakato Soldier
(22636, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 450, 0, "fire_clan", 1000, "null", 0, 0, "fighter"), -- Scarlet Stakato Noble
(22637, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 450, 0, "fire_clan", 1000, "null", 0, 0, "fighter"), -- Tepra Scorpion
(22638, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 450, 0, "fire_clan", 1000, "null", 0, 0, "fighter"), -- Tepra Scarab
(22639, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 450, 0, "fire_clan", 1000, "null", 0, 0, "fighter"), -- Assassin Beetle
(22640, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 450, 0, "fire_clan", 1000, "null", 0, 0, "fighter"), -- Mercenary of Destruction
(22641, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 450, 0, "fire_clan", 1000, "null", 0, 0, "fighter"), -- Knight of Destruction
(22642, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "fire_clan", 500, "null", 0, 0, "fighter"), -- Lavastone Golem
(22643, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "fire_clan", 500, "null", 0, 0, "fighter"), -- Magma Golem
(22644, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 450, 0, "fire_clan", 1000, "null", 0, 0, "fighter"), -- Arimanes of Destruction
(22645, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 450, 0, "fire_clan", 1000, "null", 0, 0, "fighter"), -- Balor of Destruction
(22646, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 450, 0, "fire_clan", 1000, "null", 0, 0, "fighter"), -- Ashuras of Destruction
(22647, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 450, 0, "fire_clan", 1000, "null", 0, 0, "fighter"), -- Lavasillisk
(22648, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 450, 0, "fire_clan", 1000, "null", 0, 0, "fighter"), -- Blazing Ifrit
(22649, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 450, 0, "fire_clan", 1000, "null", 0, 0, "fighter"), -- Magma Drake
(22650, 7, 15, 5909, 300, 1, 1, 1, 4670, 15, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "reedfield_object", 300, 0, "fighter"), -- Mucrokian Fanatic
(22651, 7, 15, 5909, 300, 1, 1, 1, 4582, 15, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "reedfield_object", 300, 0, "fighter"), -- Mucrokian Ascetic
(22652, 7, 15, 5909, 300, 1, 1, 1, 4670, 15, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "reedfield_object", 300, 0, "fighter"), -- Mucrokian Savior
(22653, 7, 15, 5909, 300, 1, 1, 1, 4582, 15, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "reedfield_object", 300, 0, "fighter"), -- Mucrokian Preacher
(22654, 7, 15, 5909, 300, 1, 1, 1, 4067, 15, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "reedfield_object", 300, 0, "fighter"), -- Contaminated Mucrokian
(22655, 7, 15, 5909, 300, 1, 1, 1, 4072, 15, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "reedfield_object", 300, 0, "fighter"), -- Awakened Mucrokian
(22656, 7, 15, 5909, 300, 1, 1, 1, 4670, 15, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "reedfield_mucrokian", 300, 0, "fighter"), -- Suppressor
(22657, 7, 15, 5909, 300, 1, 1, 1, 4670, 15, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "reedfield_mucrokian", 300, 0, "fighter"), -- Executioner
(22658, 7, 15, 5910, 300, 1, 1, 1, 4582, 15, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "reedfield_mucrokian", 300, 0, "balanced"), -- Sentinel Waterspirit
(22659, 7, 15, 5910, 300, 1, 1, 1, 4582, 15, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "reedfield_mucrokian", 300, 0, "balanced"), -- Guardian Waterspirit
(22660, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lesser Giant
(22661, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lesser Giant Soldier
(22662, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lesser Giant Shooter
(22663, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lesser Giant Scout
(22664, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lesser Giant Mage
(22665, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lesser Giant Elder
(22666, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "giant_clan", 400, "null", 0, 0, "fighter"), -- Barif
(22667, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "giant_clan", 300, "null", 0, 0, "fighter"), -- Barif's Pet
(22668, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "giant_clan", 400, "null", 0, 0, "fighter"), -- Gamlin
(22669, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "giant_clan", 400, "null", 0, 0, "fighter"), -- Leogul
(22670, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "beast_clan", 400, "null", 0, 0, "fighter"), -- Cursed Lord
(22671, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "beast_clan", 300, "null", 0, 0, "fighter"), -- Cursed Guardian!
(22672, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "beast_clan", 300, "null", 0, 0, "fighter"), -- Cursed Seer
(22673, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "beast_clan", 300, "null", 0, 0, "fighter"), -- Hirokai
(22674, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "beast_clan", 300, "null", 0, 0, "fighter"), -- Imagro
(22675, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "beast_clan", 300, "null", 0, 0, "fighter"), -- Palit
(22676, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "beast_clan", 300, "null", 0, 0, "fighter"), -- Hamlet
(22677, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, "beast_clan", 300, "null", 0, 0, "fighter"), -- Klennot
(22678, 7, 15, 6145, 300, 1, 1, 1, 0, 0, 4254, 30, 0, 0, 0, 0, 0, 0, "robber_clan", 300, "null", 0, 0, "mage"), -- Grave Robber Summoner
(22679, 7, 15, 6145, 300, 1, 1, 1, 0, 0, 4254, 30, 0, 0, 0, 0, 0, 0, "robber_clan", 300, "null", 0, 0, "mage"), -- Grave Robber Magician
(22680, 7, 15, 6145, 300, 1, 1, 1, 5082, 15, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Grave Robber Worker
(22681, 7, 15, 6145, 300, 1, 1, 1, 6168, 15, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Grave Robber Warrior
(22682, 7, 15, 6145, 300, 1, 1, 1, 4643, 15, 0, 0, 0, 0, 0, 0, 350, 0, "null", 300, "null", 0, 0, "fighter"), -- Grave Robber Warrior of Light
(22683, 7, 15, 0, 300, 1, 1, 1, 4643, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Servitor of Darkness
(22684, 7, 15, 4573, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Servitor of Darkness
(22685, 7, 15, 4573, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Servitor of Darkness
(22686, 7, 15, 4573, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Servitor of Darkness
(22687, 7, 15, 4032, 300, 1, 1, 1, 4034, 15, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Phantoms of the Mine
(22688, 7, 15, 0, 300, 1, 1, 1, 4582, 15, 0, 0, 0, 0, 0, 0, 400, 0, "null", 300, "null", 0, 0, "fighter"), -- Evil Spirits of the Mine
(22689, 7, 15, 6145, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 300, "null", 0, 0, "fighter"), -- Mine Bug
(22690, 7, 15, 0, 300, 1, 1, 1, 4582, 15, 4035, 15, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Earth Wyrm's Descendant
(22691, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 10, 10, 0, 0, "ragnaorc_clan", 300, "null", 0, 0, "fighter"), -- Ragna Orc
(22692, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 10, 10, 0, 0, "ragnaorc_clan", 300, "null", 0, 0, "fighter"), -- Ragna Orc Warrior
(22693, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 10, 10, 400, 0, "ragnaorc_clan", 300, "null", 0, 0, "fighter"), -- Ragna Orc Hero
(22694, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 10, 10, 400, 0, "ragnaorc_clan", 300, "null", 0, 0, "fighter"), -- Ragna Orc Commander
(22695, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 10, 10, 0, 0, "ragnaorc_clan", 700, "null", 0, 0, "healer"), -- Ragna Orc Healer
(22696, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 10, 10, 0, 0, "ragnaorc_clan", 300, "null", 0, 0, "mage"), -- Ragna Orc Shaman
(22697, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 10, 10, 0, 0, "ragnaorc_clan", 300, "null", 0, 0, "mage"), -- Ragna Orc Priest
(22698, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, "ragnaorc_clan", 300, "null", 0, 15, "archer"), -- Ragna Orc Archer
(22699, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 30, 30, 800, 0, "ragnaorc_clan", 300, "null", 0, 15, "archer"), -- Ragna Orc Sniper
(22700, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 10, 10, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Varangka's Guardian
(22701, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 10, 10, 0, 0, "barankad_clan", 300, "null", 0, 0, "balanced"), -- Varangka's Dre Vanul
(22702, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 10, 10, 0, 0, "barankad_clan", 300, "null", 0, 0, "balanced"), -- Varangka's Destroyer
(22703, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Contaminated Morek Warrior
(22704, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 444, 0, "legendorc_clan", 300, "null", 0, 0, "fighter"), -- Contaminated Batur Warrior
(22705, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 444, 0, "legendorc_clan", 300, "null", 0, 0, "fighter"), -- Contaminated Batur Commander
(22706, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 444, 0, "legendorc_clan", 500, "null", 0, 0, "fighter"), -- Turka Follower's Ghost
(22707, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 444, 0, "legendorc_clan", 300, "null", 0, 0, "fighter"), -- Turka Commander's Ghost
(22708, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fantasy_clan", 300, "null", 0, 0, "fighter"), -- Invader Warrior of Nightmare
(22709, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fantasy_clan", 300, "null", 0, 0, "fighter"), -- Invader Healer of Nightmare
(22710, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fantasy_clan", 300, "null", 0, 0, "fighter"), -- Invader Guide of Nightmare
(22711, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fantasy_clan", 300, "null", 0, 0, "fighter"), -- Invader Destroyer of Nightmare
(22712, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fantasy_clan", 300, "null", 0, 0, "fighter"), -- Invader Assassin of Nightmare
(22713, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fantasy_clan", 300, "null", 0, 0, "fighter"), -- Invader Shaman of Nightmare
(22714, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fantasy_clan", 300, "null", 0, 0, "fighter"), -- Invader Archer of Nightmare
(22715, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fantasy_clan", 300, "null", 0, 0, "fighter"), -- Invader Soldier of Nightmare
(22716, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fantasy_clan", 300, "null", 0, 0, "fighter"), -- Invader Soldier of Nightmare
(22717, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fantasy_clan", 300, "null", 0, 0, "fighter"), -- Invader Disciple of Nightmare
(22718, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fantasy_clan", 300, "null", 0, 0, "fighter"), -- Invader Elite Soldier of Nightmare
(22719, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fantasy_clan", 300, "null", 0, 0, "fighter"), -- Nihil Invader Warrior
(22720, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fantasy_clan", 300, "null", 0, 0, "fighter"), -- Nihil Invader Healer
(22721, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fantasy_clan", 300, "null", 0, 0, "fighter"), -- Nihil Invader Guide
(22722, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fantasy_clan", 300, "null", 0, 0, "fighter"), -- Nihil Invader Destroyer
(22723, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fantasy_clan", 300, "null", 0, 0, "fighter"), -- Nihil Invader Assassin
(22724, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fantasy_clan", 300, "null", 0, 0, "fighter"), -- Nihil Invader Shaman
(22725, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fantasy_clan", 300, "null", 0, 0, "fighter"), -- Nihil Invader Archer
(22726, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fantasy_clan", 300, "null", 0, 0, "fighter"), -- Nihil Invader Soldier
(22727, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fantasy_clan", 300, "null", 0, 0, "fighter"), -- Nihil Invader Soldier
(22728, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fantasy_clan", 300, "null", 0, 0, "fighter"), -- Nihil Invader Disciple
(22729, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fantasy_clan", 300, "null", 0, 0, "fighter"), -- Nihil Invader Elite Soldier
(22730, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fantasy_clan", 300, "null", 0, 0, "fighter"), -- Mutant Warrior
(22731, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fantasy_clan", 300, "null", 0, 0, "fighter"), -- Mutant Healer
(22732, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fantasy_clan", 300, "null", 0, 0, "fighter"), -- Mutant Guide
(22733, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fantasy_clan", 300, "null", 0, 0, "fighter"), -- Mutant Destroyer
(22734, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fantasy_clan", 300, "null", 0, 0, "fighter"), -- Mutant Assassin
(22735, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fantasy_clan", 300, "null", 0, 0, "fighter"), -- Mutant Shaman
(22736, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fantasy_clan", 300, "null", 0, 0, "fighter"), -- Mutant Overlord
(22737, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fantasy_clan", 300, "null", 0, 0, "fighter"), -- Mutant Soldier
(22738, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fantasy_clan", 300, "null", 0, 0, "fighter"), -- Mutant Soldier
(22739, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fantasy_clan", 300, "null", 0, 0, "fighter"), -- Mutant Disciple
(22740, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fantasy_clan", 300, "null", 0, 0, "fighter"), -- Mutant Elite Soldier
(22741, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "robber_clan", 300, "null", 0, 0, "fighter"), -- Grave Robber Warrior
(22742, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Ornithomimus
(22743, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Deinonychus
(22744, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Ornithomimus
(22745, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 500, "null", 0, 0, "fighter"), -- Deinonychus
(22746, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 300, "null", 0, 0, "fighter"), -- Bgurent
(22747, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 300, "null", 0, 0, "fighter"), -- Brakian
(22748, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 300, "null", 0, 0, "fighter"), -- Groikan
(22749, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 300, "null", 0, 0, "fighter"), -- Treykan
(22750, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "bestacon_elite_clan", 300, "null", 0, 0, "fighter"), -- Elite Bgurent
(22751, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "bestacon_elite_clan", 300, "null", 0, 0, "fighter"), -- Elite Brakian
(22752, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "bestacon_elite_clan", 300, "null", 0, 0, "fighter"), -- Elite Groikan
(22753, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "bestacon_elite_clan", 300, "null", 0, 0, "fighter"), -- Elite Treykan
(22754, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 300, "null", 0, 0, "fighter"), -- Turtlelian
(22755, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 300, "null", 0, 0, "fighter"), -- Krajian
(22756, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 300, "null", 0, 0, "fighter"), -- Tardyon
(22757, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "raptilicon_elite_clan", 300, "null", 0, 0, "fighter"), -- Elite Turtlelian
(22758, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "raptilicon_elite_clan", 300, "null", 0, 0, "fighter"), -- Elite Krajian
(22759, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "raptilicon_elite_clan", 300, "null", 0, 0, "fighter"), -- Elite Tardyon
(22760, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 300, "null", 0, 0, "fighter"), -- Kanibi
(22761, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 300, "null", 0, 0, "fighter"), -- Kiriona
(22762, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 300, "null", 0, 0, "fighter"), -- Kaiona
(22763, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "cocracon_elite_clan", 300, "null", 0, 0, "fighter"), -- Elite Kanibi
(22764, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "cocracon_elite_clan", 300, "null", 0, 0, "fighter"), -- Elite Kiriona
(22765, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "cocracon_elite_clan", 300, "null", 0, 0, "fighter"), -- Elite Kaiona
(22766, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mithril Millipede
(22767, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Archery Knight
(22768, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 300, "null", 0, 0, "fighter"), -- Tanta Lizardman Scout
(22769, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tanta Lizardman Warrior
(22770, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tanta Lizardman Soldier
(22771, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tanta Lizardman Berserker
(22772, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "archer"), -- Tanta Lizardman Archer
(22773, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 800, 0, "null", 300, "null", 0, 0, "mage"), -- Tanta Lizardman Magician
(22774, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Tanta Lizardman Summoner
(22775, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sel Mahum Drill Sergeant
(22776, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sel Mahum Training Officer
(22777, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sel Mahum Drill Sergeant
(22778, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sel Mahum Drill Sergeant
(22779, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sel Mahum Escort Guard
(22780, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 400, "null", 0, 0, "fighter"), -- Sel Mahum Recruit
(22781, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sel Mahum Soldier
(22782, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 400, "null", 0, 0, "fighter"), -- Sel Mahum Recruit
(22783, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sel Mahum Soldier
(22784, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 400, "null", 0, 0, "fighter"), -- Sel Mahum Recruit
(22785, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sel Mahum Soldier
(22786, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "xel_private_clan", 400, "null", 0, 0, "fighter"), -- Sel Mahum Squad Leader
(22787, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "xel_private_clan", 400, "null", 0, 0, "fighter"), -- Sel Mahum Squad Leader
(22788, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "xel_private_clan", 400, "null", 0, 0, "fighter"), -- Sel Mahum Squad Leader
(22789, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "solina_n_clan", 300, "null", 0, 0, "balanced"), -- Guide Solina
(22790, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "solina_n_clan", 300, "null", 0, 0, "balanced"), -- Seeker Solina
(22791, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "solina_n_clan", 300, "null", 0, 0, "balanced"), -- Savior Solina
(22792, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "solina_n_clan", 300, "null", 0, 0, "balanced"), -- Disciple Solina
(22793, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "solina_n_clan", 300, "null", 0, 0, "balanced"), -- Ascetic Solina
(22794, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "divine_n_clan", 300, "null", 0, 0, "balanced"), -- Divinity Judge
(22795, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "divine_n_clan", 300, "null", 0, 0, "balanced"), -- Divinity Manager
(22796, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "divine_n_clan", 300, "null", 0, 0, "balanced"), -- Divinity Supervisor
(22797, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "divine_n_clan", 300, "null", 0, 0, "balanced"), -- Divinity Worshipper
(22798, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "n_divine_clan", 500, "null", 0, 0, "balanced"), -- Divinity Protector
(22799, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "n_divine_clan", 500, "null", 0, 0, "balanced"), -- Divinity Fighter
(22800, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "n_divine_clan", 500, "null", 0, 0, "mage"), -- Divinity Magus
(22801, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Cruel Pincer Golem
(22802, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Cruel Pincer Golem
(22803, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Cruel Pincer Golem
(22804, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Horrifying Jackhammer Golem
(22805, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Horrifying Jackhammer Golem
(22806, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Horrifying Jackhammer Golem
(22807, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Scout-type Golem No. 28
(22808, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "golem_p_clan", 300, "null", 0, 0, "fighter"), -- Scout-type Golem No. 2
(22809, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "golem_p_clan", 300, "null", 0, 0, "fighter"), -- Guard Golem
(22810, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "golem_p_clan", 300, "null", 0, 0, "fighter"), -- Micro Scout Golem
(22811, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "golem_p_clan", 300, "null", 0, 0, "fighter"), -- Great Chaos Golem
(22812, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "golem_p_clan", 300, "null", 0, 0, "fighter"), -- Boom Golem
(22813, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Demon's Banquet
(22814, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Demon's Banquet
(22815, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 0, "null", 0, 0, "balanced"), -- Drakos
(22816, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 0, "null", 0, 0, "balanced"), -- Maluk Maiden of the Valley
(22817, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 0, "null", 0, 0, "balanced"), -- Maluk Summoner of the Valley
(22818, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 0, "null", 0, 0, "balanced"), -- Exploding Orc Ghost
(22819, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 0, "null", 0, 0, "balanced"), -- Wrathful Orc Ghost
(22820, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 0, "null", 0, 0, "balanced"), -- Mesmer Drake
(22821, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 0, "null", 0, 0, "balanced"), -- Immortal Necromancer
(22822, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 0, "null", 0, 0, "balanced"), -- Drakos Warrior
(22823, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 0, "null", 0, 0, "balanced"), -- Drakos Assassin
(22824, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 0, "null", 0, 0, "balanced"), -- Drakos Guardian
(22825, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 0, "null", 0, 0, "balanced"), -- Giant Noxious Scorpion
(22826, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 0, "null", 0, 0, "balanced"), -- Noxious Scorpion
(22827, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 0, "null", 0, 0, "balanced"), -- Batwing Drake
(22828, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 0, "null", 0, 0, "balanced"), -- Parasitic Leech
(22829, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 0, "null", 0, 0, "balanced"), -- Emerald Drake
(22830, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 0, "null", 0, 0, "balanced"), -- Gem Dragon
(22831, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 0, "null", 0, 0, "balanced"), -- Dragon Tracker of the Valley
(22832, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 0, "null", 0, 0, "balanced"), -- Dragon Scout of the Valley
(22833, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 0, "null", 0, 0, "balanced"), -- Sand Drake Tracker
(22834, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 0, "null", 0, 0, "balanced"), -- Dust Dragon Tracker
(22835, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 0, "null", 0, 0, "balanced"), -- Magma Drake Mother
(22836, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 0, "null", 0, 0, "balanced"), -- Magma Drake Hatchling
(22837, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 0, "null", 0, 0, "balanced"), -- Gem Dragon Hatchling
(22838, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 0, "null", 0, 0, "balanced"), -- Maluk Leader
(22839, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 0, "null", 0, 0, "balanced"), -- Maluk Warlord
(22840, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 0, "null", 0, 0, "balanced"), -- Maluk Hunter
(22841, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 0, "null", 0, 0, "balanced"), -- Maluk Princess
(22842, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 0, "null", 0, 0, "balanced"), -- Maluk Banshee
(22843, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 0, "null", 0, 0, "balanced"), -- Maluk Sniper
(22844, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 0, "null", 0, 0, "balanced"), -- Dragon Knight
(22845, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 0, "null", 0, 0, "balanced"), -- Dragon Knight
(22846, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 0, "null", 0, 0, "balanced"), -- Elite Dragon Knight
(22847, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 0, "null", 0, 0, "balanced"), -- Dragon Knight Warrior
(22848, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 0, "null", 0, 0, "balanced"), -- Drake Leader
(22849, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 0, "null", 0, 0, "balanced"), -- Drake Warrior
(22850, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 0, "null", 0, 0, "balanced"), -- Drake Scout
(22851, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 0, "null", 0, 0, "balanced"), -- Drake Mage
(22852, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 0, "null", 0, 0, "balanced"), -- Dragon Guard
(22853, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 0, "null", 0, 0, "balanced"), -- Dragon Mage
(22854, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 0, "null", 0, 0, "balanced"), -- Bloody Karik
(22855, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 0, "null", 0, 0, "balanced"), -- Bloody Berserker
(22856, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 0, "null", 0, 0, "balanced"), -- Bloody Karinness
(22857, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 0, "null", 0, 0, "balanced"), -- Knoriks
(22858, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 0, "null", 0, 0, "mage"), -- Necromancer of the Valley
(22859, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 0, "null", 0, 0, "balanced"), -- Howl
(22860, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 0, "null", 0, 0, "balanced"), -- Hungry Parasitic Leech
(22861, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 0, "null", 0, 0, "balanced"), -- Hard Noxious Scorpion
(22862, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 0, "null", 0, 0, "balanced"), -- Drakos Hunter
(25001, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Greyclaw Kutus
(25002, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guard of Kutus
(25003, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Pawn of Kutus
(25004, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Turek Mercenary Captain
(25005, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 15, "archer"), -- Turek Mercenary Archer
(25006, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Turek Mercenary Warrior
(25007, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Retreat Spider Cletu
(25008, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Cletu's Retainer
(25009, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Cletu's Pawn
(25010, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Furious Thieles
(25011, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guard of Thieles
(25012, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Follower of Thieles
(25013, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Ghost of Peasant Leader
(25014, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Ghost of Peasant
(25015, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 15, "archer"), -- Ghost of Peasant
(25016, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- The 3rd Underwater Guardian
(25017, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Escort of the 3rd Guardian
(25018, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Support of the 3rd Guardian
(25019, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Pan Dryad
(25020, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Breka Warlock Pastu
(25021, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Pastu's Silhouette
(25022, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Pastu's Shadow
(25023, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Stakato Queen Zyrnna
(25024, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Jeruna's Guard Captain
(25025, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Jeruna's Guard
(25026, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Ketra Commander Atis
(25027, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 15, "archer"), -- Ketra Marksman
(25028, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ketra Raider
(25029, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Atraiban
(25030, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Atraiban's Top Disciple
(25031, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Atraiban's Disciple
(25032, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Eva's Guardian Millenu
(25033, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Millenu Guard Shaman
(25034, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Millenu Guard Warrior
(25035, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Shilen's Messenger Cabrio
(25036, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 15, "archer"), -- Cabrio Captor
(25037, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Cabrio Blader
(25038, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Tirak
(25039, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tirak's Guard
(25040, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tirak's Knight
(25041, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Remmel
(25042, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 15, "archer"), -- Remmel's Archer
(25043, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Remmel's Guard
(25044, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Barion
(25045, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Barion's Dark Mage
(25046, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Barion's Grunt
(25047, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Karte
(25048, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Karte's Chief Knight
(25049, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Karte's Royal Guard
(25050, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Verfa
(25051, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Rahha
(25052, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Priestess of Rahha
(25053, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Fanatics of Rahha
(25054, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Kernon
(25055, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Taliadon
(25056, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Vemsk
(25057, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Beacon of Blue Sky
(25058, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 15, "archer"), -- Beacon's Shooter
(25059, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Beacon's Warrior
(25060, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Unrequited Kael
(25061, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kael's Bead
(25062, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kael's Escort
(25063, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Chertuba of Great Soul
(25064, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Wizard of Storm Teruk
(25065, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Teruk's Escort
(25066, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Teruk's Knight
(25067, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Captain of Red Flag Shaka
(25068, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 15, "archer"), -- Shaka's Shooter
(25069, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Shaka's Follower
(25070, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Enchanted Forest Watcher Ruell
(25071, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ruell's Wind
(25072, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ruell's Unicorn
(25073, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Bloody Priest Rudelto
(25074, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Rudelto's Banshee
(25075, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Rudelto's Dre Vanul
(25076, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Princess Molrang
(25077, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Captain Dogun
(25078, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Princess' Guard
(25079, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Cat's Eye Bandit
(25080, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Mercenary
(25081, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Cat's Eye Bandit
(25082, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Leader of Cat Gang
(25083, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Cat Gang
(25084, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Cat Gang
(25085, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Timak Orc Chief Ranger
(25086, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 15, "archer"), -- Timak Orc Ranger
(25087, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Timak Orc Ranger
(25088, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Crazy Mechanic Golem
(25089, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Soulless Wild Boar
(25090, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Soulless Wolf
(25091, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Soulless Bear
(25092, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Korim
(25093, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Korim Chief Guard Kaywon
(25094, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Korim Guards
(25095, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Elf Renoa
(25096, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Renoa's Elpy
(25097, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Renoa's Hog
(25098, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Sejarr's Servitor
(25099, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Rotting Tree Repiro
(25100, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Spirit of Sea of Spores
(25101, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Fighter of Sea of Spores
(25102, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Shacram
(25103, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Sorcerer Isirr
(25104, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Isirr's Guard
(25105, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Isirr's Guards
(25106, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Ghost of the Well Lidia
(25107, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 15, "archer"), -- Lidia's Archer
(25108, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lidia's Fighter
(25109, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Antharas Priest Cloe
(25110, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Cloe's Servitor
(25111, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Cloe's Servitor
(25112, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Beleth's Agent, Meana
(25113, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Meana's Maid
(25114, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Meana's Guard Doll
(25115, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Icarus Sample 1
(25116, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 15, "archer"), -- Icarus Sample 2
(25117, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Icarus Sample 3
(25118, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Guillotine, Warden of the Execution Grounds
(25119, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Messenger of Fairy Queen Berun
(25120, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Berun's Officer
(25121, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Berun's Prattler
(25122, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Refugee Applicant Leo
(25123, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Leo's Servant
(25124, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Leo's Steward
(25125, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Fierce Tiger King Angel
(25126, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Longhorn Golkonda
(25127, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Langk Matriarch Rashkos
(25128, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Vuku Grand Priest Gharmash
(25129, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Vuku Shaman
(25130, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gharmash's Pet Trimden
(25131, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Carnage Lord Gato
(25132, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 15, "archer"), -- Gato's Marksman
(25133, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gato's Troop Leader
(25134, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Leto Chief Talkin
(25135, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Talkin's Priest
(25136, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Talkin's Bodyguard
(25137, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Beleth's Seer, Sephia
(25138, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Soul Drinker
(25139, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Sephia's Salve
(25140, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Hekaton Prime
(25141, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Hekaton Cottus
(25142, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Hekaton Chires
(25143, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Fire of Wrath Shuriel
(25144, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Shuriel's Oracle
(25145, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Shuriel's Paladin
(25146, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Serpent Demon Bifrons
(25147, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Assassin of Bifrons
(25148, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Butcher of Bifrons
(25149, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Zombie Lord Crowl
(25150, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 15, "archer"), -- Evil Spirit Archer
(25151, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Evil Spirit Warrior
(25152, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Flame Lord Shadar
(25153, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Claws of Shadar
(25154, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Whip of Shadar
(25155, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Shaman King Selu
(25156, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Fanatic Shaman
(25157, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Fanatic Soldier
(25158, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- King Tarlk
(25159, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Paniel the Unicorn
(25160, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Rapini the Unicorn
(25161, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ririf the Unicorn
(25162, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Giant Marpanak
(25163, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Roaring Skylancer
(25166, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Ikuntai
(25167, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ikuntai's Servitor
(25168, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Pawn of Ikuntai
(25169, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Ragraman
(25170, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Lizardmen Leader Hellion
(25171, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 15, "archer"), -- Hellion's Archers
(25172, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Hellion's Guards
(25173, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Tiger King Karuta
(25174, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Karuta's Follower
(25175, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Karuta's Inferiors
(25176, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Black Lily
(25177, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian Knight of Black Lily
(25178, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Servitor of Black Lily
(25179, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Guardian of the Statue of Giant Karum
(25180, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Karum's Guard
(25181, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Karum's Warrior
(25182, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Demon Kuri
(25183, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kuri's Wife
(25184, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Devil Blader of Chaos
(25185, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Tasaba Patriarch Hellena
(25186, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Hellena's Marksman
(25187, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Hellena's Soldier
(25188, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Apepi
(25189, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Cronos' Servitor Mumu
(25190, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mumu's Wizard
(25191, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mumu's Warrior
(25192, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Earth Protector Panathen
(25193, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Panathen's Knight
(25194, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Panathen's Protectors
(25198, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Fafurion's Herald Lokness
(25199, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Water Dragon Priest Sheshark
(25200, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Family of Sheshark
(25201, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Guard of Sheshark
(25202, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Krokian Padisha Sobekk
(25203, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Parhit Padisha Sobekk
(25204, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Krokian Padisha Sobekk
(25205, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Ocean Flame Ashakiel
(25206, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Ashakiel's Blade
(25207, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Ashakiel's Rod
(25208, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Water Couatl Ateka
(25209, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ateka's Shaman
(25210, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ateka's Grunt
(25211, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Sebek
(25212, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sebek's Priest
(25213, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sebek's Fanatic
(25214, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Fafurion's Page Sika
(25215, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sika's Wizard
(25216, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sika's Fighter
(25217, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Cursed Clara
(25218, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Clara's Marksman
(25219, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Clara's Pawn
(25220, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Death Lord Hallate
(25221, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Death Mage Krician
(25222, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Death Fighter Harik
(25223, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Soul Collector Acheron
(25224, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Soul Slasher
(25225, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Soul Strainer
(25226, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Roaring Lord Kastor
(25227, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "mage"), -- Kastor's Priest
(25228, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Kastor's Prefect
(25229, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Storm Winged Naga
(25230, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Timak Priest Ragoth
(25231, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Ragoth's Guard
(25232, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Ragoth's Herald
(25233, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Spirit of Andras, the Betrayer
(25234, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Ancient Drake
(25235, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Vanor Chief Kandra
(25236, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Kandra's Healer
(25237, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Kandra's Guard
(25238, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Abyss Brukunt
(25239, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Monstrous Beast of Abyss Brukunt
(25240, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Wild Beast of Abyss Brukunt
(25241, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Harit Hero Tamash
(25242, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Tamash's Advisor
(25243, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Tamash's Servant
(25244, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Last Lesser Giant Olkuth
(25245, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Last Lesser Giant Glaki
(25246, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Glaki's Henchman
(25247, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Glaki's Servant
(25248, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Doom Blade Thanatos
(25249, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Menacing Palatanos
(25250, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Man-Eating Plant of Palatanos
(25251, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Sapling of Palatanos
(25252, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Palibati Queen Themis
(25253, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Handmaiden of Themis
(25254, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Themis' Sentinel
(25255, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Gargoyle Lord Tiphon
(25256, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Taik High Prefect Arak
(25257, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 15, "archer"), -- Arak's Archer
(25258, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Arak's Footman
(25259, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Zaken's Butcher Krantz
(25260, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Iron Giant Totem
(25261, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 15, "archer"), -- Totem Guard Archer
(25262, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Totem Guard
(25263, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Kernon's Faithful Servant Kelone
(25264, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Kelone's Assassin
(25265, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Kelone's Secret Knight
(25266, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Bloody Empress Decarbia
(25267, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Decarbia's Royal Guard
(25268, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Decarbia's Escort
(25269, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Beast Lord Behemoth
(25270, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Behemoth Javeliner
(25271, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Behemoth Flare
(25272, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Partisan Leader Talakin
(25273, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Carnamakos
(25274, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Carnabarun
(25275, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Carnassiud
(25276, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Death Lord Ipos
(25277, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Lilith's Witch Marilion
(25278, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Dead Soul of Stigma
(25279, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Evil Spirit of Stigma
(25280, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Pagan Watcher Cerberon
(25281, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Anakim's Nemesis Zakaron
(25282, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Death Lord Shax
(25283, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Lilith
(25284, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "mage"), -- Lilith's Agent
(25285, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Lilith's Escort
(25286, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Anakim
(25287, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Anakim's Guardian
(25288, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Anakim's Royal Guard
(25289, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Anakim's Executor
(25290, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Daimon the White-Eyed
(25291, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Family of Daimon
(25292, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Family of Daimon
(25293, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Hesti Guardian Deity of the Hot Springs
(25294, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Fighter of Hestia
(25295, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Follower of Hestia
(25296, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Icicle Emperor Bumbalump
(25297, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Icicle Giant
(25298, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Icicle Giant
(25299, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Ketra's Hero Hekaton
(25300, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 15, "archer"), -- Scout of Hekaton
(25301, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Servant of Hekaton
(25302, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Ketra's Commander Tayr
(25303, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Tayr's Aide
(25304, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Tayr's Guard
(25305, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Ketra's Chief Brakki
(25306, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Soul of Fire Nastron
(25307, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Family of Nastron
(25308, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Family of Nastron
(25309, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Varka's Hero Shadith
(25310, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Shadith's Royal Guard Captain
(25311, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Shadith's Sentinel
(25312, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Varka's Commander Mos
(25313, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Mos' Aide
(25314, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Mos' Guard
(25315, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Varka's Chief Horus
(25316, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Soul of Water Ashutar
(25317, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Family of Ashutar
(25318, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Family of Ashutar
(25319, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Ember
(25320, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Sentinel of Ember
(25321, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Messenger of Ember
(25322, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Demon's Agent Falston
(25323, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Falston's Disciple
(25324, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Servant of Falston
(25325, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Flame of Splendor Barakiel
(25326, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Barakiel's Disciple
(25327, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Barakiel's Acolyte
(25328, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Eilhalder von Hellmann
(25329, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Violet
(25330, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Kurstin
(25331, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Mina
(25332, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Dorian
(25333, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Anakazel
(25334, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Anakazel
(25335, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Anakazel
(25336, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Anakazel
(25337, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Anakazel
(25338, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Anakazel
(25339, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Shadow of Halisha
(25340, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Knight of Shadow
(25341, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Knight of Shadow
(25342, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Shadow of Halisha
(25343, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Knight of Shadow
(25344, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 15, "archer"), -- Knight of Shadow
(25345, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Knight of shadow
(25346, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Shadow of Halisha
(25347, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Knight of Shadow
(25348, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Knight of Shadow
(25349, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Shadow of Halisha
(25350, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Knight of Shadow
(25351, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Knight of Shadow
(25352, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Giant Wasteland Basilisk
(25353, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Giant Wasteland Basilisk
(25354, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Gargoyle Lord Sirocco
(25355, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sirocco's Gargoyle
(25356, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sirocco's Guards
(25357, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Sukar Wererat Chief
(25358, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sukar Wererat Guard
(25359, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sukar Wererat Priest
(25360, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Tiger Hornet
(25361, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Yellow Hornet
(25362, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Tracker Leader Sharuk
(25363, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sharuk's Tracker
(25364, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sharuk's Marksman
(25365, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Patriarch Kuroboros
(25366, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Kuroboros' Priest
(25367, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kuroboros' Follower
(25368, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Kuroboros' Discipline
(25369, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Soul Scavenger
(25370, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Corpse Scavenger
(25371, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Anima Scavenger
(25372, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Discarded Guardian
(25373, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Malex Herald of Dagoniel
(25374, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Abyss Flyer
(25375, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Zombie Lord Ferkel
(25376, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ferkel's Warrior
(25377, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ferkel's Priest
(25378, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Madness Beast
(25379, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dementia Beast
(25380, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Kaysha Herald of Icarus
(25381, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Nightmare Flyer
(25382, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Hostile Flyer
(25383, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Revenant of Sir Calibus
(25384, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Servant of Calibus
(25385, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Evil Spirit Tempest
(25386, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ghost of the Execution Grounds
(25387, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Malignant Spirit of the Execution Grounds
(25388, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Red Eye Captain Trakia
(25389, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 15, "archer"), -- Red Eye Archer
(25390, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Red Eye Guards
(25391, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Nurka's Messenger
(25392, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Captain of Queen's Royal Guards
(25393, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Marsh Stakato Noble
(25394, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Premo Prime
(25395, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Archon Susceptor
(25396, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kusion Susceptor
(25397, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gustos Susceptor
(25398, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Beleth's Eye
(25399, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Apprentice of Watchman
(25400, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Page of Watchman
(25401, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Skyla
(25402, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Retainer of Skyla
(25403, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Follower of Skyla
(25404, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Corsair Captain Kylon
(25405, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kylon's Pirate
(25406, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kylon's Mate
(25407, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Lord Ishka
(25408, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Ishka's Elite Officer
(25409, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Ishka's Elite Soldier
(25410, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Road Scavenger Leader
(25411, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Road Scavenger Henchman
(25412, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Necrosentinel Royal Guard
(25413, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 15, "archer"), -- Necrosentinel Archer
(25414, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Necrosentinel Soldier
(25415, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Nakondas
(25416, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Nakondas' Slave
(25417, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Nakondas' Chain
(25418, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Dread Avenger Kraven
(25419, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dread Panther
(25420, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Orfen's Handmaiden
(25421, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Trisalim Escort
(25422, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Page of Rotting Tree
(25423, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "timiniel_clan", 300, "null", 0, 0, "balanced"), -- Fairy Queen Timiniel
(25424, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "timiniel_clan", 300, "null", 0, 0, "fighter"), -- Timiniel's Royal Guards
(25425, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "timiniel_clan", 300, "null", 0, 0, "fighter"), -- Timiniel's Royal Guard Captain
(25426, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Betrayer of Urutu Freki
(25427, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Freki's Vampire Bat
(25428, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Freki's Wild Bear
(25429, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Mammon Collector Talos
(25430, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Talos' Cohort
(25431, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Flamestone Golem
(25432, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Elemental of Flame
(25433, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Elemental of Spark
(25434, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Bandit Leader Barda
(25435, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Barda's Bandit
(25436, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Barda's Shaman
(25437, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Timak Orc Gosmos
(25438, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Thief Kelbar
(25439, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kelbar's Inferior
(25440, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kelbar's Wizard
(25441, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Evil Spirit Cyrion
(25442, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Evil Creature of Forest
(25443, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Anger of Forest
(25444, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Enmity Ghost Ramdal
(25445, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Enmity Ghosts
(25446, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 15, "archer"), -- Shooter of Enmity
(25447, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Immortal Savior Mardil
(25448, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Immortal Savior
(25449, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Immortal Guide
(25450, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Cherub Galaxia
(25451, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Galaxia's Guards
(25452, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Messenger of Angel
(25453, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Meanas Anor
(25454, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Wyvern of Marsh
(25455, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Succubus of Marsh
(25456, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Mirror of Oblivion
(25457, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Shards of Oblivion
(25458, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Shadow of Oblivion
(25459, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Shards of Oblivion
(25460, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Deadman Ereve
(25461, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ereve's Knight
(25462, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ereve's Squire
(25463, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Harit Guardian Garangky
(25464, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Garangky Guard Captain
(25465, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Garangky Guard Shaman
(25466, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Garangky Guard
(25467, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Gorgolos
(25468, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Cursed Life
(25469, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Cursed Soul
(25470, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Last Titan Utenus
(25471, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Utenus' Wizard
(25472, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Utenus' Guard
(25473, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Grave Robber Kim
(25474, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kim's Gang
(25475, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Ghost Knight Kabed
(25476, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kabed's Soldier
(25477, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 15, "archer"), -- Kabed's Archer
(25478, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Shilen's Priest Hisilrome
(25479, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Hisilrome's Servitor
(25480, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Hisilrome's Page
(25481, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Magus Kenishee
(25482, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Shadow of Kenishee
(25483, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Phantom of Kenishee
(25484, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Zaken's Chief Mate Tillion
(25485, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tillion's Inferior
(25486, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tillion's Bat
(25487, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Water Spirit Lian
(25488, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Spirit of Gildor
(25489, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Gildor
(25490, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Gwindorr
(25491, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guard of Gwindorr
(25492, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Follower of Gwindorr
(25493, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Eva's Spirit Niniel
(25494, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Spirit of Niniel
(25495, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Spirit of Niniel
(25496, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Fafurion's Envoy Pingolpin
(25497, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Fafurion's Envoy
(25498, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Fafurion's Henchman Istary
(25499, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Alligator of Istary
(25500, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Alligator of Istary
(25501, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "balanced"), -- Boss Akata
(25502, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Akata's Thug
(25503, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Akata's Lackey
(25504, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "balanced"), -- Nellis' Vengeful Spirit
(25505, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Nellis' Follower
(25506, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "balanced"), -- Rayito the Looter
(25507, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Rayito's Henchman
(25508, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Rayito's Henchman
(25509, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "balanced"), -- Dark Shaman Varangka
(25510, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Varangka's Descendant
(25511, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Varangka's Page
(25512, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "golem_clan", 300, "null", 0, 0, "balanced"), -- Gigantic Chaos Golem
(25514, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Queen Shyeed
(25515, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Spiked Stakato
(25516, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Spiked Stakato
(25523, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "balanced"), -- Plague Golem
(25524, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Flamestone Giant
(25525, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Flame Spirit
(25526, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Charged Spirit
(25527, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Uruka
(25528, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ndg_clan", 300, "null", 0, 0, "balanced"), -- Tiberias
(25529, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ndg_clan", 300, "null", 0, 0, "balanced"), -- Garden Guard
(25530, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ndg_clan", 300, "null", 0, 0, "balanced"), -- Garden Guard
(25531, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Darnel
(25532, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "granisko_clan", 300, "null", 0, 0, "balanced"), -- Kechi
(25533, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 200, 0, "granisko_clan", 300, "null", 0, 0, "fighter"), -- Kechi's Henchman
(25534, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Tears
(25535, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 200, 0, "null", 300, "null", 0, 0, "fighter"), -- Tears
(25536, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Hannibal
(25537, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Enmity
(25538, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Vengeance
(25539, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Typhoon
(25540, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Demon Prince
(25541, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Fiend
(25542, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ranku_clan", 2000, "null", 0, 0, "balanced"), -- Ranku
(25543, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ranku_clan", 300, "null", 0, 0, "balanced"), -- Eidolon
(25544, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Tully
(25545, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Tully's Banshee
(25546, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Rhianna the Traitor
(25547, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Rhianna's Escort
(25548, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Rhianna's Healer
(25549, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Tesla the Deceiver
(25550, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Tesla's Apprentice
(25551, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Tesla's Herald
(25552, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Soul Hunter Chakundel
(25553, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Durango the Crusher
(25554, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Brutus the Obstinate
(25555, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Brutus' Right Hand
(25556, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Brutus' Left Hand
(25557, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Ranger Karankawa
(25558, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Karankawa's Root
(25559, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Karankawa's Blossom
(25560, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Sargon the Mad
(25561, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Sargon's Attendant
(25562, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Sargon's Squire
(25563, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Beautiful Atrielle
(25564, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Atrielle's Follower
(25565, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Atrielle's Minion
(25566, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Nagen the Tomboy
(25567, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Nagen's Cohort
(25568, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Nagen's Friend
(25569, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Jax the Destroyer
(25570, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 15, "archer"), -- Jax's Vanguard
(25571, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Jax's Raider
(25572, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Hager the Outlaw
(25573, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Hager's Henchman
(25574, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Hager's Bodyguard
(25575, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- All-Seeing Rango
(25576, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Rango's Iris
(25577, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Rango's Lens
(25578, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Jakard
(25579, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Helsing
(25580, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Helsing's Guard
(25581, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Helsing's Assassin
(25582, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Gillien
(25583, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Gillien's Daughter
(25584, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Gillien's Attendant
(25585, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Medici
(25586, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Medici's Sister
(25587, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Medici's Brother
(25588, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Immortal Muus
(25589, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Brand the Exile
(25590, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Brand's Chamberlain
(25591, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Brand's Servant
(25592, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Commander Koenig
(25593, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Gerg the Hunter
(25594, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Gerg's Follower
(25595, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Gerg's Henchman
(25596, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 600, "null", 0, 0, "balanced"), -- Ocular Servitor
(25597, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Heurel
(25598, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Gegei
(25599, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Iglas
(25600, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 500, "null", 0, 0, "balanced"), -- Temenir
(25601, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 500, "null", 0, 0, "balanced"), -- Draksius
(25602, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 500, "null", 0, 0, "balanced"), -- Kiretcenah
(25603, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Darion
(25604, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Mutated Elpy
(25605, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Naia Spore
(25606, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Naia Spore
(25607, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Naia Spore
(25608, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Naia Spore
(25609, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Epidos
(25610, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Epidos
(25611, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Epidos
(25612, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Epidos
(25613, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "castle_clan", 300, "null", 0, 0, "balanced"), -- Naia Spore
(25614, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Floating Ghost
(25615, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Floating Ghost
(25616, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Lost Warden
(25617, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Lost Warden
(25618, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Lost Warden
(25619, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Lost Warden
(25620, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Lost Warden
(25621, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Lost Warden
(25622, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Lost Warden
(25623, 7, 15, 0, 400, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "masterrider_clan", 1000, "null", 0, 0, "balanced"), -- Valdstone
(25624, 7, 15, 0, 400, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "loc_clan", 1000, "null", 0, 0, "balanced"), -- Rok
(25625, 7, 15, 0, 400, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "bansheequeen_clan", 1000, "null", 0, 0, "balanced"), -- Enira
(25626, 7, 15, 0, 400, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "mutantdrakewing_clan", 1000, "null", 0, 0, "balanced"), -- Dius
(25627, 7, 15, 0, 400, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "loc_clan", 1000, "null", 0, 0, "balanced"), -- Mutant Bird
(25628, 7, 15, 0, 400, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "loc_clan", 1000, "null", 0, 0, "balanced"), -- Dra Hawk
(25629, 7, 15, 0, 400, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "bansheequeen_clan", 1000, "null", 0, 0, "balanced"), -- Floating Skull
(25630, 7, 15, 0, 400, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "bansheequeen_clan", 1000, "null", 0, 0, "balanced"), -- Floating Zombie
(25631, 7, 15, 0, 400, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "mutantdrakewing_clan", 1000, "null", 0, 0, "balanced"), -- Drake Wing
(25632, 7, 15, 0, 400, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "mutantdrakewing_clan", 1000, "null", 0, 0, "balanced"), -- Drak
(25633, 7, 15, 0, 400, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "masterrider_clan", 1000, "null", 0, 0, "balanced"), -- Elite Rider
(25634, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Cohemenes
(25635, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Argekunte
(25636, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Ravenous Soul Devourer
(25637, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Karpencharr
(25638, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Romerohiv
(25639, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Hitchkarshiek
(25640, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Freedkyilla
(25641, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Yehan Cravenizad
(25642, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Yehan Jaxsibhan
(25643, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Awakened Ancient Sentry
(25644, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Awakened Ancient Severer
(25645, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Awakened Ancient Soul Extractor
(25646, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Awakened Ancient Soul Devourer
(25647, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Awakened Ancient Fighter
(25648, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Awakened Ancient Fighter
(25649, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Awakened Ancient Executor
(25650, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Awakened Ancient Executor
(25651, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Awakened Ancient Prophet
(25652, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Awakened Ancient Prophet
(25653, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "rune_pailaka_clan", 300, "null", 0, 0, "balanced"), -- Kanadis Herald
(25654, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "rune_pailaka_clan", 300, "null", 0, 0, "balanced"), -- Kanadis Herald
(25655, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "rune_pailaka_clan", 300, "null", 0, 0, "balanced"), -- Kanadis Herald
(25656, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "rune_pailaka_clan", 300, "null", 0, 0, "balanced"), -- Kanadis Fanatic
(25657, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "rune_pailaka_clan", 300, "null", 0, 0, "balanced"), -- Kanadis Fanatic
(25658, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "rune_pailaka_clan", 300, "null", 0, 0, "balanced"), -- Kanadis Fanatic
(25659, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "rune_pailaka_clan", 300, "null", 0, 0, "balanced"), -- Kanadis Guide
(25660, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "rune_pailaka_clan", 300, "null", 0, 0, "balanced"), -- Kanadis Guide
(25661, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "rune_pailaka_clan", 300, "null", 0, 0, "balanced"), -- Kanadis Guide
(25662, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "rune_pailaka_clan", 300, "null", 0, 0, "balanced"), -- Kanadis Follower
(25663, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "rune_pailaka_clan", 300, "null", 0, 0, "balanced"), -- Kanadis Follower
(25664, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "rune_pailaka_clan", 300, "null", 0, 0, "balanced"), -- Kanadis Follower
(25665, 7, 25, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 1500, "null", 0, 0, "balanced"), -- Yehan Klodekus
(25666, 7, 25, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 1500, "null", 0, 0, "balanced"), -- Yehan Klanikus
(25667, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Cannibalistic Stakato Chief
(25668, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Cannibalistic Stakato Chief
(25669, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Cannibalistic Stakato Chief
(25670, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Cannibalistic Stakato Chief
(25671, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Queen Shyeed
(25672, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Spiked Stakato
(25673, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Spiked Stakato
(25674, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gwindorr
(25675, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guard of Gwindorr
(25676, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Follower of Gwindorr
(25677, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Water Spirit Lian
(25678, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Spirit of Gildor
(25679, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Gildor
(25680, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Giant Marpanak
(25681, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gorgolos
(25682, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Cursed Life
(25683, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Cursed Soul
(25684, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Last Titan Utenus
(25685, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Utenus' Wizard
(25686, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Utenus' Guard
(25687, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Hekaton Prime
(25688, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Hekaton Cottus
(25689, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Hekaton Chires
(25690, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Aenkinel
(25691, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Aenkinel
(25692, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Aenkinel
(25693, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Aenkinel
(25694, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Aenkinel
(25695, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Aenkinel
(25696, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Taklacan
(25697, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Torumba
(25698, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dopagen
(25699, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "freya_clan", 300, "null", 0, 0, "fighter"), -- Glakias
(25700, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "freya_clan", 300, "null", 0, 0, "fighter"), -- Glakias
(25701, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "grail_clan", 300, "null", 0, 0, "balanced"), -- Anais
(25702, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guard of the Grail
(25703, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gigantic Golem
(25704, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gigantic Golem Subordinate
(25705, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gigantic Boom Golem
(25706, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "abyss_clan", 1000, "null", 0, 0, "fighter"), -- Lost Watcher
(25707, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "abyss_clan", 1000, "null", 0, 0, "fighter"), -- Lost Watcher
(25708, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "abyss_clan", 1000, "null", 0, 0, "fighter"), -- Lost Beholder
(25709, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lost Warden
(25710, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lost Captain
(25711, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lost Guard
(25712, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lost Assistant Guard
(25713, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Darnel
(25714, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "granisko_clan", 300, "null", 0, 0, "fighter"), -- Kechi
(25715, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "granisko_clan", 300, "null", 0, 0, "fighter"), -- Kechi's Subordinate
(25716, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tears
(25717, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tears
(25718, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Emerald Horn
(25719, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Dust Rider
(25720, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Bleeding Fly
(25721, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Blackdagger Wing
(25722, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Shadow Summoner
(25723, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Spike Slasher
(25724, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Muscle Bomber
(25725, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 0, "null", 0, 0, "fighter"), -- Drake Lord
(25726, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 0, "null", 0, 0, "fighter"), -- Behemoth Leader
(25727, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 0, "null", 0, 0, "fighter"), -- Dragon Beast
(25728, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Death Knight
(25729, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Death Knight
(25730, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Demon's Banquet
(25731, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Demon's Banquet
(25732, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Dragon Beast
(25733, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Gem Dragon
(25734, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Parasitic Leech
(25735, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Fairy Warrior
(25736, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Fairy Slasher
(25737, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Fairy Attacker
(25738, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Satyr Wizard
(25739, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Satyr Summoner
(25740, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Satyr Witch
(25741, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trichin Defender
(25742, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Centaur Archer
(25743, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Beorning Berserker
(25744, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Double Nightmare
(25745, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kimerian
(25746, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kimerian Ghost
(25747, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kimerian
(25748, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Fairy Warrior
(25749, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Fairy Slasher
(25750, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Fairy Attacker
(25751, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Satyr Wizard
(25752, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Satyr Summoner
(25753, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Satyr Witch
(25754, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trichin Defender
(25755, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Centaur Archer
(25756, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Beorning Berserker
(25757, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Double Nightmare
(25758, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kimerian
(25759, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kimerian Ghost
(25760, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Turanclass
(25761, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Georgios
(25762, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Angelos
(25763, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Theofanis
(25764, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Steregos
(25765, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Beast
(25766, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Talicrome
(25767, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Meikaliya
(25768, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Evangelos
(25769, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Sotiris
(25770, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Lazaros
(25771, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Noctum
(25772, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Harnak Ghost
(25773, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Demonic Noctum
(25774, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Harnak's Evil Spirit
(25775, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Apherus
(25776, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Court Guard
(25777, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Chasseur
(25778, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Sentry
(25779, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Spezion
(25780, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Spezion's Subordinate
(25781, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Spezion's Subordinate
(25782, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Spezion's Subordinate
(25783, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Eyesaroch
(25784, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Overseer
(25785, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Teredor
(25786, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Lachikios
(25787, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Lachikios
(25788, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Lachikios
(25789, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Lachikios
(25790, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Royal Guard Member
(25791, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Royal Guard Member
(25792, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Rachicues
(25793, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Rachicues
(25794, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Rachicues
(25795, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Rachicues
(25796, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Veridan
(25797, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kechi
(25798, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kechi's Subordinate
(25799, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Michaela
(25800, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Michaela
(25801, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Teredor
(27001, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 15, "archer"), -- Orc Sniper
(27002, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Orc Fighter
(27003, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Spirit Of Mirrors
(27004, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Spirit Of Mirrors
(27005, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Spirit Of Mirrors
(27006, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Bhato Bloodspear
(27007, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tanuki Skullcrusher
(27008, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kraacul Blackskull
(27009, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 15, "archer"), -- Taarq Blackskull
(27016, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Nerkas
(27017, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Plague Zombie
(27018, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Orc Warrior
(27019, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Orc Warrior Leader
(27020, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Varool Foulclaw
(27021, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "kirunak_clan", 300, "null", 0, 0, "fighter"), -- Kirunak
(27022, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Merkenis
(27024, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Undead Priest
(27029, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Phantom Salamander
(27030, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Water Seer
(27031, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ol_mahum_clan", 300, "null", 0, 0, "fighter"), -- Ol Mahum Sentry
(27032, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Lizardman Warrior
(27033, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Lizardman Scout
(27034, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Lizardman Soldier
(27035, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Tamil
(27036, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Calpico
(27037, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Calpico's Goons
(27038, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Cat's Eye Bandit
(27041, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Varangka's Messenger
(27042, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Orc Escort
(27043, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Varangka's Tracker
(27044, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Kasha Bear Totem Spirit
(27045, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "wererat_clan", 300, "null", 0, 0, "fighter"), -- Kuruka Ratman Leader
(27046, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sumi
(27047, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Wanuk
(27048, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Chewba
(27049, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Heitafu
(27050, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Picubo
(27051, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Bumbum
(27052, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Minsku
(27053, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Chuchu
(27054, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Umbar Orc
(27055, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Zakan
(27056, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Durka Spirit
(27058, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Honey Bear
(27059, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Uoph
(27060, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "orc_clan", 300, "null", 0, 15, "archer"), -- Kracha
(27061, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Batoh
(27062, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Tanukia
(27063, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Tanukia's Warhound
(27064, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Turel
(27065, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "orc_clan", 300, "null", 0, 15, "archer"), -- Roko
(27066, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Roko's Warhound
(27067, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Kamut
(27068, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "orc_clan", 300, "null", 0, 15, "archer"), -- Murtika
(27069, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Murtika's Warhound
(27070, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Tumran Orc Brigand
(27077, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Unicorn Of Eva
(27078, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Trimden Lord
(27079, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Black Willow Lurker
(27080, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Pashika Son Of Voltar
(27081, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Vultus Son Of Voltar
(27082, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Enku Orc Overlord
(27083, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Makum Bugbear Thug
(27086, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Revenant of Tantos Chief
(27088, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Harpy Matriarch
(27089, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Road Collector
(27090, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Serpent Demon Kadesh
(27092, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "lizardman_clan", 300, "null", 0, 0, "fighter"), -- Neer Bodyguard
(27093, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "lizardman_clan", 300, "null", 0, 0, "fighter"), -- Delu Chief Kalkis
(27094, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "lizardman_clan", 300, "null", 0, 0, "fighter"), -- Delu Lizardman Assassin
(27095, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Singing Flower of Phantasm
(27096, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Singing Flower of Nightmare
(27097, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Singing Flower of Darkness
(27098, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ghost Fire
(27099, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Nameless Revenant
(27100, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Skeletal Mercenary
(27101, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Drevanul Prince Zeruel
(27102, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Pako the Cat
(27103, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Racer the Unicorn
(27104, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Shadow Turen
(27105, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mimi the Cat
(27106, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Unicorn Phantasm
(27107, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Silhouette Tilfo
(27108, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Stenoa Gorgon Queen
(27109, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Handmaiden of Stenoa
(27110, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Shyslassys
(27111, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Cave Basilisk
(27112, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gorr
(27113, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Baraham
(27114, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "demonic_clan", 300, "null", 0, 0, "fighter"), -- Succubus Queen
(27115, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "demonic_clan", 300, "null", 0, 0, "fighter"), -- Claw Of Succubus
(27116, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "elemental3_clan", 300, "null", 0, 0, "fighter"), -- Lava Salamander
(27117, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Nahir
(27118, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Black Willow
(27119, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "skeleton_clan", 300, "null", 0, 0, "fighter"), -- Spirit of Sir Herod
(27120, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "elemental2_clan", 300, "null", 0, 0, "fighter"), -- Luell Of Zephyr Winds
(27121, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "elemental1_clan", 300, "null", 0, 0, "fighter"), -- Actea Of Verdant Wilds
(27122, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "lizardman_clan", 300, "null", 0, 0, "fighter"), -- Leto Lizardman Agent
(27123, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "lizardman_clan", 300, "null", 0, 0, "fighter"), -- Leto Lizardman Leader
(27124, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "lizardman_clan", 300, "null", 0, 0, "fighter"), -- Leto Lizardman Assassin
(27125, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "lizardman_clan", 300, "null", 0, 0, "fighter"), -- Leto Lizardman Sniper
(27126, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "lizardman_clan", 300, "null", 0, 0, "balanced"), -- Leto Lizardman Wizard
(27127, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "lizardman_clan", 300, "null", 0, 0, "fighter"), -- Leto Lizardman Lord
(27128, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Aruraune
(27129, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Ol Mahum Inspector
(27130, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ol Mahum Betrayer
(27131, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "werewolf_clan", 300, "null", 0, 0, "fighter"), -- Crimson Werewolf
(27132, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "elemental1_clan", 300, "null", 0, 0, "fighter"), -- Krudel Lizardman
(27133, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Evil Eye Lord
(27134, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "orc_clan", 300, "null", 0, 0, "fighter"), -- Tatoma
(27135, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Grima
(27136, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Succubus Of Seduction
(27137, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Demon King
(27138, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Great Demon King
(27139, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Secret Keeper Tree
(27140, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Breka Overlord Haka
(27141, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Breka Overlord Jaka
(27142, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Breka Overlord Marka
(27143, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Windsus Aleph
(27144, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Tarlk Raider Athu
(27145, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Tarlk Raider Lanka
(27146, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Tarlk Raider Triska
(27147, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Tarlk Raider Motura
(27148, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Tarlk Raider Kalath
(27149, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Gremlin Filcher
(27150, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Black Legion Stormtrooper
(27151, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Delu Lizardman Headhunter
(27152, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Marsh Stakato Marquess
(27153, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Alexandro Sanches
(27154, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Bonaparterius
(27155, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ramsebalius
(27156, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "balanced"), -- Leto Shaman Ketz
(27157, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Leto Chief Narak
(27158, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Timak Raider Kaikee
(27159, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Timak Overlord Okun
(27160, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Gok Magok
(27161, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Taik Overlord Kakran
(27162, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Hatar Chieftain Kubel
(27163, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Vanor Elder Kerunos
(27164, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Karul Chief Orooto
(27165, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "abyss_jewel_clan", 300, "null", 0, 0, "fighter"), -- Abyssal Jewel 1
(27166, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "abyss_jewel_clan", 300, "null", 0, 0, "fighter"), -- Abyssal Jewel 2
(27167, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "abyss_jewel_clan", 300, "null", 0, 0, "fighter"), -- Abyssal Jewel 3
(27168, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "abyss_jewel_clan", 300, "null", 0, 0, "fighter"), -- Jewel Guardian Mara
(27169, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "abyss_jewel_clan", 300, "null", 0, 0, "fighter"), -- Jewel Guardian Musfel
(27170, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "abyss_jewel_clan", 300, "null", 0, 0, "fighter"), -- Jewel Guardian Pyton
(27171, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ghost of Offering
(27172, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Harit Lizardman Zealot
(27173, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Box Of Athrea 1
(27174, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Box Of Athrea 2
(27175, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Box Of Athrea 3
(27176, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Box Of Athrea 4
(27177, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Box Of Athrea 5
(27178, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Blitz Wyrm
(27179, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "grave_guard_clan", 300, "null", 0, 0, "fighter"), -- Grave Keymaster
(27180, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "grave_keeper_clan", 300, "null", 0, 0, "fighter"), -- Imperial Slave
(27181, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "grave_keeper_clan", 300, "null", 0, 0, "fighter"), -- Imperial Gravekeeper
(27182, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 100, "null", 0, 0, "fighter"), -- Ark Guardian Elberoth
(27183, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 100, "null", 0, 15, "archer"), -- Ark Guardian Shadowfang
(27184, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 100, "null", 0, 0, "balanced"), -- Angel Killer
(27185, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "q421_tree_clan", 100, "null", 0, 0, "fighter"), -- Fairy Tree of Wind
(27186, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "q421_tree_clan", 100, "null", 0, 0, "fighter"), -- Fairy Tree of Star
(27187, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "q421_tree_clan", 100, "null", 0, 0, "fighter"), -- Fairy Tree of Twilight
(27188, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "q421_tree_clan", 100, "null", 0, 0, "fighter"), -- Fairy Tree of Abyss
(27189, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "q421_tree_clan", 100, "null", 0, 0, "fighter"), -- Soul of Tree Guardian
(27190, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "orc_clan", 200, "null", 0, 0, "fighter"), -- Ol Mahum Support Troop
(27191, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 100, "null", 0, 0, "fighter"), -- Malcom
(27192, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 200, "null", 0, 0, "fighter"), -- Succubus Handmaiden
(27193, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 200, "null", 0, 0, "fighter"), -- Goblin Servant
(27194, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 100, "null", 0, 0, "fighter"), -- Julie the Ripper
(27195, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 200, "null", 0, 0, "fighter"), -- Male Ant
(27196, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "croc_clan", 200, "null", 0, 0, "fighter"), -- Bluebacked Alligator
(27197, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "croc_clan", 200, "null", 0, 0, "fighter"), -- Bejeweled Alligator
(27199, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "werewolf_clan", 300, "null", 0, 0, "fighter"), -- Crimson Werewolf
(27200, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "elemental1_clan", 300, "null", 0, 0, "fighter"), -- Krudel Lizardman
(27201, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "elemental1_clan", 300, "null", 0, 0, "balanced"), --
(27202, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "elemental1_clan", 300, "null", 0, 0, "balanced"), --
(27203, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "elemental1_clan", 300, "null", 0, 0, "balanced"), --
(27204, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "elemental1_clan", 300, "null", 0, 0, "balanced"), --
(27205, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "elemental1_clan", 300, "null", 0, 0, "balanced"), --
(27206, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "elemental1_clan", 300, "null", 0, 0, "balanced"), --
(27207, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "elemental1_clan", 300, "null", 0, 0, "balanced"), --
(27208, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "elemental1_clan", 300, "null", 0, 0, "balanced"), --
(27209, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "elemental1_clan", 300, "null", 0, 0, "balanced"), --
(27210, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "elemental1_clan", 300, "null", 0, 0, "balanced"), --
(27211, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "elemental1_clan", 300, "null", 0, 0, "balanced"), --
(27212, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "elemental1_clan", 300, "null", 0, 0, "balanced"), --
(27213, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "elemental1_clan", 300, "null", 0, 0, "balanced"), --
(27214, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "guard_of_secrets_clan", 300, "null", 0, 0, "fighter"), -- Guardian of Forbidden Knowledge
(27215, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "guard_of_secrets_clan", 300, "null", 0, 0, "fighter"), -- Guardian of Forbidden Knowledge
(27216, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "guard_of_secrets_clan", 300, "null", 0, 0, "fighter"), -- Guardian of Forbidden Knowledge
(27217, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Soul of the Well
(27218, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Triol's Pawn
(27219, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Archon of Halisha
(27220, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Archon of Halisha
(27221, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Archon of Halisha
(27222, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Archon of Halisha
(27223, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Archon of Halisha
(27224, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Archon of Halisha
(27225, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Archon of Halisha
(27226, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Archon of Halisha
(27227, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Archon of Halisha
(27228, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Archon of Halisha
(27229, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Archon of Halisha
(27230, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Archon of Halisha
(27231, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Archon of Halisha
(27232, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Archon of Halisha
(27233, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Archon of Halisha
(27234, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Archon of Halisha
(27235, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Archon of Halisha
(27236, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Archon of Halisha
(27237, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Archon of Halisha
(27238, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Archon of Halisha
(27239, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Archon of Halisha
(27240, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Archon of Halisha
(27241, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Archon of Halisha
(27242, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Archon of Halisha
(27243, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Archon of Halisha
(27244, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Archon of Halisha
(27245, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Archon of Halisha
(27246, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Archon of Halisha
(27247, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Archon of Halisha
(27248, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Archon of Halisha
(27249, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Archon of Halisha
(27250, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Fallen Angel Allector
(27251, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Fallen Angel Allector
(27252, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Fallen Angel Allector
(27253, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Hell Fire
(27254, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 15, "archer"), -- Unknown Stopper
(27255, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 15, "archer"), -- Unknown Stopper
(27256, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 15, "archer"), -- Unknown Stopper
(27257, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Archangel Iconoclasis
(27258, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Archangel Iconoclasis
(27259, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Archangel Iconoclasis
(27260, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Archangel Iconoclasis
(27261, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Bead of Sacred Flame
(27262, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Death Lord Hallate
(27263, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Death Lord Hallate
(27264, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Death Lord Hallate
(27265, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Lich King Icarus
(27266, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Fallen Angel Haures
(27267, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Fallen Angel Haures
(27268, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Guard of Haures
(27269, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Fallen Angel Naverius
(27270, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Fallen Angel Naverius
(27271, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Chimera Golem
(27272, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Hallate's Dancer Lillian
(27273, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "balanced"), -- Assassin Pezel
(27274, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Fallen Angel Tanakia
(27275, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Fallen Angel Tanakia
(27276, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Fallen Angel Tanakia
(27277, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Fallen Angel Tanakia
(27278, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Beleth's Shadow
(27279, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "balanced"), -- Cursed Kesadein
(27280, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Fallen Angel Narcissus
(27281, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Fallen Angel Metellus
(27282, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Dark Angel Othiel
(27283, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Grandpapa Askalius
(27284, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Flame Evil Spirit Azira
(27285, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Lizard's Totem Sharuhi
(27286, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Fallen Knight Adhil
(27287, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Bound Elf Panacea
(27288, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sword Player Biel
(27289, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ancient Sword Master Iron
(27290, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- White Wing Commander
(27291, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- White Wing Fighter
(27292, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Fallen Noble Orc Muhark
(27293, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Khavatari Uruz
(27294, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Overlord Atrus
(27295, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sharuhi Mouth Mudaha
(27296, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Monument Watcher Ezekiel
(27297, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Monument Watcher Ezekiel
(27298, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Monument Watcher Ezekiel
(27299, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Monument Watcher Ezekiel
(27300, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Monument Watcher Ezekiel
(27301, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Monument Watcher Ezekiel
(27302, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Monument Defender Azrael
(27303, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Monument Defender Azrael
(27304, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Monument Defender Azrael
(27305, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Monument Defender Azrael
(27306, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Monument Defender Azrael
(27307, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Monument Defender Azrael
(27308, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "balanced"), -- Assassin Frost
(27309, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "mage"), -- Minervia Van Hacken
(27310, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Kitanis Van Hacken
(27311, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Judgment Hound Dog Kelvas
(27312, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Mysterious Servitor
(27313, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Vision Guardian Shakiel
(27314, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Vision Guardian Shakiel
(27315, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Vision Guardian Shakiel
(27316, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Fallen Chieftain Vegus
(27317, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Restrainer of Glory
(27318, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "null", 300, "null", 0, 0, "fighter"), -- Wendy's Guardian
(27319, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Black Leopard
(27320, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Timora Orc
(27321, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Bruin Lizardman
(27322, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Picot Araneid
(27323, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Divine Emissary
(27324, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Vision Guard Eranus
(27325, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Archon of Halisha
(27326, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "balanced"); -- Archangel Kanriel

INSERT INTO `npcaidata` VALUES
(27327, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Zakorel's Executor
(27328, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Zakorel
(27329, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Archon of Halisha
(27332, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian Angel
(27333, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Crimson Duchess
(27334, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Archon of Halisha
(27335, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "balanced"), -- Dark Angel Othiel
(27336, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Crimson Lady
(27337, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ol Mahum Officer Tak
(27338, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Fallen Angel
(27339, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Cruma Marshlands Traitor
(27340, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Pursuer
(27341, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Shilen's Evil Thoughts
(27342, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Shilen's Evil Thoughts
(27343, 7, 15, 0, 300, 1, 1, 1, 5976, 10, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Shilen's Evil Thoughts
(27344, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Shilen's Evil Thoughts
(27345, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Shilen's Evil Thoughts
(27346, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Shilen's Evil Thoughts
(27347, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Guards of the Dawn Oracle
(27348, 7, 15, 0, 150, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guards of the Dawn Oracle
(27349, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Guards of the Dawn Oracle
(27350, 7, 15, 0, 150, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guards of the Dawn Oracle
(27351, 7, 15, 0, 150, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "null", 300, "null", 0, 0, "fighter"), -- Guards of the Dawn
(27352, 7, 15, 0, 150, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guards of the Dawn Oracle
(27353, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lilim Butcher
(27354, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lilim Magus
(27355, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lilim Knight-Errant
(27356, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lilim Marauder
(27357, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lilim Priest
(27358, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lilim Knight
(27359, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lilim Slayer
(27360, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lilim Great Magus
(27361, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lilim Guard Knight
(27362, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lilim Butcher
(27363, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lilim Magus
(27364, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lilim Knight-Errant
(27365, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lilim Marauder
(27366, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lilim Priest
(27367, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lilim Knight
(27368, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lilim Slayer
(27369, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lilim Great Magus
(27370, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lilim Guard Knight
(27371, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lilim Butcher
(27372, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lilim Magus
(27373, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lilim Knight-Errant
(27374, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Shilen's Evil Thoughts
(27375, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Shilen's Evil Thoughts
(27376, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lilim Knight
(27377, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lilim Slayer
(27378, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lilim Great Magus
(27379, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lilim Guard Knight
(27380, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Reckless Sprite of Water
(27381, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Reckless Sprite of Air
(27382, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Power of Seal Isolation
(27383, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Power of Seal Isolation
(27384, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Seal Device
(27385, 7, 15, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Lilith
(27386, 7, 15, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Lilith's Steward
(27387, 7, 15, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Lilith's Elite
(27388, 7, 15, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Anakim
(27389, 7, 15, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Anakim's Guardian
(27390, 7, 15, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Anakim's Guard
(27391, 7, 15, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Anakim's Executor
(27392, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Bloody Axe Aide
(27393, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Headless Knight
(27394, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Shilen's Evil Thoughts
(27395, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Shilen's Evil Thoughts
(27396, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Shilen's Evil Thoughts
(27397, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Shilen's Evil Thoughts
(27398, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Shilen's Evil Thoughts
(27399, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Shilen's Evil Thoughts
(27400, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Shilen's Evil Thoughts
(27401, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Shilen's Evil Thoughts
(27402, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Shilen's Evil Thoughts
(27403, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Trainee of Rest
(27404, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Supplicant of Rest
(27405, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Monastic Pilgrim
(27406, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Monastic Crusader
(27407, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Solina Lay Brother
(27408, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Savior Solina
(27409, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Solina Knight Captain
(27410, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Solina Knights
(27411, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Divinity Manager
(27412, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Divinity Supervisor
(27413, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Divinity Fighter
(27414, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Divinity Magus
(27415, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Guide Solina
(27416, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Relic Manager Golem
(27417, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mutant Archer
(27418, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mutant Warrior
(27419, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Divinity Watcher
(27420, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Instructor Solina
(27421, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Creature of the Dusk
(27422, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Creature of the Dusk
(27423, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Creature of the Dusk
(27424, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Creature of the Dusk
(29001, 7, 15, 0, 2000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "queen_ant_clan", 2000, "null", 0, 0, "balanced"), -- Queen Ant
(29002, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "queen_ant_clan", 4500, "null", 0, 0, "fighter"), -- Queen Ant Larva
(29003, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "queen_ant_clan", 700, "null", 0, 0, "balanced"), -- Nurse Ant
(29004, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "queen_ant_clan", 700, "null", 0, 0, "fighter"), -- Guard Ant
(29005, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "queen_ant_clan", 700, "null", 0, 0, "balanced"), -- Court Guard Ant
(29006, 7, 15, 0, 2000, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "curma_core_clan", 4500, "null", 0, 0, "balanced"), -- Core
(29007, 7, 15, 0, 2100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1050, 0, "curma_core_clan", 2300, "null", 0, 0, "fighter"), -- Death Knight
(29008, 7, 15, 0, 1900, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 950, 0, "curma_core_clan", 700, "null", 0, 0, "balanced"), -- Doom Wraith
(29009, 7, 15, 0, 1300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 650, 0, "curma_core_clan", 800, "null", 0, 0, "fighter"), -- Dicor
(29010, 7, 15, 0, 1500, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 750, 0, "curma_core_clan", 1200, "null", 0, 0, "fighter"), -- Validus
(29011, 7, 15, 0, 1700, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 850, 0, "curma_core_clan", 1500, "null", 0, 0, "fighter"), -- Susceptor
(29012, 7, 15, 0, 1500, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 750, 0, "curma_core_clan", 800, "null", 0, 0, "fighter"), -- Perum
(29013, 7, 15, 0, 1300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "curma_core_clan", 1200, "null", 0, 0, "fighter"), -- Premo
(29014, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "orfen_clan", 3500, "null", 0, 0, "balanced"), -- Orfen
(29015, 7, 15, 0, 1500, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "orfen_clan", 2500, "null", 0, 0, "fighter"), -- Richard
(29016, 7, 15, 0, 1300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "orfen_clan", 2700, "null", 0, 0, "balanced"), -- Richard Leos
(29017, 7, 15, 0, 1100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "orfen_clan", 2700, "null", 0, 0, "fighter"), -- Riba
(29018, 7, 15, 0, 1500, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "orfen_clan", 2900, "null", 0, 0, "balanced"), -- Riba Iren
(29019, 7, 15, 0, 4096, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Antharas
(29020, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "baium", 300, "null", 0, 0, "balanced"), -- Baium
(29021, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "archangel_clan", 300, "baium_clan", 300, 0, "balanced"), -- Archangel
(29022, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Zaken
(29023, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Doll Blader
(29024, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Veil Master
(29025, 7, 15, 0, 4296, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Baium
(29026, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Pirate Zombie Captain
(29027, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 150, 0, "null", 300, "null", 0, 0, "fighter"), -- Pirate Zombie
(29028, 7, 15, 0, 4096, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "valakas_clan", 300, "null", 0, 0, "balanced"), -- Valakas
(29029, 7, 15, 0, 1000, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "valakas_clan", 300, "null", 0, 0, "fighter"), -- Lavasaurus Alpha
(29030, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fire_clan", 300, "null", 0, 0, "balanced"), -- Fenril Hound Kerinne
(29031, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fire_clan", 300, "null", 0, 0, "balanced"), -- Kerinne's Ifrit
(29032, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fire_clan", 300, "null", 0, 0, "balanced"), -- Kerinne's Golem
(29033, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fire_clan", 300, "null", 0, 0, "balanced"), -- Fenril Hound Freki
(29034, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fire_clan", 300, "null", 0, 0, "balanced"), -- Freki's Ifrit
(29035, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fire_clan", 300, "null", 0, 0, "balanced"), -- Freki's Golem
(29036, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fire_clan", 300, "null", 0, 0, "fighter"), -- Fenril Hound Uruz
(29037, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fire_clan", 300, "null", 0, 0, "balanced"), -- Fenril Hound Kinaz
(29038, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fire_clan", 300, "null", 0, 0, "balanced"), -- Kinaz's Ifrit
(29039, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fire_clan", 300, "null", 0, 0, "balanced"), -- Kinaz's Ifrit
(29040, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fire_clan", 300, "null", 0, 0, "fighter"), -- Wings of Flame, Ixion
(29041, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fire_clan", 300, "null", 0, 0, "balanced"), -- Inferno Golem
(29042, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fire_clan", 300, "null", 0, 0, "balanced"), -- Inferno Golem
(29043, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fire_clan", 300, "null", 0, 0, "balanced"), -- Howling Ifrit
(29044, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "fire_clan", 300, "null", 0, 0, "balanced"), -- Howling Ifrit
(29045, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 3000, 0, "frintessa_clan", 0, "null", 0, 0, "balanced"), -- Frintezza
(29046, 7, 15, 5014, 3000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 3000, 0, "frintessa_clan", 2000, "null", 0, 0, "balanced"), -- Scarlet van Halisha
(29047, 7, 15, 5014, 3000, 1, 1, 1, 5019, 10, 0, 0, 0, 0, 0, 0, 0, 0, "frintessa_clan", 2000, "null", 0, 0, "balanced"), -- Scarlet van Halisha
(29048, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "frintessa_clan", 1000, "null", 0, 0, "corpse"), -- Evil Spirit
(29049, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "frintessa_clan", 1000, "null", 0, 0, "corpse"), -- Evil Spirit
(29050, 7, 15, 0, 1500, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 2000, 0, "frintessa_clan", 2000, "null", 0, 0, "balanced"), -- Breath of Halisha
(29051, 7, 15, 0, 1500, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 2000, 0, "frintessa_clan", 2000, "null", 0, 0, "balanced"), -- Breath of Halisha
(29052, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "frintessa_clan", 0, "null", 0, 0, "balanced"), --
(29053, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "frintessa_clan", 0, "null", 0, 0, "balanced"), --
(29054, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 0, "null", 0, 0, "fighter"), -- Benom
(29055, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Teleportation Cubic
(29056, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "ice_clan", 300, "null", 0, 0, "balanced"), -- Ice Fairy Sirra
(29057, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ice_clan", 300, "null", 0, 0, "balanced"), -- Sirra's Page
(29058, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ice_clan", 300, "null", 0, 0, "balanced"), -- Sirra's Beholder
(29059, 7, 15, 0, 500, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), --
(29060, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ice_clan", 300, "null", 0, 0, "balanced"), -- Captain of the Ice Queen's Royal Guard
(29061, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Teleportation Cubic
(29062, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, "andreas_clan", 300, "null", 0, 0, "balanced"), -- Andreas Van Halter
(29063, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "andreas_clan", 300, "null", 0, 0, "balanced"), -- Andreas' Acolyte
(29064, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "andreas_clan", 300, "null", 0, 0, "balanced"), -- Andreas' Acolyte
(29065, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Sailren
(29066, 7, 25, 0, 4096, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Antharas
(29067, 7, 25, 0, 4096, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Antharas
(29068, 7, 25, 0, 4096, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Antharas
(29069, 7, 25, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 900, 0, "null", 300, "null", 0, 0, "balanced"), -- Behemoth Dragon
(29070, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 900, 0, "null", 300, "null", 0, 0, "balanced"), -- Dragon Bomber
(29071, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 900, 0, "null", 300, "null", 0, 0, "balanced"), -- Dragon Bomber
(29072, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 900, 0, "null", 300, "null", 0, 0, "balanced"), -- Dragon Bomber
(29073, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 900, 0, "null", 300, "null", 0, 0, "balanced"), -- Dragon Bomber
(29074, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 900, 0, "null", 300, "null", 0, 0, "balanced"), -- Dragon Bomber
(29075, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 900, 0, "null", 300, "null", 0, 0, "balanced"), -- Dragon Bomber
(29076, 7, 15, 0, 200, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 900, 0, "null", 300, "null", 0, 0, "balanced"), -- Dragon Bomber
(29077, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), --
(29078, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), --
(29079, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), --
(29080, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), --
(29081, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), --
(29082, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), --
(29083, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), --
(29084, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), --
(29085, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), --
(29086, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), --
(29087, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), --
(29088, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), --
(29089, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), --
(29090, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), --
(29091, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), --
(29092, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), --
(29093, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), --
(29094, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), --
(29095, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Gordon
(29096, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "solina_clan", 1000, "null", 0, 0, "balanced"), -- Anais
(29097, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "solina_clan", 300, "null", 0, 0, "balanced"), -- Disciple of Splendor
(29098, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "solina_clan", 300, "null", 0, 0, "balanced"), -- Splendor Worshiper
(29099, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 600, 0, "null", 300, "null", 0, 0, "balanced"), -- Baylor
(29100, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "null", 300, "null", 0, 0, "balanced"), -- Crystal Prison Guard
(29101, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 400, 0, "door_clan", 300, "null", 0, 0, "balanced"), -- Crystalline Golem
(29102, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "door_clan", 300, "null", 0, 0, "balanced"), -- Crystalline Golem
(29103, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Baylor
(29104, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Crystal Prison Guard
(29105, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Crystalline Golem
(29106, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(29107, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(29108, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(29109, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(29110, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(29111, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(29112, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(29113, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(29114, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(29115, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Crystal Prison Guard
(29116, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Baylor's Treasure Chest
(29117, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Baylor's Treasure Chest
(29118, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "beres_clan", 2000, "null", 0, 0, "mage"), -- Beleth
(29119, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "beres_clan", 2000, "null", 0, 0, "mage"), -- Beleth
(29120, 7, 15, 0, 300, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(29121, 7, 15, 0, 300, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(29122, 7, 15, 0, 300, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(29123, 7, 15, 0, 300, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(29124, 7, 15, 0, 300, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(29125, 7, 15, 0, 300, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(29126, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(29127, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(29128, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(29129, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Lost Captain
(29130, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Lost Guard
(29131, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Lost Assistant Guard
(29132, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Lost Captain
(29133, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Lost Guard
(29134, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Lost Assistant Guard
(29135, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Lost Captain
(29136, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Lost Guard
(29137, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Lost Assistant Guard
(29138, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Lost Captain
(29139, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Lost Guard
(29140, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Lost Assistant Guard
(29141, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Lost Captain
(29142, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Lost Guard
(29143, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Lost Assistant Guard
(29144, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Lost Captain
(29145, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Lost Guard
(29146, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Lost Assistant Guard
(29147, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Lost Captain
(29148, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Lost Guard
(29149, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Lost Assistant Guard
(29150, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Ekimus
(29151, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Feral Hound of the Netherworld
(29152, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "aceed_clan", 300, "null", 0, 0, "balanced"), -- Feral Hound of the Netherworld
(29153, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(29154, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(29155, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(29156, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(29157, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(29158, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(29159, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(29160, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(29161, 7, 15, 0, 300, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Pre-Awakened Ekimus
(29162, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Soldiers of Bravery
(29163, 7, 15, 0, 450, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Tiat
(29164, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(29165, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(29166, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(29167, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(29168, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(29169, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 300, 0, "null", 300, "null", 0, 0, "balanced"), --
(29170, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(29171, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(29172, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), --
(29173, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Tiat Priest
(29174, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Tiat Priest
(29175, 7, 15, 0, 450, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "des_dragon", 1000, "null", 0, 0, "balanced"), -- Tiat
(29176, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Zaken
(29177, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "freya_clan", 300, "null", 0, 0, "fighter"), -- Freya
(29178, 7, 15, 0, 300, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "freya_clan", 300, "null", 0, 0, "fighter"), -- Freya
(29179, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "freya_clan", 300, "null", 0, 0, "fighter"), -- Freya
(29180, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "freya_clan", 300, "null", 0, 0, "fighter"), -- Freya
(29181, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Zaken
(29182, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Doll Blader
(29183, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Veil Master
(29184, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Pirate Zombie Captain
(29185, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Pirate Zombie
(29186, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Baylor
(29187, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Crystal Prison Guard
(29188, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "door_clan", 300, "null", 0, 0, "fighter"), -- Crystalline Golem
(29189, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "door_clan", 300, "null", 0, 0, "fighter"), -- Crystalline Golem
(29190, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tarask Dragon
(30001, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lector
(30002, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Jackson
(30003, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Silvia
(30004, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Katerina
(30005, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Wilford
(30006, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Milia
(30008, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Roien
(30009, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Newbie Helper
(30010, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Auron
(30014, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Celma
(30017, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Gallint
(30019, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Newbie Helper
(30022, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Zigaunt
(30026, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Bitz
(30027, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gwinter
(30028, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Pintage
(30029, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Minia
(30030, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Vivyan
(30031, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Biotin
(30032, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Yohanes
(30033, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Baulro
(30034, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Iris
(30035, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Harrys
(30036, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Petron
(30037, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Levian
(30039, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Gilbert
(30040, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Leon
(30041, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Arnold
(30042, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Abellos
(30043, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Johnstone
(30044, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Chiperan
(30045, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Kenyos
(30046, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Hanks
(30047, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Firon
(30048, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Darin
(30049, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Bonnie
(30050, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Elias
(30051, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Cristel
(30054, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Rant
(30055, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Rolfe
(30057, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Aldo
(30058, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Holvas
(30059, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Trisha
(30060, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sabrin
(30061, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Casey
(30062, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sonia
(30063, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lara
(30064, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Terry
(30065, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Arnelle
(30066, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Pabris
(30067, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Glyvka
(30068, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Shegfield
(30069, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Rollant
(30070, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sylvain
(30071, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lucas
(30072, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Metty
(30073, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Jacob
(30074, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Harlan
(30075, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Xaber
(30076, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Liam
(30078, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Pano
(30079, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Barder
(30080, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Clarissa
(30081, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Helvetia
(30082, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Denkus
(30083, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Pochi
(30084, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Graham
(30085, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Stanford
(30086, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Taurin
(30087, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Peta
(30088, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Radia
(30090, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sandra
(30091, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ellie
(30092, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Collob
(30093, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Groot
(30094, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gentler
(30095, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Randolf
(30097, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Galladucci
(30098, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Alexandria
(30103, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Valkon
(30104, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Parman
(30105, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Genwitter
(30106, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dufner
(30107, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Goldian
(30108, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Macken
(30109, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Hannavalt
(30110, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Iker
(30111, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Dieter
(30112, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Maurius
(30113, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Juris
(30114, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Roa
(30115, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Jurek
(30116, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dustin
(30117, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Primos
(30118, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Pupina
(30119, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Isabellin
(30120, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Maximilian
(30121, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Jeronin
(30122, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Bane
(30123, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Vesa
(30124, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Zerome
(30125, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Belton
(30126, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Rath
(30128, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Atanas
(30129, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mitraell
(30130, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Undrias
(30131, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Newbie Helper
(30132, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Cecktinon
(30133, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kartia
(30134, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Teleport Device
(30135, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Iria
(30136, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Payne
(30137, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Vollodos
(30138, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Minaless
(30139, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dorankus
(30140, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Erviante
(30141, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Talloth
(30143, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Trudy
(30144, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Harne
(30145, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Vlasty
(30146, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Teleport Device
(30147, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Unoren
(30148, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ariel
(30149, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Creamees
(30150, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Herbiel
(30151, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Chad
(30152, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Julia
(30153, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Markius
(30154, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Asterios
(30155, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ellenia
(30156, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Esrandell
(30157, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Greenis
(30158, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Esrandell
(30162, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Karin
(30163, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Rex
(30164, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ian
(30165, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ralford
(30166, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Wesley
(30169, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Marty
(30170, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Radic
(30171, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Gaius
(30174, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Arkenias
(30175, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Fairen
(30176, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Valleria
(30177, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Valentina
(30178, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Zenkin
(30179, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Raudia
(30180, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sara
(30181, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Galibredo
(30182, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Cliff
(30183, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Hagger
(30184, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Rigol
(30185, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Taniac Blackbird
(30186, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Bhan
(30187, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Klaus Blackbird
(30188, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Vadin
(30189, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Rovia
(30190, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Phanovia
(30191, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Hollint
(30192, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Darya
(30194, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Gideon
(30195, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Brecson
(30196, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mouen
(30197, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Hector
(30198, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Jerin
(30199, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Yates
(30200, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Stan
(30201, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Pinaps
(30207, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Arodin
(30208, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Damion
(30209, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Colleen
(30210, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Norman
(30216, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Wheeler
(30217, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Berros
(30218, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Kendell
(30219, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Veltress
(30220, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Starden
(30221, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Rayen
(30222, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Alshupes
(30223, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Arujien
(30224, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Rayla
(30230, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Edroc
(30231, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Garette
(30232, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sorint
(30233, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Esmeralda
(30253, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Simplon
(30254, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Harmony
(30255, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Haprock
(30256, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Bella
(30283, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Altran
(30284, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Alberius
(30285, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Gartrandell
(30288, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Rains
(30289, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Raymond
(30290, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Xenos
(30291, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Alex
(30293, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Manuel
(30294, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Varan
(30297, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tobias
(30298, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Pinter
(30300, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Pushkin
(30301, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Hally
(30305, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Vellior
(30307, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Karrod
(30311, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sir Collin Windawood
(30312, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Rockswell
(30313, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Asha
(30314, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Nestle
(30315, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Poesia
(30316, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Raut
(30317, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kluto
(30320, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Richlin
(30321, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sydnia
(30322, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ballin
(30325, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Audiberti
(30326, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Leona
(30327, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sorius
(30328, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Reisa
(30329, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Virgil
(30330, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Sidra
(30331, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Toma
(30332, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Bathis
(30333, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Praga
(30334, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Babenco
(30335, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Brynn
(30336, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Curtis
(30337, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Moretti
(30338, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Melville
(30342, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Varsak
(30344, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Rohmer
(30345, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Ramoniell
(30346, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Kayleen
(30347, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Marion
(30348, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Nelsya
(30349, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Jenna
(30350, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Carlon
(30351, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Astaron
(30352, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Karina
(30353, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Jughead
(30354, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Jewel
(30355, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Roselyn
(30356, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Altima
(30357, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Kristin
(30358, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Thifiell
(30359, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kaitar
(30360, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Harant
(30361, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Rizraell
(30362, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Andellia
(30363, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Aios
(30368, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lilith
(30369, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Baenedes
(30370, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Nerupa
(30371, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Thalia
(30373, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ramos
(30374, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Rhodiell
(30375, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Adonius
(30376, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Nell
(30377, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Talbot
(30378, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Estella
(30379, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Bezique
(30380, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Plink
(30381, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Alvah
(30382, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Leikan
(30383, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Scott
(30384, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Linus
(30385, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Weisz
(30386, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Luis
(30387, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Clancy
(30391, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Parina
(30400, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Newbie Helper
(30401, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Newbie Helper
(30402, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Newbie Helper
(30403, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Newbie Helper
(30404, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Newbie Helper
(30405, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Marius
(30406, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Matheo
(30407, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mesella
(30408, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lionel
(30409, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Earth Snake
(30410, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Wasteland Lizardman
(30411, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Flame Salamander
(30412, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Wind Sylph
(30413, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Water Undine
(30414, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Rosella
(30415, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Charkeren
(30416, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Triskel
(30417, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sir Klaus Vasper
(30418, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Annika
(30419, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Arkenia
(30420, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tyra
(30421, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Varika
(30422, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kalinta
(30423, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Northwind
(30424, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Allana
(30425, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Neti
(30426, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Prias
(30427, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Siff
(30428, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Perrin
(30429, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tiramisa
(30430, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Trionell
(30431, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Eriel
(30432, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Irene
(30433, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Kathaway
(30434, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Samed
(30435, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Leopold
(30436, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sarien
(30437, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Rolento
(30452, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Kurt
(30458, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Poitan
(30459, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Wandius
(30460, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Cardien
(30461, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Mirien
(30462, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tronix
(30463, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ixia
(30464, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Clayton
(30465, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Herven
(30466, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Bright
(30469, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Jonas
(30471, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Rupio
(30472, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Rosheria
(30473, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Bandellos
(30474, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Angus
(30475, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Stapin
(30476, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Kaira
(30477, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sir Ortho Lancer
(30478, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Reikin
(30483, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Carsus
(30484, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Janssen
(30485, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Belkadhi
(30486, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ian
(30487, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Rombel
(30497, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Edmond
(30498, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Moke
(30499, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tapoy
(30500, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Osborn
(30501, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kasman
(30502, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Umos
(30503, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Rikadio
(30504, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mendio
(30505, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Drikus
(30506, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Buka
(30507, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Racoy
(30508, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Castor
(30509, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dowki
(30510, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Somak
(30511, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gesto
(30512, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kusto
(30513, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Penatus
(30514, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Vokian
(30515, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Manakia
(30516, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Reep
(30517, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Shari
(30518, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Garita
(30519, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mion
(30520, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Reed
(30521, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Murdoc
(30522, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Airy
(30523, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gouph
(30524, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Pippi
(30525, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Bronk
(30526, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Brunon
(30527, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Silvera
(30528, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Laferon
(30529, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Maron
(30530, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Newbie Helper
(30531, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lockirin
(30532, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Spiron
(30533, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Balanki
(30534, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Keef
(30535, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Filaur
(30536, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Arin
(30537, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Daichir
(30538, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Zimenf
(30539, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Chichirin
(30540, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Teleport Device
(30541, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Paion
(30542, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Runant
(30543, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Ethan
(30544, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Cromwell
(30545, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Proton
(30546, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Dinkey
(30547, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Tardyon
(30548, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Nathan
(30549, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ghouliff Droopstone
(30550, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gauri Twinklerock
(30551, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tink Wandergold
(30552, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kiril Sparkystone
(30553, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Maryse Redbonnet
(30554, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Bolter
(30555, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Torocco
(30556, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Toma
(30557, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Torai
(30558, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Jakal
(30559, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kunai
(30560, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Uska
(30561, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Papuma
(30562, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Grookin
(30563, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Imantu
(30564, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sumari
(30565, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kakai
(30566, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Varkees
(30567, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tantus
(30568, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Hatos
(30569, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Brukurse
(30570, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Karukia
(30571, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tanapi
(30572, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Livina
(30573, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Vulkus
(30575, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Newbie Helper
(30576, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Teleport Device
(30577, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Rukain
(30578, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Nakusin
(30579, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Tamai
(30580, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Parugon
(30581, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Orinak
(30582, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Tiku
(30583, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Petukai
(30584, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Vapook
(30585, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tataru Zu Hestui
(30586, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Anai Zu Neruga
(30587, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gantaki Zu Urutu
(30588, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Takia Zu Duda-Mara
(30589, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kazkin Zu Gandi
(30590, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Rosheek
(30591, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Toruku
(30592, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Hestui Totem Spirit
(30593, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Duda-Mara Totem Spirit
(30594, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ranspo
(30595, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Opix
(30596, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Harkel
(30597, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Piotur
(30598, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Newbie Helper
(30599, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Newbie Helper
(30600, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Newbie Helper
(30601, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Newbie Helper
(30602, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Newbie Helper
(30608, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Maria
(30609, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Creta
(30610, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Cronos
(30611, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Triff
(30612, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Casian
(30613, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Alders Spirit
(30614, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Metheus
(30615, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Voltar
(30616, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kepra
(30617, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Burai
(30618, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Harak
(30619, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Driko
(30620, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Emily
(30621, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Nikola
(30622, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Box Of Titan
(30623, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kaien
(30624, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ascalon
(30625, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mason
(30626, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Hamil
(30627, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tree
(30628, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Strong Wooden Chest
(30629, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Rukal
(30630, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Orim
(30631, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Roderik
(30632, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Endrigo
(30633, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Evert
(30634, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Galatea
(30635, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Almors
(30636, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Camoniell
(30637, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Belthus
(30638, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Basilla
(30639, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Celestiel
(30640, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Brynthea
(30641, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Takuna
(30642, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Chianta
(30643, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- First Orc
(30644, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kash
(30645, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Martien
(30646, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Raldo
(30647, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Chest Of Shyslassys
(30648, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Santiago
(30649, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ancestor Martankus
(30650, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gerald
(30651, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dorf
(30652, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Uruha
(30653, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sir Aron Tanford
(30654, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sir Kiel Nighthawk
(30655, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Isael Silvershadow
(30656, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Spirit Of Sir Talianus
(30657, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Seresin
(30658, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gupu
(30659, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Orphan Girl
(30660, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Windy Shaoring
(30661, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mysterious Dark Elf
(30662, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Piper Longbow
(30663, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Slein Shining Blade
(30664, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Cain Flying Knife
(30665, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kristina
(30666, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Sla
(30667, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Ramus
(30668, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Katari
(30669, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kakan
(30670, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Nyakuri
(30671, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Croto
(30672, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dubabah
(30673, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lorain
(30674, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Daurin Hammercrush
(30675, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "corpse"), -- Corpse Of Kamur
(30676, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Croop
(30677, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Flutter
(30678, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Helton
(30679, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Roameria
(30680, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Egnos
(30681, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Karia
(30682, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Pekiron
(30683, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Daunt
(30684, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Viktor
(30685, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Baxt
(30686, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Silva
(30687, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Vergara
(30688, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Duning
(30689, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Siria
(30690, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Luther
(30691, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Aren Athebaldt
(30692, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Stedmiel
(30693, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Queenien
(30694, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Scraide
(30695, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Moses
(30696, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Page
(30697, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Videlrien
(30698, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Evelyn
(30699, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Medown
(30700, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Prestan
(30701, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Errickin
(30702, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Bernard
(30703, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Colin
(30704, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Garvarentz
(30705, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Chakiris
(30706, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lazenby
(30707, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Raigen
(30708, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Nasign
(30709, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Norton
(30710, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Weston
(30711, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Byron
(30712, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Makhis
(30713, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Gardner
(30714, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Paros
(30715, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Marina
(30716, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Cecile
(30717, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Gauen
(30718, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Joan
(30719, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mariell
(30720, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Kaiena
(30721, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Ladd
(30722, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Merian
(30723, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Roy
(30724, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Tavillian
(30725, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Yening
(30726, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Tebose
(30727, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Verona
(30728, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Leirynn
(30729, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Borys
(30730, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Jax
(30731, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Martin
(30732, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ol Mahum Pilgrim
(30733, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Guard
(30734, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Supply Box On Wharf
(30735, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sophya
(30736, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Redfoot
(30737, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Morgan
(30738, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Matild
(30739, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Keltir
(30740, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Toad
(30741, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Rabbit
(30742, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Rupina
(30743, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Wisdom Chest
(30744, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Grey
(30745, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tor
(30746, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Cybellin
(30747, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mimyu
(30748, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Exarion
(30749, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Zwov
(30750, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kalibran
(30751, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Suzet
(30752, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Shamhai
(30753, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gabrielle
(30754, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gilmore
(30755, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Theodric
(30756, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sir Kristof Rodemai
(30757, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Statue Of Offering
(30758, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Athrea
(30759, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kalis
(30760, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sir Gustav Athebaldt
(30761, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "corpse"), -- Corpse Of Fritz
(30762, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "corpse"), -- Corpse Of Lutz
(30763, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "corpse"), -- Corpse Of Kurtz
(30764, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Balthazar
(30765, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Imperial Coffer
(30766, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Cleo
(30767, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Auctioneer
(30768, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Auctioneer
(30769, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Auctioneer
(30770, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Auctioneer
(30771, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Auctioneer
(30772, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Wilson
(30773, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Todd
(30827, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lundy
(30828, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Waters
(30829, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Cooper
(30830, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Joey
(30831, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Nelson
(30832, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Hardin
(30833, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kaspar
(30834, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Cema
(30835, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Icarus
(30836, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Minerva
(30837, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Woodrow
(30838, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Woodley
(30839, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Holly
(30840, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lorenzo
(30841, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Carson
(30842, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Alexis
(30843, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Romp
(30844, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Walderal
(30845, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Klump
(30846, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Wilbert
(30847, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ferris
(30848, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Elisa
(30849, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sedrick
(30850, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Aiken
(30851, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kendra
(30852, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sinden
(30853, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Raien
(30854, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Drikiyan
(30855, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Desmond
(30856, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Winonin
(30857, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Orven
(30858, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ross
(30859, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Vivyan
(30860, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Flownia
(30861, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Leonard
(30862, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Oltran
(30863, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ghest
(30864, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Hanellin
(30865, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ladanza
(30866, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Marestella
(30867, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Reva
(30868, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sir Eric Rodemai
(30869, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lemper
(30870, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Kurtiz
(30871, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Bret
(30872, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Conroy
(30873, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Coleman
(30874, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Aldis
(30875, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Carlton
(30876, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Eastan
(30877, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Grayson
(30878, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Angelina
(30879, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Felton
(30880, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Viktor Van Dake
(30881, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sanders
(30882, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Frontier Guard
(30883, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Frontier Guard
(30884, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Frontier Guard
(30885, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Frontier Guard
(30886, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Frontier Guard
(30887, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Frontier Guard
(30888, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Frontier Guard
(30889, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Frontier Guard
(30890, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Espen
(30891, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Verona
(30892, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Enverun
(30893, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Payel
(30894, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Natools
(30895, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kluck
(30896, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mia
(30897, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Roman
(30898, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Morning
(30899, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Flauen
(30900, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Marcus
(30901, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Arti
(30902, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Karuna
(30903, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Traus
(30904, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Naiel
(30905, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Squillari
(30906, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ranton
(30907, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Minevia
(30908, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Tanios
(30909, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Anabel
(30910, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Xairakin
(30911, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Brikus
(30912, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Xenovia
(30913, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tushku
(30914, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sorbo
(30915, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Takina
(30916, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gosta
(30917, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Dupuis
(30918, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Kent
(30919, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Rodic
(30920, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Kraisen
(30921, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Timos
(30922, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Cage
(30923, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Dunst
(30924, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Nedy
(30925, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Morelyn
(30926, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Restina
(30927, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Alicia
(30928, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Fenster
(30929, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Patrin
(30930, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Rogent
(30931, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Bentley
(30932, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Benica
(30933, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Braki
(30934, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Marsha
(30935, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Trumpin
(30936, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Malcom1
(30937, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Malcom2
(30938, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Malcom3
(30939, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Malcom4
(30940, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Malcom5
(30941, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Malcom6
(30942, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Malcom7
(30943, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Malcom8
(30944, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Malcom9
(30945, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Malcom10
(30946, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lucianne Tanford
(30947, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Rerikya
(30948, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Meridien
(30949, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Keplon
(30950, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Euclie
(30951, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Pithgon
(30952, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dimensional Vortex 1
(30953, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dimensional Vortex 2
(30954, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dimensional Vortex 3
(30955, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gillian's Revenant
(30956, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Nanarin
(30957, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Swan
(30958, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Galion
(30959, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Barbado
(30960, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Beer Chest
(30961, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Cloth Chest
(30962, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Statue of Water
(30963, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Statue of Fire
(30964, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Statue of Wind
(30965, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Statue of Earth
(30966, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Statue of Darkness
(30967, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Statue of Light
(30968, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Jennifer
(30969, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Iason Heine
(30970, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dorothy
(30971, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Orpheus
(30972, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Orpheus Resurrector
(30973, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Medium Jar
(30974, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Oliver
(30975, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Clarine
(30976, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Resurrected Town Maiden
(30977, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Holy Ark of Secrecy 1
(30978, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Holy Ark of Secrecy 2
(30979, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Holy Ark of Secrecy 3
(30980, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "corpse"), -- Ark Guardian's Corpse
(30981, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Black Judge
(30982, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sleeping Ant Larva1
(30983, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sleeping Ant Larva2
(30984, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sleeping Ant Larva3
(30985, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sleeping Ant Larva4
(30986, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sleeping Ant Larva5
(30987, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sleeping Ant Larva6
(30988, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Verce
(30989, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Chest of Bifrons
(30990, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lottery Ticket Seller
(30991, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lottery Ticket Seller
(30992, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lottery Ticket Seller
(30993, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lottery Ticket Seller
(30994, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lottery Ticket Seller
(30995, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Race Manager
(31001, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Claudia Athebaldt
(31002, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Reorin
(31003, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Here I Come
(31004, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Half Moon Love
(31005, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Everlasting
(31006, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dark Side of the Moon
(31007, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Wind Rider
(31008, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Shooting Star
(31009, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Cyclone Thunder
(31010, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Hungry Baby
(31011, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Salty Dog
(31012, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Raging Revolution
(31013, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Valentine Blue
(31014, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Light My Fire
(31015, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Red Bullet
(31016, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Shining Silver
(31017, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Over the top
(31018, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Royal Straight
(31019, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- All Seven
(31020, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Nasty Green
(31021, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Shortcut
(31022, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Typhoon Tiger
(31023, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Red Hot
(31024, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Galaxy Express
(31025, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Best Condition
(31026, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Albatross
(31027, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Coffer of the Dead
(31028, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Chest of Kernon
(31029, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Chest of Golkonda
(31030, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Hallate's Chest
(31031, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Broadcasting Tower
(31032, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Guard
(31033, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Sentinel
(31034, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Sentry
(31035, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Defender
(31036, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Centurion
(31042, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kantabilon
(31043, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Octavis
(31044, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Galman
(31045, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kitzka
(31046, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Marsden
(31047, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kell
(31048, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- McDermott
(31049, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Pepper
(31050, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Thora
(31051, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Keach
(31052, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Heid
(31053, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Kidder
(31067, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Rood
(31074, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "corpse"), -- Corpse of Hutaku
(31075, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sales Cat of Ivory Tower
(31076, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Newbie Helper
(31077, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Newbie Helper
(31078, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Priest of Dawn
(31079, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Priest of Dawn
(31080, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Priest of Dawn
(31081, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Priest of Dawn
(31082, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Priest of Dawn
(31083, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Priest of Dawn
(31084, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Priest of Dawn
(31085, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dusk Priestess
(31086, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dusk Priestess
(31087, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dusk Priestess
(31088, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dusk Priestess
(31089, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dusk Priestess
(31090, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dusk Priestess
(31091, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dusk Priestess
(31092, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Black Marketeer of Mammon
(31093, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Preacher of Doom
(31094, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Orator of Revelations
(31095, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gatekeeper Ziggurat
(31096, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gatekeeper Ziggurat
(31097, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gatekeeper Ziggurat
(31098, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gatekeeper Ziggurat
(31099, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gatekeeper Ziggurat
(31100, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gatekeeper Ziggurat
(31101, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gatekeeper Ziggurat
(31102, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gatekeeper Ziggurat
(31103, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gatekeeper Ziggurat
(31104, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gatekeeper Ziggurat
(31105, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gatekeeper Ziggurat
(31106, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gatekeeper Ziggurat
(31107, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gatekeeper Ziggurat
(31108, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gatekeeper Ziggurat
(31109, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gatekeeper Ziggurat
(31110, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gatekeeper Ziggurat
(31111, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gatekeeper Spirit
(31112, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gatekeeper Spirit
(31113, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Merchant of Mammon
(31114, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gatekeeper Ziggurat
(31115, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gatekeeper Ziggurat
(31116, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gatekeeper Ziggurat
(31117, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gatekeeper Ziggurat
(31118, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gatekeeper Ziggurat
(31119, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gatekeeper Ziggurat
(31120, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gatekeeper Ziggurat
(31121, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gatekeeper Ziggurat
(31122, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gatekeeper Ziggurat
(31123, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gatekeeper Ziggurat
(31124, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gatekeeper Ziggurat
(31125, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gatekeeper Ziggurat
(31126, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Blacksmith of Mammon
(31127, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Festival Guide
(31128, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Festival Guide
(31129, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Festival Guide
(31130, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Festival Guide
(31131, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Festival Guide
(31132, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Festival Witch
(31133, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Festival Witch
(31134, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Festival Witch
(31135, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Festival Witch
(31136, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Festival Witch
(31137, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Festival Guide
(31138, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Festival Guide
(31139, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Festival Guide
(31140, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Festival Guide
(31141, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Festival Guide
(31142, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Festival Witch
(31143, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Festival Witch
(31144, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Festival Witch
(31145, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Festival Witch
(31146, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Festival Witch
(31147, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sobling
(31148, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Pirate's Chest
(31149, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Alchemist's Mixing Urn
(31168, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Priest of Dawn
(31169, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dusk Priestess
(31170, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Crest of Dawn
(31171, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Crest of Dusk
(31172, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Preacher of Doom
(31173, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Orator of Revelations
(31174, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Preacher of Doom
(31175, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Orator of Revelations
(31176, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Preacher of Doom
(31177, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Orator of Revelations
(31178, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Preacher of Doom
(31179, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Orator of Revelations
(31180, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Preacher of Doom
(31181, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Orator of Revelations
(31182, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Preacher of Doom
(31183, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Orator of Revelations
(31184, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Preacher of Doom
(31185, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Orator of Revelations
(31186, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Preacher of Doom
(31187, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Orator of Revelations
(31188, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Preacher of Doom
(31189, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Orator of Revelations
(31190, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Preacher of Doom
(31191, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Orator of Revelations
(31192, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Preacher of Doom
(31193, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Orator of Revelations
(31194, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Preacher of Doom
(31195, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Orator of Revelations
(31196, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Preacher of Doom
(31197, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Orator of Revelations
(31198, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Preacher of Doom
(31199, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Orator of Revelations
(31200, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Preacher of Doom
(31201, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Orator of Revelations
(31202, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Maximus
(31203, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Moon Dancer
(31204, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Georgio
(31205, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Katz
(31206, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ten Ten
(31207, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sardinia
(31208, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- La Grange
(31209, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Misty Rain
(31210, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Race Track Gatekeeper
(31211, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Race Track Guide
(31212, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Event Gatekeeper
(31213, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Event Gatekeeper
(31214, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Event Gatekeeper
(31215, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Event Gatekeeper
(31216, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Event Gatekeeper
(31217, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Event Gatekeeper
(31218, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Event Gatekeeper
(31219, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Event Gatekeeper
(31220, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Event Gatekeeper
(31221, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Event Gatekeeper
(31222, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Event Gatekeeper
(31223, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Event Gatekeeper
(31224, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Event Gatekeeper
(31225, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Arena Manager
(31226, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Arena Director
(31227, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Buzz the Cat
(31228, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Roy the Cat
(31229, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Winnie the Cat
(31230, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Louie the Cat
(31231, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Preacher of Doom
(31232, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Preacher of Doom
(31233, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Preacher of Doom
(31234, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Preacher of Doom
(31235, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Preacher of Doom
(31236, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Preacher of Doom
(31237, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Preacher of Doom
(31238, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Preacher of Doom
(31239, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Preacher of Doom
(31240, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Preacher of Doom
(31241, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Preacher of Doom
(31242, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Preacher of Doom
(31243, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Preacher of Doom
(31244, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Preacher of Doom
(31245, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Preacher of Doom
(31246, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Preacher of Doom
(31247, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Orator of Revelations
(31248, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Orator of Revelations
(31249, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Orator of Revelations
(31250, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Orator of Revelations
(31251, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Orator of Revelations
(31252, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Orator of Revelations
(31253, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Orator of Revelations
(31254, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Orator of Revelations
(31255, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Buzz the Cat
(31256, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Leon
(31257, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Veronica
(31258, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Helmut
(31259, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Janne
(31260, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Judith
(31261, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Renee
(31262, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Rupert
(31263, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Liesel
(31264, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Olsun
(31265, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Annette
(31266, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kaiser
(31267, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lietta
(31268, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Hakon
(31269, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mona
(31270, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Stefano
(31271, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Hilda
(31272, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Noel
(31273, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Borodin
(31274, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Fundin
(31275, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tatiana
(31276, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Bernhard
(31277, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Felix
(31278, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Bronwyn
(31279, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gregory
(31280, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Bastian
(31281, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Cerenas
(31282, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Justin
(31283, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Alminas
(31284, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Elena
(31285, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Samael
(31286, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Drakon
(31287, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kamilen
(31288, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Aklan
(31289, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lakan
(31290, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Skahi
(31291, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Terava
(31292, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Andrei
(31293, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Gunter
(31294, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Sven
(31295, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Henrik
(31296, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Cadmon
(31297, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Bayard
(31298, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Ulrich
(31299, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Eugen
(31300, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Drumond
(31301, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Nils
(31302, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Vladimir
(31303, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Alisha
(31304, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Astrid
(31305, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Candice
(31306, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Natasha
(31307, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Weber
(31308, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Achim
(31309, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Woods
(31310, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Rafael
(31311, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Hugin
(31312, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Durin
(31313, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lunin
(31314, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Donal
(31315, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Daisy
(31316, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Vincenz
(31317, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lombert
(31318, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Greta
(31319, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Hans
(31320, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ilyana
(31321, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Siegmund
(31322, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Erian
(31323, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Beryl
(31324, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Andromeda
(31325, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Themis
(31326, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lambac
(31327, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tazki
(31328, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Innocentin
(31329, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Eliyah
(31330, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Wagner
(31331, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Valdis
(31332, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Amelia
(31333, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Rumiel
(31334, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tifaren
(31335, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kayan
(31336, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Rahorakti
(31337, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Mekara
(31338, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Anton
(31339, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Hakran
(31340, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mathias
(31341, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Richtor
(31342, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Dimitri
(31343, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Bellard
(31344, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Schmidt
(31345, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Ian
(31346, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Sirius
(31347, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Burke
(31348, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Agripel
(31349, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Benedict
(31350, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dominic
(31351, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Volker
(31356, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Remy
(31357, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Leandro
(31358, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kasiel
(31359, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Jaradine
(31360, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Alhena
(31361, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kreed
(31362, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tate
(31363, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Rogin
(31364, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Rokar
(31365, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Yakand
(31366, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Feed Seller
(31367, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Voice of Glory
(31368, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mikellan
(31369, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mennon
(31370, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kadun Zu Ketra
(31371, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Wahkan
(31372, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Asefa
(31373, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Atan
(31374, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Jaff
(31375, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Jumara
(31376, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Kurfa
(31377, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ashas Varka Durai
(31378, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Naran Ashanuk
(31379, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Udan Mardui
(31380, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Diyabu
(31381, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Hagos
(31382, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Shikon
(31383, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Teranu Mardui
(31384, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gatekeeper of Fire Dragon
(31385, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Heart of Volcano
(31386, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Violet
(31387, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kurstin
(31388, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mina
(31389, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dorian
(31390, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dummy - Boy A
(31391, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dummy - Boy B
(31392, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dummy - Boy C
(31393, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dummy - Boy D
(31394, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dummy - Boy E
(31395, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dummy - Lady F
(31396, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dummy - Lady G
(31397, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dummy - Lady H
(31398, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dummy - Lady I
(31399, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dummy - Lady J
(31400, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dummy - Sword Guard
(31401, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dummy - Bow Guard
(31404, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Monster Race Guide
(31405, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Monster Race Guide
(31406, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Monster Race Guide
(31407, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Monster Race Guide
(31408, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Monster Race Guide
(31409, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Monster Race Guide
(31410, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Monster Race Guide
(31411, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Monster Race Guide
(31412, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Monster Race Guide
(31413, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Antonio
(31414, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lynn
(31415, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Triya
(31416, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Aren
(31417, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Berynel
(31418, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Rouke
(31419, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lorel
(31420, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tomanel
(31421, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ratriya
(31422, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Migel
(31423, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Romas
(31424, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Shantra
(31425, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Koram
(31426, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Jaka
(31427, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Urgal
(31428, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Shafa
(31429, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Shitara
(31430, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Donai
(31431, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Karai
(31432, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Reeya
(31433, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ronaldo
(31434, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Shaling
(31435, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Daeger
(31436, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dani
(31437, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Luka
(31438, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lara
(31439, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Rogen
(31440, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lanna
(31441, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gordo
(31442, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kiki
(31443, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Raban
(31444, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Cona
(31445, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Shutner
(31452, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ghost of Wigoth
(31453, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Nameless Spirit
(31454, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ghost of Wigoth
(31455, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Key Box
(31456, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Key Box
(31457, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Key Box
(31458, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Key Box
(31459, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Key Box
(31460, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Key Box
(31461, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Key Box
(31462, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Key Box
(31463, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Key Box
(31464, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Key Box
(31465, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Key Box
(31466, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Key Box
(31467, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Key Box
(31468, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mysterious Box
(31469, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mysterious Box
(31470, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mysterious Box
(31471, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mysterious Box
(31472, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mysterious Box
(31473, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mysterious Box
(31474, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mysterious Box
(31475, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mysterious Box
(31476, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mysterious Box
(31477, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mysterious Box
(31478, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mysterious Box
(31479, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mysterious Box
(31480, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mysterious Box
(31481, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mysterious Box
(31482, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mysterious Box
(31483, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mysterious Box
(31484, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mysterious Box
(31485, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mysterious Box
(31486, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mysterious Box
(31487, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mysterious Box
(31488, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Rift Post Recruit
(31489, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Rift Post Private
(31490, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Rift Post Officer
(31491, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Rift Post Captain
(31492, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Rift Post Commander
(31493, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Rift Post Hero
(31494, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dimensional Gate Keeper
(31495, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dimensional Gate Keeper
(31496, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dimensional Gate Keeper
(31497, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dimensional Gate Keeper
(31498, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dimensional Gate Keeper
(31499, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dimensional Gate Keeper
(31500, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dimensional Gate Keeper
(31501, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dimensional Gate Keeper
(31502, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dimensional Gate Keeper
(31503, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dimensional Gate Keeper
(31504, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dimensional Gate Keeper
(31505, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dimensional Gate Keeper
(31506, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dimensional Gate Keeper
(31507, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dimensional Gate Keeper
(31508, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Altar of Saints
(31509, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Altar of Saints
(31510, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Altar of Saints
(31511, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Altar of Saints
(31512, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Evil Altar
(31513, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Evil Altar
(31514, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Evil Altar
(31515, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Evil Altar
(31516, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Evil Altar
(31517, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Hierarch
(31518, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mysterious Necromancer
(31519, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Enfeux
(31520, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Leikar
(31521, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Jeremy
(31522, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mysterious Wizard
(31523, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tombstone
(31524, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ghost of von Hellmann
(31525, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ghost of von Hellmann's Page
(31526, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Broken Bookshelf
(31527, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Well
(31528, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ghost of Priest
(31529, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ghost of Adventurer
(31530, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Box
(31531, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tombstone
(31532, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Lidia's Maid
(31533, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Broken Bookshelf
(31534, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Broken Bookshelf
(31535, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Broken Bookshelf
(31536, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Coffin
(31537, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tunatun
(31538, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ghost of Adventurer
(31539, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Vulcan
(31540, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Klein
(31541, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Daimon's Altar
(31542, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Yeti's Table
(31543, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Pulin
(31544, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Naff
(31545, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Crocus
(31546, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kuber
(31547, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Beolin
(31548, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mysterious Ancient Tablet
(31549, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mysterious Ancient Tablet
(31550, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mysterious Ancient Tablet
(31551, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mysterious Ancient Tablet
(31552, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mysterious Ancient Tablet
(31553, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Pierce
(31554, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kahman
(31555, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Abercrombie
(31556, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Selina
(31557, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mercenary Sentry
(31558, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ketra's Holy Altar
(31559, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Box of Asefa
(31560, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Varka's Holy Altar
(31561, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Udan Mardui's Box
(31562, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Klufe
(31563, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Perelin
(31564, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mishini
(31565, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ogord
(31566, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ropfi
(31567, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Bleaker
(31568, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Pamfus
(31569, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Cyano
(31570, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lanosco
(31571, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Hufs
(31572, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- O'Fulle
(31573, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Monakan
(31574, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Willie
(31575, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Litulon
(31576, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Berix
(31577, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Linnaeus
(31578, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Hilgendorf
(31579, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Klaus
(31580, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Galadrid
(31581, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Anastia
(31582, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mordred
(31583, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Feynn
(31584, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Valentine
(31585, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sparky the Cat
(31586, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sparky the Cat
(31587, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gedrik
(31588, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Agnes
(31589, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Duda-Mara Totem Spirit
(31590, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Truth Scholar Devianne
(31591, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sunset Guide Luna
(31592, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Telson
(31593, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dorothy
(31594, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mond
(31595, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Leona Blackbird
(31596, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tobald
(31597, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tobald
(31598, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Medina Blackheart
(31599, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Disgraced Knight Waldstein
(31600, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Pamela Aprodia
(31601, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Pamela Aprodia
(31602, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sharona Artemia
(31603, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Black Cat
(31604, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Grimst
(31605, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Kinsley
(31606, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Alice de Catrina
(31607, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sake Dun Zu Hestui
(31608, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Belinda
(31609, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Aurora the Unicorn
(31610, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Shiken Gloomdrake
(31611, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Scryde Heartseeker
(31612, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Eternity Wanderer Staris
(31613, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Noctisse
(31614, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Radyss
(31615, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Hermit
(31616, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Hermit
(31617, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Aria Firstmatter
(31618, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Moon Voice Irene
(31619, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Erica Ken Weber
(31620, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Verdure Elder Elikia
(31621, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Abyssal Saintess Elcadia
(31622, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Keats
(31623, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Bavarin
(31624, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Donath
(31625, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Yeti
(31626, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Duncan
(31627, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mist
(31628, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lilly
(31629, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kaleidos the Unicorn
(31630, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kaleidos the Unicorn
(31631, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Eric Ramsheart
(31632, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mysterious Servitor
(31633, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Winter Hunter Kadyth
(31634, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Winter Hunter Kadyth
(31635, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Winter Hunter Kadyth
(31636, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Flame Successor Akkan
(31637, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Khavatari Kashu
(31638, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Starling Knight Kastien
(31639, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kain Van Halter
(31640, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Pilgrim of Darkness
(31641, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Pilgrim of Darkness
(31642, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tarkai Zu Duda-Mara
(31643, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Silver Feyshar
(31644, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Dawn Witness Franz
(31645, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Hindemith Truevoice
(31646, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tablet of Vision
(31647, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tablet of Vision
(31648, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tablet of Vision
(31649, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tablet of Vision
(31650, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tablet of Vision
(31651, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tablet of Vision
(31652, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tablet of Vision
(31653, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tablet of Vision
(31654, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tablet of Vision
(31655, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tablet of Vision
(31656, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tablet of Vision
(31657, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tablet of Vision
(31658, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tablet of Vision
(31659, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tablet of Vision
(31660, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tablet of Vision
(31661, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Forgotten Monument
(31662, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Forgotten Monument
(31663, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Forgotten Monument
(31664, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Forgotten Monument
(31665, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "corpse"), -- Corpse of Dwarf
(31666, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lumen
(31667, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Raik
(31668, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Tangen
(31669, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Onyx
(31670, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Burns
(31671, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Patrol
(31672, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Patrol
(31673, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Patrol
(31674, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "null", 300, "null", 0, 0, "fighter"), -- Patrol
(31675, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Viktor Van Deik
(31676, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gregory Athebaldt
(31677, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Border Patrol
(31678, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Border Patrol
(31679, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Eustace Van Essen
(31680, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Fleming Van Issen
(31681, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Frontier Guard
(31682, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Frontier Guard
(31683, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Eye of Argos
(31684, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Eye of Udan Mardui
(31685, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Asefa's Eye
(31686, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gatekeeper of Fire Dragon
(31687, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gatekeeper of Fire Dragon
(31688, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Grand Olympiad Manager
(31689, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Olympiad Finisher
(31690, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Monument of Heroes
(31691, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Training Dummy
(31692, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Priest of Dawn
(31693, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Priest of Dusk
(31694, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Priest of Dawn
(31695, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Priest of Dusk
(31696, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Platis
(31697, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Eindarkner
(31698, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Arisha
(31699, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Stanislava
(31700, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Saint's Follower
(31701, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Saint's Follower
(31702, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Saint's Follower
(31703, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Saint's Follower
(31704, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Saint's Follower
(31705, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Daimon the White-Eyed
(31706, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Miki the Cat
(31707, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ketra Van Grunt
(31708, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Ketra Van Shaman
(31709, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ketra Van Captain
(31710, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Varka Van Commander
(31711, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Varka Van Shaman
(31712, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Varka Raider
(31713, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Preacher of Doom
(31714, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Preacher of Doom
(31715, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Preacher of Doom
(31716, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Preacher of Doom
(31717, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Preacher of Doom
(31718, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Preacher of Doom
(31719, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Preacher of Doom
(31720, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Preacher of Doom
(31721, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Orator of Revelations
(31722, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Orator of Revelations
(31723, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Orator of Revelations
(31724, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Orator of Revelations
(31725, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Orator of Revelations
(31726, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Orator of Revelations
(31727, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Orator of Revelations
(31728, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Orator of Revelations
(31729, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31730, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31731, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31732, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31733, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31734, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31735, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31736, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31737, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31738, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31739, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Talien
(31740, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Caradine
(31741, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ossian
(31742, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Virgil
(31743, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kassandra
(31744, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Ogmar
(31745, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Lady of the Lake
(31746, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Fallen Unicorn
(31747, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Pure White Unicorn
(31748, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Cornerstone of Restraining
(31750, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mysterious Woman
(31751, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mysterious Dark Knight
(31752, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "corpse"), -- Corpse of Angel
(31755, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Halaster
(31756, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Mr. Cat
(31757, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Miss Queen
(31758, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Rafi
(31759, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Teleportation Cubic
(31760, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Miss Queen
(31761, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Miss Queen
(31762, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Miss Queen
(31763, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Miss Queen
(31764, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Miss Queen
(31765, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Miss Queen
(31766, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Miss Queen
(31767, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Event Gatekeeper
(31768, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Event Gatekeeper
(31769, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Monument of Heroes
(31770, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Monument of Heroes
(31771, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Monument of Heroes
(31772, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Monument of Heroes
(31773, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sonin
(31774, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Beryl the Cat
(31775, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31776, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31777, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31778, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31779, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31780, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31781, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31782, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31783, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31784, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31785, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31786, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31787, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31788, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31789, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31790, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31791, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31792, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31793, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31794, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31795, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31796, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31797, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31798, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31799, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31800, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31801, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31802, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31803, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31804, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31805, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31806, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31807, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31808, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31809, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31810, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31811, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31812, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31813, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31814, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31815, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31816, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31817, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31818, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31819, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31820, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31821, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31822, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31823, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31824, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31825, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31826, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31827, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31828, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31829, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31830, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31831, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31832, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31833, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31834, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31835, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31836, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31837, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31838, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31839, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31840, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31841, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31842, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Teleportation Cubic
(31843, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Teleportation Cubic
(31844, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "all_elemental_clan", 300, "all_elemental2_clan", 300, 0, "balanced"), -- Aracna
(31845, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, "all_elemental2_clan", 300, "all_elemental_clan", 300, 0, "balanced"), -- Bloody Pixy
(31846, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "all_elemental2_clan", 300, "all_elemental_clan", 300, 0, "balanced"), -- Satyros
(31847, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "all_elemental_clan", 300, "all_elemental2_clan", 300, 0, "balanced"), -- Pan
(31848, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "all_elemental_clan", 300, "all_elemental2_clan", 300, 0, "balanced"), -- Pixy
(31849, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "all_elemental2_clan", 300, "all_elemental_clan", 300, 0, "balanced"), -- Red Arachne
(31850, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "all_elemental2_clan", 300, "all_elemental_clan", 300, 0, "balanced"), -- Blight Treant
(31851, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "all_elemental_clan", 300, "all_elemental2_clan", 300, 0, "balanced"), -- Treant
(31852, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "all_elemental_clan", 300, "all_elemental2_clan", 300, 0, "fighter"), -- Pixy Murika
(31853, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "all_elemental_clan", 300, "all_elemental2_clan", 300, 0, "balanced"), -- Treant Bremec
(31854, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Event Manager
(31855, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Event Manager
(31856, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Event Manager
(31857, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Event Manager
(31858, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Event Manager
(31859, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Teleportation Cubic
(31860, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Buzz the Cat
(31861, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "door_clan;dion_siege_clan", 600, "null", 0, 0, "fighter"), -- Gatekeeper
(31862, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Angelic Vortex
(31863, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Santa Trainee
(31864, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Santa Trainee
(31865, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31866, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31867, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31868, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31869, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31870, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31871, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31872, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31873, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31874, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31875, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31876, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31877, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31878, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31879, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31880, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31881, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31882, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31883, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31884, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31885, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31886, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31887, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31888, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31889, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31890, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31891, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31892, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31893, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31894, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31895, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31896, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31897, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31898, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31899, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31900, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31901, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31902, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31903, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31904, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31905, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31906, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31907, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31908, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31909, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31910, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31911, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31912, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31913, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31914, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31915, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31916, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31917, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31918, 7, 15, 0, 300, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Guardian of Border
(31919, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Elmoreden's Ghost Chamberlain
(31920, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Elmoreden's Ghost Chamberlain
(31921, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Conquerors' Sepulcher Manager
(31922, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Emperors' Sepulcher Manager
(31923, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Great Sages' Sepulcher Manager
(31924, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Judges' Sepulcher Manager
(31925, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Baron's Hall Gatekeeper
(31926, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Viscount's Hall Gatekeeper
(31927, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Count's Hall Gatekeeper
(31928, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Marquis' Hall Gatekeeper
(31929, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Duke's Hall Gatekeeper
(31930, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Baron's Hall Gatekeeper
(31931, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Viscount's Hall Gatekeeper
(31932, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Count's Hall Gatekeeper
(31933, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Marquis' Hall Gatekeeper
(31934, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Duke's Hall Gatekeeper
(31935, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Baron's Hall Gatekeeper
(31936, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Viscount's Hall Gatekeeper
(31937, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Count's Hall Gatekeeper
(31938, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Marquis' Hall Gatekeeper
(31939, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Duke's Hall Gatekeeper
(31940, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Baron's Hall Gatekeeper
(31941, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Viscount's Hall Gatekeeper
(31942, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Count's Hall Gatekeeper
(31943, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Marquis' Hall Gatekeeper
(31944, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Duke's Hall Gatekeeper
(31945, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Auzendorff
(31946, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Hombre
(31947, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Owaki
(31948, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Adrian
(31949, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Rouge
(31950, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mailland
(31951, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Jose
(31952, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Pele
(31953, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "mage"), -- Rankar
(31954, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Saroyan
(31955, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Ruby
(31956, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Rydel
(31957, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Cherbal
(31958, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Yasheni
(31959, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Axel
(31960, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Buryun
(31961, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Newyear
(31962, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Altair
(31963, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Hitchi
(31964, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Bilia
(31965, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Hector
(31966, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Karamon
(31967, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Euline
(31968, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Baryl
(31969, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "mage"), -- Evelyn
(31970, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "mage"), -- Sinis
(31971, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "mage"), -- Otillo
(31972, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "mage"), -- Atraxia
(31973, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Raheel
(31974, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Drizzit
(31975, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Aerina
(31976, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "mage"), -- Talia
(31977, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Shaka
(31978, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Tazeer
(31979, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Moira
(31980, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Rumba
(31981, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Vishotsky
(31982, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Glen
(31983, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Friggar
(31984, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sherring
(31985, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Kosmos
(31986, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Erstack
(31987, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Gotter
(31988, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Singa
(31989, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Batidae
(31990, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Siger
(31991, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31992, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31993, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31994, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31995, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Adventure Guildsman
(31996, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "mage"), -- Javier
(31997, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Priest of Dawn
(31998, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Dusk Priestess
(31999, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Preacher of Doom
(32000, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Preacher of Doom
(32001, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Preacher of Doom
(32002, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"); -- Preacher of Doom

INSERT INTO `npcaidata` VALUES
(32003, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Orator of Revelations
(32004, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Orator of Revelations
(32005, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Orator of Revelations
(32006, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Orator of Revelations
(32007, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Galba
(32008, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Greymore
(32009, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Devorin
(32010, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Flauron
(32011, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Imperial Tomb Guide
(32012, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Tantan
(32013, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Suki
(32014, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Ivan
(32015, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "corpse"), -- Scout's Corpse
(32016, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Torrant
(32017, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Karuda
(32018, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Misa
(32019, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Suspicious Man
(32020, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Rafforty
(32021, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Ice Sculpture
(32022, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kier
(32023, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Ice Shelf
(32024, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mulia
(32025, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Ilia
(32026, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Hestui Guard
(32027, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Divine Furnace
(32028, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Holy Grail
(32029, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Freya's Steward
(32030, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ice_clan", 0, "null", 0, 0, "fighter"), -- Garden Sculpture
(32031, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "ice_clan", 0, "null", 0, 0, "fighter"), -- Ice Fairy Sculpture
(32032, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Strange Machine
(32033, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Dr. Chaos
(32034, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Temple Gatekeeper
(32035, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Temple Gatekeeper
(32036, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Temple Gatekeeper
(32037, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Temple Gatekeeper
(32038, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Ritual Offering
(32039, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Triol's Mirror
(32040, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Triol's Mirror
(32041, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Yumi
(32042, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Weathermaster
(32043, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Weathermaster
(32044, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Weathermaster
(32045, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Dr. Chaos' Secret Bookshelf
(32046, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Suspicious-Looking Pile of Stones
(32047, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Wendy
(32048, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Event Gatekeeper
(32049, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Rooney
(32050, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Parts Box
(32051, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Altar Gatekeeper
(32052, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Obi
(32053, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Abey
(32054, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Ghost of a Railroad Engineer
(32055, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Ghost of an Ancient Railroad Engineer
(32056, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "mage"), -- Aren
(32057, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Totem Spirit of Gandi
(32058, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "trioll_clan", 300, "null", 0, 0, "fighter"), -- Triol's Revelation
(32059, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "trioll_clan", 300, "null", 0, 0, "fighter"), -- Triol's Revelation
(32060, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "trioll_clan", 300, "null", 0, 0, "fighter"), -- Triol's Revelation
(32061, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "trioll_clan", 300, "null", 0, 0, "fighter"), -- Triol's Revelation
(32062, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "trioll_clan", 300, "null", 0, 0, "fighter"), -- Triol's Revelation
(32063, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "trioll_clan", 300, "null", 0, 0, "fighter"), -- Triol's Revelation
(32064, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "trioll_clan", 300, "null", 0, 0, "fighter"), -- Triol's Revelation
(32065, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "trioll_clan", 300, "null", 0, 0, "fighter"), -- Triol's Revelation
(32066, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "trioll_clan", 300, "null", 0, 0, "fighter"), -- Triol's Revelation
(32067, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "trioll_clan", 300, "null", 0, 0, "fighter"), -- Triol's Revelation
(32068, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "andreas_clan", 300, "null", 0, 0, "fighter"), -- Triol's Revelation
(32069, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Gutenhagen
(32070, 7, 15, 0, 100, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Adolph
(32071, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Linda
(32072, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Edwin
(32073, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Old Female Drifter
(32074, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "mage"), -- Gludio Territory Manager
(32075, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Sandy the Cat
(32076, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Box
(32077, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Ice Sculpture
(32078, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Ice Sculpture
(32079, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Ice Sculpture
(32082, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "mage"), -- Dion Territory Manager
(32083, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "mage"), -- Giran Territory Manager
(32084, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "mage"), -- Oren Territory Manager
(32085, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "mage"), -- Aden Territory Manager
(32086, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "mage"), -- Innadril Territory Manager
(32087, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "mage"), -- Schuttgart Territory Manager
(32088, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "mage"), -- Goddard Territory Manager
(32089, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "mage"), -- Rune Territory Manager
(32090, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Dead Leopard's Carcass
(32091, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Omega's Cat
(32092, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Alder
(32093, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Bolin
(32094, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Schule
(32095, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Marie
(32096, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Helminter
(32097, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "fighter"), -- Finker
(32098, 7, 15, 0, 1000, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Celes
(32099, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Tony the Cat
(32100, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Tony the Cat
(32101, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Tony the Cat
(32102, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Tony the Cat
(32103, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Telling the Cat
(32104, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Vervato
(32105, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Dinn
(32106, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Singsing
(32107, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Teleportation Cubic
(32108, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), --
(32109, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Shilen's Stone Statue
(32110, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), --
(32111, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Orahochin
(32112, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Gariachin
(32113, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Marquez
(32114, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mushika
(32115, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Asamah
(32116, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Kirikachin
(32117, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Karakawei
(32118, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Mantarasa Egg
(32119, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Ulu Kaimu
(32120, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Balu Kaimu
(32121, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Chuta Kaimu
(32122, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Warrior's Grave
(32123, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Valakas
(32124, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Great Soul
(32125, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Great Soul
(32126, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Priest Guard
(32127, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Priest Guard
(32128, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Guardian Wizard of the Cloth
(32129, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), --
(32130, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Strategist Lucien
(32131, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Magic Laboratory Worker
(32132, 7, 15, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "fighter"), -- Alchemist's Servitor
(32133, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Perwan
(32134, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Newbie Helper
(32135, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Newbie Helper
(32136, 7, 15, 0, 1000, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Basil
(32137, 7, 15, 0, 1000, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Sucrete
(32138, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Kekropus
(32139, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Casca
(32140, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Zenya
(32141, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Nerga
(32142, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Tenor
(32143, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Belkis
(32144, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Xonia
(32145, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Maynard
(32146, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Valfar
(32147, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Rivian
(32148, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Cindet
(32149, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Ennear
(32150, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Took
(32151, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Herz
(32152, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Henri
(32153, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Franco
(32154, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Aldenia
(32155, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Nabot
(32156, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Talbot
(32157, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Moka
(32158, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Fisler
(32159, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Kincaid
(32160, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "mage"), -- Devon
(32161, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Black
(32162, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Martika
(32163, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Teleport Device
(32164, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Erinu
(32165, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Zakone
(32166, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Trevor
(32167, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Nika
(32168, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Zenith
(32169, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Mila
(32170, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Benis
(32171, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Hoffa
(32172, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Saylem
(32173, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Marcela
(32174, 7, 15, 0, 1000, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Maddy
(32175, 7, 15, 0, 1000, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Bixon
(32176, 7, 15, 0, 1000, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Ambra
(32177, 7, 15, 0, 1000, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Syzar
(32178, 7, 15, 0, 1000, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Carver
(32179, 7, 15, 0, 1000, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Putin
(32180, 7, 15, 0, 1000, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Kato
(32181, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Mellon
(32182, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Coplan
(32183, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Yunha
(32184, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Yinir
(32185, 7, 15, 0, 1000, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Peregrine
(32186, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Yung
(32187, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Nadir
(32188, 7, 15, 0, 1000, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Morelin
(32189, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Largo
(32190, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Mao
(32191, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Hanarin
(32192, 7, 15, 0, 1000, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Falken
(32193, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Yeniche
(32194, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Shubain
(32195, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Sione
(32196, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Gershwin
(32197, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Gwain
(32198, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Gobie
(32199, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Holst
(32200, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Entien
(32201, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Rindy
(32202, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Khadava
(32203, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Ramen
(32204, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Fiske
(32205, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Aetonic
(32206, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Pieche
(32207, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Orkurus
(32208, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Rasha
(32209, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Ferdinand
(32210, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Eddy
(32211, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Jueno
(32212, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Rishtar
(32213, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Vitus
(32214, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Meldina
(32215, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Tenain
(32216, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Noir
(32217, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Barta
(32218, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Miya
(32219, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Fabnor
(32220, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Selsia
(32221, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Brome
(32222, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Liane
(32223, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Duroga
(32224, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 0, "null", 0, 0, "balanced"), -- Auren
(32225, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "null", 300, "null", 0, 0, "balanced"), -- Taine
(32226, 7, 15, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,