﻿## Active Perl 5.8.8

# *.htm 中のＮＰＣ名を一括して日本語化する
# レイド編

use utf8;
use strict;
use warnings;
use Encode;

binmode STDOUT,':encoding(cp932)'; $|=1;
sub   FS {Encode::encode('cp932',shift)}
sub UTF8 {Encode::decode('cp932',shift)}

my $DEBUG = 0; # 1 or 0

my $LogFile = UTF8(__FILE__);
   $LogFile =~ s!\.[^.\/\\]*$!.log!;
open LOG, '>:utf8', FS($LogFile)  or die "'$LogFile' $!";

&start('build/dist/game/data/scripts/custom/RaidbossInfo/');

close LOG;
exit 0;

sub start {
	my ($subDir) = @_;

	print ' [',$subDir,"]\n" if $DEBUG;
	opendir DIR, FS($subDir) or die "'$subDir' $!";
	my @files = readdir DIR; foreach (@files) { $_ = UTF8($_) }
	closedir DIR;

	foreach my $fileName (@files) {
		next if $fileName =~ m/^\./;
		next if $fileName =~ m/ /;

		my $filePath = $subDir.$fileName;

		if (-d FS($filePath)) {
			$filePath =~ s!^\.\/!!;
			&start($filePath.'/');
			next;

		} elsif ($fileName =~ /^level[0-9]+\.html?$/) {
			my $outPath = $filePath;
			   $outPath .= '.text' if $DEBUG;

			print "  $filePath\n" if $DEBUG;
			open FILE, '<:utf8', FS($filePath) or die;
			my $mtime = (stat FILE)[9];
			my @TEXT = <FILE>;
			close FILE;

			my $UPDATE = 0;
			for my $ix (0..$#TEXT) {
				chomp $TEXT[$ix];
				my $text = $TEXT[$ix];
				if ($text =~ m!<a action="bypass -h Quest RaidbossInfo ([0-9]+?)">(.+?) \(l?v?([0-9]+?)\)</a>(.*)$!) {
						#	   <a action="bypass -h Quest RaidbossInfo 25001">Greyclaw Kutus (lv23)</a><br1>
					my $id = $1;
					my $name_en = $2;
					my $level = $3;
					my $br1 = $4;

					my $name_jp = "\&\@$id;";

					$text = '<a action="bypass -h Quest RaidbossInfo '.$id.'">'.$name_jp.' (lv'.$level.')</a>'.$br1;
						#	 <a action="bypass -h Quest RaidbossInfo 25001">Greyclaw Kutus (lv23)</a><br1>
					if ($text ne $TEXT[$ix]) {
						print  '+',$outPath,"(",$ix+1,")\n" unless $UPDATE;
						print     "\t[",$name_en,"]\n";
						print     "\t[",$name_jp,"]\n";
						print LOG  $outPath,"(",$ix+1,")\n" unless $UPDATE;
						print LOG "\t[",$name_en,"]\n";
						print LOG "\t[",$name_jp,"]\n";

						$TEXT[$ix] = $text;
						$UPDATE = 1;
					}
				}
			}
			if ($UPDATE) {
				open FILE, '>:utf8', FS($outPath) or die;
				foreach my $text (@TEXT) {
					print FILE $text,"\n";
				}
				close FILE;
				utime $mtime, $mtime, FS($outPath);
			}
		}
	}
}
