//
//  FJNCoreDataArrayController.h
//  FJNCoreData
//
//  Created by FUJIDANA on 06/08/17.
//  Copyright 2006-2008 FUJIDANA. All rights reserved.
//

#import <Cocoa/Cocoa.h>


extern NSString *FJNObjectIDsPboardType;


@interface FJNCoreDataArrayController : NSArrayController
{
	IBOutlet NSTableView *mainTableView;
	
	NSArray	 *_defaultSortDescriptors;
	NSString *_localizedEntityName;
	BOOL _supportsDragAndDrop;
}

#pragma mark Methods overriding super class
- (void)awakeFromNib;

#pragma mark Accessor methods
- (NSString *)sortKey;
- (NSTableView *)tableView;
- (NSArray *)defaultSortDescriptors;
- (NSString *)localizedEntityName;
- (void)setLocalizedEntityName:(NSString *)value;
- (NSArray *)readablePasteboardTypes;
- (BOOL)supportsDragAndDrop;
- (void)setSupportsDragAndDrop:(BOOL)value;
- (NSArray *)allObjects;

#pragma mark Actions
- (void)selectNext:(id)sender;
- (void)selectPrevious:(id)sender;
- (IBAction)deselectSort:(id)sender;

#pragma mark Validating User Interface Items
- (BOOL)validateUserInterfaceItem:(id <NSValidatedUserInterfaceItem>)item;

#pragma mark methods to support drag and drop operation.
- (NSArray *)URIRepresentationsOfManagedObjects:(NSArray *)objects;
- (NSArray *)managedObjectsOfURIRepresentations:(NSArray *)URIReps;
- (void)rearrangeItemsWithUndoRegistration;

//#pragma mark Methods implementing NSTableDataSource informal protocol
// --- Subclasses should invoke this method when override. ---
//- (int)numberOfRowsInTableView:(NSTableView *)tableView;
//- (id)tableView:(NSTableView *)tableView objectValueForTableColumn:(NSTableColumn *)tableColumn row:(int)rowIndex;
//- (BOOL)tableView:(NSTableView *)tableView writeRowsWithIndexes:(NSIndexSet *)rowIndexes toPasteboard:(NSPasteboard *)pboard;
//- (NSDragOperation)tableView:(NSTableView *)tableView validateDrop:(id <NSDraggingInfo>)info proposedRow:(int)row proposedDropOperation:(NSTableViewDropOperation)operation;
//- (BOOL)tableView:(NSTableView *)tableView acceptDrop:(id <NSDraggingInfo>)info row:(int)row dropOperation:(NSTableViewDropOperation)operation;

@end
