//
//  FJNContentArrayController.m
//  FJNCoreData
//
//  Created by FUJIDANA on 06/08/17.
//  Copyright 2006-2008 FUJIDANA. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#import "FJNContentArrayController.h"


@implementation FJNContentArrayController : FJNCoreDataArrayController

- (void)dealloc
{
	[self setEntityImageName:nil];
	
	[super dealloc];
}

#pragma mark Accessor methods

- (NSString *)entityImageName
{
	return (_entityImageName != nil ? _entityImageName : @"ToolbarGenericContentIcon.tiff");
}

- (void)setEntityImageName:(NSString *)value
{
	if (_entityImageName != value)
	{
		[_entityImageName release];
		_entityImageName = [value copy];
	}
}

- (NSString *)containerKeyPath
{
	return @"container";
}

- (NSArray *)defaultSortDescriptors
{
	if (_defaultSortDescriptors == nil)
	{
		NSString *parentSortKey = [NSString stringWithFormat:@"%@.%@", [self containerKeyPath], [self sortKey]];
		NSSortDescriptor *sortDescriptor = [[NSSortDescriptor alloc] initWithKey:[self sortKey] ascending:YES];
		NSSortDescriptor *parentSortDescriptor = [[NSSortDescriptor alloc] initWithKey:parentSortKey ascending:YES];
		
		_defaultSortDescriptors = [[NSArray alloc] initWithObjects:parentSortDescriptor, sortDescriptor, nil];
		
		[sortDescriptor release];
		[parentSortDescriptor release];
	}
	return _defaultSortDescriptors;
}

@end
