// 
//  FJNContent.m
//  FJNCoreData
//
//  Created by FUJIDANA on 06/08/20.
//  Copyright 2006-2008 FUJIDANA. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#import "FJNContent.h"


@implementation FJNContent 

- (NSManagedObject *)container
{
	id tmpObject;
	
	[self willAccessValueForKey:@"container"];
	tmpObject = [self primitiveValueForKey:@"container"];
	[self didAccessValueForKey:@"container"];
	
	return tmpObject;
}

- (void)setContainer:(NSManagedObject *)value
{
	NSManagedObject *oldContainer = [self container];
	
	if (oldContainer == nil)
	{
		// When container relationship is newly set, do nothing.
		// Instead, insertObject:atArrangedObjectIndex: defined in FJNCoreDataArrayController sets the order properly.
	}
	else if (oldContainer != value)
	{
		// When container relationship is changed, set the order so that the item is positioned at the bottom of the container.
		long order = 0;
		NSSet *contents = [value valueForKeyPath:@"contents"];
		if (contents != nil && [contents count] > 0)
		{
			NSSortDescriptor *sortDescriptor = [[[NSSortDescriptor alloc] initWithKey:@"order" ascending:YES] autorelease];
			NSArray          *sortedItems    = [[contents allObjects] sortedArrayUsingDescriptors:[NSArray arrayWithObject:sortDescriptor]];
			order = [[[sortedItems lastObject] valueForKey:@"order"] longValue] + 1;
		}
		[self setValue:[NSNumber numberWithLong:order] forKey:@"order"];
	}
	
	[self willChangeValueForKey:@"container"];
	[self setPrimitiveValue:value forKey:@"container"];
	[self didChangeValueForKey:@"container"];
}


- (BOOL)validateContainer:(id *)valueRef error:(NSError **)outError
{
	// Insert custom validation logic here.
	return YES;
}

@end
