//
//  FJNContainerArrayController.m
//  FJNCoreData
//
//  Created by FUJIDANA on 06/08/17.
//  Copyright 2006-2008 FUJIDANA. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#import "FJNContainerArrayController.h"
#import "FJNContentArrayController.h"


@implementation FJNContainerArrayController

- (void)dealloc
{
	[self setEntityImageName:nil];
	
	[super dealloc];
}

#pragma mark Accessor methods

- (NSString *)entityImageName
{
	return (_entityImageName != nil ? _entityImageName : @"ToolbarGenericContainerIcon.tiff");
}

- (void)setEntityImageName:(NSString *)value
{
	if (_entityImageName != value)
	{
		[_entityImageName release];
		_entityImageName = [value copy];
	}
}

- (BOOL)conditionallyHidesContainerColumnInContentTableView
{
	return _conditionallyHidesContainerColumnInContentTableView;
}

- (void)setConditionallyHidesContainerColumnInContentTableView:(BOOL)flag
{
	_conditionallyHidesContainerColumnInContentTableView = flag;
	
	if (flag == NO)
	{
		if (floor(NSAppKitVersionNumber) > 824) // if the runtime environment is Leopard or later
		{
			NSTableColumn *column = [[contentArrayController tableView] tableColumnWithIdentifier:[contentArrayController containerKeyPath]];
			objc_msgSend(column, @selector(setHidden:), (NO));
		}
	}
}

#pragma mark Methods implementing NSTableDataSource informal protocol

- (NSDragOperation)tableView:(NSTableView *)aTableView validateDrop:(id <NSDraggingInfo>)info proposedRow:(int)row proposedDropOperation:(NSTableViewDropOperation)operation
{
	if (operation == NSTableViewDropOn &&
		aTableView == [self tableView] &&
		[info draggingSource] == [contentArrayController tableView] &&
		[[[info draggingPasteboard] types] containsObject:FJNObjectIDsPboardType])
	{
		// Dragged from contentsTableView... (This means container properties of dragged items is being changed.)
		return NSDragOperationMove;
	}
	return [super tableView:aTableView validateDrop:info proposedRow:row proposedDropOperation:operation];
}

- (BOOL)tableView:(NSTableView *)aTableView acceptDrop:(id <NSDraggingInfo>)info row:(int)row dropOperation:(NSTableViewDropOperation)operation
{
	if (operation == NSTableViewDropOn &&
		aTableView == [self tableView] &&
		[info draggingSource] == [contentArrayController tableView] &&
		[[[info draggingPasteboard] types] containsObject:FJNObjectIDsPboardType])
	{
		// Dragged from child table view to parent item table view
		if ([[self arrangedObjects] count] <= row) return NO;
		NSManagedObject *container = [[self arrangedObjects] objectAtIndex:row];
		
		NSArray *URIReps = [[info draggingPasteboard] propertyListForType:FJNObjectIDsPboardType];
		if (URIReps == nil || [URIReps isKindOfClass:[NSArray class]] == NO || [URIReps count] == 0) return NO;
		
		NSEnumerator *enumerator = [[self managedObjectsOfURIRepresentations:URIReps] objectEnumerator];
		NSManagedObject *object;
		NSString *containerKeyPath = [contentArrayController containerKeyPath];
		int i = 0;
		
		while (object = [enumerator nextObject])
		{
			if (container != [object valueForKey:containerKeyPath])
			{
				[object setValue:container forKey:containerKeyPath];
				i++;
			}
		}
		
		if (i > 0) // if one or more items are moved,
		{
			[self rearrangeItemsWithUndoRegistration];
			return YES;
		}
		return NO;
	}
	return [super tableView:aTableView acceptDrop:info row:row dropOperation:operation];
}

#pragma mark Methods delagated by NSTableView

- (void)tableViewSelectionDidChange:(NSNotification *)notification
{
	if (_conditionallyHidesContainerColumnInContentTableView)
	{
		unsigned count = [[self selectionIndexes] count];
		
		if (floor(NSAppKitVersionNumber) > 824) // if the runtime environment is Leopard or later
		{
			NSTableColumn *column = [[contentArrayController tableView] tableColumnWithIdentifier:@"container"];
			objc_msgSend(column, @selector(setHidden:), (count == 1));
		}
//		else // if the runtime environment is Tiger
//		{
//			if (count <= 1)
//			{
//				NSTableView *contentsTableView = [contentArrayController tableView];
//				int i = [contentsTableView columnWithIdentifier:[folderTableColumn identifier]];
//				if (i != -1)
//				{
//					[contentsTableView removeTableColumn:folderTableColumn];
//					[contentsTableView sizeLastColumnToFit];
//					columnIndex = i;
//				}
//				
//			}
//			else
//			{
//				NSTableView *contentsTableView = [contentArrayController tableView];
//				if ([contentsTableView columnWithIdentifier:[folderTableColumn identifier]] == -1)
//				{
//					[contentsTableView addTableColumn:folderTableColumn];
//					[contentsTableView moveColumn:([[contentsTableView tableColumns] count] - 1) toColumn:columnIndex];
//					[contentsTableView sizeLastColumnToFit];
//				}
//			}
//		}
	}
}


@end
