﻿module kyojintati4d.val.kyojinconst;

private import std.conv;

private import y4d_aux.filesys;
private import yamalib.auxil.properties;

/// プログラム定数定義クラス
class KyojinConst {
	
public:

	/// アプリケーション名
	static const char[] strAppName = "去人たち完全版 powered by Y4D";
	/// バージョン
	static const char[] APP_VERSION = "1.17";
	/// セーブファイル名
	static const char[] saveFileName = "kyojintati.sav";
	/// セーブファイル名
	static const char[] C_SAVE_IDENT_FILE = "saves";
	/// ユーザ環境設定ファイル
	static const char[] C_USER_ENV_FILE = "setting.txt";
	
	
	/** 暗号化のキー（こういうのは変数名自体もわかりにくいものにすべきである） */
	static const ubyte C_K2C_INFO_KYOJINTACHI = 0x7E;

	// TODO : 本物のパスワードを設定すること
	static final const char[] PK = "aaaa";
	static final const char[] P2 = "bbbb";
	static final const char[] PC = "cccc";
	
	static const char[] PK2C = PK ~ P2 ~ PC;
		
	/** 推奨FSP */
	static const int C_FSP_DEFAULT = 60;
	/** 実FSP */
	static int C_FSP_NOW;
	
	/** 最大タスク数 */
	static const int C_MAX_TASK_NUM = 30;

	/// 背景定数
	enum BGDef : int { BLACK = 0, WHITE = 0 };
	
	/// オートセーブ栞定数
	enum BookmarkID : int { AUTO = 3 };
	
	/// シナリオ定数
	enum ScenarioID : int {
		NOT_DATA=-1,
		STORY01=0,	// 0 秋日狂想
		STORY02_0,STORY02_1,STORY02_2,	// 1,2,3 残秋挽歌	
		STORY03,	// 4, 頑是なき乱声
		STORY04,	// 5, 道化の臨終
		STORY05,	// 6, 終末事端
		STORY06,	// 7, つみびとをして
		STORY07,	// 8, 始衷終と少女
		STORY08_0,STORY08_1,STORY08_2,STORY08_3,	// 9, 10, 11, 12 或る秋までの歴史
		STORY09,	// 13, 或る秋までの歴史
		KYOJIN01, 	// 14, 精神病十種
		KYOJIN02, 	// 15, 仮構のひと
		KYOJIN03,	// 16, 去人たち
		STORY2ch01
	};
	
	/// シナリオスクリプトファイル名定数
	static const char[][] scenarioFileName = [
		"data/s01.html",	// 0
		"data/s02.0.html",	// 1
		"data/s02.1.html",	// 2
		"data/s02.2.html",	// 3
		"data/s03.html",	// 4
		"data/s04.html",	// 5
		"data/s05.html",	// 6
		"data/s06.html",	// 7
		"data/s07.html",	// 8
		"data/s08.0html",	// 9
		"data/s08.1html",	// 10
		"data/s08.2html",	// 11
		"data/s08.3html",	// 12
		"data/s09.html",	// 13
		"data/sKyojin1.html",	// 14
		"data/sKyojin2.html",	// 15
		"data/sKyojin3.html",	// 16
		"data/debug_sKyojin1.html",	// 14
		"data/debug_sKyojin2.html",	// 15
		"data/debug_sKyojin3.html",	// 16
		"data/s2ch01.html"	// 17
	];
	
	/** ヴォイスフォルダへの相対パス */
	static const char[][] voicePath = [
		"snd/voice/s01/",	// data/s01.html
		"snd/voice/s02/",	// data/s2.0.html
		"snd/voice/s02_1/",	// data/s2.1.html
		"snd/voice/s02_2/",	// data/s2.2.html
		"snd/voice/s03/",	// data/s03.html
		"snd/voice/s04/",	// data/s04.html
		"snd/voice/s05/",	// data/s05.html
		"snd/voice/s06/",	// data/s06.html
		"snd/voice/s07/",	// data/s07.html
		"snd/voice/kyojin01/",
		"snd/voice/kyojin02/",
		"snd/voice/kyojin03/",
		"snd/voice/2ch01/",
	  ];
	
	/// 使用するタスクの列挙体
	enum Task : int {
		Task_Movie=0,		// ムービー再生タスク
		Task_Logo,			// K2C Logo
		Task_Demo,			// Demo
		Task_Title,			// タイトルタスク
		Task_Option,		// オプションタスク
		Task_Telop,			// テロップタスク
		Task_Scenario,		// シナリオタスク
		Task_Pinup,			// ピンナップタスク
		Task_Ending1,		// エンディング１タスク
		Task_Ending2,		// エンディング１タスク
		Task_Ending3,		// エンディング１タスク
		Task_EndingKyojin,	// 去人パートエンディング
		Task_Music,			// 音楽室タスク
		Task_Bookmark,		// セーブ管理画面タスク
		Task_BookmarkMain,	// セーブ管理画面タスク
		Task_Dev,			// 開発室タスク
		Task_Loader,		// ファイルロードタスク
		Task_YesNo,			// 終了しますかタスク
		Task_Selector,		// シナリオ選択タスク
		Task_EyeCatche,		// アイキャッチタスク
		Task_TelopKyojin,	// テロップタスク
		Task_4Koma,			// 四コマタスク
		Task_EndingOption,	// エンディングオプション
		
		Task_Test,			// TEST用タスク
	
	};
	
	/// 使用しているタスクの文字列ＩＤ（ここに記述するタスク名は固有であること）
	static const char[][] TASK_NAME = [
		"TASK_MOVIE",
		"TASK_LOGO",
		"TASK_DEMO",
		"TASK_TITLE",
		"TASK_OPTION",
		"TASK_TELOP",
		"TASK_SCENARIO",
		"TASK_ENDING1",
		"TASK_ENDING2",
		"TASK_ENDING3",
		"TASK_ENDING_KYOJIN",
		"TASK_MUSIC",
		"TASK_BOOKMARK",
		"TASK_BOOKMARKMAIN",
		"TASK_DEV",
		"TASK_LOADER",
		"TASK_YESNO",
		"TASK_SELECTOR",
		"TASK_EYECATCHE",
		"TASK_TELOPKYOJIN",
		"TASK_4KOMA",
		"TASK_TEST",
		"TASK_SCENARIOCONV"
	];


	/** 改行コード */
	static const char[] NEWLINE_CODE = "\n";
	
	/** 外部に定義しておくメインフォント */
	private static const int C_FONT_MAIN = 1;
	
	/** フォント番号：シナリオ画面ルビ文字 */
	static const int C_FONT_NO_RUBI = 0;
	/** フォント番号：シナリオ画面メイン文字 */
	static int C_FONT_NO_MAIN_TEXT = C_FONT_MAIN;
	/** フォント番号：ダイアログボックス文字 */
	static const int C_FONT_NO_DIALOG_TEXT = C_FONT_MAIN;
	/** フォント番号：セーブ画面フォント文字 */
	static const int C_FONT_NO_SEVE_TEXT = C_FONT_MAIN;
	/** フォント番号：セーブ画面フォント文字 */
	static const int C_FONT_NO_DEVROOM = 4;
	/** フォント番号：セーブ画面フォント文字 */
	static const int C_FONT_NO_KYOJIN_MAIN_TEXT = 7;


	/// 静的コンストラクタ
	static this() {
		// プロパティ読み読込
		Properties prop = Properties.getInstance(cast(char[]) C_USER_ENV_FILE);
//		prop.load( C_USER_ENV_FILE );
		
		int fsp;
		char[] strfsp = prop.getProperty(cast(char[]) "fps", cast(char[]) "60");
		
		try {
			fsp = std.conv.toInt(strfsp);
		} catch (ConvError e) {
			fsp = 30;
			printf("Property [FPS] is invalid.\n");
		}
		
		// FSPは15 30 60 120
		int tmp = 15;
		while (true) {
			if ( tmp == fsp ) {
				break;
			}
			tmp *= 2;
			if ( tmp > 120 ) {
				fsp = 30;
				break;
			}
		}

		C_FSP_NOW = fsp;
	}

private:

	/* インスタンスを生成しべきではない */
	this() {
	}
}


/// 画像ファイル名定数定義クラス
/**
	Mixinとして使うとスコープが解決されてとっても便利
*/
class PicNameConst {
	
public:
	
	static const char[] IMG__BACK__LIST_LST= "img\\back\\list.lst";
	static const char[] IMG__BACK__PLACE000_JPG= "img\\back\\place000.jpg";
	static const char[] IMG__BACK__PLACE001_JPG= "img\\back\\place001.jpg";
	static const char[] IMG__BACK__PLACE002_JPG= "img\\back\\place002.jpg";
	static const char[] IMG__BACK__PLACE003_JPG= "img\\back\\place003.jpg";
	static const char[] IMG__BACK__PLACE004_JPG= "img\\back\\place004.jpg";
	static const char[] IMG__BACK__PLACE005_JPG= "img\\back\\place005.jpg";
	static const char[] IMG__BACK__PLACE006_JPG= "img\\back\\place006.jpg";
	static const char[] IMG__BACK__PLACE007_JPG= "img\\back\\place007.jpg";
	static const char[] IMG__BACK__PLACE008_JPG= "img\\back\\place008.jpg";
	static const char[] IMG__BACK__PLACE009_JPG= "img\\back\\place009.jpg";
	static const char[] IMG__BACK__PLACE010_JPG= "img\\back\\place010.jpg";
	static const char[] IMG__BACK__PLACE011_JPG= "img\\back\\place011.jpg";
	static const char[] IMG__BACK__PLACE012_JPG= "img\\back\\place012.jpg";
	static const char[] IMG__BACK__PLACE013_JPG= "img\\back\\place013.jpg";
	static const char[] IMG__BACK__PLACE014_JPG= "img\\back\\place014.jpg";
	static const char[] IMG__BACK__PLACE015_JPG= "img\\back\\place015.jpg";
	static const char[] IMG__BACK__PLACE016_JPG= "img\\back\\place016.jpg";
	static const char[] IMG__BACK__PLACE017_JPG= "img\\back\\place017.jpg";
	static const char[] IMG__BACK__PLACE018_JPG= "img\\back\\place018.jpg";
	static const char[] IMG__BACK__PLACE019_JPG= "img\\back\\place019.jpg";
	static const char[] IMG__BACK__PLACE020_JPG= "img\\back\\place020.jpg";
	static const char[] IMG__BACK__PLACE021_JPG= "img\\back\\place021.jpg";
	static const char[] IMG__BACK__PLACE022_JPG= "img\\back\\place022.jpg";
	static const char[] IMG__BACK__PLACE023_JPG= "img\\back\\place023.jpg";
	static const char[] IMG__BACK__PLACE024_JPG= "img\\back\\place024.jpg";
	static const char[] IMG__BACK__PLACE025_JPG= "img\\back\\place025.jpg";
	static const char[] IMG__BACK__PLACE026_JPG= "img\\back\\place026.jpg";
	static const char[] IMG__BACK__PLACE027_JPG= "img\\back\\place027.jpg";
	static const char[] IMG__BACK__PLACE028_JPG= "img\\back\\place028.jpg";
	static const char[] IMG__BACK__PLACE029_JPG= "img\\back\\place029.jpg";
	static const char[] IMG__BACK__PLACE030_JPG= "img\\back\\place030.jpg";
	static const char[] IMG__BACK__PLACE031_JPG= "img\\back\\place031.jpg";
	static const char[] IMG__BACK__PLACE032_JPG= "img\\back\\place032.jpg";
	static const char[] IMG__BACK__PLACE033_JPG= "img\\back\\place033.jpg";
	static const char[] IMG__BACK__PLACE034_JPG= "img\\back\\place034.jpg";
	static const char[] IMG__BACK__PLACE035_JPG= "img\\back\\place035.jpg";
	static const char[] IMG__BACK__PLACE036_JPG= "img\\back\\place036.jpg";
	static const char[] IMG__BACK__PLACE037_JPG= "img\\back\\place037.jpg";
	static const char[] IMG__BACK__PLACE038_JPG= "img\\back\\place038.jpg";
	static const char[] IMG__BACK__PLACE039_JPG= "img\\back\\place039.jpg";
	static const char[] IMG__BACK__PLACE040_JPG= "img\\back\\place040.jpg";
	static const char[] IMG__BACK__PLACE041_JPG= "img\\back\\place041.jpg";
	static const char[] IMG__BACK__PLACE042_JPG= "img\\back\\place042.jpg";
	static const char[] IMG__BACK__PLACE043_JPG= "img\\back\\place043.jpg";
	static const char[] IMG__BACK__PLACE044_JPG= "img\\back\\place044.jpg";
	static const char[] IMG__BACK__PLACE045_JPG= "img\\back\\place045.jpg";
	static const char[] IMG__BACK__PLACE046_JPG= "img\\back\\place046.jpg";
	static const char[] IMG__BACK__PLACE047_JPG= "img\\back\\place047.jpg";
	static const char[] IMG__BACK__PLACE048_JPG= "img\\back\\place048.jpg";
	static const char[] IMG__BACK__PLACE049_JPG= "img\\back\\place049.jpg";
	static const char[] IMG__BACK__PLACE050_JPG= "img\\back\\place050.jpg";
	static const char[] IMG__BACK__PLACE051_JPG= "img\\back\\place051.jpg";
	static const char[] IMG__BACK__PLACE052_JPG= "img\\back\\place052.jpg";
	static const char[] IMG__BACK__PLACE053_JPG= "img\\back\\place053.jpg";
	static const char[] IMG__BACK__PLACE054_JPG= "img\\back\\place054.jpg";
	static const char[] IMG__BACK__PLACE055_JPG= "img\\back\\place055.jpg";
	static const char[] IMG__BACK__PLACE056_JPG= "img\\back\\place056.jpg";
	static const char[] IMG__BACK__PLACE057_JPG= "img\\back\\place057.jpg";
	static const char[] IMG__BACK__PLACE058_JPG= "img\\back\\place058.jpg";
	static const char[] IMG__BACK__PLACE059_JPG= "img\\back\\place059.jpg";
	static const char[] IMG__BACK__PLACE060_JPG= "img\\back\\place060.jpg";
	static const char[] IMG__BACK__PLACE061_JPG= "img\\back\\place061.jpg";
	static const char[] IMG__BACK__PLACE062_JPG= "img\\back\\place062.jpg";
	static const char[] IMG__BACK__PLACE063_JPG= "img\\back\\place063.jpg";
	static const char[] IMG__BACK__PLACE064_JPG= "img\\back\\place064.jpg";
	static const char[] IMG__BACK__PLACE065_JPG= "img\\back\\place065.jpg";
	static const char[] IMG__BACK__PLACE066_JPG= "img\\back\\place066.jpg";
	static const char[] IMG__BACK__PLACE067_JPG= "img\\back\\place067.jpg";
	static const char[] IMG__BACK__PLACE068_JPG= "img\\back\\place068.jpg";
	static const char[] IMG__BACK__PLACE069_JPG= "img\\back\\place069.jpg";
	static const char[] IMG__BACK__PLACE070_JPG= "img\\back\\place070.jpg";
	static const char[] IMG__BACK__PLACE071_JPG= "img\\back\\place071.jpg";
	static const char[] IMG__BACK__PLACE072_JPG= "img\\back\\place072.jpg";
	static const char[] IMG__BACK__PLACE073_JPG= "img\\back\\place073.jpg";
	static const char[] IMG__BACK__PLACE074_JPG= "img\\back\\place074.jpg";
	static const char[] IMG__BACK__PLACE075_JPG= "img\\back\\place075.jpg";
	static const char[] IMG__BACK__PLACE076_JPG= "img\\back\\place076.jpg";
	static const char[] IMG__BACK__PLACE077_JPG= "img\\back\\place077.jpg";
	static const char[] IMG__BACK__PLACE078_JPG= "img\\back\\place078.jpg";
	static const char[] IMG__BACK__PLACE079_JPG= "img\\back\\place079.jpg";
	static const char[] IMG__BACK__PLACE080_JPG= "img\\back\\place080.jpg";
	static const char[] IMG__BACK__PLACE081_JPG= "img\\back\\place081.jpg";
	static const char[] IMG__BACK__PLACE082_JPG= "img\\back\\place082.jpg";
	static const char[] IMG__BACK__PLACE083_JPG= "img\\back\\place083.jpg";
	static const char[] IMG__BACK__PLACE084_JPG= "img\\back\\place084.jpg";
	static const char[] IMG__BACK__PLACE085_JPG= "img\\back\\place085.jpg";
	static const char[] IMG__BACK__PLACE086_JPG= "img\\back\\place086.jpg";
	static const char[] IMG__BACK__PLACE087_JPG= "img\\back\\place087.jpg";
	static const char[] IMG__BACK__PLACE088_JPG= "img\\back\\place088.jpg";
	static const char[] IMG__BACK__PLACE089_JPG= "img\\back\\place089.jpg";
	static const char[] IMG__BACK__PLACE090_JPG= "img\\back\\place090.jpg";
	static const char[] IMG__BACK__PLACE091_JPG= "img\\back\\place091.jpg";
	static const char[] IMG__BACK__PLACE092_JPG= "img\\back\\place092.jpg";
	static const char[] IMG__BACK__PLACE093_JPG= "img\\back\\place093.jpg";
	static const char[] IMG__BACK__PLACE094_JPG= "img\\back\\place094.jpg";
	static const char[] IMG__BACK__PLACE095_JPG= "img\\back\\place095.jpg";
	static const char[] IMG__BACK__PLACE096_JPG= "img\\back\\place096.jpg";
	static const char[] IMG__BACK__PLACE097_JPG= "img\\back\\place097.jpg";
	static const char[] IMG__BACK__PLACE098_JPG= "img\\back\\place098.jpg";
	static const char[] IMG__BACK__PLACE099_JPG= "img\\back\\place099.jpg";
	static const char[] IMG__BACK__PLACE100_JPG= "img\\back\\place100.jpg";
	static const char[] IMG__BACK__PLACE101_JPG= "img\\back\\place101.jpg";
	static const char[] IMG__BACK__PLACE102_JPG= "img\\back\\place102.jpg";
	static const char[] IMG__BACK__PLACE103_JPG= "img\\back\\place103.jpg";
	static const char[] IMG__BACK__PLACE104_JPG= "img\\back\\place104.jpg";
	static const char[] IMG__BACK__PLACE105_JPG= "img\\back\\place105.jpg";
	static const char[] IMG__BACK__PLACE106_JPG= "img\\back\\place106.jpg";
	static const char[] IMG__BACK__PLACE107_JPG= "img\\back\\place107.jpg";
	static const char[] IMG__BACK__PLACE108_JPG= "img\\back\\place108.jpg";
	static const char[] IMG__BACK__PLACE109_JPG= "img\\back\\place109.jpg";
	static const char[] IMG__BACK__PLACE110_JPG= "img\\back\\place110.jpg";
	static const char[] IMG__BACK__PLACE111_JPG= "img\\back\\place111.jpg";
	static const char[] IMG__BACK__PLACE112_JPG= "img\\back\\place112.jpg";
	static const char[] IMG__BACK__PLACE113_JPG= "img\\back\\place113.jpg";
	static const char[] IMG__BACK__PLACE114_JPG= "img\\back\\place114.jpg";
	static const char[] IMG__BACK__PLACE115_JPG= "img\\back\\place115.jpg";
	static const char[] IMG__BACK__PLACE116_JPG= "img\\back\\place116.jpg";
	static const char[] IMG__BACK__PLACE117_JPG= "img\\back\\place117.jpg";
	static const char[] IMG__BACK__PLACE118_JPG= "img\\back\\place118.jpg";
	static const char[] IMG__BACK__PLACE119_JPG= "img\\back\\place119.jpg";
	static const char[] IMG__BACK__PLACE120_JPG= "img\\back\\place120.jpg";
	static const char[] IMG__BACK__PLACE121_JPG= "img\\back\\place121.jpg";
	static const char[] IMG__BACK__PLACE122_JPG= "img\\back\\place122.jpg";
	static const char[] IMG__BACK__PLACE123_JPG= "img\\back\\place123.jpg";
	static const char[] IMG__BACK__PLACE124_JPG= "img\\back\\place124.jpg";
	static const char[] IMG__BACK__PLACE125_JPG= "img\\back\\place125.jpg";
	static const char[] IMG__BACK__PLACE126_JPG= "img\\back\\place126.jpg";
	static const char[] IMG__BACK__PLACE127_JPG= "img\\back\\place127.jpg";
	static const char[] IMG__BACK__PLACE128_JPG= "img\\back\\place128.jpg";
	static const char[] IMG__BACK__PLACE129_JPG= "img\\back\\place129.jpg";
	static const char[] IMG__BACK__PLACE130_JPG= "img\\back\\place130.jpg";
	static const char[] IMG__BACK__PLACE131_JPG= "img\\back\\place131.jpg";
	static const char[] IMG__BACK__PLACE132_JPG= "img\\back\\place132.jpg";
	static const char[] IMG__BACK__PLACE133_JPG= "img\\back\\place133.jpg";
	static const char[] IMG__BACK__PLACE134_JPG= "img\\back\\place134.jpg";
	static const char[] IMG__BACK__PLACE135_JPG= "img\\back\\place135.jpg";
	static const char[] IMG__BACK__PLACE136_JPG= "img\\back\\place136.jpg";
	static const char[] IMG__BACK__PLACE137_JPG= "img\\back\\place137.jpg";
	static const char[] IMG__BACK__PLACE138_JPG= "img\\back\\place138.jpg";
	static const char[] IMG__BACK__PLACE139_JPG= "img\\back\\place139.jpg";
	static const char[] IMG__BACK__PLACE140_JPG= "img\\back\\place140.jpg";
	static const char[] IMG__BACK__PLACE141_JPG= "img\\back\\place141.jpg";
	static const char[] IMG__BACK__PLACE142_JPG= "img\\back\\place142.jpg";
	static const char[] IMG__BACK__PLACE143_JPG= "img\\back\\place143.jpg";
	static const char[] IMG__BACK__PLACE144_JPG= "img\\back\\place144.jpg";
	static const char[] IMG__BACK__PLACE145_JPG= "img\\back\\place145.jpg";
	static const char[] IMG__BACK__PLACE146_JPG= "img\\back\\place146.jpg";
	static const char[] IMG__BACK__PLACE147_JPG= "img\\back\\place147.jpg";
	static const char[] IMG__BACK__PLACE148_JPG= "img\\back\\place148.jpg";
	static const char[] IMG__BACK__PLACE149_JPG= "img\\back\\place149.jpg";
	static const char[] IMG__BACK__PLACE150_JPG= "img\\back\\place150.jpg";
	static const char[] IMG__BACK__PLACE151_JPG= "img\\back\\place151.jpg";
	static const char[] IMG__BACK__PLACE152_JPG= "img\\back\\place152.jpg";
	static const char[] IMG__BACK__PLACE153_JPG= "img\\back\\place153.jpg";
	static const char[] IMG__BACK__PLACE154_JPG= "img\\back\\place154.jpg";
	static const char[] IMG__BACK__PLACE155_JPG= "img\\back\\place155.jpg";
	static const char[] IMG__BACK2CH__LIST_LST= "img\\back2ch\\list.lst";
	static const char[] IMG__BACK2CH__PLACE000_JPG= "img\\back2ch\\place000.jpg";
	static const char[] IMG__BACK2CH__PLACE001_JPG= "img\\back2ch\\place001.jpg";
	static const char[] IMG__BACK2CH__PLACE002_JPG= "img\\back2ch\\place002.jpg";
	static const char[] IMG__BACK2CH__PLACE003_JPG= "img\\back2ch\\place003.jpg";
	static const char[] IMG__BACK2CH__PLACE004_JPG= "img\\back2ch\\place004.jpg";
	static const char[] IMG__BACK2CH__PLACE005_JPG= "img\\back2ch\\place005.jpg";
	static const char[] IMG__BACK2CH__PLACE006_JPG= "img\\back2ch\\place006.jpg";
	static const char[] IMG__BACK2CH__PLACE007_JPG= "img\\back2ch\\place007.jpg";
	static const char[] IMG__BACK2CH__PLACE008_JPG= "img\\back2ch\\place008.jpg";
	static const char[] IMG__BACK2CH__PLACE009_JPG= "img\\back2ch\\place009.jpg";
	static const char[] IMG__BACK2CH__PLACE010_JPG= "img\\back2ch\\place010.jpg";
	static const char[] IMG__BACK2CH__PLACE011_JPG= "img\\back2ch\\place011.jpg";
	static const char[] IMG__BACK2CH__PLACE012_JPG= "img\\back2ch\\place012.jpg";
	static const char[] IMG__BACK2CH__PLACE013_JPG= "img\\back2ch\\place013.jpg";
	static const char[] IMG__BACK2CH__PLACE014_JPG= "img\\back2ch\\place014.jpg";
	static const char[] IMG__BACK2CH__PLACE015_JPG= "img\\back2ch\\place015.jpg";
	static const char[] IMG__BACK2CH__PLACE016_JPG= "img\\back2ch\\place016.jpg";
	static const char[] IMG__BACK2CH__PLACE017_JPG= "img\\back2ch\\place017.jpg";
	static const char[] IMG__BACK2CH__PLACE018_JPG= "img\\back2ch\\place018.jpg";
	static const char[] IMG__BACK2CH__PLACE019_JPG= "img\\back2ch\\place019.jpg";
	static const char[] IMG__BACK2CH__PLACE020_JPG= "img\\back2ch\\place020.jpg";
	static const char[] IMG__BACK2CH__PLACE021_JPG= "img\\back2ch\\place021.jpg";
	static const char[] IMG__BACK2CH__PLACE022_JPG= "img\\back2ch\\place022.jpg";
	static const char[] IMG__BACK2CH__PLACE023_JPG= "img\\back2ch\\place023.jpg";
	static const char[] IMG__BACK2CH__PLACE024_JPG= "img\\back2ch\\place024.jpg";
	static const char[] IMG__BACK2CH__PLACE025_JPG= "img\\back2ch\\place025.jpg";
	static const char[] IMG__BACK2CH__PLACE026_JPG= "img\\back2ch\\place026.jpg";
	static const char[] IMG__BACK2CH__PLACE027_JPG= "img\\back2ch\\place027.jpg";
	static const char[] IMG__BACK2CH__PLACE028_JPG= "img\\back2ch\\place028.jpg";
	static const char[] IMG__BACK2CH__PLACE029_JPG= "img\\back2ch\\place029.jpg";
	static const char[] IMG__BACK2CH__PLACE030_JPG= "img\\back2ch\\place030.jpg";
	static const char[] IMG__BLACK_FILTER_PNG= "img\\scenario\\black_filter.png";
	static const char[] IMG__CARSOR_PNG= "img\\carsor.png";
	static const char[] IMG__CLICK_PNG= "img\\click.png";
	static const char[] IMG__DEMO__2_PNG= "img\\demo\\2.png";
	static const char[] IMG__DEMO__A_PNG= "img\\demo\\A.png";
	static const char[] IMG__DEMO__ALICE_CODE_PNG= "img\\demo\\alice_code.png";
	static const char[] IMG__DEMO__ALICE_EYE_PNG= "img\\demo\\alice_eye.png";
	static const char[] IMG__DEMO__ALICE_SHADOW_PNG= "img\\demo\\alice_shadow.png";
	static const char[] IMG__DEMO__ALICE_ST_PNG= "img\\demo\\alice_st.png";
	static const char[] IMG__DEMO__ALICE_UP_PNG= "img\\demo\\alice_up.png";
	static const char[] IMG__DEMO__ANZAI_FACE_PNG= "img\\demo\\anzai_face.png";
	static const char[] IMG__DEMO__ANZAI_INTRO_PNG= "img\\demo\\anzai_intro.png";
	static const char[] IMG__DEMO__ASA_F_PNG= "img\\demo\\asa_f.png";
	static const char[] IMG__DEMO__BACK_JPG= "img\\demo\\back.jpg";
	static const char[] IMG__DEMO__BG__GAZOU1902_JPG= "img\\demo\\bg\\gazou1902.jpg";
	static const char[] IMG__DEMO__BG__GAZOU1903_JPG= "img\\demo\\bg\\gazou1903.jpg";
	static const char[] IMG__DEMO__BG__GAZOU1904_JPG= "img\\demo\\bg\\gazou1904.jpg";
	static const char[] IMG__DEMO__BG__GAZOU1905_JPG= "img\\demo\\bg\\gazou1905.jpg";
	static const char[] IMG__DEMO__BG__GAZOU1906_JPG= "img\\demo\\bg\\gazou1906.jpg";
	static const char[] IMG__DEMO__BG__GAZOU1907_JPG= "img\\demo\\bg\\gazou1907.jpg";
	static const char[] IMG__DEMO__BG__GAZOU1908_JPG= "img\\demo\\bg\\gazou1908.jpg";
	static const char[] IMG__DEMO__BG__GAZOU1909_JPG= "img\\demo\\bg\\gazou1909.jpg";
	static const char[] IMG__DEMO__BG__GAZOU1910_JPG= "img\\demo\\bg\\gazou1910.jpg";
	static const char[] IMG__DEMO__BG__GAZOU1911_JPG= "img\\demo\\bg\\gazou1911.jpg";
	static const char[] IMG__DEMO__BG__GAZOU1912_JPG= "img\\demo\\bg\\gazou1912.jpg";
	static const char[] IMG__DEMO__BG__GAZOU1913_JPG= "img\\demo\\bg\\gazou1913.jpg";
	static const char[] IMG__DEMO__BG__GAZOU1914_JPG= "img\\demo\\bg\\gazou1914.jpg";
	static const char[] IMG__DEMO__BG__GAZOU1915_JPG= "img\\demo\\bg\\gazou1915.jpg";
	static const char[] IMG__DEMO__BG__GAZOU1916_JPG= "img\\demo\\bg\\gazou1916.jpg";
	static const char[] IMG__DEMO__BG__GAZOU1917_JPG= "img\\demo\\bg\\gazou1917.jpg";
	static const char[] IMG__DEMO__BG__GAZOU1918_JPG= "img\\demo\\bg\\gazou1918.jpg";
	static const char[] IMG__DEMO__BG__GAZOU1919_JPG= "img\\demo\\bg\\gazou1919.jpg";
	static const char[] IMG__DEMO__BG__GAZOU1920_JPG= "img\\demo\\bg\\gazou1920.jpg";
	static const char[] IMG__DEMO__BG__GAZOU1921_JPG= "img\\demo\\bg\\gazou1921.jpg";
	static const char[] IMG__DEMO__BG__GAZOU1922_JPG= "img\\demo\\bg\\gazou1922.jpg";
	static const char[] IMG__DEMO__BG__GAZOU1923_JPG= "img\\demo\\bg\\gazou1923.jpg";
	static const char[] IMG__DEMO__BG__GAZOU1924_JPG= "img\\demo\\bg\\gazou1924.jpg";
	static const char[] IMG__DEMO__BG__GAZOU1925_JPG= "img\\demo\\bg\\gazou1925.jpg";
	static const char[] IMG__DEMO__BG__GAZOU1926_JPG= "img\\demo\\bg\\gazou1926.jpg";
	static const char[] IMG__DEMO__BG__GAZOU1927_JPG= "img\\demo\\bg\\gazou1927.jpg";
	static const char[] IMG__DEMO__BG__GAZOU1928_JPG= "img\\demo\\bg\\gazou1928.jpg";
	static const char[] IMG__DEMO__BG__LIST_LST= "img\\demo\\bg\\list.lst";
	static const char[] IMG__DEMO__BG1_JPG= "img\\demo\\bg1.jpg";
	static const char[] IMG__DEMO__BG2__BG_LST= "img\\demo\\bg2\\bg.lst";
	static const char[] IMG__DEMO__BG2__GAZOU1902_JPG= "img\\demo\\bg2\\gazou1902.jpg";
	static const char[] IMG__DEMO__BG2__GAZOU1903_JPG= "img\\demo\\bg2\\gazou1903.jpg";
	static const char[] IMG__DEMO__BG2__GAZOU1904_JPG= "img\\demo\\bg2\\gazou1904.jpg";
	static const char[] IMG__DEMO__BG2__GAZOU1905_JPG= "img\\demo\\bg2\\gazou1905.jpg";
	static const char[] IMG__DEMO__BG2__GAZOU1906_JPG= "img\\demo\\bg2\\gazou1906.jpg";
	static const char[] IMG__DEMO__BG2__GAZOU1907_JPG= "img\\demo\\bg2\\gazou1907.jpg";
	static const char[] IMG__DEMO__BG2__GAZOU1908_JPG= "img\\demo\\bg2\\gazou1908.jpg";
	static const char[] IMG__DEMO__BG2__GAZOU1909_JPG= "img\\demo\\bg2\\gazou1909.jpg";
	static const char[] IMG__DEMO__BG2__GAZOU1910_JPG= "img\\demo\\bg2\\gazou1910.jpg";
	static const char[] IMG__DEMO__BG2__GAZOU1911_JPG= "img\\demo\\bg2\\gazou1911.jpg";
	static const char[] IMG__DEMO__BG2__GAZOU1912_JPG= "img\\demo\\bg2\\gazou1912.jpg";
	static const char[] IMG__DEMO__BG2__GAZOU1913_JPG= "img\\demo\\bg2\\gazou1913.jpg";
	static const char[] IMG__DEMO__BG2__GAZOU1914_JPG= "img\\demo\\bg2\\gazou1914.jpg";
	static const char[] IMG__DEMO__BG2__GAZOU1915_JPG= "img\\demo\\bg2\\gazou1915.jpg";
	static const char[] IMG__DEMO__BG2__GAZOU1916_JPG= "img\\demo\\bg2\\gazou1916.jpg";
	static const char[] IMG__DEMO__BG2__GAZOU1917_JPG= "img\\demo\\bg2\\gazou1917.jpg";
	static const char[] IMG__DEMO__BG2__GAZOU1918_JPG= "img\\demo\\bg2\\gazou1918.jpg";
	static const char[] IMG__DEMO__BG2__GAZOU1919_JPG= "img\\demo\\bg2\\gazou1919.jpg";
	static const char[] IMG__DEMO__BG2__GAZOU1920_JPG= "img\\demo\\bg2\\gazou1920.jpg";
	static const char[] IMG__DEMO__BG2__GAZOU1921_JPG= "img\\demo\\bg2\\gazou1921.jpg";
	static const char[] IMG__DEMO__BG2__GAZOU1922_JPG= "img\\demo\\bg2\\gazou1922.jpg";
	static const char[] IMG__DEMO__BG2__GAZOU1923_JPG= "img\\demo\\bg2\\gazou1923.jpg";
	static const char[] IMG__DEMO__BG2__GAZOU1924_JPG= "img\\demo\\bg2\\gazou1924.jpg";
	static const char[] IMG__DEMO__BG2__GAZOU1925_JPG= "img\\demo\\bg2\\gazou1925.jpg";
	static const char[] IMG__DEMO__BG2__GAZOU1926_JPG= "img\\demo\\bg2\\gazou1926.jpg";
	static const char[] IMG__DEMO__BG2__GAZOU1927_JPG= "img\\demo\\bg2\\gazou1927.jpg";
	static const char[] IMG__DEMO__BG2__GAZOU1928_JPG= "img\\demo\\bg2\\gazou1928.jpg";
	static const char[] IMG__DEMO__BG_NOISE_PNG= "img\\demo\\bg_noise.png";
	static const char[] IMG__DEMO__BLACK_FILTER_PNG= "img\\demo\\black_filter.png";
	static const char[] IMG__DEMO__C_PNG= "img\\demo\\C.png";
	static const char[] IMG__DEMO__CLOCK_PNG= "img\\demo\\clock.png";
	static const char[] IMG__DEMO__CLOCK_BASE_PNG= "img\\demo\\clock_base.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM_PNG= "img\\demo\\clock_item\\clock_item.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM01_PNG= "img\\demo\\clock_item\\clock_item01.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM02_PNG= "img\\demo\\clock_item\\clock_item02.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM03_PNG= "img\\demo\\clock_item\\clock_item03.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM04_PNG= "img\\demo\\clock_item\\clock_item04.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM05_PNG= "img\\demo\\clock_item\\clock_item05.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM06_PNG= "img\\demo\\clock_item\\clock_item06.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM07_PNG= "img\\demo\\clock_item\\clock_item07.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM08_PNG= "img\\demo\\clock_item\\clock_item08.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM09_PNG= "img\\demo\\clock_item\\clock_item09.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM10_PNG= "img\\demo\\clock_item\\clock_item10.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM11_PNG= "img\\demo\\clock_item\\clock_item11.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM12_PNG= "img\\demo\\clock_item\\clock_item12.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM13_PNG= "img\\demo\\clock_item\\clock_item13.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM14_PNG= "img\\demo\\clock_item\\clock_item14.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM15_PNG= "img\\demo\\clock_item\\clock_item15.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM16_PNG= "img\\demo\\clock_item\\clock_item16.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM17_PNG= "img\\demo\\clock_item\\clock_item17.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM18_PNG= "img\\demo\\clock_item\\clock_item18.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM19_PNG= "img\\demo\\clock_item\\clock_item19.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM20_PNG= "img\\demo\\clock_item\\clock_item20.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM21_PNG= "img\\demo\\clock_item\\clock_item21.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM22_PNG= "img\\demo\\clock_item\\clock_item22.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM23_PNG= "img\\demo\\clock_item\\clock_item23.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM24_PNG= "img\\demo\\clock_item\\clock_item24.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM25_PNG= "img\\demo\\clock_item\\clock_item25.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM26_PNG= "img\\demo\\clock_item\\clock_item26.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM27_PNG= "img\\demo\\clock_item\\clock_item27.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM28_PNG= "img\\demo\\clock_item\\clock_item28.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM29_PNG= "img\\demo\\clock_item\\clock_item29.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM30_PNG= "img\\demo\\clock_item\\clock_item30.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM31_PNG= "img\\demo\\clock_item\\clock_item31.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM32_PNG= "img\\demo\\clock_item\\clock_item32.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM33_PNG= "img\\demo\\clock_item\\clock_item33.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM34_PNG= "img\\demo\\clock_item\\clock_item34.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM35_PNG= "img\\demo\\clock_item\\clock_item35.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM36_PNG= "img\\demo\\clock_item\\clock_item36.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM37_PNG= "img\\demo\\clock_item\\clock_item37.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM38_PNG= "img\\demo\\clock_item\\clock_item38.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM39_PNG= "img\\demo\\clock_item\\clock_item39.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM40_PNG= "img\\demo\\clock_item\\clock_item40.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM41_PNG= "img\\demo\\clock_item\\clock_item41.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM42_PNG= "img\\demo\\clock_item\\clock_item42.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM43_PNG= "img\\demo\\clock_item\\clock_item43.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM44_PNG= "img\\demo\\clock_item\\clock_item44.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM45_PNG= "img\\demo\\clock_item\\clock_item45.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM46_PNG= "img\\demo\\clock_item\\clock_item46.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM47_PNG= "img\\demo\\clock_item\\clock_item47.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM48_PNG= "img\\demo\\clock_item\\clock_item48.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM49_PNG= "img\\demo\\clock_item\\clock_item49.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM50_PNG= "img\\demo\\clock_item\\clock_item50.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM51_PNG= "img\\demo\\clock_item\\clock_item51.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM52_PNG= "img\\demo\\clock_item\\clock_item52.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM53_PNG= "img\\demo\\clock_item\\clock_item53.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM54_PNG= "img\\demo\\clock_item\\clock_item54.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM55_PNG= "img\\demo\\clock_item\\clock_item55.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM56_PNG= "img\\demo\\clock_item\\clock_item56.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__CLOCK_ITEM57_PNG= "img\\demo\\clock_item\\clock_item57.png";
	static const char[] IMG__DEMO__CLOCK_ITEM__ITEM1_LST= "img\\demo\\clock_item\\item1.lst";
	static const char[] IMG__DEMO__CODE1_PNG= "img\\demo\\code1.png";
	static const char[] IMG__DEMO__CODE2_PNG= "img\\demo\\code2.png";
	static const char[] IMG__DEMO__CODE3_PNG= "img\\demo\\code3.png";
	static const char[] IMG__DEMO__CODE4_PNG= "img\\demo\\code4.png";
	static const char[] IMG__DEMO__CODE5_PNG= "img\\demo\\code5.png";
	static const char[] IMG__DEMO__CODE_A_PNG= "img\\demo\\code_a.png";
	static const char[] IMG__DEMO__CODE_B_PNG= "img\\demo\\code_b.png";
	static const char[] IMG__DEMO__CODE_C_PNG= "img\\demo\\code_c.png";
	static const char[] IMG__DEMO__CODE_D_PNG= "img\\demo\\code_d.png";
	static const char[] IMG__DEMO__CODE_E_PNG= "img\\demo\\code_e.png";
	static const char[] IMG__DEMO__ENDSTAFF_PNG= "img\\demo\\endstaff.png";
	static const char[] IMG__DEMO__FADER_PNG= "img\\demo\\fader.png";
	static const char[] IMG__DEMO__FLERE_PNG= "img\\demo\\flere.png";
	static const char[] IMG__DEMO__H_PNG= "img\\demo\\H.png";
	static const char[] IMG__DEMO__HALF_PNG= "img\\demo\\half.png";
	static const char[] IMG__DEMO__HAND_PNG= "img\\demo\\hand.png";
	static const char[] IMG__DEMO__HORIZON_PNG= "img\\demo\\horizon.png";
	static const char[] IMG__DEMO__I_PNG= "img\\demo\\I.png";
	static const char[] IMG__DEMO__J_PNG= "img\\demo\\J.png";
	static const char[] IMG__DEMO__K_PNG= "img\\demo\\K.png";
	static const char[] IMG__DEMO__K2C_EX_PNG= "img\\demo\\k2c_ex.png";
	static const char[] IMG__DEMO__KYO_PNG= "img\\demo\\kyo.png";
	static const char[] IMG__DEMO__KYOJINTACHI_LST= "img\\demo\\kyojintachi.lst";
	static const char[] IMG__DEMO__KYOJINTACHI_PNG= "img\\demo\\kyojintachi.png";
	static const char[] IMG__DEMO__LHAND_PNG= "img\\demo\\lhand.png";
	static const char[] IMG__DEMO__LIGHT_PNG= "img\\demo\\light.png";
	static const char[] IMG__DEMO__LOGO__2_PNG= "img\\demo\\logo\\2.png";
	static const char[] IMG__DEMO__LOGO__A_PNG= "img\\demo\\logo\\a.png";
	static const char[] IMG__DEMO__LOGO__C_PNG= "img\\demo\\logo\\c.png";
	static const char[] IMG__DEMO__LOGO__E_PNG= "img\\demo\\logo\\e.png";
	static const char[] IMG__DEMO__LOGO__I_PNG= "img\\demo\\logo\\i.png";
	static const char[] IMG__DEMO__LOGO__K_PNG= "img\\demo\\logo\\k.png";
	static const char[] IMG__DEMO__LOGO__K2C_LST= "img\\demo\\logo\\k2c.lst";
	static const char[] IMG__DEMO__LOGO__M_PNG= "img\\demo\\logo\\m.png";
	static const char[] IMG__DEMO__LOGO__N_PNG= "img\\demo\\logo\\n.png";
	static const char[] IMG__DEMO__LOGO__O_PNG= "img\\demo\\logo\\o.png";
	static const char[] IMG__DEMO__LOGO__P_PNG= "img\\demo\\logo\\p.png";
	static const char[] IMG__DEMO__LOGO__R_PNG= "img\\demo\\logo\\r.png";
	static const char[] IMG__DEMO__LOGO__T_PNG= "img\\demo\\logo\\t.png";
	static const char[] IMG__DEMO__LOGO__X_PNG= "img\\demo\\logo\\x.png";
	static const char[] IMG__DEMO__LOGO1_PNG= "img\\demo\\logo1.png";
	static const char[] IMG__DEMO__MIDO_SHADOW_PNG= "img\\demo\\mido_shadow.png";
	static const char[] IMG__DEMO__MIDO_ST_PNG= "img\\demo\\mido_st.png";
	static const char[] IMG__DEMO__N_PNG= "img\\demo\\N.png";
	static const char[] IMG__DEMO__NANNO_PNG= "img\\demo\\nanno.png";
	static const char[] IMG__DEMO__NOISE_PNG= "img\\demo\\noise.png";
	static const char[] IMG__DEMO__O_PNG= "img\\demo\\O.png";
	static const char[] IMG__DEMO__POLE_PNG= "img\\demo\\pole.png";
	static const char[] IMG__DEMO__RING_PNG= "img\\demo\\ring.png";
	static const char[] IMG__DEMO__ROLE_TEXT_PNG= "img\\demo\\role_text.png";
	static const char[] IMG__DEMO__RUBI_FACE_PNG= "img\\demo\\rubi_face.png";
	static const char[] IMG__DEMO__RUBI_INTRO_PNG= "img\\demo\\rubi_intro.png";
	static const char[] IMG__DEMO__SCENE01_JPG= "img\\demo\\scene01.jpg";
	static const char[] IMG__DEMO__SCENE01Z_JPG= "img\\demo\\scene01Z.jpg";
	static const char[] IMG__DEMO__T_PNG= "img\\demo\\T.png";
	static const char[] IMG__DEMO__TATUWO_FACE_PNG= "img\\demo\\tatuwo_face.png";
	static const char[] IMG__DEMO__TATUWO_INTRO_PNG= "img\\demo\\tatuwo_intro.png";
	static const char[] IMG__DEMO__TEXT1_PNG= "img\\demo\\text1.png";
	static const char[] IMG__DEMO__TEXT2_PNG= "img\\demo\\text2.png";
	static const char[] IMG__DEMO__TEXT3_PNG= "img\\demo\\text3.png";
	static const char[] IMG__DEMO__TEXT4_PNG= "img\\demo\\text4.png";
	static const char[] IMG__DEMO__TEXT5_PNG= "img\\demo\\text5.png";
	static const char[] IMG__DEMO__TEXT6_PNG= "img\\demo\\text6.png";
	static const char[] IMG__DEMO__TEXT7_PNG= "img\\demo\\text7.png";
	static const char[] IMG__DEMO__TITLE_PNG= "img\\demo\\title.png";
	static const char[] IMG__DEMO__TITLE_MEMO_PNG= "img\\demo\\title_memo.png";
	static const char[] IMG__DEMO__TOMI_FACE_PNG= "img\\demo\\tomi_face.png";
	static const char[] IMG__DEMO__TOMI_INTRO_PNG= "img\\demo\\tomi_intro.png";
	static const char[] IMG__DEMO__TOMI_SHADE_PNG= "img\\demo\\tomi_shade.png";
	static const char[] IMG__DEMO__TOMI_ST_PNG= "img\\demo\\tomi_st.png";
	static const char[] IMG__DEMO__WA_PNG= "img\\demo\\wa.png";
	static const char[] IMG__DEMO__Y_PNG= "img\\demo\\Y.png";
	static const char[] IMG__DEMO__YUIRI_SHADOW_PNG= "img\\demo\\yuiri_shadow.png";
	static const char[] IMG__E_PNG= "img\\e.png";
	static const char[] IMG__ENDING__ALICE_PNG= "img\\ending\\alice.png";
	static const char[] IMG__ENDING__AMUA_PNG= "img\\ending\\amua.png";
	static const char[] IMG__ENDING__ANZAI_PNG= "img\\ending\\anzai.png";
	static const char[] IMG__ENDING__BG_JPG= "img\\ending\\bg.jpg";
	static const char[] IMG__ENDING__COMMAND_PNG= "img\\ending\\command.png";
	static const char[] IMG__ENDING__CREATE_PNG= "img\\ending\\create.png";
	static const char[] IMG__ENDING__G9FRIED_PNG= "img\\ending\\g9fried.png";
	static const char[] IMG__ENDING__GRA_PNG= "img\\ending\\gra.png";
	static const char[] IMG__ENDING__HARUHI_PNG= "img\\ending\\haruhi.png";
	static const char[] IMG__ENDING__HAZUKI_PNG= "img\\ending\\hazuki.png";
	static const char[] IMG__ENDING__INTERFACE_PNG= "img\\ending\\interface.png";
	static const char[] IMG__ENDING__KOWASUHITO_PNG= "img\\ending\\kowasuhito.png";
	static const char[] IMG__ENDING__MASK1_PNG= "img\\ending\\mask1.png";
	static const char[] IMG__ENDING__NAGATUKI_PNG= "img\\ending\\nagatuki.png";
	static const char[] IMG__ENDING__NICHINO_PNG= "img\\ending\\nichino.png";
	static const char[] IMG__ENDING__PLAN_PNG= "img\\ending\\plan.png";
	static const char[] IMG__ENDING__PROGRAM_PNG= "img\\ending\\program.png";
	static const char[] IMG__ENDING__ROLE_PNG= "img\\ending\\role.png";
	static const char[] IMG__ENDING__SATUEI_PNG= "img\\ending\\satuei.png";
	static const char[] IMG__ENDING__SCENARIO_PNG= "img\\ending\\scenario.png";
	static const char[] IMG__ENDING__SCENARIO_SUB_PNG= "img\\ending\\scenario_sub.png";
	static const char[] IMG__ENDING__SOUND_PNG= "img\\ending\\sound.png";
	static const char[] IMG__ENDING__SPRITE_SDF= "img\\ending\\sprite.sdf";
	static const char[] IMG__ENDING__SUB_SCENARIO_PNG= "img\\ending\\sub_scenario.png";
	static const char[] IMG__ENDING__SUOU_PNG= "img\\ending\\suou.png";
	static const char[] IMG__ENDING__TATUWO_PNG= "img\\ending\\tatuwo.png";
	static const char[] IMG__ENDING__VOICE_PNG= "img\\ending\\voice.png";
	static const char[] IMG__ENDING__YUHI_PNG= "img\\ending\\yuhi.png";
	static const char[] IMG__FLERE_PNG= "img\\flere.png";
	static const char[] IMG__HEX_PNG= "img\\hex.png";
	static const char[] IMG__HEX_FLAME_PNG= "img\\hex_flame.png";
	static const char[] IMG__HEX_FLAME2_PNG= "img\\hex_flame2.png";
	static const char[] IMG__HEX_FLAME3_PNG= "img\\hex_flame3.png";
	static const char[] IMG__HORIZON_PNG= "img\\horizon.png";
	static const char[] IMG__LOGO1_PNG= "img\\logo1.png";
	static const char[] IMG__LOGO_2_BMP= "img\\logo_2.bmp";
	static const char[] IMG__LOGO_2_PNG= "img\\logo_2.png";
	static const char[] IMG__LOGO_BACK_BMP= "img\\logo_back.bmp";
	static const char[] IMG__LOGO_BACK_PNG= "img\\logo_back.png";
	static const char[] IMG__LOGO_C_BMP= "img\\logo_c.bmp";
	static const char[] IMG__LOGO_C_PNG= "img\\logo_c.png";
	static const char[] IMG__LOGO_K_BMP= "img\\logo_k.bmp";
	static const char[] IMG__LOGO_K_PNG= "img\\logo_k.png";
	static const char[] IMG__NOISE_PNG= "img\\noise.png";
	static const char[] IMG__OPTION__BG_JPG= "img\\option\\bg.jpg";
	static const char[] IMG__OPTION__BT_L_OFF_BMP= "img\\option\\bt_l_off.bmp";
	static const char[] IMG__OPTION__BT_L_ON_BMP= "img\\option\\bt_l_on.bmp";
	static const char[] IMG__OPTION__BT_R_OFF_BMP= "img\\option\\bt_r_off.bmp";
	static const char[] IMG__OPTION__BT_R_ON_BMP= "img\\option\\bt_r_on.bmp";
	static const char[] IMG__OPTION__OP_BACK_OFF_JPG= "img\\option\\op_back_off.jpg";
	static const char[] IMG__OPTION__OP_BACK_ON_JPG= "img\\option\\op_back_on.jpg";
	static const char[] IMG__OPTION__OP_BT_LST= "img\\option\\op_bt.lst";
	static const char[] IMG__OPTION__OP_EXIT_OFF_JPG= "img\\option\\op_exit_off.jpg";
	static const char[] IMG__OPTION__OP_EXIT_ON_JPG= "img\\option\\op_exit_on.jpg";
	static const char[] IMG__OPTION__OP_FAST_OFF_JPG= "img\\option\\op_fast_off.jpg";
	static const char[] IMG__OPTION__OP_FAST_ON_JPG= "img\\option\\op_fast_on.jpg";
	static const char[] IMG__OPTION__OP_FULL_OFF_JPG= "img\\option\\op_full_off.jpg";
	static const char[] IMG__OPTION__OP_FULL_ON_JPG= "img\\option\\op_full_on.jpg";
	static const char[] IMG__OPTION__OP_LINE_OFF_JPG= "img\\option\\op_line_off.jpg";
	static const char[] IMG__OPTION__OP_LINE_ON_JPG= "img\\option\\op_line_on.jpg";
	static const char[] IMG__OPTION__OP_NORMAL_OFF_JPG= "img\\option\\op_normal_off.jpg";
	static const char[] IMG__OPTION__OP_NORMAL_ON_JPG= "img\\option\\op_normal_on.jpg";
	static const char[] IMG__OPTION__OP_OFF_OFF_JPG= "img\\option\\op_off_off.jpg";
	static const char[] IMG__OPTION__OP_OFF_ON_JPG= "img\\option\\op_off_on.jpg";
	static const char[] IMG__OPTION__OP_ON_OFF_JPG= "img\\option\\op_on_off.jpg";
	static const char[] IMG__OPTION__OP_ON_ON_JPG= "img\\option\\op_on_on.jpg";
	static const char[] IMG__OPTION__OP_PAGE_OFF_JPG= "img\\option\\op_page_off.jpg";
	static const char[] IMG__OPTION__OP_PAGE_ON_JPG= "img\\option\\op_page_on.jpg";
	static const char[] IMG__OPTION__OP_TITLE_OFF_JPG= "img\\option\\op_title_off.jpg";
	static const char[] IMG__OPTION__OP_TITLE_ON_JPG= "img\\option\\op_title_on.jpg";
	static const char[] IMG__OPTION__OP_WINDOW_OFF_JPG= "img\\option\\op_window_off.jpg";
	static const char[] IMG__OPTION__OP_WINDOW_ON_JPG= "img\\option\\op_window_on.jpg";
	static const char[] IMG__OPTION__VOL_BAR_PNG= "img\\option\\vol_bar.png";
	static const char[] IMG__OPTION__VOL_BAR_DISABLE_PNG= "img\\option\\vol_bar_disable.png";
	static const char[] IMG__OPTION__VOL_BAR_RED_PNG= "img\\option\\vol_bar_red.png";
	static const char[] IMG__OP_BT_OFF_PNG= "img\\op_bt_off.png";
	static const char[] IMG__OP_BT_ON_PNG= "img\\op_bt_on.png";
	static const char[] IMG__POLE_PNG= "img\\pole.png";
	static const char[] IMG__RAIN_PNG= "img\\common\\rain.png";
	static const char[] IMG__RING_PNG= "img\\ring.png";
	static const char[] IMG__SIL__ANZAI__ANZA00_PNG= "img\\sil\\anzai\\anza00.png";
	static const char[] IMG__SIL__ANZAI__ANZA01_PNG= "img\\sil\\anzai\\anza01.png";
	static const char[] IMG__SIL__ANZAI__ANZA02_PNG= "img\\sil\\anzai\\anza02.png";
	static const char[] IMG__SIL__ANZAI__ANZA03_PNG= "img\\sil\\anzai\\anza03.png";
	static const char[] IMG__SIL__ANZAI__ANZA04_PNG= "img\\sil\\anzai\\anza04.png";
	static const char[] IMG__SIL__ARIS__ALICE0101_PNG= "img\\sil\\aris\\alice0101.png";
	static const char[] IMG__SIL__ARIS__ALICE0102_PNG= "img\\sil\\aris\\alice0102.png";
	static const char[] IMG__SIL__ARIS__ALICE0103_PNG= "img\\sil\\aris\\alice0103.png";
	static const char[] IMG__SIL__ARIS__ALICE0104_PNG= "img\\sil\\aris\\alice0104.png";
	static const char[] IMG__SIL__ARIS__ARIS00_SDF= "img\\sil\\aris\\aris00.sdf";
	static const char[] IMG__SIL__ARIS__ARIS00_PNG= "img\\sil\\aris\\aris00.png";
	static const char[] IMG__SIL__ARIS__ARIS01_SDF= "img\\sil\\aris\\aris01.sdf";
	static const char[] IMG__SIL__ARIS__ARIS01_PNG= "img\\sil\\aris\\aris01.png";
	static const char[] IMG__SIL__ARIS__ARIS02_SDF= "img\\sil\\aris\\aris02.sdf";
	static const char[] IMG__SIL__ARIS__ARIS02_PNG= "img\\sil\\aris\\aris02.png";
	static const char[] IMG__SIL__ARIS__ARIS03_SDF= "img\\sil\\aris\\aris03.sdf";
	static const char[] IMG__SIL__ARIS__ARIS03_PNG= "img\\sil\\aris\\aris03.png";
	static const char[] IMG__SIL__ARIS__ARIS04_SDF= "img\\sil\\aris\\aris04.sdf";
	static const char[] IMG__SIL__ARIS__ARIS04_PNG= "img\\sil\\aris\\aris04.png";
	static const char[] IMG__SIL__ARIS__ARIS05_SDF= "img\\sil\\aris\\aris05.sdf";
	static const char[] IMG__SIL__ARIS__ARIS05_PNG= "img\\sil\\aris\\aris05.png";
	static const char[] IMG__SIL__CHARA_MAP_LST= "img\\sil\\chara_map.lst";
	static const char[] IMG__SIL__JITY__JITY00_SDF= "img\\sil\\jity\\jity00.sdf";
	static const char[] IMG__SIL__JITY__JITY00_PNG= "img\\sil\\jity\\jity00.png";
	static const char[] IMG__SIL__JITY__JITY01_SDF= "img\\sil\\jity\\jity01.sdf";
	static const char[] IMG__SIL__JITY__JITY01_PNG= "img\\sil\\jity\\jity01.png";
	static const char[] IMG__SIL__JITY__JITY02_SDF= "img\\sil\\jity\\jity02.sdf";
	static const char[] IMG__SIL__JITY__JITY03_PNG= "img\\sil\\jity\\jity03.png";
	static const char[] IMG__SIL__LIST_LST= "img\\sil\\list.lst";
	static const char[] IMG__SIL__MIDO__MIDO00_SDF= "img\\sil\\mido\\mido00.sdf";
	static const char[] IMG__SIL__MIDO__MIDO00_PNG= "img\\sil\\mido\\mido00.png";
	static const char[] IMG__SIL__MIDO__MIDO01_SDF= "img\\sil\\mido\\mido01.sdf";
	static const char[] IMG__SIL__MIDO__MIDO01_PNG= "img\\sil\\mido\\mido01.png";
	static const char[] IMG__SIL__MIDO__MIDO02_SDF= "img\\sil\\mido\\mido02.sdf";
	static const char[] IMG__SIL__MIDO__MIDO02_PNG= "img\\sil\\mido\\mido02.png";
	static const char[] IMG__SIL__MIDO__MIDO03_SDF= "img\\sil\\mido\\mido03.sdf";
	static const char[] IMG__SIL__MIDO__MIDO03_PNG= "img\\sil\\mido\\mido03.png";
	static const char[] IMG__SIL__MIDO__MIDO04_SDF= "img\\sil\\mido\\mido04.sdf";
	static const char[] IMG__SIL__MIDO__MIDO04_PNG= "img\\sil\\mido\\mido04.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE01_PNG= "img\\sil\\OLD\\SILHOUETTE01.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE02_PNG= "img\\sil\\OLD\\SILHOUETTE02.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE03_PNG= "img\\sil\\OLD\\SILHOUETTE03.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE04_PNG= "img\\sil\\OLD\\SILHOUETTE04.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE05_PNG= "img\\sil\\OLD\\SILHOUETTE05.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE06_PNG= "img\\sil\\OLD\\SILHOUETTE06.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE07_PNG= "img\\sil\\OLD\\SILHOUETTE07.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE08_PNG= "img\\sil\\OLD\\SILHOUETTE08.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE09_PNG= "img\\sil\\OLD\\SILHOUETTE09.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE10_PNG= "img\\sil\\OLD\\SILHOUETTE10.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE11_PNG= "img\\sil\\OLD\\SILHOUETTE11.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE12_PNG= "img\\sil\\OLD\\SILHOUETTE12.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE13_PNG= "img\\sil\\OLD\\SILHOUETTE13.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE14_PNG= "img\\sil\\OLD\\SILHOUETTE14.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE15_PNG= "img\\sil\\OLD\\SILHOUETTE15.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE16_PNG= "img\\sil\\OLD\\SILHOUETTE16.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE17_PNG= "img\\sil\\OLD\\SILHOUETTE17.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE18_PNG= "img\\sil\\OLD\\SILHOUETTE18.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE19_PNG= "img\\sil\\OLD\\SILHOUETTE19.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE20_PNG= "img\\sil\\OLD\\SILHOUETTE20.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE21_PNG= "img\\sil\\OLD\\SILHOUETTE21.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE22_PNG= "img\\sil\\OLD\\SILHOUETTE22.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE23_PNG= "img\\sil\\OLD\\SILHOUETTE23.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE24_PNG= "img\\sil\\OLD\\SILHOUETTE24.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE25_PNG= "img\\sil\\OLD\\SILHOUETTE25.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE26_PNG= "img\\sil\\OLD\\SILHOUETTE26.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE27_PNG= "img\\sil\\OLD\\SILHOUETTE27.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE28_PNG= "img\\sil\\OLD\\SILHOUETTE28.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE29_PNG= "img\\sil\\OLD\\SILHOUETTE29.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE30_PNG= "img\\sil\\OLD\\SILHOUETTE30.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE31_PNG= "img\\sil\\OLD\\SILHOUETTE31.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE32_PNG= "img\\sil\\OLD\\SILHOUETTE32.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE33_PNG= "img\\sil\\OLD\\SILHOUETTE33.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE34_PNG= "img\\sil\\OLD\\SILHOUETTE34.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE35_PNG= "img\\sil\\OLD\\SILHOUETTE35.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE36_PNG= "img\\sil\\OLD\\SILHOUETTE36.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE37_PNG= "img\\sil\\OLD\\SILHOUETTE37.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE38_PNG= "img\\sil\\OLD\\SILHOUETTE38.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE39_PNG= "img\\sil\\OLD\\SILHOUETTE39.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE40_PNG= "img\\sil\\OLD\\SILHOUETTE40.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE41_PNG= "img\\sil\\OLD\\SILHOUETTE41.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE42_PNG= "img\\sil\\OLD\\SILHOUETTE42.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE43_PNG= "img\\sil\\OLD\\SILHOUETTE43.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE44_PNG= "img\\sil\\OLD\\SILHOUETTE44.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE45_PNG= "img\\sil\\OLD\\SILHOUETTE45.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE46_PNG= "img\\sil\\OLD\\SILHOUETTE46.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE47_PNG= "img\\sil\\OLD\\SILHOUETTE47.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE48_PNG= "img\\sil\\OLD\\SILHOUETTE48.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE49_PNG= "img\\sil\\OLD\\SILHOUETTE49.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE50_PNG= "img\\sil\\OLD\\SILHOUETTE50.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE51_PNG= "img\\sil\\OLD\\SILHOUETTE51.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE52_PNG= "img\\sil\\OLD\\SILHOUETTE52.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE53_PNG= "img\\sil\\OLD\\SILHOUETTE53.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE54_PNG= "img\\sil\\OLD\\SILHOUETTE54.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE55_PNG= "img\\sil\\OLD\\SILHOUETTE55.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE56_PNG= "img\\sil\\OLD\\SILHOUETTE56.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE57_PNG= "img\\sil\\OLD\\SILHOUETTE57.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE58_PNG= "img\\sil\\OLD\\SILHOUETTE58.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE59_PNG= "img\\sil\\OLD\\SILHOUETTE59.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE60_PNG= "img\\sil\\OLD\\SILHOUETTE60.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE61_PNG= "img\\sil\\OLD\\SILHOUETTE61.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE62_PNG= "img\\sil\\OLD\\SILHOUETTE62.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE63_PNG= "img\\sil\\OLD\\SILHOUETTE63.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE64_PNG= "img\\sil\\OLD\\SILHOUETTE64.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE65_PNG= "img\\sil\\OLD\\SILHOUETTE65.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE66_PNG= "img\\sil\\OLD\\SILHOUETTE66.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE67_PNG= "img\\sil\\OLD\\SILHOUETTE67.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE68_PNG= "img\\sil\\OLD\\SILHOUETTE68.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE69_PNG= "img\\sil\\OLD\\SILHOUETTE69.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE70_PNG= "img\\sil\\OLD\\SILHOUETTE70.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE71_PNG= "img\\sil\\OLD\\SILHOUETTE71.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE72_PNG= "img\\sil\\OLD\\SILHOUETTE72.png";
	static const char[] IMG__SIL__OLD__SILHOUETTE73_PNG= "img\\sil\\OLD\\SILHOUETTE73.png";
	static const char[] IMG__SIL__RUBI__RUBI00_SDF= "img\\sil\\rubi\\rubi00.sdf";
	static const char[] IMG__SIL__RUBI__RUBI00_PNG= "img\\sil\\rubi\\rubi00.png";
	static const char[] IMG__SIL__RUBI__RUBI01_SDF= "img\\sil\\rubi\\rubi01.sdf";
	static const char[] IMG__SIL__RUBI__RUBI01_PNG= "img\\sil\\rubi\\rubi01.png";
	static const char[] IMG__SIL__RUBI__RUBI02_SDF= "img\\sil\\rubi\\rubi02.sdf";
	static const char[] IMG__SIL__RUBI__RUBI02_PNG= "img\\sil\\rubi\\rubi02.png";
	static const char[] IMG__SIL__RUBI__RUBI03_SDF= "img\\sil\\rubi\\rubi03.sdf";
	static const char[] IMG__SIL__RUBI__RUBI03_PNG= "img\\sil\\rubi\\rubi03.png";
	static const char[] IMG__SIL__RUBI__RUBI04_SDF= "img\\sil\\rubi\\rubi04.sdf";
	static const char[] IMG__SIL__RUBI__RUBI04_PNG= "img\\sil\\rubi\\rubi04.png";
	static const char[] IMG__SIL__RUBI__RUBI05_SDF= "img\\sil\\rubi\\rubi05.sdf";
	static const char[] IMG__SIL__RUBI__RUBI05_PNG= "img\\sil\\rubi\\rubi05.png";
	static const char[] IMG__SIL__RUBI__RUBI06_SDF= "img\\sil\\rubi\\rubi06.sdf";
	static const char[] IMG__SIL__RUBI__RUBI06_PNG= "img\\sil\\rubi\\rubi06.png";
	static const char[] IMG__SIL__RUBI__RUBI07_SDF= "img\\sil\\rubi\\rubi07.sdf";
	static const char[] IMG__SIL__RUBI__RUBI07_PNG= "img\\sil\\rubi\\rubi07.png";
	static const char[] IMG__SIL__SIL_00_BMP= "img\\sil\\sil_00.bmp";
	static const char[] IMG__SIL__SIL_01_BMP= "img\\sil\\sil_01.bmp";
	static const char[] IMG__SIL__SIL_02_BMP= "img\\sil\\sil_02.bmp";
	static const char[] IMG__SIL__SIL_03_BMP= "img\\sil\\sil_03.bmp";
	static const char[] IMG__SIL__SIL_04_BMP= "img\\sil\\sil_04.bmp";
	static const char[] IMG__SIL__TADA__TADA00_SDF= "img\\sil\\tada\\tada00.sdf";
	static const char[] IMG__SIL__TADA__TADA00_PNG= "img\\sil\\tada\\tada00.png";
	static const char[] IMG__SIL__TADA__TADA01_SDF= "img\\sil\\tada\\tada01.sdf";
	static const char[] IMG__SIL__TADA__TADA01_PNG= "img\\sil\\tada\\tada01.png";
	static const char[] IMG__SIL__TADA__TADA02_SDF= "img\\sil\\tada\\tada02.sdf";
	static const char[] IMG__SIL__TADA__TADA02_PNG= "img\\sil\\tada\\tada02.png";
	static const char[] IMG__SIL__TADA__TADA03_SDF= "img\\sil\\tada\\tada03.sdf";
	static const char[] IMG__SIL__TADA__TADA03_PNG= "img\\sil\\tada\\tada03.png";
	static const char[] IMG__SIL__TADA__TADA04_SDF= "img\\sil\\tada\\tada04.sdf";
	static const char[] IMG__SIL__TADA__TADA04_PNG= "img\\sil\\tada\\tada04.png";
	static const char[] IMG__SIL__TADA__TADA05_SDF= "img\\sil\\tada\\tada05.sdf";
	static const char[] IMG__SIL__TADA__TADA05_PNG= "img\\sil\\tada\\tada05.png";
	static const char[] IMG__SIL__TASK__TASK00_SDF= "img\\sil\\task\\task00.sdf";
	static const char[] IMG__SIL__TASK__TASK00_PNG= "img\\sil\\task\\task00.png";
	static const char[] IMG__SIL__TASK__TASK01_SDF= "img\\sil\\task\\task01.sdf";
	static const char[] IMG__SIL__TASK__TASK01_PNG= "img\\sil\\task\\task01.png";
	static const char[] IMG__SIL__TASK__TASK02_SDF= "img\\sil\\task\\task02.sdf";
	static const char[] IMG__SIL__TASK__TASK02_PNG= "img\\sil\\task\\task02.png";
	static const char[] IMG__SIL__TASK__TASK03_SDF= "img\\sil\\task\\task03.sdf";
	static const char[] IMG__SIL__TASK__TASK03_PNG= "img\\sil\\task\\task03.png";
	static const char[] IMG__SIL__TATU__TATU00_SDF= "img\\sil\\tatu\\tatu00.sdf";
	static const char[] IMG__SIL__TATU__TATU00_PNG= "img\\sil\\tatu\\tatu00.png";
	static const char[] IMG__SIL__TATU__TATU01_SDF= "img\\sil\\tatu\\tatu01.sdf";
	static const char[] IMG__SIL__TATU__TATU01_PNG= "img\\sil\\tatu\\tatu01.png";
	static const char[] IMG__SIL__TATU__TATU02_SDF= "img\\sil\\tatu\\tatu02.sdf";
	static const char[] IMG__SIL__TATU__TATU02_PNG= "img\\sil\\tatu\\tatu02.png";
	static const char[] IMG__SIL__TATU__TATU03_SDF= "img\\sil\\tatu\\tatu03.sdf";
	static const char[] IMG__SIL__TATU__TATU03_PNG= "img\\sil\\tatu\\tatu03.png";
	static const char[] IMG__SIL__TOMI__TOMI00_SDF= "img\\sil\\tomi\\tomi00.sdf";
	static const char[] IMG__SIL__TOMI__TOMI00_PNG= "img\\sil\\tomi\\tomi00.png";
	static const char[] IMG__SIL__TOMI__TOMI01_SDF= "img\\sil\\tomi\\tomi01.sdf";
	static const char[] IMG__SIL__TOMI__TOMI01_PNG= "img\\sil\\tomi\\tomi01.png";
	static const char[] IMG__SIL__TOMI__TOMI02_SDF= "img\\sil\\tomi\\tomi02.sdf";
	static const char[] IMG__SIL__TOMI__TOMI02_PNG= "img\\sil\\tomi\\tomi02.png";
	static const char[] IMG__SIORI_BT1_OFF_PNG= "img\\siori_bt1_off.png";
	static const char[] IMG__SIORI_BT1_ON_PNG= "img\\siori_bt1_on.png";
	static const char[] IMG__SIORI_BT2_OFF_PNG= "img\\siori_bt2_off.png";
	static const char[] IMG__SIORI_BT2_ON_PNG= "img\\siori_bt2_on.png";
	static const char[] IMG__SIORI_BT3_OFF_PNG= "img\\siori_bt3_off.png";
	static const char[] IMG__SIORI_BT3_ON_PNG= "img\\siori_bt3_on.png";
	static const char[] IMG__SIORI_BT4_DIS_PNG= "img\\siori_bt4_dis.png";
	static const char[] IMG__SIORI_BT4_OFF_PNG= "img\\siori_bt4_off.png";
	static const char[] IMG__SIORI_BT4_ON_PNG= "img\\siori_bt4_on.png";
	static const char[] IMG__SIORI_BT_AUTO_OFF_PNG= "img\\siori_bt_auto_off.png";
	static const char[] IMG__SIORI_BT_AUTO_ON_PNG= "img\\siori_bt_auto_on.png";
	static const char[] IMG__SIORI_BT_OFF_PNG= "img\\siori_bt_off.png";
	static const char[] IMG__SIORI_BT_ON_PNG= "img\\siori_bt_on.png";
	static const char[] IMG__SNOW_PNG= "img\\snow.png";
	static const char[] IMG__TELOP__0100_PNG= "img\\telop\\0100.png";
	static const char[] IMG__TELOP__0101_PNG= "img\\telop\\0101.png";
	static const char[] IMG__TELOP__0102_PNG= "img\\telop\\0102.png";
	static const char[] IMG__TELOP__0103_PNG= "img\\telop\\0103.png";
	static const char[] IMG__TELOP__0200_PNG= "img\\telop\\0200.png";
	static const char[] IMG__TELOP__0201_PNG= "img\\telop\\0201.png";
	static const char[] IMG__TELOP__0202_PNG= "img\\telop\\0202.png";
	static const char[] IMG__TELOP__0203_PNG= "img\\telop\\0203.png";
	static const char[] IMG__TELOP__PLACE083_JPG= "img\\telop\\place083.jpg";
	static const char[] IMG__TELOP__PLACE084_JPG= "img\\telop\\place084.jpg";
	static const char[] IMG__TELOP__PLACE085_JPG= "img\\telop\\place085.jpg";
	static const char[] IMG__TELOP__PLACE086_JPG= "img\\telop\\place086.jpg";
	static const char[] IMG__TELOP__PLACE087_JPG= "img\\telop\\place087.jpg";
	static const char[] IMG__TELOP__PLACE088_JPG= "img\\telop\\place088.jpg";
	static const char[] IMG__TELOP__PLACE143_JPG= "img\\telop\\place143.jpg";
	static const char[] IMG__TELOP__PLACE144_JPG= "img\\telop\\place144.jpg";
	static const char[] IMG__TELOP__PLACE145_JPG= "img\\telop\\place145.jpg";
	static const char[] IMG__TELOP__PLACE146_JPG= "img\\telop\\place146.jpg";
	static const char[] IMG__TELOP__PLACE152_JPG= "img\\telop\\place152.jpg";
	static const char[] IMG__TELOP__TELOP01_LST= "img\\telop\\telop01.lst";
	static const char[] IMG__TELOP__TELOP02_JPG= "img\\telop\\telop02.jpg";
	static const char[] IMG__TELOP__TELOP02_LST= "img\\telop\\telop02.lst";
	static const char[] IMG__TITLE_PARTS__AUTO_SIORI_PNG= "img\\title_parts\\auto_siori.png";
	static const char[] IMG__TITLE_PARTS__AUTO_SIORI_OFF_PNG= "img\\title_parts\\auto_siori_off.png";
	static const char[] IMG__TITLE_PARTS__AUTO_SIORI_ON_PNG= "img\\title_parts\\auto_siori_on.png";
	static const char[] IMG__TITLE_PARTS__B01_OFF_BMP= "img\\title_parts\\b01_off.bmp";
	static const char[] IMG__TITLE_PARTS__B01_OFF_PNG= "img\\title_parts\\b01_off.png";
	static const char[] IMG__TITLE_PARTS__B01_ON_BMP= "img\\title_parts\\b01_on.bmp";
	static const char[] IMG__TITLE_PARTS__B01_ON_PNG= "img\\title_parts\\b01_on.png";
	static const char[] IMG__TITLE_PARTS__B02_OFF_BMP= "img\\title_parts\\b02_off.bmp";
	static const char[] IMG__TITLE_PARTS__B02_OFF_PNG= "img\\title_parts\\b02_off.png";
	static const char[] IMG__TITLE_PARTS__B02_ON_BMP= "img\\title_parts\\b02_on.bmp";
	static const char[] IMG__TITLE_PARTS__B02_ON_PNG= "img\\title_parts\\b02_on.png";
	static const char[] IMG__TITLE_PARTS__B03_OFF_BMP= "img\\title_parts\\b03_off.bmp";
	static const char[] IMG__TITLE_PARTS__B03_OFF_PNG= "img\\title_parts\\b03_off.png";
	static const char[] IMG__TITLE_PARTS__B03_ON_BMP= "img\\title_parts\\b03_on.bmp";
	static const char[] IMG__TITLE_PARTS__B03_ON_PNG= "img\\title_parts\\b03_on.png";
	static const char[] IMG__TITLE_PARTS__B04_OFF_BMP= "img\\title_parts\\b04_off.bmp";
	static const char[] IMG__TITLE_PARTS__B04_OFF_PNG= "img\\title_parts\\b04_off.png";
	static const char[] IMG__TITLE_PARTS__B04_ON_BMP= "img\\title_parts\\b04_on.bmp";
	static const char[] IMG__TITLE_PARTS__B04_ON_PNG= "img\\title_parts\\b04_on.png";
	static const char[] IMG__TITLE_PARTS__BG_JPG= "img\\title_parts\\bg.jpg";
	static const char[] IMG__TITLE_PARTS__BG_PNG= "img\\title_parts\\bg.png";
	static const char[] IMG__TITLE_PARTS__DIAL_PNG= "img\\title_parts\\dial.png";
	static const char[] IMG__TITLE_PARTS__DIAL_ORIGIN_PNG= "img\\title_parts\\dial_origin.png";
	static const char[] IMG__TITLE_PARTS__DIS_ENTER_OFF_PNG= "img\\title_parts\\dis_enter_off.png";
	static const char[] IMG__TITLE_PARTS__DIS_ENTER_ON_PNG= "img\\title_parts\\dis_enter_on.png";
	static const char[] IMG__TITLE_PARTS__ENTER_OFF_PNG= "img\\title_parts\\enter_off.png";
	static const char[] IMG__TITLE_PARTS__ENTER_ON_PNG= "img\\title_parts\\enter_on.png";
	static const char[] IMG__TITLE_PARTS__MR_NEXT_OFF_BMP= "img\\title_parts\\mr_next_off.bmp";
	static const char[] IMG__TITLE_PARTS__MR_NEXT_OFF_PNG= "img\\title_parts\\mr_next_off.png";
	static const char[] IMG__TITLE_PARTS__MR_NEXT_ON_BMP= "img\\title_parts\\mr_next_on.bmp";
	static const char[] IMG__TITLE_PARTS__MR_NEXT_ON_PNG= "img\\title_parts\\mr_next_on.png";
	static const char[] IMG__TITLE_PARTS__MR_PLAY_OFF_BMP= "img\\title_parts\\mr_play_off.bmp";
	static const char[] IMG__TITLE_PARTS__MR_PLAY_OFF_PNG= "img\\title_parts\\mr_play_off.png";
	static const char[] IMG__TITLE_PARTS__MR_PLAY_ON_BMP= "img\\title_parts\\mr_play_on.bmp";
	static const char[] IMG__TITLE_PARTS__MR_PLAY_ON_PNG= "img\\title_parts\\mr_play_on.png";
	static const char[] IMG__TITLE_PARTS__MR_PRE_OFF_BMP= "img\\title_parts\\mr_pre_off.bmp";
	static const char[] IMG__TITLE_PARTS__MR_PRE_OFF_PNG= "img\\title_parts\\mr_pre_off.png";
	static const char[] IMG__TITLE_PARTS__MR_PRE_ON_BMP= "img\\title_parts\\mr_pre_on.bmp";
	static const char[] IMG__TITLE_PARTS__MR_PRE_ON_PNG= "img\\title_parts\\mr_pre_on.png";
	static const char[] IMG__TITLE_PARTS__MR_STOP_OFF_BMP= "img\\title_parts\\mr_stop_off.bmp";
	static const char[] IMG__TITLE_PARTS__MR_STOP_OFF_PNG= "img\\title_parts\\mr_stop_off.png";
	static const char[] IMG__TITLE_PARTS__MR_STOP_ON_BMP= "img\\title_parts\\mr_stop_on.bmp";
	static const char[] IMG__TITLE_PARTS__MR_STOP_ON_PNG= "img\\title_parts\\mr_stop_on.png";
	static const char[] IMG__TITLE_PARTS__MUSIC_ROOM_BMP= "img\\title_parts\\MUSIC_ROOM.bmp";
	static const char[] IMG__TITLE_PARTS__MUSIC_ROOM_PNG= "img\\title_parts\\MUSIC_ROOM.png";
	static const char[] IMG__TITLE_PARTS__REMARK_LST= "img\\title_parts\\remark.lst";
	static const char[] IMG__TITLE_PARTS__REMARK00_PNG= "img\\title_parts\\remark00.png";
	static const char[] IMG__TITLE_PARTS__REMARK01_PNG= "img\\title_parts\\remark01.png";
	static const char[] IMG__TITLE_PARTS__REMARK02_PNG= "img\\title_parts\\remark02.png";
	static const char[] IMG__TITLE_PARTS__REMARK03_PNG= "img\\title_parts\\remark03.png";
	static const char[] IMG__TITLE_PARTS__REMARK04_PNG= "img\\title_parts\\remark04.png";
	static const char[] IMG__TITLE_PARTS__REMARK05_PNG= "img\\title_parts\\remark05.png";
	static const char[] IMG__TITLE_PARTS__REMARK06_PNG= "img\\title_parts\\remark06.png";
	static const char[] IMG__TITLE_PARTS__SIORI_LST= "img\\title_parts\\siori.lst";
	static const char[] IMG__TITLE_PARTS__SIORI_PNG= "img\\title_parts\\siori.png";
	static const char[] IMG__TITLE_PARTS__SIORI_OFF_PNG= "img\\title_parts\\siori_off.png";
	static const char[] IMG__TITLE_PARTS__SIORI_ON_PNG= "img\\title_parts\\siori_on.png";
	static const char[] IMG__TITLE_PARTS__START_ON_PNG= "img\\title_parts\\start_on.png";
	static const char[] IMG__TITLE_PARTS__T01_OFF_BMP= "img\\title_parts\\t01_off.bmp";
	static const char[] IMG__TITLE_PARTS__T01_OFF_PNG= "img\\title_parts\\t01_off.png";
	static const char[] IMG__TITLE_PARTS__T01_ON_BMP= "img\\title_parts\\t01_on.bmp";
	static const char[] IMG__TITLE_PARTS__T01_ON_PNG= "img\\title_parts\\t01_on.png";
	static const char[] IMG__TITLE_PARTS__T02_OFF_BMP= "img\\title_parts\\t02_off.bmp";
	static const char[] IMG__TITLE_PARTS__T02_OFF_PNG= "img\\title_parts\\t02_off.png";
	static const char[] IMG__TITLE_PARTS__T02_ON_BMP= "img\\title_parts\\t02_on.bmp";
	static const char[] IMG__TITLE_PARTS__T02_ON_PNG= "img\\title_parts\\t02_on.png";
	static const char[] IMG__TITLE_PARTS__T03_OFF_BMP= "img\\title_parts\\t03_off.bmp";
	static const char[] IMG__TITLE_PARTS__T03_OFF_PNG= "img\\title_parts\\t03_off.png";
	static const char[] IMG__TITLE_PARTS__T03_ON_BMP= "img\\title_parts\\t03_on.bmp";
	static const char[] IMG__TITLE_PARTS__T03_ON_PNG= "img\\title_parts\\t03_on.png";
	static const char[] IMG__TITLE_PARTS__T04_OFF_BMP= "img\\title_parts\\t04_off.bmp";
	static const char[] IMG__TITLE_PARTS__T04_OFF_PNG= "img\\title_parts\\t04_off.png";
	static const char[] IMG__TITLE_PARTS__T04_ON_BMP= "img\\title_parts\\t04_on.bmp";
	static const char[] IMG__TITLE_PARTS__T04_ON_PNG= "img\\title_parts\\t04_on.png";
	static const char[] IMG__TITLE_PARTS__T05_OFF_BMP= "img\\title_parts\\t05_off.bmp";
	static const char[] IMG__TITLE_PARTS__T05_OFF_PNG= "img\\title_parts\\t05_off.png";
	static const char[] IMG__TITLE_PARTS__T05_ON_BMP= "img\\title_parts\\t05_on.bmp";
	static const char[] IMG__TITLE_PARTS__T05_ON_PNG= "img\\title_parts\\t05_on.png";
	static const char[] IMG__TITLE_PARTS__T06_OFF_BMP= "img\\title_parts\\t06_off.bmp";
	static const char[] IMG__TITLE_PARTS__T06_OFF_PNG= "img\\title_parts\\t06_off.png";
	static const char[] IMG__TITLE_PARTS__T06_ON_BMP= "img\\title_parts\\t06_on.bmp";
	static const char[] IMG__TITLE_PARTS__T06_ON_PNG= "img\\title_parts\\t06_on.png";
	static const char[] IMG__TITLE_PARTS__T07_OFF_BMP= "img\\title_parts\\t07_off.bmp";
	static const char[] IMG__TITLE_PARTS__T07_OFF_PNG= "img\\title_parts\\t07_off.png";
	static const char[] IMG__TITLE_PARTS__T07_ON_BMP= "img\\title_parts\\t07_on.bmp";
	static const char[] IMG__TITLE_PARTS__T07_ON_PNG= "img\\title_parts\\t07_on.png";
	static const char[] IMG__TITLE_PARTS__T08_OFF_BMP= "img\\title_parts\\t08_off.bmp";
	static const char[] IMG__TITLE_PARTS__T08_OFF_PNG= "img\\title_parts\\t08_off.png";
	static const char[] IMG__TITLE_PARTS__T08_ON_BMP= "img\\title_parts\\t08_on.bmp";
	static const char[] IMG__TITLE_PARTS__T08_ON_PNG= "img\\title_parts\\t08_on.png";
	static const char[] IMG__TITLE_PARTS__T09_OFF_BMP= "img\\title_parts\\t09_off.bmp";
	static const char[] IMG__TITLE_PARTS__T09_OFF_PNG= "img\\title_parts\\t09_off.png";
	static const char[] IMG__TITLE_PARTS__T09_ON_BMP= "img\\title_parts\\t09_on.bmp";
	static const char[] IMG__TITLE_PARTS__T09_ON_PNG= "img\\title_parts\\t09_on.png";
	static const char[] IMG__TITLE_PARTS__T10_OFF_BMP= "img\\title_parts\\t10_off.bmp";
	static const char[] IMG__TITLE_PARTS__T10_OFF_PNG= "img\\title_parts\\t10_off.png";
	static const char[] IMG__TITLE_PARTS__T10_ON_BMP= "img\\title_parts\\t10_on.bmp";
	static const char[] IMG__TITLE_PARTS__T10_ON_PNG= "img\\title_parts\\t10_on.png";
	static const char[] IMG__TITLE_PARTS__T11_OFF_BMP= "img\\title_parts\\t11_off.bmp";
	static const char[] IMG__TITLE_PARTS__T11_OFF_PNG= "img\\title_parts\\t11_off.png";
	static const char[] IMG__TITLE_PARTS__T11_ON_BMP= "img\\title_parts\\t11_on.bmp";
	static const char[] IMG__TITLE_PARTS__T11_ON_PNG= "img\\title_parts\\t11_on.png";
	static const char[] IMG__TITLE_PARTS__T12_OFF_BMP= "img\\title_parts\\t12_off.bmp";
	static const char[] IMG__TITLE_PARTS__T12_OFF_PNG= "img\\title_parts\\t12_off.png";
	static const char[] IMG__TITLE_PARTS__T12_ON_BMP= "img\\title_parts\\t12_on.bmp";
	static const char[] IMG__TITLE_PARTS__T12_ON_PNG= "img\\title_parts\\t12_on.png";
	static const char[] IMG__TITLE_PARTS__T13_OFF_BMP= "img\\title_parts\\t13_off.bmp";
	static const char[] IMG__TITLE_PARTS__T13_OFF_PNG= "img\\title_parts\\t13_off.png";
	static const char[] IMG__TITLE_PARTS__T13_ON_BMP= "img\\title_parts\\t13_on.bmp";
	static const char[] IMG__TITLE_PARTS__T13_ON_PNG= "img\\title_parts\\t13_on.png";
	static const char[] IMG__TITLE_PARTS__T20_OFF_PNG= "img\\title_parts\\t20_off.png";
	static const char[] IMG__TITLE_PARTS__T20_ON_PNG= "img\\title_parts\\t20_on.png";
	static const char[] IMG__TITLE_PARTS__TITLE_BT_LST= "img\\title_parts\\title_bt.lst";
	static const char[] IMG__WA_PNG= "img\\wa.png";
	static const char[] IMG__YESNO__01_BMP= "img\\yesno\\01.bmp";
	static const char[] IMG__YESNO__02_BMP= "img\\yesno\\02.bmp";
	static const char[] IMG__YESNO__03_BMP= "img\\yesno\\03.bmp";
	static const char[] IMG__YESNO__04_BMP= "img\\yesno\\04.bmp";
	static const char[] IMG__YESNO__05_BMP= "img\\yesno\\05.bmp";
	static const char[] IMG__YESNO__06_BMP= "img\\yesno\\06.bmp";
	static const char[] IMG__YESNO__END_BMP= "img\\yesno\\end.bmp";
	static const char[] IMG__YESNO__LIST_LST= "img\\yesno\\list.lst";


	private static PicNameConst instance;
	static PicNameConst getInstance() {
		if (instance is null) {
			instance = new PicNameConst();
		}
		return instance;
	}
	
	/// ファイル存在チェック付き絶対パス取得
	static char[] getFullName(char[] filename) {
		
		return filename;
/*		
		debug {
			// null でない
			assert( !(filename is null) );
			// サイズ0でない
			assert( filename.length != 0 );
			// ファイルが存在している
			assert( FileSys.isExist( filename ) );
		}
		
		return FileSys.makeFullName( filename );
*/
	}
	
private:
	// インスタンスは生成すべきではない
	this() {
	}

}

