﻿module kyojintati4d.mygametaskfactory;

private import y4d;

private import kyojintati4d.val.kyojinconst;
private import kyojintati4d.myapp;
private import kyojintati4d.taskmovie;
private import kyojintati4d.tasklogo;
private import kyojintati4d.taskdemo;
private import kyojintati4d.tasktelop;
private import kyojintati4d.tasktitle;
private import kyojintati4d.taskoption;
private import kyojintati4d.taskbookmark;
private import kyojintati4d.taskscenario;
private import kyojintati4d.taskpinup;
//private import kyojintati4d.taskscenarioconv;
private import kyojintati4d.taskending1;
private import kyojintati4d.taskending2;
private import kyojintati4d.taskending3;
private import kyojintati4d.taskendingkyojin;
private import kyojintati4d.taskmusicroom;
private import kyojintati4d.taskloader;
private import kyojintati4d.taskyesno;
private import kyojintati4d.tasktest;
private import kyojintati4d.taskselector;
private import kyojintati4d.taskeyecatche;
private import kyojintati4d.tasktelopkyojin;
private import kyojintati4d.task4koma;
private import kyojintati4d.taskdevroom;
private import kyojintati4d.taskendingoption;

private import yamalib.log.log;


class MyGameTaskFactory : GameTaskFactoryBase {

	/// タスクＩＤでタスクを生成し返却する		
	GameTaskBase createTask(int id) {

		with (kyojintati4d.val.kyojinconst) {
			
			Log.print("MyGameTaskFactory TASK ID %s", id);
			switch(id) {
				case KyojinConst.Task.Task_Movie		: return new TaskMovie;
				case KyojinConst.Task.Task_Logo   		: return new TaskLogo;
				case KyojinConst.Task.Task_Demo   		: return new TaskDemo;
//				case KyojinConst.Task.Task_Demo2   		: return new TaskDemo2;
				case KyojinConst.Task.Task_Telop  		: return new TaskTelop;
				case KyojinConst.Task.Task_Title  		: return new TaskTitle;
				case KyojinConst.Task.Task_Option 		: return new TaskOption;
				case KyojinConst.Task.Task_Bookmark		: return new TaskBookmark;
				case KyojinConst.Task.Task_Scenario		: return new TaskScenario;
				case KyojinConst.Task.Task_Pinup		: return new TaskPinup;
				case KyojinConst.Task.Task_Ending1 		: return new TaskEnding1;
				case KyojinConst.Task.Task_Ending2 		: return new TaskEnding2;
				case KyojinConst.Task.Task_Ending3 		: return new TaskEnding3;
				case KyojinConst.Task.Task_EndingKyojin	: return new TaskEndingKyojin;
				case KyojinConst.Task.Task_Loader 		: return new TaskLoader;
//				case KyojinConst.Task.Task_YesNo 		: return new TaskYesNo;
				case KyojinConst.Task.Task_Selector		: return new TaskSelector;
				case KyojinConst.Task.Task_EyeCatche	: return new TaskEyeCatche;
//				case KyojinConst.Task.Task_ScenarioConv : return new TaskScenarioConv;
				case KyojinConst.Task.Task_EndingOption	: return new TaskEndingOption;
			debug 
			{
				case KyojinConst.Task.Task_Test 		: return new TaskTest;
			}
				case KyojinConst.Task.Task_Music 		: return new TaskMusicRoom;
				case KyojinConst.Task.Task_TelopKyojin 	: return new TaskTelopKyojin;
				case KyojinConst.Task.Task_4Koma		: return new Task4Koma;
				case KyojinConst.Task.Task_Dev			: return new TaskDevRoom;
				default:
					Log.printError("ERORR-Undefined Task No:%s",id);
					return null;
			}
			
			assert(false);

		}	// with
	}
}