﻿module yamalib.draw.texturelinenoise;

private import y4d;


/// テクスチャを水平線上でズレズレで表示させるクラス
class TextureLineNoise {

	/// 描画位置の設定
	void setXY(int x,int y) {
		posx = x;
		posy = y;
	}

	/// 水平乱れの間の平均フレーム数
	void setInterval(int n) {
		nowInterval = interval = n;
		if (intervalRand) {
			nowInterval = rand.get(interval);
		}
	}

	/// 水平乱れが持続する平均フレーム数
	void setEffectingTime(int n) {
		effectingTime = n;
	}

	/// 水平乱れが持続する時間を乱数にする
	void setEffectingTimeRand(bool b) {
		bEffectingTimeRand = b;
	}

	/// 水平乱れ間の正常状態維持フレーム数をランダムにする
	void setIntervalRand(bool b) {
		intervalRand = b;
	}

	/// エフェクト描画するテクスチャーのセット
	void setTexture(Texture t_) {
		t = t_;
		tHeight = cast(int)t.getHeight();
		tWidth = cast(int)t.getWidth();
	}

	/// ランダム幅の設定
	void setRandWidth(int n) {
		randWidth = n;
	}

	/// 適宜呼び出すなり
	void onDraw(Screen screen) {
		if (!t) return;

		if (bInterval) {
			intervalCounter++;
			if (nowInterval <= intervalCounter) {
				intervalCounter = 0;
				bInterval = false;
				nowInterval = rand.get(interval);
			}
		}

		if (bInterval) {
			screen.blt(t,posx,posy);
		} else {
			for(int i; i<tHeight; ++i) {
				Rect rc;
				rc.top = i;
				rc.bottom = i+1;
				rc.left = 0;
				rc.right = tWidth;

				int offsetx = rand.get(randWidth) - randWidth/2;
				screen.blt(t,posx+offsetx,posy+i,&rc);

			}
		}

		if (!bInterval) {
			effectingCounter++;
			if (nowEffectingTime <= effectingCounter) {
				effectingCounter = 0;
				bInterval = true;
				nowEffectingTime = rand.get(effectingTime);
			}
		}
	}

	/// コンストラクタ
	this() {
		rand = new Rand;
		rand.randomize();
		randWidth = 4;
		interval = 100;
		effectingTime = 60;
		nowEffectingTime = rand.get(effectingTime);
	}

private :
	bool inti;
	Rand rand;
	Texture t;

	int[] slant;	//!< ずれ幅
	int posx;
	int posy;
	int tWidth;
	int tHeight;
	int randWidth;
	int effectingCounter;
	int effectingTime;
	int nowEffectingTime;
	bool bEffectingTimeRand = true;
	bool bInterval;
	int intervalCounter;
	int interval;
	int nowInterval;
	bool intervalRand = true;
}