﻿module kyojintati4d.userinfo;

private import kyojintati4d.val.kyojinconst;

private import yamalib.serialize;
private import yamalib.log.log;

/**
	ユーザ情報管理クラス
*/
class UserInfo : Archive {
	static final const int SEVE_DATA_VERSION_LATEST = 100;
	static final const int SEVE_DATA_VERSION_100 = 100;
	
	/// シリアライズ
	override void serialize(inout Serialize s) {
		// 何にせよ、ここで最新バージョンにしておく
		dataVersion = SEVE_DATA_VERSION_LATEST;
		s << dataVersion;
		if (SEVE_DATA_VERSION_LATEST == dataVersion ) {
			s << m_readFlags << m_readPos;
		} else if (SEVE_DATA_VERSION_LATEST > dataVersion ) {
			// 下位互換
			// ここで、それぞれの下位バージョンを判定し、追加されたデータにデフォルト値を設定
			Log.printError("Can't load this save data version : %s", dataVersion);
		} else if (SEVE_DATA_VERSION_LATEST < dataVersion ) {
			// 上位互換
			// たぶん、これは、おもわぬ動作を引き起こすので、バージョンアップを促す
			Log.printError("Can't load this save data version : %s", dataVersion);
		}
	}
	
	/// 既読フラグをセットする
	void setReadFlag(int nScenarioNo, bool flag) {
		assert(nScenarioNo < m_readFlags.length);
		assert(nScenarioNo >= 0);
		
		m_readFlags[nScenarioNo] = flag;
	}
	
	/// 指定のシナリオは読まれたか
	bool isRead( int nScenarioNo ) {
		assert(nScenarioNo < m_readFlags.length);
		assert(nScenarioNo >= 0);

		return m_readFlags[nScenarioNo];
	}
	
	/// 全フラグ取得
	bool[] getReadFlags() {
		return m_readFlags;
	}
	
	/// メインパートを読み終えたか？
	bool isReadMain() {
		for (int i = 0; i <  KyojinConst.ScenarioID.STORY07; ++i) {
			if ( !m_readFlags[i] ) {
				return false;
			}
		}
		
		return true;
	}
	
	/// 去人パートを読み終えたか
	bool isReadKyojin() {
		for (int i = KyojinConst.ScenarioID.KYOJIN01; i <  KyojinConst.ScenarioID.KYOJIN03; ++i) {
			if ( !m_readFlags[i] ) {
				return false;
			}
		}
		
		return true;
	}
	
	/// 対象シナリオの既読位置を設定します
	void setReadPos(int nScenarioNo, long pos) {
		assert(nScenarioNo < m_readPos.length);
		assert(nScenarioNo >= 0);

		m_readPos[nScenarioNo] = pos;
	}
	
	/// 指定シナリオの既読位置を取得する
	long getReadPos(int nScenarioNo) {
		assert(nScenarioNo < m_readPos.length);
		assert(nScenarioNo >= 0);

		return m_readPos[nScenarioNo];
	}
	
	/// コンストラクタ
	this() {
		/* シナリオの怠惰位置を求める */
//		int nScenarioMax = cast(int) KyojinConst.ScenarioID.max;
		int nScenarioMax = cast(int) KyojinConst.ScenarioID.STORY2ch01;
		m_readFlags = new bool[nScenarioMax];
		m_readPos = new long[nScenarioMax];
		
		foreach ( bool b; m_readFlags) {
			// 念のため初期化する
			b = false;
		}
		dataVersion = SEVE_DATA_VERSION_LATEST;
	}
	
private :
	bool[] m_readFlags;	//!< 既読フラグ
	long[] m_readPos;	//!< 既読位置フラグ
	int dataVersion;
}